/*
 * Decompiled with CFR 0.152.
 */
package topo.table;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import topo.table.ObjectTableDesc;

public class ObjectTableModel
extends DefaultTableModel {
    static final String idName = ".ObjectIDName.";
    private ObjectTableDesc desc;

    public ObjectTableModel(ObjectTableDesc objectTableDesc) {
        this(ObjectTableModel.toColNames(objectTableDesc));
        this.desc = objectTableDesc;
    }

    public void addRowObject(Object object) {
        this.addRowObject(object, this.desc.getRowDatas(object));
    }

    public void addRowObject(List list) {
        int n = 0;
        while (n < list.size()) {
            this.addRowObject(list.get(n));
            ++n;
        }
    }

    public void addRowObject(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.addRowObject(enumeration.nextElement());
        }
    }

    public void delRowObject(Object object) {
        int n = this.getRowObjectIndex(object);
        if (n >= 0) {
            super.removeRow(n);
        }
    }

    public void delRowObject(List list) {
        int n = 0;
        while (n < list.size()) {
            this.delRowObject(list.get(n));
            ++n;
        }
    }

    public void updateRowObject(Object object) {
        this.updateRowObject(object, this.desc.getRowDatas(object));
    }

    public void clearAllObject() {
        this.dataVector.clear();
        this.fireTableDataChanged();
    }

    public Object getRowObject(int n) {
        int n2 = super.getColumnCount();
        return super.getValueAt(n, n2 - 1);
    }

    public Vector getAllRowObject() {
        Vector<Object> vector = new Vector<Object>();
        int n = super.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            Object object = this.getRowObject(n2);
            vector.add(object);
            ++n2;
        }
        return vector;
    }

    private static Object[] toColNames(ObjectTableDesc objectTableDesc) {
        Object[] objectArray = objectTableDesc.getcolumnNames();
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray2.length - 1] = idName;
        return objectArray2;
    }

    private ObjectTableModel(Object[] objectArray) {
        super(objectArray, 0);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    private void addRowObject(Object object, Object[] objectArray) {
        if (object == null || objectArray == null) {
            return;
        }
        int n = this.getRowObjectIndex(object);
        if (n >= 0) {
            this.updateRowObject(object, objectArray);
        } else {
            Object[] objectArray2 = this.toRowDatas(object, objectArray);
            super.addRow(objectArray2);
        }
    }

    private void updateRowObject(Object object, Object[] objectArray) {
        if (object == null) {
            return;
        }
        int n = this.getRowObjectIndex(object);
        if (n >= 0) {
            Object[] objectArray2 = this.toRowDatas(object, objectArray);
            int n2 = 0;
            while (n2 < objectArray2.length) {
                this.setValueAt(objectArray2[n2], n, n2);
                ++n2;
            }
        }
    }

    private int getRowObjectIndex(Object object) {
        if (object == null) {
            return -1;
        }
        int n = super.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            Object object2 = this.getRowObject(n2);
            if (object2 != null && object2.equals(object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private Object[] toRowDatas(Object object, Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray2.length - 1] = object;
        return objectArray2;
    }
}

