/*
 * Decompiled with CFR 0.152.
 */
package topo.trap;

import com.zhtelecom.common.snmp.trap.TrapMessageInfo;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TrapPrintTextArea
extends JTextArea
implements ActionListener {
    private JPopupMenu popupMenu;
    private JMenuItem copyItem;
    private JMenuItem selectAllItem;
    private JMenuItem clearSelectItem;
    private JMenuItem clearAllItem;
    private JMenuItem lockRollItem;
    private boolean lockRollBoolean = false;
    private final String LOCKROLL_YES = "\u6eda\u52a8\u9501\u5b9a";
    private final String LOCKROLL_NO = "\u6eda\u52a8\u89e3\u9501";
    private static final Font font = new Font("Courier", 0, 14);
    private static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public TrapPrintTextArea() throws IOException {
        this.initTrapArea();
    }

    private void initTrapArea() {
        this.popupMenu = new JPopupMenu();
        this.copyItem = new JMenuItem("\u590d\u5236");
        this.selectAllItem = new JMenuItem("\u5168\u90e8\u9009\u4e2d");
        this.clearSelectItem = new JMenuItem("\u6e05\u9664\u9009\u4e2d");
        this.clearAllItem = new JMenuItem("\u6e05\u9664\u5168\u90e8");
        this.lockRollItem = new JMenuItem("\u6eda\u52a8\u9501\u5b9a");
        this.popupMenu.add(this.copyItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.selectAllItem);
        this.popupMenu.add(this.clearSelectItem);
        this.popupMenu.add(this.clearAllItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.lockRollItem);
        this.copyItem.addActionListener(this);
        this.selectAllItem.addActionListener(this);
        this.clearSelectItem.addActionListener(this);
        this.clearAllItem.addActionListener(this);
        this.lockRollItem.addActionListener(this);
        this.add(this.popupMenu);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    TrapPrintTextArea.this.copyItem.setEnabled(TrapPrintTextArea.this.isCanCopy());
                    TrapPrintTextArea.this.clearSelectItem.setEnabled(TrapPrintTextArea.this.isCanCopy());
                    TrapPrintTextArea.this.popupMenu.show(TrapPrintTextArea.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                TrapPrintTextArea.this.setCursor(new Cursor(2));
            }
        });
        this.getCaret().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TrapPrintTextArea.this.getCaret().setVisible(true);
            }
        });
        this.setEditable(false);
        this.setFont(font);
        this.setCaretColor(Color.RED);
        this.setTabSize(4);
    }

    public boolean isCanCopy() {
        int n;
        boolean bl = false;
        int n2 = this.getSelectionStart();
        if (n2 != (n = this.getSelectionEnd())) {
            bl = true;
        }
        return bl;
    }

    public void printTrap(TrapMessageInfo trapMessageInfo) {
        this.printMessage("\u6536\u5230\u4e00\u4e2aTRAP\uff0cTRAP\u4fe1\u606f\u5982\u4e0b\uff1a");
        this.printMessage("\u53d1\u9001Trap\u7684\u8bbe\u5907IP: " + trapMessageInfo.getAgentSendIP());
        this.printMessage("TRAP\u4e2d\u6307\u660e\u7684\u8bbe\u5907IP: " + trapMessageInfo.getPduAgentIP());
        this.printMessage("TRAP\u7248\u672c\uff081-V1,2-V2\uff09: " + trapMessageInfo.getTrapVersion());
        this.printMessage("\u89e3\u6790\u51fa\u7684TRAP\u540d\u79f0: " + trapMessageInfo.getTrapName());
        this.printMessage("TRAP\u7684OID\uff08V2\uff09\u6216EnterpriseOID\uff08V1\uff09: " + trapMessageInfo.getTrapOID());
        this.printMessage("TRAP\u63a5\u6536\u65f6\u95f4: " + TIME_FORMATTER.format(trapMessageInfo.getReceiverTime()));
        this.printMessage("TRAP V1\u7248\u672c\u4e2d\u6807\u51c6Trap\u7c7b\u578b\uff080-5\u6807\u51c6\u7c7b\u578b\uff0c6-\u79c1\u6709\u7c7b\u578b\uff09: " + trapMessageInfo.getTrapV1GenericType());
        this.printMessage("TRAP V1\u7248\u672c\u4e2d\u79c1\u6709Trap\u7c7b\u578b: " + trapMessageInfo.getTrapV1SpecificType());
        this.printMessage("Trap\u4e2d\u7ed1\u5b9a\u7684OID\u548cOID\u503c\u5982\u4e0b\uff1a");
        for (String string : trapMessageInfo.getTrapPDUOIDs()) {
            this.printMessage("OID: " + string + "\uff0c \u503c: " + trapMessageInfo.getOIDValue(string));
        }
        this.printMessage("***************TRAP\u6253\u5370\u7ed3\u675f***************\n");
    }

    private void printMessage(String string) {
        this.append(String.valueOf(string) + "\n");
        if (!this.lockRollBoolean) {
            this.setCaretPosition(this.getDocument().getLength());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.copyItem.getText())) {
            this.copy();
        } else if (string.equals(this.selectAllItem.getText())) {
            this.selectAll();
        } else if (string.equals(this.clearSelectItem.getText())) {
            this.replaceSelection(null);
        } else if (string.equals(this.clearAllItem.getText())) {
            this.setText("");
        } else if (string.equals("\u6eda\u52a8\u9501\u5b9a")) {
            this.lockRollBoolean = true;
            this.lockRollItem.setText("\u6eda\u52a8\u89e3\u9501");
        } else if (string.equals("\u6eda\u52a8\u89e3\u9501")) {
            this.lockRollBoolean = false;
            this.lockRollItem.setText("\u6eda\u52a8\u9501\u5b9a");
        }
    }
}

