/*
 * Decompiled with CFR 0.152.
 */
package topo.utils;

import com.zhtelecom.common.base.MyException;
import com.zhtelecom.common.base.MyLog;
import com.zhtelecom.common.snmp.SNMPAPI;
import com.zhtelecom.common.snmp.SNMPFactory;
import com.zhtelecom.common.snmp.SNMPTarget;
import topo.data.NodeDevice;

public class SNMPTargetTool {
    public static SNMPTarget nodeToSNMPConnInfo(NodeDevice nodeDevice) {
        SNMPTarget sNMPTarget = new SNMPTarget();
        sNMPTarget.nodeIP = nodeDevice.getIpAddress();
        sNMPTarget.readCommunity = nodeDevice.getReadCommit();
        sNMPTarget.writeCommunity = nodeDevice.getWriteCommit();
        sNMPTarget.port = nodeDevice.getSnmpPort();
        sNMPTarget.snmpVersion = nodeDevice.getSnmpVersion();
        if (nodeDevice.getIsEnableSNMPProxy() == 1) {
            sNMPTarget.proxySNMPGateIP = nodeDevice.getSnmpProxyIP();
        }
        return sNMPTarget;
    }

    public static String getSNMPOIDValue(NodeDevice nodeDevice, String string) throws MyException {
        try {
            SNMPTarget sNMPTarget = SNMPTargetTool.nodeToSNMPConnInfo(nodeDevice);
            return SNMPFactory.getSNMPAPI().getOIDValue(string, sNMPTarget);
        }
        catch (Exception exception) {
            throw new MyException(exception);
        }
    }

    public static String getSNMPNextOIDValue(NodeDevice nodeDevice, String string) throws MyException {
        try {
            SNMPTarget sNMPTarget = SNMPTargetTool.nodeToSNMPConnInfo(nodeDevice);
            return SNMPFactory.getSNMPAPI().getNextOIDValue(string, sNMPTarget);
        }
        catch (Exception exception) {
            throw new MyException(exception);
        }
    }

    public static String checkAgentErroMsg(NodeDevice nodeDevice) {
        try {
            SNMPTarget sNMPTarget = SNMPTargetTool.nodeToSNMPConnInfo(nodeDevice);
            SNMPAPI sNMPAPI = SNMPFactory.getSNMPAPI();
            sNMPAPI.checkSnmpAgentActive(sNMPTarget);
            return null;
        }
        catch (Exception exception) {
            MyLog.err("\u68c0\u67e5SNMPAgent\u662f\u5426\u6d3b\u52a8\uff0c\u53d1\u751f\u9519\u8bef\uff0c\u8bbe\u5907ID:" + nodeDevice.getNodeName() + ",\u9519\u8bef:" + exception.getMessage());
            String string = exception.getMessage();
            if (string == null) {
                string = exception.toString();
            }
            return string;
        }
    }
}

