/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.GrammarException;
import net.percederberg.grammatica.TreePrinter;
import net.percederberg.grammatica.output.CSharpParserGenerator;
import net.percederberg.grammatica.output.JavaParserGenerator;
import net.percederberg.grammatica.output.VisualBasicParserGenerator;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

public class Grammatica {
    private static final /* synthetic */ String COMMAND_HELP = "Generates source code for a C#, Java or Visual Basic parser from\na grammar file. This program comes with ABSOLUTELY NO WARRANTY;\nfor details see the LICENSE.txt file.\n\nSyntax: Grammatica <grammarfile> <action> [<options>]\n\nActions:\n  --debug\n      Debugs the grammar by validating it and printing the\n      internal representation.\n  --tokenize <file>\n      Debugs the grammar by using it to tokenize the specified\n      file. No code has to be generated for this.\n  --parse <file>\n      Debugs the grammar by using it to parse the specified\n      file. No code has to be generated for this.\n  --profile <file(s)>\n      Profiles the grammar by using it to parse the specified\n      file(s) and printing a statistic summary.\n  --csoutput <dir>\n      Creates a C# parser for the grammar (in source code).\n      The specified directory will be used as output directory\n      for the source code files.\n  --javaoutput <dir>\n      Creates a Java parser for the grammar (in source code).\n      The specified directory will be used as the base output\n      directory for the source code files.\n  --vboutput <dir>\n      Creates a Visual Basic (.NET) parser for the grammar (in\n      source code). The specified directory will be used as\n      output directory for the source code files.\n\nC# Output Options:\n  --csnamespace <package>\n      Sets the C# namespace to use in generated source code\n      files. By default no namespace declaration is included.\n  --csclassname <name>\n      Sets the C# class name prefix to use in generated source\n      code files. By default the grammar file name is used.\n  --cspublic\n      Sets public access for all C# types generated. By default\n      type access is internal.\n\nJava Output Options:\n  --javapackage <package>\n      Sets the Java package to use in generated source code\n      files. By default no package declaration is included.\n  --javaclassname <name>\n      Sets the Java class name prefix to use in generated source\n      code files. By default the grammar file name is used.\n  --javapublic\n      Sets public access for all Java types. By default type\n      access is package local.\n\nVisual Basic Output Options:\n  --vbnamespace <package>\n      Sets the namespace to use in generated source code files.\n      By default no namespace declaration is included.\n  --vbclassname <name>\n      Sets the class name prefix to use in generated source code\n      files. By default the grammar file name is used.\n  --vbpublic\n      Sets public access for all types generated. By default type\n      access is friend.";
    private static final /* synthetic */ String INTERNAL_ERROR = "INTERNAL ERROR: An internal error in Grammatica has been found.\n    Please report this error to the maintainers (see the web\n    site for instructions). Be sure to include the Grammatica\n    version number, as well as the information below:\n";

    public Grammatica() {
        Grammatica iiiIIiIIIii;
    }

    public static void main(String[] iiiIIiIIIii) {
        Grammar iiiIIiIIIii2 = null;
        if (iiiIIiIIIii.length == 1 && iiiIIiIIIii[0].equals("--help")) {
            Grammatica.printHelp(null);
            System.exit(1);
        }
        if (iiiIIiIIIii.length < 2) {
            Grammatica.printHelp("Missing grammar file and/or action");
            System.exit(1);
        }
        try {
            iiiIIiIIIii2 = new Grammar(new File(iiiIIiIIIii[0]));
        }
        catch (FileNotFoundException iiiIIiIIIii3) {
            Grammatica.printError(iiiIIiIIIii[0], iiiIIiIIIii3);
            System.exit(1);
        }
        catch (ParserLogException iiiIIiIIIii4) {
            Grammatica.printError(iiiIIiIIIii[0], iiiIIiIIIii4);
            System.exit(1);
        }
        catch (GrammarException iiiIIiIIIii5) {
            Grammatica.printError(iiiIIiIIIii5);
            System.exit(1);
        }
        catch (SecurityException iiiIIiIIIii6) {
            throw iiiIIiIIIii6;
        }
        catch (RuntimeException iiiIIiIIIii7) {
            Grammatica.printInternalError(iiiIIiIIIii7);
            System.exit(2);
        }
        try {
            if (iiiIIiIIIii[1].equals("--debug")) {
                Grammatica.debug(iiiIIiIIIii2);
            } else if (iiiIIiIIIii.length < 3) {
                Grammatica.printHelp("missing action file parameter");
                System.exit(1);
            } else if (iiiIIiIIIii[1].equals("--tokenize")) {
                Grammatica.tokenize(iiiIIiIIIii2, new File(iiiIIiIIIii[2]));
            } else if (iiiIIiIIIii[1].equals("--parse")) {
                Grammatica.parse(iiiIIiIIIii2, new File(iiiIIiIIIii[2]));
            } else if (iiiIIiIIIii[1].equals("--profile")) {
                Grammatica.profile(iiiIIiIIIii2, iiiIIiIIIii, 2);
            } else if (iiiIIiIIIii[1].equals("--javaoutput")) {
                Grammatica.writeJavaCode(iiiIIiIIIii, iiiIIiIIIii2);
            } else if (iiiIIiIIIii[1].equals("--csoutput")) {
                Grammatica.writeCSharpCode(iiiIIiIIIii, iiiIIiIIIii2);
            } else if (iiiIIiIIIii[1].equals("--vboutput")) {
                Grammatica.writeVisualBasicCode(iiiIIiIIIii, iiiIIiIIIii2);
            } else {
                Grammatica.printHelp("unrecognized option: " + iiiIIiIIIii[1]);
                System.exit(1);
            }
        }
        catch (SecurityException iiiIIiIIIii8) {
            throw iiiIIiIIIii8;
        }
        catch (RuntimeException iiiIIiIIIii9) {
            Grammatica.printInternalError(iiiIIiIIIii9);
            System.exit(2);
        }
    }

    private static /* synthetic */ void printHelp(String iiiIIiIIIii) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (iiiIIiIIIii != null) {
            System.err.print("Error: ");
            System.err.println(iiiIIiIIIii);
            System.err.println();
        }
    }

    private static /* synthetic */ void printError(Exception iiiIIiIIIii) {
        StringBuffer iiiIIiIIIii2 = new StringBuffer();
        iiiIIiIIIii2.append("Error: ");
        iiiIIiIIIii2.append(iiiIIiIIIii.getMessage());
        System.err.println(iiiIIiIIIii2.toString());
    }

    private static /* synthetic */ void printError(String iiiIIiIIIii, FileNotFoundException iiiIIiIIIii2) {
        StringBuffer iiiIIiIIIii3 = new StringBuffer();
        iiiIIiIIIii3.append("Error: couldn't open file:");
        iiiIIiIIIii3.append("\n    ");
        iiiIIiIIIii3.append(iiiIIiIIIii);
        System.err.println(iiiIIiIIIii3.toString());
    }

    private static /* synthetic */ void printError(String iiiIIiIIIii, ParseException iiiIIiIIIii2) {
        StringBuffer iiiIIiIIIii3 = new StringBuffer();
        iiiIIiIIIii3.append("Error: in ");
        iiiIIiIIIii3.append(iiiIIiIIIii);
        if (iiiIIiIIIii2.getLine() > 0) {
            iiiIIiIIIii3.append(": line ");
            iiiIIiIIIii3.append(iiiIIiIIIii2.getLine());
        }
        iiiIIiIIIii3.append(":\n");
        iiiIIiIIIii3.append(Grammatica.linebreakString(iiiIIiIIIii2.getErrorMessage(), "    ", 70));
        String iiiIIiIIIii4 = Grammatica.readLines(iiiIIiIIIii, iiiIIiIIIii2.getLine(), iiiIIiIIIii2.getLine());
        if (iiiIIiIIIii4 != null) {
            iiiIIiIIIii3.append("\n\n");
            iiiIIiIIIii3.append(iiiIIiIIIii4);
            for (int iiiIIiIIIii5 = 1; iiiIIiIIIii5 < iiiIIiIIIii2.getColumn(); ++iiiIIiIIIii5) {
                if (iiiIIiIIIii4.charAt(iiiIIiIIIii5 - 1) == '\t') {
                    iiiIIiIIIii3.append("\t");
                    continue;
                }
                iiiIIiIIIii3.append(" ");
            }
            iiiIIiIIIii3.append("^");
        }
        System.err.println(iiiIIiIIIii3.toString());
    }

    private static /* synthetic */ void printError(String iiiIIiIIIii, ParserLogException iiiIIiIIIii2) {
        for (int iiiIIiIIIii3 = 0; iiiIIiIIIii3 < iiiIIiIIIii2.getErrorCount(); ++iiiIIiIIIii3) {
            Grammatica.printError(iiiIIiIIIii, iiiIIiIIIii2.getError(iiiIIiIIIii3));
        }
    }

    private static /* synthetic */ void printError(GrammarException iiiIIiIIIii) {
        StringBuffer iiiIIiIIIii2 = new StringBuffer();
        iiiIIiIIIii2.append("Error: in ");
        iiiIIiIIIii2.append(iiiIIiIIIii.getFile());
        if (iiiIIiIIIii.getStartLine() > 0) {
            if (iiiIIiIIIii.getStartLine() == iiiIIiIIIii.getEndLine()) {
                iiiIIiIIIii2.append(": line ");
                iiiIIiIIIii2.append(iiiIIiIIIii.getStartLine());
            } else {
                iiiIIiIIIii2.append(": lines ");
                iiiIIiIIIii2.append(iiiIIiIIIii.getStartLine());
                iiiIIiIIIii2.append("-");
                iiiIIiIIIii2.append(iiiIIiIIIii.getEndLine());
            }
        }
        iiiIIiIIIii2.append(":\n");
        iiiIIiIIIii2.append(Grammatica.linebreakString(iiiIIiIIIii.getErrorMessage(), "    ", 70));
        String iiiIIiIIIii3 = Grammatica.readLines(iiiIIiIIIii.getFile(), iiiIIiIIIii.getStartLine(), iiiIIiIIIii.getEndLine());
        if (iiiIIiIIIii3 != null) {
            iiiIIiIIIii2.append("\n\n");
            iiiIIiIIIii2.append(iiiIIiIIIii3);
        }
        System.err.println(iiiIIiIIIii2.toString());
    }

    private static /* synthetic */ void printInternalError(Exception iiiIIiIIIii) {
        System.err.println(INTERNAL_ERROR);
        iiiIIiIIIii.printStackTrace();
    }

    private static /* synthetic */ String linebreakString(String iiiIIiIIIii, String iiiIIiIIIii2, int iiiIIiIIIii3) {
        int iiiIIiIIIii4;
        StringBuffer iiiIIiIIIii5 = new StringBuffer();
        while (iiiIIiIIIii.length() + iiiIIiIIIii2.length() > iiiIIiIIIii3 && ((iiiIIiIIIii4 = iiiIIiIIIii.lastIndexOf(32, iiiIIiIIIii3 - iiiIIiIIIii2.length())) >= 0 || (iiiIIiIIIii4 = iiiIIiIIIii.indexOf(32)) >= 0)) {
            iiiIIiIIIii5.append(iiiIIiIIIii2);
            iiiIIiIIIii5.append(iiiIIiIIIii.substring(0, iiiIIiIIIii4));
            iiiIIiIIIii = iiiIIiIIIii.substring(iiiIIiIIIii4 + 1);
            iiiIIiIIIii5.append("\n");
        }
        iiiIIiIIIii5.append(iiiIIiIIIii2);
        iiiIIiIIIii5.append(iiiIIiIIIii);
        return iiiIIiIIIii5.toString();
    }

    private static /* synthetic */ String readLines(String iiiIIiIIIii, int iiiIIiIIIii2, int iiiIIiIIIii3) {
        StringBuffer iiiIIiIIIii4 = new StringBuffer();
        if (iiiIIiIIIii2 < 1 || iiiIIiIIIii3 < iiiIIiIIIii2) {
            return null;
        }
        try {
            BufferedReader iiiIIiIIIii5 = new BufferedReader(new FileReader(iiiIIiIIIii));
            for (int iiiIIiIIIii6 = 0; iiiIIiIIIii6 < iiiIIiIIIii3; ++iiiIIiIIIii6) {
                String iiiIIiIIIii7 = iiiIIiIIIii5.readLine();
                if (iiiIIiIIIii7 == null) {
                    iiiIIiIIIii5.close();
                    return null;
                }
                if (iiiIIiIIIii2 > iiiIIiIIIii6 + 1) continue;
                iiiIIiIIIii4.append(iiiIIiIIIii7);
                iiiIIiIIIii4.append("\n");
            }
            iiiIIiIIIii5.close();
        }
        catch (IOException iiiIIiIIIii8) {
            return null;
        }
        return iiiIIiIIIii4.toString();
    }

    private static /* synthetic */ void debug(Grammar iiiIIiIIIii) {
        Tokenizer iiiIIiIIIii2 = null;
        Parser iiiIIiIIIii3 = null;
        try {
            iiiIIiIIIii2 = iiiIIiIIIii.createTokenizer(null);
            iiiIIiIIIii3 = iiiIIiIIIii.createParser(iiiIIiIIIii2);
        }
        catch (GrammarException iiiIIiIIIii4) {
            Grammatica.printInternalError(iiiIIiIIIii4);
            System.exit(2);
        }
        System.out.println("Contents of " + iiiIIiIIIii.getFileName() + ":");
        System.out.println();
        System.out.println("Token Declarations:");
        System.out.println("-------------------");
        System.out.print(iiiIIiIIIii2);
        System.out.println("Production Declarations:");
        System.out.println("------------------------");
        System.out.print(iiiIIiIIIii3);
    }

    private static /* synthetic */ void tokenize(Grammar iiiIIiIIIii, File iiiIIiIIIii2) {
        try {
            Token iiiIIiIIIii3;
            Tokenizer iiiIIiIIIii4 = iiiIIiIIIii.createTokenizer(new FileReader(iiiIIiIIIii2));
            System.out.println("Tokens from " + iiiIIiIIIii2 + ":");
            while ((iiiIIiIIIii3 = iiiIIiIIIii4.next()) != null) {
                System.out.println(iiiIIiIIIii3);
            }
        }
        catch (FileNotFoundException iiiIIiIIIii5) {
            Grammatica.printError(iiiIIiIIIii2.toString(), iiiIIiIIIii5);
            System.exit(1);
        }
        catch (GrammarException iiiIIiIIIii6) {
            Grammatica.printInternalError(iiiIIiIIIii6);
            System.exit(2);
        }
        catch (ParseException iiiIIiIIIii7) {
            Grammatica.printError(iiiIIiIIIii2.toString(), iiiIIiIIIii7);
            System.exit(1);
        }
    }

    private static /* synthetic */ void parse(Grammar iiiIIiIIIii, File iiiIIiIIIii2) {
        try {
            Tokenizer iiiIIiIIIii3 = iiiIIiIIIii.createTokenizer(new FileReader(iiiIIiIIIii2));
            TreePrinter iiiIIiIIIii4 = new TreePrinter(System.out);
            Parser iiiIIiIIIii5 = iiiIIiIIIii.createParser(iiiIIiIIIii3, iiiIIiIIIii4);
            System.out.println("Parse tree from " + iiiIIiIIIii2 + ":");
            iiiIIiIIIii5.parse();
        }
        catch (FileNotFoundException iiiIIiIIIii6) {
            Grammatica.printError(iiiIIiIIIii2.toString(), iiiIIiIIIii6);
            System.exit(1);
        }
        catch (GrammarException iiiIIiIIIii7) {
            Grammatica.printInternalError(iiiIIiIIIii7);
            System.exit(2);
        }
        catch (ParserCreationException iiiIIiIIIii8) {
            Grammatica.printInternalError(iiiIIiIIIii8);
            System.exit(2);
        }
        catch (ParserLogException iiiIIiIIIii9) {
            Grammatica.printError(iiiIIiIIIii2.toString(), iiiIIiIIIii9);
            System.exit(1);
        }
    }

    private static /* synthetic */ void profile(Grammar iiiIIiIIIii, String[] iiiIIiIIIii2, int iiiIIiIIIii3) {
        int iiiIIiIIIii4;
        int iiiIIiIIIii5;
        long iiiIIiIIIii6;
        Tokenizer iiiIIiIIIii7;
        File iiiIIiIIIii8 = new File(iiiIIiIIIii2[iiiIIiIIIii3]);
        int iiiIIiIIIii9 = iiiIIiIIIii2.length - iiiIIiIIIii3;
        try {
            System.out.println("Tokenizing " + iiiIIiIIIii9 + " file(s)...");
            iiiIIiIIIii7 = iiiIIiIIIii.createTokenizer(new FileReader(iiiIIiIIIii8));
            iiiIIiIIIii6 = System.currentTimeMillis();
            iiiIIiIIIii5 = 0;
            for (iiiIIiIIIii4 = iiiIIiIIIii3; iiiIIiIIIii4 < iiiIIiIIIii2.length; ++iiiIIiIIIii4) {
                if (iiiIIiIIIii4 > iiiIIiIIIii3) {
                    iiiIIiIIIii8 = new File(iiiIIiIIIii2[iiiIIiIIIii4]);
                    iiiIIiIIIii7.reset(new FileReader(iiiIIiIIIii8));
                }
                while (iiiIIiIIIii7.next() != null) {
                    ++iiiIIiIIIii5;
                }
            }
            iiiIIiIIIii6 = System.currentTimeMillis() - iiiIIiIIIii6 + 1L;
            System.out.println("  Time elapsed:  " + iiiIIiIIIii6 + " millisec");
            System.out.println("  Tokens found:  " + iiiIIiIIIii5);
            System.out.println("  Average speed: " + (long)iiiIIiIIIii5 / iiiIIiIIIii6 + " tokens/millisec");
            System.out.println();
        }
        catch (FileNotFoundException iiiIIiIIIii10) {
            Grammatica.printError(iiiIIiIIIii8.toString(), iiiIIiIIIii10);
            System.exit(1);
        }
        catch (GrammarException iiiIIiIIIii11) {
            Grammatica.printInternalError(iiiIIiIIIii11);
            System.exit(2);
        }
        catch (ParseException iiiIIiIIIii12) {
            Grammatica.printError(iiiIIiIIIii8.toString(), iiiIIiIIIii12);
            System.exit(1);
        }
        try {
            System.out.println("Parsing " + iiiIIiIIIii9 + " file(s)...");
            iiiIIiIIIii8 = new File(iiiIIiIIIii2[iiiIIiIIIii3]);
            iiiIIiIIIii7 = iiiIIiIIIii.createTokenizer(new FileReader(iiiIIiIIIii8));
            Parser iiiIIiIIIii13 = iiiIIiIIIii.createParser(iiiIIiIIIii7);
            iiiIIiIIIii6 = System.currentTimeMillis();
            iiiIIiIIIii5 = 0;
            for (iiiIIiIIIii4 = iiiIIiIIIii3; iiiIIiIIIii4 < iiiIIiIIIii2.length; ++iiiIIiIIIii4) {
                if (iiiIIiIIIii4 > iiiIIiIIIii3) {
                    iiiIIiIIIii8 = new File(iiiIIiIIIii2[iiiIIiIIIii4]);
                    iiiIIiIIIii13.reset(new FileReader(iiiIIiIIIii8));
                }
                Node iiiIIiIIIii14 = iiiIIiIIIii13.parse();
                iiiIIiIIIii5 += 1 + iiiIIiIIIii14.getDescendantCount();
            }
            iiiIIiIIIii6 = System.currentTimeMillis() - iiiIIiIIIii6 + 1L;
            System.out.println("  Time elapsed:  " + iiiIIiIIIii6 + " millisec");
            System.out.println("  Nodes found:   " + iiiIIiIIIii5);
            System.out.println("  Average speed: " + (long)iiiIIiIIIii5 / iiiIIiIIIii6 + " nodes/millisec");
            System.out.println();
        }
        catch (FileNotFoundException iiiIIiIIIii15) {
            Grammatica.printError(iiiIIiIIIii8.toString(), iiiIIiIIIii15);
            System.exit(1);
        }
        catch (GrammarException iiiIIiIIIii16) {
            Grammatica.printInternalError(iiiIIiIIIii16);
            System.exit(2);
        }
        catch (ParserCreationException iiiIIiIIIii17) {
            Grammatica.printInternalError(iiiIIiIIIii17);
            System.exit(2);
        }
        catch (ParserLogException iiiIIiIIIii18) {
            Grammatica.printError(iiiIIiIIIii8.toString(), iiiIIiIIIii18);
            System.exit(1);
        }
    }

    private static /* synthetic */ void writeJavaCode(String[] iiiIIiIIIii, Grammar iiiIIiIIIii2) {
        JavaParserGenerator iiiIIiIIIii3 = new JavaParserGenerator(iiiIIiIIIii2);
        for (int iiiIIiIIIii4 = 1; iiiIIiIIIii4 < iiiIIiIIIii.length; ++iiiIIiIIIii4) {
            if (iiiIIiIIIii[iiiIIiIIIii4].equals("--javaoutput")) {
                iiiIIiIIIii3.setBaseDir(new File(iiiIIiIIIii[++iiiIIiIIIii4]));
                continue;
            }
            if (iiiIIiIIIii[iiiIIiIIIii4].equals("--javapackage")) {
                iiiIIiIIIii3.setBasePackage(iiiIIiIIIii[++iiiIIiIIIii4]);
                continue;
            }
            if (iiiIIiIIIii[iiiIIiIIIii4].equals("--javaclassname")) {
                iiiIIiIIIii3.setBaseName(iiiIIiIIIii[++iiiIIiIIIii4]);
                continue;
            }
            if (iiiIIiIIIii[iiiIIiIIIii4].equals("--javapublic")) {
                iiiIIiIIIii3.setPublicAccess(true);
                continue;
            }
            Grammatica.printHelp("unrecognized option: " + iiiIIiIIIii[iiiIIiIIIii4]);
            System.exit(1);
        }
        try {
            System.out.println("Writing Java parser source code...");
            iiiIIiIIIii3.write();
            System.out.println("Done.");
        }
        catch (IOException iiiIIiIIIii5) {
            Grammatica.printError(iiiIIiIIIii5);
            System.exit(1);
        }
    }

    private static /* synthetic */ void writeCSharpCode(String[] iiiIIiIIIii, Grammar iiiIIiIIIii2) {
        CSharpParserGenerator iiiIIiIIIii3 = new CSharpParserGenerator(iiiIIiIIIii2);
        for (int iiiIIiIIIii4 = 1; iiiIIiIIIii4 < iiiIIiIIIii.length; ++iiiIIiIIIii4) {
            if (iiiIIiIIIii[iiiIIiIIIii4].equals("--csoutput")) {
                iiiIIiIIIii3.setBaseDir(new File(iiiIIiIIIii[++iiiIIiIIIii4]));
                continue;
            }
            if (iiiIIiIIIii[iiiIIiIIIii4].equals("--csnamespace")) {
                iiiIIiIIIii3.setNamespace(iiiIIiIIIii[++iiiIIiIIIii4]);
                continue;
            }
            if (iiiIIiIIIii[iiiIIiIIIii4].equals("--csclassname")) {
                iiiIIiIIIii3.setBaseName(iiiIIiIIIii[++iiiIIiIIIii4]);
                continue;
            }
            if (iiiIIiIIIii[iiiIIiIIIii4].equals("--cspublic")) {
                iiiIIiIIIii3.setPublicAccess(true);
                continue;
            }
            Grammatica.printHelp("unrecognized option: " + iiiIIiIIIii[iiiIIiIIIii4]);
            System.exit(1);
        }
        try {
            System.out.println("Writing C# parser source code...");
            iiiIIiIIIii3.write();
            System.out.println("Done.");
        }
        catch (IOException iiiIIiIIIii5) {
            Grammatica.printError(iiiIIiIIIii5);
            System.exit(1);
        }
    }

    private static /* synthetic */ void writeVisualBasicCode(String[] iiiIIiIIIii, Grammar iiiIIiIIIii2) {
        VisualBasicParserGenerator iiiIIiIIIii3 = new VisualBasicParserGenerator(iiiIIiIIIii2);
        for (int iiiIIiIIIii4 = 1; iiiIIiIIIii4 < iiiIIiIIIii.length; ++iiiIIiIIIii4) {
            if (iiiIIiIIIii[iiiIIiIIIii4].equals("--vboutput")) {
                iiiIIiIIIii3.setBaseDir(new File(iiiIIiIIIii[++iiiIIiIIIii4]));
                continue;
            }
            if (iiiIIiIIIii[iiiIIiIIIii4].equals("--vbnamespace")) {
                iiiIIiIIIii3.setNamespace(iiiIIiIIIii[++iiiIIiIIIii4]);
                continue;
            }
            if (iiiIIiIIIii[iiiIIiIIIii4].equals("--vbclassname")) {
                iiiIIiIIIii3.setBaseName(iiiIIiIIIii[++iiiIIiIIIii4]);
                continue;
            }
            if (iiiIIiIIIii[iiiIIiIIIii4].equals("--vbpublic")) {
                iiiIIiIIIii3.setPublicAccess(true);
                continue;
            }
            Grammatica.printHelp("unrecognized option: " + iiiIIiIIIii[iiiIIiIIIii4]);
            System.exit(1);
        }
        try {
            System.out.println("Writing Visual Basic parser source code...");
            iiiIIiIIIii3.write();
            System.out.println("Done.");
        }
        catch (IOException iiiIIiIIIii5) {
            Grammatica.printError(iiiIIiIIIii5);
            System.exit(1);
        }
    }
}

