/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.IOException;
import java.io.PrintWriter;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.re.Element;
import net.percederberg.grammatica.parser.re.Matcher;
import net.percederberg.grammatica.parser.re.StringElement;

public class CharacterSetElement
extends Element {
    public static final CharacterSetElement DOT = new CharacterSetElement(false){
        {
            1 iiiIIiIIIii2;
        }

        public boolean inSet(char iiiIIiIIIii) {
            switch (iiiIIiIIIii) {
                case '\n': 
                case '\r': 
                case '\u0085': 
                case '\u2028': 
                case '\u2029': {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return ".";
        }
    };
    public static final CharacterSetElement DIGIT = new CharacterSetElement(false){
        {
            2 iiiIIiIIIii2;
        }

        public boolean inSet(char iiiIIiIIIii) {
            return '0' <= iiiIIiIIIii && iiiIIiIIIii <= '9';
        }

        public String toString() {
            return "\\d";
        }
    };
    public static final CharacterSetElement NON_DIGIT = new CharacterSetElement(true){
        {
            3 iiiIIiIIIii2;
        }

        public boolean inSet(char iiiIIiIIIii) {
            return iiiIIiIIIii < '0' || '9' < iiiIIiIIIii;
        }

        public String toString() {
            return "\\D";
        }
    };
    public static final CharacterSetElement WHITESPACE = new CharacterSetElement(false){
        {
            4 iiiIIiIIIii2;
        }

        public boolean inSet(char iiiIIiIIIii) {
            switch (iiiIIiIIIii) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "\\s";
        }
    };
    public static final CharacterSetElement NON_WHITESPACE = new CharacterSetElement(true){
        {
            5 iiiIIiIIIii2;
        }

        public boolean inSet(char iiiIIiIIIii) {
            switch (iiiIIiIIIii) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "\\S";
        }
    };
    public static final CharacterSetElement WORD = new CharacterSetElement(false){
        {
            6 iiiIIiIIIii2;
        }

        public boolean inSet(char iiiIIiIIIii) {
            return 'a' <= iiiIIiIIIii && iiiIIiIIIii <= 'z' || 'A' <= iiiIIiIIIii && iiiIIiIIIii <= 'Z' || '0' <= iiiIIiIIIii && iiiIIiIIIii <= '9' || iiiIIiIIIii == '_';
        }

        public String toString() {
            return "\\w";
        }
    };
    public static final CharacterSetElement NON_WORD = new CharacterSetElement(true){
        {
            7 iiiIIiIIIii2;
        }

        public boolean inSet(char iiiIIiIIIii) {
            boolean iiiIIiIIIii2 = 'a' <= iiiIIiIIIii && iiiIIiIIIii <= 'z' || 'A' <= iiiIIiIIIii && iiiIIiIIIii <= 'Z' || '0' <= iiiIIiIIIii && iiiIIiIIIii <= '9' || iiiIIiIIIii == '_';
            return !iiiIIiIIIii2;
        }

        public String toString() {
            return "\\W";
        }
    };
    private /* synthetic */ boolean inverted;
    private /* synthetic */ Object[] contents;

    public CharacterSetElement(boolean iiiIIiIIIii) {
        CharacterSetElement iiiIIiIIIii2;
        iiiIIiIIIii2.contents = new Object[0];
        iiiIIiIIIii2.inverted = iiiIIiIIIii;
    }

    public void addCharacter(char iiiIIiIIIii) {
        CharacterSetElement iiiIIiIIIii2;
        iiiIIiIIIii2.addContent(new Character(iiiIIiIIIii));
    }

    public void addCharacters(String iiiIIiIIIii) {
        for (int iiiIIiIIIii2 = 0; iiiIIiIIIii2 < iiiIIiIIIii.length(); ++iiiIIiIIIii2) {
            CharacterSetElement iiiIIiIIIii3;
            iiiIIiIIIii3.addCharacter(iiiIIiIIIii.charAt(iiiIIiIIIii2));
        }
    }

    public void addCharacters(StringElement iiiIIiIIIii) {
        CharacterSetElement iiiIIiIIIii2;
        iiiIIiIIIii2.addCharacters(iiiIIiIIIii.getString());
    }

    public void addRange(char iiiIIiIIIii, char iiiIIiIIIii2) {
        CharacterSetElement iiiIIiIIIii3;
        iiiIIiIIIii3.addContent(iiiIIiIIIii3.new Range(iiiIIiIIIii, iiiIIiIIIii2));
    }

    public void addCharacterSet(CharacterSetElement iiiIIiIIIii) {
        CharacterSetElement iiiIIiIIIii2;
        iiiIIiIIIii2.addContent(iiiIIiIIIii);
    }

    private /* synthetic */ void addContent(Object iiiIIiIIIii) {
        CharacterSetElement iiiIIiIIIii2;
        Object[] iiiIIiIIIii3 = iiiIIiIIIii2.contents;
        iiiIIiIIIii2.contents = new Object[iiiIIiIIIii3.length + 1];
        System.arraycopy(iiiIIiIIIii3, 0, iiiIIiIIIii2.contents, 0, iiiIIiIIIii3.length);
        iiiIIiIIIii2.contents[iiiIIiIIIii3.length] = iiiIIiIIIii;
    }

    public Object clone() {
        CharacterSetElement iiiIIiIIIii;
        return iiiIIiIIIii;
    }

    public int match(Matcher iiiIIiIIIii, ReaderBuffer iiiIIiIIIii2, int iiiIIiIIIii3, int iiiIIiIIIii4) throws IOException {
        CharacterSetElement iiiIIiIIIii5;
        if (iiiIIiIIIii4 != 0) {
            return -1;
        }
        int iiiIIiIIIii6 = iiiIIiIIIii2.peek(iiiIIiIIIii3);
        if (iiiIIiIIIii6 < 0) {
            iiiIIiIIIii.setReadEndOfString();
            return -1;
        }
        if (iiiIIiIIIii.isCaseInsensitive()) {
            iiiIIiIIIii6 = Character.toLowerCase((char)iiiIIiIIIii6);
        }
        return iiiIIiIIIii5.inSet((char)iiiIIiIIIii6) ? 1 : -1;
    }

    public boolean inSet(char iiiIIiIIIii) {
        CharacterSetElement iiiIIiIIIii2;
        for (int iiiIIiIIIii3 = 0; iiiIIiIIIii3 < iiiIIiIIIii2.contents.length; ++iiiIIiIIIii3) {
            CharacterSetElement iiiIIiIIIii4;
            Range iiiIIiIIIii5;
            Character iiiIIiIIIii6;
            Object iiiIIiIIIii7 = iiiIIiIIIii2.contents[iiiIIiIIIii3];
            if (!(iiiIIiIIIii7 instanceof Character ? (iiiIIiIIIii6 = (Character)iiiIIiIIIii7).charValue() == iiiIIiIIIii : (iiiIIiIIIii7 instanceof Range ? (iiiIIiIIIii5 = (Range)iiiIIiIIIii7).inside(iiiIIiIIIii) : iiiIIiIIIii7 instanceof CharacterSetElement && (iiiIIiIIIii4 = (CharacterSetElement)iiiIIiIIIii7).inSet(iiiIIiIIIii)))) continue;
            return !iiiIIiIIIii2.inverted;
        }
        return iiiIIiIIIii2.inverted;
    }

    public void printTo(PrintWriter iiiIIiIIIii, String iiiIIiIIIii2) {
        CharacterSetElement iiiIIiIIIii3;
        iiiIIiIIIii.println(iiiIIiIIIii2 + iiiIIiIIIii3.toString());
    }

    public String toString() {
        CharacterSetElement iiiIIiIIIii;
        StringBuffer iiiIIiIIIii2 = new StringBuffer();
        if (iiiIIiIIIii.inverted) {
            iiiIIiIIIii2.append("[^");
        } else {
            iiiIIiIIIii2.append("[");
        }
        for (int iiiIIiIIIii3 = 0; iiiIIiIIIii3 < iiiIIiIIIii.contents.length; ++iiiIIiIIIii3) {
            iiiIIiIIIii2.append(iiiIIiIIIii.contents[iiiIIiIIIii3]);
        }
        iiiIIiIIIii2.append("]");
        return iiiIIiIIIii2.toString();
    }

    private class Range {
        private /* synthetic */ char min;
        private /* synthetic */ char max;

        public Range(char iiiIIiIIIii, char iiiIIiIIIii2) {
            Range iiiIIiIIIii3;
            iiiIIiIIIii3.min = iiiIIiIIIii;
            iiiIIiIIIii3.max = iiiIIiIIIii2;
        }

        public boolean inside(char iiiIIiIIIii) {
            Range iiiIIiIIIii2;
            return iiiIIiIIIii >= iiiIIiIIIii2.min && iiiIIiIIIii <= iiiIIiIIIii2.max;
        }

        public String toString() {
            Range iiiIIiIIIii;
            return iiiIIiIIIii.min + "-" + iiiIIiIIIii.max;
        }
    }
}

