/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import com.zhtelecom.common.snmp.OMMappingInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import org.bouncycastle.crypto.CipherKeyGenerator;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class SecurityProtocols
implements Serializable {
    private static final /* synthetic */ long serialVersionUID = 3800474900139635836L;
    private /* synthetic */ Hashtable authProtocols;
    private /* synthetic */ Hashtable privProtocols;
    public static final String SECURITY_PROTOCOLS_PROPERTIES = "org.snmp4j.securityProtocols";
    private static final /* synthetic */ String SECURITY_PROTOCOLS_PROPERTIES_DEFAULT = "SecurityProtocols.properties";
    private static final /* synthetic */ LogAdapter logger;
    private static /* synthetic */ SecurityProtocols instance;
    private /* synthetic */ int maxAuthDigestLength;
    private /* synthetic */ int maxPrivDecryptParamsLength;

    static {
        logger = LogFactory.getLogger(SecurityProtocols.class);
        instance = null;
    }

    public SecurityProtocols() {
        SecurityProtocols iiiIIiIIIii;
        SecurityProtocols securityProtocols = iiiIIiIIIii;
        securityProtocols.maxAuthDigestLength = 0;
        securityProtocols.maxPrivDecryptParamsLength = 0;
        SecurityProtocols securityProtocols2 = iiiIIiIIIii;
        securityProtocols.authProtocols = new Hashtable(5);
        securityProtocols2.privProtocols = new Hashtable(5);
    }

    public static SecurityProtocols getInstance() {
        if (instance == null) {
            instance = new SecurityProtocols();
        }
        return instance;
    }

    public static void setSecurityProtocols(SecurityProtocols iiiIIiIIIii) {
        instance = iiiIIiIIIii;
    }

    public synchronized void addDefaultProtocols() {
        SecurityProtocols iiiIIiIIIii;
        block13: {
            InputStream inputStream;
            if (!SNMP4JSettings.isExtensibilityEnabled()) break block13;
            String string = System.getProperty(SECURITY_PROTOCOLS_PROPERTIES, SECURITY_PROTOCOLS_PROPERTIES_DEFAULT);
            InputStream inputStream2 = SecurityProtocols.class.getResourceAsStream(string);
            if (inputStream2 == null) {
                throw new InternalError(OMMappingInfo.IiIIiiiIIii("TVbUs\u0019yVc\u0019e\\v]7\u001e") + string + CipherKeyGenerator.IiIIiiiIIii("DC\u0005\u0011\f\u000eC\u0000\u000f\u0002\u0010\u0010\u0013\u0002\u0017\u000bB"));
            }
            Object object = new Properties();
            try {
                try {
                    Properties properties = object;
                    properties.load(inputStream2);
                    Object object2 = object = properties.propertyNames();
                    while (object2.hasMoreElements()) {
                        String string2 = (String)object.nextElement();
                        try {
                            Class<?> clazz = Class.forName(string2);
                            Object obj = clazz.newInstance();
                            if (obj instanceof AuthenticationProtocol) {
                                iiiIIiIIIii.addAuthenticationProtocol((AuthenticationProtocol)obj);
                                object2 = object;
                                continue;
                            }
                            if (obj instanceof PrivacyProtocol) {
                                iiiIIiIIIii.addPrivacyProtocol((PrivacyProtocol)obj);
                                object2 = object;
                                continue;
                            }
                            logger.error(OMMappingInfo.IiIIiiiIIii("QX~Ur]7Mx\u0019e\\pPdMrK7JrZbK~Mn\u0019gKxMxZxU7[rZvLd\\7Pc\u0019sVrJ7WxM7PzI{\\z\\yM7KrHbPe\\s\u0019~Wc\\e_vZrJ-\u0019") + string2);
                            object2 = object;
                        }
                        catch (Exception exception) {
                            logger.error(exception);
                            throw new InternalError(exception.toString());
                        }
                    }
                    inputStream = inputStream2;
                }
                catch (IOException iOException) {
                    String string3 = CipherKeyGenerator.IiIIiiiIIii(" \f\u0016\u000f\u0007C\r\f\u0017C\u0011\u0006\u0002\u0007CD") + string + OMMappingInfo.IiIIiiiIIii("\u001e-\u0019") + iOException.getMessage();
                    logger.error(string3);
                    throw new InternalError(string3);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                try {
                    inputStream2.close();
                    throwable2 = throwable;
                }
                catch (IOException iOException) {
                    logger.warn(iOException);
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            {
                inputStream.close();
                return;
            }
        }
        SecurityProtocols securityProtocols = iiiIIiIIIii;
        securityProtocols.addAuthenticationProtocol(new AuthMD5());
        securityProtocols.addAuthenticationProtocol(new AuthSHA());
        iiiIIiIIIii.addPrivacyProtocol(new PrivDES());
        securityProtocols.addPrivacyProtocol(new PrivAES128());
        securityProtocols.addPrivacyProtocol(new PrivAES192());
        securityProtocols.addPrivacyProtocol(new PrivAES256());
    }

    public synchronized void addAuthenticationProtocol(AuthenticationProtocol iiiIIiIIIii) {
        SecurityProtocols iiiIIiIIIii2;
        if (iiiIIiIIIii2.authProtocols.get(iiiIIiIIIii.getID()) == null) {
            AuthenticationProtocol authenticationProtocol = iiiIIiIIIii;
            iiiIIiIIIii2.authProtocols.put(iiiIIiIIIii.getID(), authenticationProtocol);
            if (authenticationProtocol.getDigestLength() > iiiIIiIIIii2.maxAuthDigestLength) {
                iiiIIiIIIii2.maxAuthDigestLength = iiiIIiIIIii.getDigestLength();
            }
        }
    }

    public AuthenticationProtocol getAuthenticationProtocol(OID iiiIIiIIIii) {
        SecurityProtocols iiiIIiIIIii2;
        if (iiiIIiIIIii == null) {
            return null;
        }
        return (AuthenticationProtocol)iiiIIiIIIii2.authProtocols.get(iiiIIiIIIii);
    }

    public void removeAuthenticationProtocol(AuthenticationProtocol iiiIIiIIIii) {
        SecurityProtocols iiiIIiIIIii2;
        iiiIIiIIIii2.authProtocols.remove(iiiIIiIIIii.getID());
    }

    public synchronized void addPrivacyProtocol(PrivacyProtocol iiiIIiIIIii) {
        SecurityProtocols iiiIIiIIIii2;
        if (iiiIIiIIIii2.privProtocols.get(iiiIIiIIIii.getID()) == null) {
            PrivacyProtocol privacyProtocol = iiiIIiIIIii;
            iiiIIiIIIii2.privProtocols.put(iiiIIiIIIii.getID(), privacyProtocol);
            if (privacyProtocol.getDecryptParamsLength() > iiiIIiIIIii2.maxPrivDecryptParamsLength) {
                iiiIIiIIIii2.maxPrivDecryptParamsLength = iiiIIiIIIii.getDecryptParamsLength();
            }
        }
    }

    public PrivacyProtocol getPrivacyProtocol(OID iiiIIiIIIii) {
        SecurityProtocols iiiIIiIIIii2;
        if (iiiIIiIIIii == null) {
            return null;
        }
        return (PrivacyProtocol)iiiIIiIIIii2.privProtocols.get(iiiIIiIIIii);
    }

    public void removePrivacyProtocol(PrivacyProtocol iiiIIiIIIii) {
        SecurityProtocols iiiIIiIIIii2;
        iiiIIiIIIii2.privProtocols.remove(iiiIIiIIIii.getID());
    }

    public byte[] passwordToKey(OID iiiIIiIIIii, OctetString iiiIIiIIIii2, byte[] iiiIIiIIIii3) {
        SecurityProtocols iiiIIiIIIii4;
        if ((iiiIIiIIIii = (AuthenticationProtocol)iiiIIiIIIii4.authProtocols.get(iiiIIiIIIii)) == null) {
            return null;
        }
        return iiiIIiIIIii.passwordToKey(iiiIIiIIIii2, iiiIIiIIIii3);
    }

    public byte[] passwordToKey(OID iiiIIiIIIii, OID iiiIIiIIIii2, OctetString iiiIIiIIIii3, byte[] iiiIIiIIIii4) {
        SecurityProtocols iiiIIiIIIii5;
        if ((iiiIIiIIIii2 = (AuthenticationProtocol)iiiIIiIIIii5.authProtocols.get(iiiIIiIIIii2)) == null) {
            return null;
        }
        if ((iiiIIiIIIii = (PrivacyProtocol)iiiIIiIIIii5.privProtocols.get(iiiIIiIIIii)) == null) {
            return null;
        }
        byte[] byArray = iiiIIiIIIii2.passwordToKey(iiiIIiIIIii3, iiiIIiIIIii4);
        if (byArray == null) {
            return null;
        }
        if (byArray.length >= iiiIIiIIIii.getMinKeyLength()) {
            if (byArray.length > iiiIIiIIIii.getMaxKeyLength()) {
                byte[] byArray2 = new byte[iiiIIiIIIii.getMaxKeyLength()];
                System.arraycopy(byArray, 0, byArray2, 0, iiiIIiIIIii.getMaxKeyLength());
                return byArray2;
            }
            return byArray;
        }
        byte[] byArray3 = iiiIIiIIIii.extendShortKey(byArray, iiiIIiIIIii3, iiiIIiIIIii4, (AuthenticationProtocol)iiiIIiIIIii2);
        return byArray3;
    }

    public int getMaxAuthDigestLength() {
        SecurityProtocols iiiIIiIIIii;
        return iiiIIiIIIii.maxAuthDigestLength;
    }

    public int getMaxPrivDecryptParamsLength() {
        SecurityProtocols iiiIIiIIIii;
        return iiiIIiIIIii.maxPrivDecryptParamsLength;
    }

    public byte[] truncateKey(byte[] iiiIIiIIIii, int iiiIIiIIIii22) {
        byte[] iiiIIiIIIii22 = new byte[Math.min(iiiIIiIIIii22, iiiIIiIIIii.length)];
        System.arraycopy(iiiIIiIIIii, 0, iiiIIiIIIii22, 0, iiiIIiIIIii22.length);
        return iiiIIiIIIii22;
    }
}

