﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Text.RegularExpressions;

namespace SunnyTest
{
    public partial class Form1 : Form
    {

        public Form1()
        {
            InitializeComponent();
        }

        //创建一个证书管理器对象 ws 客户端 TCP 客户端 需要用
        CertificateManager Certificate = new CertificateManager();

        //WS测试客户端 不能声明到局部 否则 子程序结束 内存就被回收
        WSClient ws = new WSClient();

        //WS客户端 不能声明到局部 否则 子程序结束 内存就被回收
        TCPClient tcp = new TCPClient();

        /// <summary>
        /// 队列测试
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button3_Click(object sender, EventArgs e)
        {

            //创建一个队列对象
            Queue a = new Queue();

            //创建一个队列
            a.创建队列("111唯一id");

            a.压入_字节集(System.Text.Encoding.GetEncoding("gb2312").GetBytes("00001"));
            a.压入("00002");
            a.压入("00003");
            //再创建一个队列对象
            Queue c = new Queue();

            //注意这里不使用 创建队列，而是使用 a 创建队列时 使用的唯一标识
            c.置唯一标识("111唯一id");

            //这时候a和c是一样的了
            //当前队列中有3个数据 00001 和 00002和 00003
            Console.WriteLine(a.弹出());//这里输出00001
            Console.WriteLine(c.弹出());//这里输出00002
            Console.WriteLine(c.弹出());//这里输出00003 

        }


        /// <summary>
        /// 证书管理器测试
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button4_Click(object sender, EventArgs e)
        {
            //创建一个证书管理器对象
            CertificateManager a = new CertificateManager();
            a.创建证书("baidu.com");
            Console.WriteLine(a.导出CA证书());
            //a._载入X509KeyPair(); //未测试
            //a._载入X509Certificate(); //未测试
            //等.....都未测试 
             
    
        }


        /// <summary>
        /// WS客户端 测试
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button5_Click_1(object sender, EventArgs e)
        {
            ws.断开();
            Console.Write("ws连接：");
            bool ok = ws.连接(WSClient_textBox_URL.Text, Callback.WsClientCallback, WSClient_textBox_Heads.Text, false);
            //bool ok = ws.连接(WSClient_textBox_URL.Text,  Callback.WsClientCallback, WSClient_textBox_Heads.Text, false, "", "", "", "", Certificate);
            Console.WriteLine(ok);
            //同步模式未测试
        }

        /// <summary>
        /// WS客户端发送数据
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void WSClient_button_Send_Click(object sender, EventArgs e)
        {
            ws.发送数据(Tool.StrToBytes(WSClient_textBox_Send.Text), Const.WSClient_TextMessage);
        }
        /// <summary>
        /// ws客户端 断开
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Ws_button_Close_Click(object sender, EventArgs e)
        {
            ws.断开();
        }

        /// <summary>
        /// TCP客户端测试
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button6_Click(object sender, EventArgs e)
        {
            tcp.断开();
            tcp.置缓冲区大小(4096);
            Console.Write("TCP连接：");
            //bool ok = tcp.连接(TcpClient_textBox_IP.Text, Callback.TcpClientCallback, Certificate);
            bool ok = tcp.连接(TcpClient_textBox_IP.Text, Callback.TcpClientCallback);
            //同步模式未测试
            Console.WriteLine(ok);

        }

        /// <summary>
        /// TCP客户端 发送数据
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button8_Click(object sender, EventArgs e)
        {
            tcp.发送数据(Tool.StrToBytes(TcpClient_textBox_Send.Text));
        }

        /// <summary>
        /// TCP客户端 断开
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button7_Click(object sender, EventArgs e)
        {
            tcp.断开();
        }

        /// <summary>
        /// HTTP客户端测试
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button9_Click(object sender, EventArgs e)
        {
            SunnyHttp http = new SunnyHttp();

            string Mods = "GET";
            if (radioButton1.Checked)
            {
                Mods = "POST";
            }

            http.打开(Mods, SunnyHttp_textBox_Url.Text);

            string Heads = SunnyHttp_textBox_Heads.Text;
            string[] arr = Regex.Split(Heads, "\r\n", RegexOptions.IgnoreCase);
            foreach (string s in arr)
            {
                string[] arr1 = Regex.Split(s, ": ", RegexOptions.IgnoreCase);
                if (arr1.Length == 2)
                {

                    http.置协议头(arr1[0], arr1[1]);
                }
            } 
            http.发送(SunnyHttp_textBox_data.Text);
            Console.WriteLine(http.取响应全部Heads());
            Console.WriteLine(Tool.BytesToStr(http.取响应内容()));
             
        }

        /// <summary>
        /// 存取健值表测试
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button10_Click(object sender, EventArgs e)
        {
            SunnyKeyValueTable Table1 = new SunnyKeyValueTable();
            Table1.写文本("a", "1111");
            Table1.写文本("b", "2222");
            Table1.写双精度("c", 3.1415926789);
            Table1.写字节集("d", Tool.StrToBytes("4444"));
            Console.Write("存取键值表测试-读文本-a：");
            Console.WriteLine(Table1.读文本("a"));
            Console.Write("存取键值表测试-读文本-b：");
            Console.WriteLine(Table1.读文本("b"));
            Console.Write("存取键值表测试-读双精度-c：");
            Console.WriteLine(Table1.读双精度("c"));
            Console.Write("存取键值表测试-读字节集-d(长度)：");
            Console.WriteLine(Table1.读字节集("d").Length);
            Console.Write("存取键值表测试-读文本-d：");
            Console.WriteLine(Table1.读文本("d"));
             

        }


        /// <summary>
        /// 中间件测试
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button1_Click_1(object sender, EventArgs e)
        {
            if (button1.Text == "停止")
            {
                SunnyPublic.停止代理();
                button1.Text = "启动";
                return;
            }
            bool b = false;
            if (checkBox1.Checked)
            {
                SunnyPublic.强制全部走TCP(checkBox2.Checked);
                b = SunnyPublic.启动(int.Parse(text_port.Text), Callback.HTTP回调, Callback.WebSocket回调, Callback.TCP回调);
            }
            else
            {
                b = SunnyPublic.启动(int.Parse(text_port.Text), Callback.HTTP回调, Callback.WebSocket回调, null);
            }


            Console.Write("中间件启动：");
            Console.WriteLine(b);
            if (b)
            {
                button1.Text = "停止";
            }
            else
            {
                button1.Text = "启动失败";
                Console.WriteLine(SunnyPublic.取错误信息());
            }
        }
        /// <summary>
        /// 设置或取消IE代理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void checkBox3_CheckedChanged(object sender, EventArgs e)
        {
            Sunny.SetIeProxy(!checkBox3.Checked);
        }
    }
}
