﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
namespace SunnyTest
{

    class Sunny
    {
        public static Request MessageIdToSunny(int MessageId)
        {
            Request request = new Request(MessageId);
            return request; 
        }


        public static bool Is64BitProcess = Environment.Is64BitProcess;

        public static int CreateCertificate()
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_CreateCertificate();
            }
            else
            {
                return Sunny86.Sunny_CreateCertificate();
            }
        }

        public static void RemoveCertificate(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_RemoveCertificate(Context);
            }
            else
            {
                Sunny86.Sunny_RemoveCertificate(Context);
            }
        }

        public static bool LoadP12Certificate(System.Int32 Context, IntPtr Name, IntPtr Password)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_LoadP12Certificate(Context, Name, Password);
            }
            else
            {
                return Sunny86.Sunny_LoadP12Certificate(Context, Name, Password);
            }
        }

        public static bool LoadX509KeyPair(System.Int32 Context, IntPtr Ca_Path, IntPtr KEY_Path)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_LoadX509KeyPair(Context, Ca_Path, KEY_Path);
            }
            else
            {
                return Sunny86.Sunny_LoadX509KeyPair(Context, Ca_Path, KEY_Path);
            }
        }

        public static bool LoadX509Certificate(System.Int32 Context, IntPtr Host, IntPtr CA, IntPtr KEY)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_LoadX509Certificate(Context, Host, CA, KEY);
            }
            else
            {
                return Sunny86.Sunny_LoadX509Certificate(Context, Host, CA, KEY);
            }
        }

        public static bool SetInsecureSkipVerify(System.Int32 Context, System.Boolean b)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SetInsecureSkipVerify(Context, b);
            }
            else
            {
                return Sunny86.Sunny_SetInsecureSkipVerify(Context, b);
            }
        }

        public static bool SetServerName(System.Int32 Context, IntPtr name)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SetServerName(Context, name);
            }
            else
            {
                return Sunny86.Sunny_SetServerName(Context, name);
            }
        }

        public static IntPtr GetServerName(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetServerName(Context);
            }
            else
            {
                return Sunny86.Sunny_GetServerName(Context);
            }
        }

        public static bool AddCertPoolPath(System.Int32 Context, IntPtr cer)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_AddCertPoolPath(Context, cer);
            }
            else
            {
                return Sunny86.Sunny_AddCertPoolPath(Context, cer);
            }
        }

        public static bool AddCertPoolText(System.Int32 Context, IntPtr cer)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_AddCertPoolText(Context, cer);
            }
            else
            {
                return Sunny86.Sunny_AddCertPoolText(Context, cer);
            }
        }

        public static bool AddClientAuth(System.Int32 Context, System.Int32 val)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_AddClientAuth(Context, val);
            }
            else
            {
                return Sunny86.Sunny_AddClientAuth(Context, val);
            }
        }

        public static bool CreateCA(System.Int32 Context, IntPtr Country, IntPtr Organization, IntPtr OrganizationalUnit, IntPtr Province, IntPtr CommonName, IntPtr Locality, System.Int32 bits, System.Int32 NotAfter)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_CreateCA(Context, Country, Organization, OrganizationalUnit, Province, CommonName, Locality, bits, NotAfter);
            }
            else
            {
                return Sunny86.Sunny_CreateCA(Context, Country, Organization, OrganizationalUnit, Province, CommonName, Locality, bits, NotAfter);
            }
        }

        public static IntPtr ExportCA(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_ExportCA(Context);
            }
            else
            {
                return Sunny86.Sunny_ExportCA(Context);
            }
        }

        public static IntPtr ExportKEY(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_ExportKEY(Context);
            }
            else
            {
                return Sunny86.Sunny_ExportKEY(Context);
            }
        }

        public static IntPtr ExportPub(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_ExportPub(Context);
            }
            else
            {
                return Sunny86.Sunny_ExportPub(Context);
            }
        }

        public static bool ExportP12(System.Int32 Context, IntPtr path, IntPtr pass)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_ExportP12(Context, path, pass);
            }
            else
            {
                return Sunny86.Sunny_ExportP12(Context, path, pass);
            }
        }

        public static int CreateHTTPClient()
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_CreateHTTPClient();
            }
            else
            {
                return Sunny86.Sunny_CreateHTTPClient();
            }
        }

        public static void RemoveHTTPClient(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_RemoveHTTPClient(Context);
            }
            else
            {
                Sunny86.Sunny_RemoveHTTPClient(Context);
            }
        }

        public static IntPtr HTTPClientGetErr(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_HTTPClientGetErr(Context);
            }
            else
            {
                return Sunny86.Sunny_HTTPClientGetErr(Context);
            }
        }

        public static void HTTPOpen(System.Int32 Context, IntPtr mod, IntPtr u)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_HTTPOpen(Context, mod, u);
            }
            else
            {
                Sunny86.Sunny_HTTPOpen(Context, mod, u);
            }
        }

        public static void HTTPSetHeader(System.Int32 Context, IntPtr name, IntPtr value)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_HTTPSetHeader(Context, name, value);
            }
            else
            {
                Sunny86.Sunny_HTTPSetHeader(Context, name, value);
            }
        }
        public static bool HTTPSetRedirect(int Context, bool Redirect)
        {
            if (Is64BitProcess)
            {
                return Sunny64.HTTPSetRedirect(Context, Redirect);
            }
            else
            {
                return Sunny86.HTTPSetRedirect(Context, Redirect);
            }
        }
        public static void HTTPSetProxyIP(System.Int32 Context, IntPtr ip)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_HTTPSetProxyIP(Context, ip);
            }
            else
            {
                Sunny86.Sunny_HTTPSetProxyIP(Context, ip);
            }
        }

        public static void HTTPSetProxyBasicAuth(System.Int32 Context, IntPtr u, IntPtr p)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_HTTPSetProxyBasicAuth(Context, u, p);
            }
            else
            {
                Sunny86.Sunny_HTTPSetProxyBasicAuth(Context, u, p);
            }
        }

        public static void HTTPSetTimeouts(System.Int32 Context, System.Int32 t1, System.Int32 t2, System.Int32 t3)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_HTTPSetTimeouts(Context, t1, t2, t3);
            }
            else
            {
                Sunny86.Sunny_HTTPSetTimeouts(Context, t1, t2, t3);
            }
        }

        public static void HTTPSendBin(System.Int32 Context, IntPtr b, System.Int32 l)
        {
          
            if (Is64BitProcess)
            {
                Sunny64.Sunny_HTTPSendBin(Context, b, l);
            }
            else
            {
                Sunny86.Sunny_HTTPSendBin(Context, b, l);
            }
        }

        public static int HTTPGetBodyLen(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_HTTPGetBodyLen(Context);
            }
            else
            {
                return Sunny86.Sunny_HTTPGetBodyLen(Context);
            }
        }

        public static IntPtr HTTPGetHeads(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_HTTPGetHeads(Context);
            }
            else
            {
                return Sunny86.Sunny_HTTPGetHeads(Context);
            }
        }

        public static IntPtr HTTPGetBody(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_HTTPGetBody(Context);
            }
            else
            {
                return Sunny86.Sunny_HTTPGetBody(Context);
            }
        }

        public static int HTTPGetCode(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_HTTPGetCode(Context);
            }
            else
            {
                return Sunny86.Sunny_HTTPGetCode(Context);
            }
        }

        public static void CreateQueue(IntPtr name)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_CreateQueue(name);
            }
            else
            {
                Sunny86.Sunny_CreateQueue(name);
            }
        }

        public static bool QueueIsEmpty(IntPtr name)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_QueueIsEmpty(name);
            }
            else
            {
                return Sunny86.Sunny_QueueIsEmpty(name);
            }
        }

        public static void QueueRelease(IntPtr name)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_QueueRelease(name);
            }
            else
            {
                Sunny86.Sunny_QueueRelease(name);
            }
        }

        public static int QueueLength(IntPtr name)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_QueueLength(name);
            }
            else
            {
                return Sunny86.Sunny_QueueLength(name);
            }
        }

        public static void QueuePush(IntPtr name, IntPtr val, System.Int32 vallen)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_QueuePush(name, val, vallen);
            }
            else
            {
                Sunny86.Sunny_QueuePush(name, val, vallen);
            }
        }

        public static IntPtr QueuePull(IntPtr name, IntPtr rlen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_QueuePull(name, rlen);
            }
            else
            {
                return Sunny86.Sunny_QueuePull(name, rlen);
            }
        }

        public static int CreateKeys()
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_CreateKeys();
            }
            else
            {
                return Sunny86.Sunny_CreateKeys();
            }
        }

        public static void RemoveKeys(System.Int32 KeysHandle)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_RemoveKeys(KeysHandle);
            }
            else
            {
                Sunny86.Sunny_RemoveKeys(KeysHandle);
            }
        }

        public static void KeysDelete(System.Int32 KeysHandle, IntPtr name)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_KeysDelete(KeysHandle, name);
            }
            else
            {
                Sunny86.Sunny_KeysDelete(KeysHandle, name);
            }
        }

        public static IntPtr KeysRead(System.Int32 KeysHandle, IntPtr name, IntPtr p)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_KeysRead(KeysHandle, name, p);
            }
            else
            {
                return Sunny86.Sunny_KeysRead(KeysHandle, name, p);
            }
        }

        public static void KeysWrite(System.Int32 KeysHandle, IntPtr name, IntPtr val, System.Int32 len)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_KeysWrite(KeysHandle, name, val, len);
            }
            else
            {
                Sunny86.Sunny_KeysWrite(KeysHandle, name, val, len);
            }
        }

        public static void KeysWriteFloat(System.Int32 KeysHandle, IntPtr name, System.Double val)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_KeysWriteFloat(KeysHandle, name, val);
            }
            else
            {
                Sunny86.Sunny_KeysWriteFloat(KeysHandle, name, val);
            }
        }

        public static Double KeysReadFloat(System.Int32 KeysHandle, IntPtr name)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_KeysReadFloat(KeysHandle, name);
            }
            else
            {
                return Sunny86.Sunny_KeysReadFloat(KeysHandle, name);
            }
        }

        public static void KeysWriteLong(System.Int32 KeysHandle, IntPtr name, System.Int64 val)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_KeysWriteLong(KeysHandle, name, val);
            }
            else
            {
                Sunny86.Sunny_KeysWriteLong(KeysHandle, name, val);
            }
        }

        public static Int64 KeysReadLong(System.Int32 KeysHandle, IntPtr name)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_KeysReadLong(KeysHandle, name);
            }
            else
            {
                return Sunny86.Sunny_KeysReadLong(KeysHandle, name);
            }
        }

        public static void KeysWriteInt(System.Int32 KeysHandle, IntPtr name, System.Int32 val)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_KeysWriteInt(KeysHandle, name, val);
            }
            else
            {
                Sunny86.Sunny_KeysWriteInt(KeysHandle, name, val);
            }
        }

        public static int KeysReadInt(System.Int32 KeysHandle, IntPtr name)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_KeysReadInt(KeysHandle, name);
            }
            else
            {
                return Sunny86.Sunny_KeysReadInt(KeysHandle, name);
            }
        }

        public static void KeysEmpty(System.Int32 KeysHandle)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_KeysEmpty(KeysHandle);
            }
            else
            {
                Sunny86.Sunny_KeysEmpty(KeysHandle);
            }
        }

        public static int KeysGetCount(System.Int32 KeysHandle)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_KeysGetCount(KeysHandle);
            }
            else
            {
                return Sunny86.Sunny_KeysGetCount(KeysHandle);
            }
        }

        public static IntPtr KeysGetJson(System.Int32 KeysHandle)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_KeysGetJson(KeysHandle);
            }
            else
            {
                return Sunny86.Sunny_KeysGetJson(KeysHandle);
            }
        }

        public static void KeysWriteStr(System.Int32 KeysHandle, IntPtr name, IntPtr val, System.Int32 len)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_KeysWriteStr(KeysHandle, name, val, len);
            }
            else
            {
                Sunny86.Sunny_KeysWriteStr(KeysHandle, name, val, len);
            }
        }

        public static int CreateSocketClient()
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_CreateSocketClient();
            }
            else
            {
                return Sunny86.Sunny_CreateSocketClient();
            }
        }

        public static void RemoveSocketClient(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_RemoveSocketClient(Context);
            }
            else
            {
                Sunny86.Sunny_RemoveSocketClient(Context);
            }
        }

        public static IntPtr SocketClientGetErr(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SocketClientGetErr(Context);
            }
            else
            {
                return Sunny86.Sunny_SocketClientGetErr(Context);
            }
        }

        public static bool SocketClientSetBufferSize(System.Int32 Context, System.Int32 BufferSize)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SocketClientSetBufferSize(Context, BufferSize);
            }
            else
            {
                return Sunny86.Sunny_SocketClientSetBufferSize(Context, BufferSize);
            }
        }

        public static bool SocketClientDial(System.Int32 Context, IntPtr addr, IntPtr call, System.Boolean istls, System.Boolean synchronous, IntPtr ProxyIP, IntPtr ProxyUser, IntPtr ProxyPass, System.Int32 CertificateConText)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SocketClientDial(Context, addr, call, istls, synchronous, ProxyIP, ProxyUser, ProxyPass, CertificateConText);
            }
            else
            {
                return Sunny86.Sunny_SocketClientDial(Context, addr, call, istls, synchronous, ProxyIP, ProxyUser, ProxyPass, CertificateConText);
            }
        }

        public static IntPtr SocketClientReceive(System.Int32 Context, System.Int32 OutTimes, IntPtr len)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SocketClientReceive(Context, OutTimes, len);
            }
            else
            {
                return Sunny86.Sunny_SocketClientReceive(Context, OutTimes, len);
            }
        }

        public static void SocketClientClose(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SocketClientClose(Context);
            }
            else
            {
                Sunny86.Sunny_SocketClientClose(Context);
            }
        }

        public static int SocketClientWrite(System.Int32 Context, System.Int32 OutTimes, IntPtr val, System.Int32 vallen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SocketClientWrite(Context, OutTimes, val, vallen);
            }
            else
            {
                return Sunny86.Sunny_SocketClientWrite(Context, OutTimes, val, vallen);
            }
        }

        public static int CreateWebsocket()
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_CreateWebsocket();
            }
            else
            {
                return Sunny86.Sunny_CreateWebsocket();
            }
        }

        public static void RemoveWebsocket(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_RemoveWebsocket(Context);
            }
            else
            {
                Sunny86.Sunny_RemoveWebsocket(Context);
            }
        }

        public static IntPtr WebsocketGetErr(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_WebsocketGetErr(Context);
            }
            else
            {
                return Sunny86.Sunny_WebsocketGetErr(Context);
            }
        }

        public static bool WebsocketDial(System.Int32 Context, IntPtr url_, IntPtr head_, IntPtr call, System.Boolean synchronous, IntPtr ProxyType, IntPtr ProxyAddr, IntPtr ProxyUser, IntPtr ProxyPass, System.Int32 CertificateConText)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_WebsocketDial(Context, url_, head_, call, synchronous, ProxyType, ProxyAddr, ProxyUser, ProxyPass, CertificateConText);
            }
            else
            {
                return Sunny86.Sunny_WebsocketDial(Context, url_, head_, call, synchronous, ProxyType, ProxyAddr, ProxyUser, ProxyPass, CertificateConText);
            }
        }

        public static void WebsocketClose(System.Int32 Context)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_WebsocketClose(Context);
            }
            else
            {
                Sunny86.Sunny_WebsocketClose(Context);
            }
        }

        public static bool WebsocketReadWrite(System.Int32 Context, IntPtr val, System.Int32 vallen, System.Int32 types)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_WebsocketReadWrite(Context, val, vallen, types);
            }
            else
            {
                return Sunny86.Sunny_WebsocketReadWrite(Context, val, vallen, types);
            }
        }

        public static IntPtr WebsocketClientReceive(System.Int32 Context, System.Int32 OutTimes, IntPtr messageType, IntPtr lenx)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_WebsocketClientReceive(Context, OutTimes, messageType, lenx);
            }
            else
            {
                return Sunny86.Sunny_WebsocketClientReceive(Context, OutTimes, messageType, lenx);
            }
        }

        public static void SetRequestHeader(System.Int32 MessageId, IntPtr name, IntPtr val)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SetRequestHeader(MessageId, name, val);
            }
            else
            {
                Sunny86.Sunny_SetRequestHeader(MessageId, name, val);
            }
        }

        public static void SetRequestProxy(System.Int32 MessageId, IntPtr val, IntPtr val1, System.Int32 out1)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SetRequestProxy(MessageId, val, val1, out1);
            }
            else
            {
                Sunny86.Sunny_SetRequestProxy(MessageId, val, val1, out1);
            }
        }

        public static int GetResponseStatusCode(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetResponseStatusCode(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetResponseStatusCode(MessageId);
            }
        }

        public static IntPtr GetRequestClientIp(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetRequestClientIp(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetRequestClientIp(MessageId);
            }
        }

        public static IntPtr GetResponseStatus(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetResponseStatus(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetResponseStatus(MessageId);
            }
        }

        public static void SetResponseStatus(System.Int32 MessageId, System.Int32 code)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SetResponseStatus(MessageId, code);
            }
            else
            {
                Sunny86.Sunny_SetResponseStatus(MessageId, code);
            }
        }

        public static void DelResponseHeader(System.Int32 MessageId, IntPtr name)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_DelResponseHeader(MessageId, name);
            }
            else
            {
                Sunny86.Sunny_DelResponseHeader(MessageId, name);
            }
        }

        public static void DelRequestHeader(System.Int32 MessageId, IntPtr name)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_DelRequestHeader(MessageId, name);
            }
            else
            {
                Sunny86.Sunny_DelRequestHeader(MessageId, name);
            }
        }

        public static bool SetRequestUrl(System.Int32 MessageId, IntPtr URI)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SetRequestUrl(MessageId, URI);
            }
            else
            {
                return Sunny86.Sunny_SetRequestUrl(MessageId, URI);
            }
        }

        public static void SetRequestCookie(System.Int32 MessageId, IntPtr name, IntPtr val)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SetRequestCookie(MessageId, name, val);
            }
            else
            {
                Sunny86.Sunny_SetRequestCookie(MessageId, name, val);
            }
        }

        public static void SetRequestAllCookie(System.Int32 MessageId, IntPtr val)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SetRequestAllCookie(MessageId, val);
            }
            else
            {
                Sunny86.Sunny_SetRequestAllCookie(MessageId, val);
            }
        }

        public static IntPtr GetRequestHeader(System.Int32 MessageId, IntPtr name)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetRequestHeader(MessageId, name);
            }
            else
            {
                return Sunny86.Sunny_GetRequestHeader(MessageId, name);
            }
        }

        public static void SetResponseHeader(System.Int32 MessageId, IntPtr name, IntPtr val)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SetResponseHeader(MessageId, name, val);
            }
            else
            {
                Sunny86.Sunny_SetResponseHeader(MessageId, name, val);
            }
        }

        public static void SetResponseAllHeader(System.Int32 MessageId, IntPtr value)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SetResponseAllHeader(MessageId, value);
            }
            else
            {
                Sunny86.Sunny_SetResponseAllHeader(MessageId, value);
            }
        }

        public static IntPtr GetRequestCookie(System.Int32 MessageId, IntPtr name)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetRequestCookie(MessageId, name);
            }
            else
            {
                return Sunny86.Sunny_GetRequestCookie(MessageId, name);
            }
        }

        public static IntPtr GetRequestData(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetRequestData(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetRequestData(MessageId);
            }
        }

        public static int SetResponseData(System.Int32 MessageId, IntPtr data, System.Int32 datalen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SetResponseData(MessageId, data, datalen);
            }
            else
            {
                return Sunny86.Sunny_SetResponseData(MessageId, data, datalen);
            }
        }

        public static void SetIpProxy(IntPtr ip)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SetIpProxy(ip);
            }
            else
            {
                Sunny86.Sunny_SetIpProxy(ip);
            }
        }

        public static void SetIpAuth(IntPtr Auth)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SetIpAuth(Auth);
            }
            else
            {
                Sunny86.Sunny_SetIpAuth(Auth);
            }
        }

        public static void SetProxyTimeout(System.Int32 Timeout)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SetProxyTimeout(Timeout);
            }
            else
            {
                Sunny86.Sunny_SetProxyTimeout(Timeout);
            }
        }

        public static IntPtr GetResponseData(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetResponseData(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetResponseData(MessageId);
            }
        }

        public static int GetRequestBodyLen(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetRequestBodyLen(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetRequestBodyLen(MessageId);
            }
        }

        public static int GetResponseBodyLen(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetResponseBodyLen(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetResponseBodyLen(MessageId);
            }
        }

        public static int SetRequestData(System.Int32 MessageId, IntPtr data, System.Int32 datalen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SetRequestData(MessageId, data, datalen);
            }
            else
            {
                return Sunny86.Sunny_SetRequestData(MessageId, data, datalen);
            }
        }

        public static IntPtr GetRequestBody(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetRequestBody(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetRequestBody(MessageId);
            }
        }

        public static IntPtr GetResponseBody(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetResponseBody(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetResponseBody(MessageId);
            }
        }

        public static int GetWebsocketBodyLen(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetWebsocketBodyLen(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetWebsocketBodyLen(MessageId);
            }
        }

        public static IntPtr GetWebsocketBody(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetWebsocketBody(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetWebsocketBody(MessageId);
            }
        }

        public static bool SetWebsocketBody(System.Int32 MessageId, IntPtr data, System.Int32 datalen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SetWebsocketBody(MessageId, data, datalen);
            }
            else
            {
                return Sunny86.Sunny_SetWebsocketBody(MessageId, data, datalen);
            }
        }

        public static bool SendWebsocketBody(System.Int32 MessageId, System.Int32 MessageTpye, IntPtr data, System.Int32 datalen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SendWebsocketBody(MessageId, MessageTpye, data, datalen);
            }
            else
            {
                return Sunny86.Sunny_SendWebsocketBody(MessageId, MessageTpye, data, datalen);
            }
        }

        public static IntPtr GetRequestALLCookie(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetRequestALLCookie(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetRequestALLCookie(MessageId);
            }
        }

        public static IntPtr GetResponseAllHeader(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetResponseAllHeader(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetResponseAllHeader(MessageId);
            }
        }

        public static IntPtr GetResponseHeader(System.Int32 MessageId, IntPtr name)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetResponseHeader(MessageId, name);
            }
            else
            {
                return Sunny86.Sunny_GetResponseHeader(MessageId, name);
            }
        }

        public static IntPtr GetRequestAllHeader(System.Int32 MessageId)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GetRequestAllHeader(MessageId);
            }
            else
            {
                return Sunny86.Sunny_GetRequestAllHeader(MessageId);
            }
        }

        public static bool SetTcpBody(System.Int32 MessageId, System.Int32 MsgType, IntPtr data, System.Int32 datalen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SetTcpBody(MessageId, MsgType, data, datalen);
            }
            else
            {
                return Sunny86.Sunny_SetTcpBody(MessageId, MsgType, data, datalen);
            }
        }

        public static bool SetTcpAgent(System.Int32 MessageId, IntPtr ip, IntPtr user, IntPtr pass)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SetTcpAgent(MessageId, ip, user, pass);
            }
            else
            {
                return Sunny86.Sunny_SetTcpAgent(MessageId, ip, user, pass);
            }
        }

        public static bool TcpCloseClient(System.Int32 Theonly)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_TcpCloseClient(Theonly);
            }
            else
            {
                return Sunny86.Sunny_TcpCloseClient(Theonly);
            }
        }

        public static bool SetTcpConnectionIP(System.Int32 MessageId, IntPtr data)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SetTcpConnectionIP(MessageId, data);
            }
            else
            {
                return Sunny86.Sunny_SetTcpConnectionIP(MessageId, data);
            }
        }

        public static int TcpSendMsg(System.Int32 MessageId, IntPtr data, System.Int32 datalen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_TcpSendMsg(MessageId, data, datalen);
            }
            else
            {
                return Sunny86.Sunny_TcpSendMsg(MessageId, data, datalen);
            }
        }

        public static int TcpSendMsgClient(System.Int32 MessageId, IntPtr data, System.Int32 datalen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_TcpSendMsgClient(MessageId, data, datalen);
            }
            else
            {
                return Sunny86.Sunny_TcpSendMsgClient(MessageId, data, datalen);
            }
        }

        public static void SetCa(System.Int32 ca)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SetCa(ca);
            }
            else
            {
                Sunny86.Sunny_SetCa(ca);
            }
        }

        public static IntPtr HexDump(IntPtr data, System.Int32 datalen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_HexDump(data, datalen);
            }
            else
            {
                return Sunny86.Sunny_HexDump(data, datalen);
            }
        }

        public static IntPtr Geterr()
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_Geterr();
            }
            else
            {
                return Sunny86.Sunny_Geterr();
            }
        }
        /// <summary>
        /// 设置或取消IE代理
        /// </summary>
        /// <param name="del">为真表示取消  为假表示 设置</param>
        /// <returns></returns>
        public static bool SetIeProxy(System.Boolean del)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_SetIeProxy(del);
            }
            else
            {
                return Sunny86.Sunny_SetIeProxy(del);
            }
        }

        public static bool PInit(System.Int32 port, IntPtr _callback, bool IsInstall, bool SetIEproxy)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_PInit(port, _callback, IsInstall, SetIEproxy);
            }
            else
            {
                return Sunny86.Sunny_PInit(port, _callback, IsInstall, SetIEproxy);
            }
        }

        public static void OpenTcp(IntPtr s)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_OpenTcp(s);
            }
            else
            {
                Sunny86.Sunny_OpenTcp(s);
            }
        }

        public static void Stop()
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_Stop();
            }
            else
            {
                Sunny86.Sunny_Stop();
            }
        }

        public static IntPtr BrUnCompress(IntPtr val, System.Int32 vallen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_BrUnCompress(val, vallen);
            }
            else
            {
                return Sunny86.Sunny_BrUnCompress(val, vallen);
            }
        }

        public static IntPtr GzipUnCompress(IntPtr val, System.Int32 vallen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_GzipUnCompress(val, vallen);
            }
            else
            {
                return Sunny86.Sunny_GzipUnCompress(val, vallen);
            }
        }

        public static IntPtr DeflateUnCompress(IntPtr val, System.Int32 vallen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_DeflateUnCompress(val, vallen);
            }
            else
            {
                return Sunny86.Sunny_DeflateUnCompress(val, vallen);
            }
        }

        public static int BytesToInt(IntPtr val, System.Int32 vallen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_BytesToInt(val, vallen);
            }
            else
            {
                return Sunny86.Sunny_BytesToInt(val, vallen);
            }
        }

        public static void Cfree(IntPtr s)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_Cfree(s);
            }
            else
            {
                Sunny86.Sunny_Cfree(s);
            }
        }

        public static bool StartProcess()
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_StartProcess();
            }
            else
            {
                return Sunny86.Sunny_StartProcess();
            }
        }

        public static bool ProcessAddPID(System.Int32 s)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_ProcessAddPID(s);
            }
            else
            {
                return Sunny86.Sunny_ProcessAddPID(s);
            }
        }

        public static bool ProcessStart()
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_ProcessStart();
            }
            else
            {
                return Sunny86.Sunny_ProcessStart();
            }
        }

        public static bool ProcessCancelAll()
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_ProcessCancelAll();
            }
            else
            {
                return Sunny86.Sunny_ProcessCancelAll();
            }
        }

        public static bool ProcessDelPID(System.Int32 s)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_ProcessDelPID(s);
            }
            else
            {
                return Sunny86.Sunny_ProcessDelPID(s);
            }
        }

        public static void DelP12Certificate(IntPtr HostName)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_DelP12Certificate(HostName);
            }
            else
            {
                Sunny86.Sunny_DelP12Certificate(HostName);
            }
        }

        public static bool AddP12Certificate(IntPtr HostName, IntPtr privateKeyName, IntPtr privatePassword, System.Int32 cerType)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_AddP12Certificate(HostName, privateKeyName, privatePassword, cerType);
            }
            else
            {
                return Sunny86.Sunny_AddP12Certificate(HostName, privateKeyName, privatePassword, cerType);
            }
        }

        public static bool WebpToPng(IntPtr webpPath, IntPtr savePath)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_WebpToPng(webpPath, savePath);
            }
            else
            {
                return Sunny86.Sunny_WebpToPng(webpPath, savePath);
            }
        }

        public static bool WebpToJpeg(IntPtr webpPath, IntPtr savePath, System.Int32 SaveQuality)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_WebpToJpeg(webpPath, savePath, SaveQuality);
            }
            else
            {
                return Sunny86.Sunny_WebpToJpeg(webpPath, savePath, SaveQuality);
            }
        }

        public static IntPtr WebpToPngBytes(IntPtr val, System.Int32 vallen)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_WebpToPngBytes(val, vallen);
            }
            else
            {
                return Sunny86.Sunny_WebpToPngBytes(val, vallen);
            }
        }

        public static IntPtr WebpToJpegBytes(IntPtr val, System.Int32 vallen, System.Int32 SaveQuality)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_WebpToJpegBytes(val, vallen, SaveQuality);
            }
            else
            {
                return Sunny86.Sunny_WebpToJpegBytes(val, vallen, SaveQuality);
            }
        }

        public static void MustTcp(System.Boolean i)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_MustTcp(i);
            }
            else
            {
                Sunny86.Sunny_MustTcp(i);
            }
        }

        public static IntPtr ScriptCall(System.Int32 i, IntPtr Request)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_ScriptCall(i, Request);
            }
            else
            {
                return Sunny86.Sunny_ScriptCall(i, Request);
            }
        }

        public static void SetScript(IntPtr Request)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SetScript(Request);
            }
            else
            {
                Sunny86.Sunny_SetScript(Request);
            }
        }

        public static void SetScriptLogCallAddress(IntPtr i)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_SetScriptLogCallAddress(i);
            }
            else
            {
                Sunny86.Sunny_SetScriptLogCallAddress(i);
            }
        }

        public static void VerifyUser(bool open)
        {
            if (Is64BitProcess)
            {
                Sunny64.Sunny_VerifyUser(open);
            }
            else
            {
                Sunny86.Sunny_VerifyUser(open);
            }
        }
        public static bool DelVerifyUser(IntPtr user)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_DelVerifyUser(user);
            }
            else
            {
                return Sunny86.Sunny_DelVerifyUser(user);
            }
        }
        public static bool AddVerifyUser(IntPtr user,IntPtr pass)
        {
            if (Is64BitProcess)
            {
                return Sunny64.Sunny_AddVerifyUser(user, pass);
            }
            else
            {
                return Sunny86.Sunny_AddVerifyUser(user, pass);
            }
        }

    }
}
