﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SunnyTest
{
    /// <summary>
    /// SunnyHTTP 功能不强，但是不会处理协议头大小写 我用过很多模块 总会自动的去处理协议头大小写
    /// </summary>
    class SunnyHttp
    {

        private int Context = 0;
        public SunnyHttp()
        {
            Context = Sunny.CreateHTTPClient();
            if (Context > 0)
            {
                是否禁止重定向(false);
            }
        }
        ~SunnyHttp()
        {
            //自动销毁
            Sunny.RemoveHTTPClient(Context);
            Context = 0;
        }

        public void 重新创建()
        {
            Sunny.RemoveHTTPClient(Context);
            Context = Sunny.CreateHTTPClient();
            if (Context > 0)
            {
                是否禁止重定向(false);
            }
        }
        public string 取错误信息()
        {
            IntPtr p = Sunny.HTTPClientGetErr(Context);
            if (p.ToInt64() < 1)
            {
                return "";
            }
            return Tool.PtrToString(p);
        }
        /// <summary>
        /// 打开(Open)
        /// </summary>
        /// <param name="Method">POST/GET/...</param>
        /// <param name="url">https://baidu.com/............ </param>
        /// <returns></returns>
        public void 打开(string Method, string url)
        {
            IntPtr A = Tool.StringToIntptr(Method.ToUpper());
            IntPtr B = Tool.StringToIntptr(url);
            Sunny.HTTPOpen(Context, A, B);
            Tool.PtrFree(A);
            Tool.PtrFree(B);
        }
        /// <summary>
        /// 设置重定向 是否禁止重定向 true=禁止重定向
        /// </summary>
        /// <param name="Redirect">是否禁止重定向 true=禁止重定向 </param>
        /// <returns></returns>
        public bool 是否禁止重定向(bool Redirect)
        {
            return Sunny.HTTPSetRedirect(Context, Redirect);
        }
        /// <summary>
        /// 置协议头
        /// </summary>
        /// <param name="协议头名称"></param>
        /// <param name="协议头值"></param>
        public void 置协议头(string 协议头名称, string 协议头值)
        {
            IntPtr A1 = Tool.StringToIntptr(协议头名称);
            IntPtr B1 = Tool.StringToIntptr(协议头值);
            Sunny.HTTPSetHeader(Context, A1, B1);
            Tool.PtrFree(A1);
            Tool.PtrFree(B1);
        }
        /// <summary>
        /// 设置代理IP 仅支持HTTP类型代理IP
        /// </summary>
        /// <param name="IP">例如：127.0.0.1:8888 </param>
        /// <param name="账号">代理账号</param>
        /// <param name="密码">代理密码</param>
        public void 设置代理IP(string IP, string 账号 = "", string 密码 = "")
        {
            IntPtr A = Tool.StringToIntptr(IP);
            IntPtr B = Tool.StringToIntptr(账号);
            IntPtr C = Tool.StringToIntptr(密码);
            Sunny.HTTPSetProxyIP(Context, A);
            if (账号 != "")
            {
                Sunny.HTTPSetProxyBasicAuth(Context, B, C);
            }
            Tool.PtrFree(A);
            Tool.PtrFree(B);
            Tool.PtrFree(C);
        }

        /// <summary>
        /// 设置超时
        /// </summary>
        /// <param name="连接超时">单位毫秒 默认 30000 / 30秒</param>
        /// <param name="发送超时">单位毫秒 默认 30000 / 30秒</param>
        /// <param name="接收超时">单位毫秒 默认 30000 / 30秒</param>
        public void 设置超时(int 连接超时 = 30000, int 发送超时 = 30000, int 接收超时 = 30000)
        {
            Sunny.HTTPSetTimeouts(Context, 连接超时, 发送超时, 接收超时);
        }
        /// <summary>
        ///  发送字节集
        /// </summary>
        /// <param name="data">要发送的数据</param>
        /// <returns></returns>
        public void 发送字节集(byte[] data)
        {
            IntPtr i1 = Tool.BytesToIntptr(data);
            Sunny.HTTPSendBin(Context, i1, data.Length);
            Tool.PtrFree(i1);
        }
        /// <summary>
        ///  发送
        /// </summary>
        /// <param name="data">要发送的文本数据</param>
        /// <returns></returns>
        public void 发送(string data)
        {
            Byte[] btData = System.Text.Encoding.Default.GetBytes(data);
            发送字节集(btData);
        }
        /// <summary>
        ///  取响应长度 发送数据之后有效
        /// </summary>
        /// <returns></returns>
        public int 取响应长度()
        {
            return Sunny.HTTPGetBodyLen(Context);
        }
        /// <summary>
        ///  取响应状态码 发送数据之后有效
        /// </summary>
        /// <returns></returns>
        public int 取响应状态码()
        {
            return Sunny.HTTPGetCode(Context);
        }
        /// <summary>
        ///  取响应全部Heads 发送数据之后有效
        /// </summary>
        /// <returns></returns>
        public string 取响应全部Heads()
        {
            IntPtr P = Sunny.HTTPGetHeads(Context);
            if (P.ToInt64() < 1)
            {
                return "";
            }
            return Tool.PtrToString(P);
        }

        /// <summary>
        ///  取响应内容 发送数据之后有效
        /// </summary>
        /// <returns></returns>
        public byte[] 取响应内容()
        {
            int l = 取响应长度();
            IntPtr P = Sunny.HTTPGetBody(Context);
            if (P.ToInt64() < 1)
            {
                return new byte[0];
            }
            return Tool.PtrToBytes(P, l);
        }
    }
}
