package Certificate

import (
	"Sunny/Certificate/pkcs"
	"crypto/tls"
	"encoding/pem"
	"errors"
	"io/ioutil"
	"os"
	"strings"
)

func AddP12Certificate(privateKeyName, privatePassword string) (*tls.Certificate, string, string, error) {
	PRIVATE := ""
	Certificates := ""
	k, e := getPrivateKey(privateKeyName, privatePassword)
	if k == nil {
		return nil, Certificates, PRIVATE, errors.New("Loading P12 Error  :" + e.Error())
	}
	var pemData []byte
	for _, b := range k {
		if strings.Index(b.Type, "PRIVATE") != -1 {
			PRIVATE = string(pem.EncodeToMemory(b))
		} else if strings.Index(b.Type, "CERTIFICATE") != -1 {
			Certificates = string(pem.EncodeToMemory(b))
		}
		pemData = append(pemData, pem.EncodeToMemory(b)...)
	}
	ce, err := tls.X509KeyPair(pemData, pemData)
	if err != nil {
		return nil, Certificates, PRIVATE, errors.New("Loading P12 Error  :" + err.Error())
	}

	return &ce, Certificates, PRIVATE, nil
}

func getPrivateKey(privateKeyName, privatePassword string) ([]*pem.Block, error) {
	f, err := os.Open(privateKeyName)
	if err != nil {
		return nil, err
	}

	bytes, err := ioutil.ReadAll(f)
	if err != nil {
		return nil, err
	}

	A, C := pkcs.ToPEM(bytes, privatePassword)
	if A == nil {
		return nil, C
	}
	return A, C
}
