package SunnyProxy

const (
	RootCa = `-----BEGIN CERTIFICATE-----
MIIDizCCAnOgAwIBAgIUKZuAsiiXCMz613rrURfxAHNuU7YwDQYJKoZIhvcNAQEL
BQAwVDELMAkGA1UEBhMCQ04xCzAJBgNVBAgMAkJKMQswCQYDVQQHDAJCSjENMAsG
A1UECgwEbGl2ZTENMAsGA1UECwwEUk9PVDENMAsGA1UEAwwEUk9PVDAgFw0yMTEw
MjEwMzUwNTBaGA8yMTIxMDkyNzAzNTA1MFowVDELMAkGA1UEBhMCQ04xCzAJBgNV
BAgMAkJKMQswCQYDVQQHDAJCSjENMAsGA1UECgwEbGl2ZTENMAsGA1UECwwEUk9P
VDENMAsGA1UEAwwEUk9PVDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
AMI+CTQSiFlew0i5Ir0OczDnucnHbCoCEb5m3x3VyH+KFAPdc8DltkETlSlvKbcc
C3G4Tm8IQ0lN9GpFepqbd/+06vhiZg+NU10hoXFP7pk3LwnrBXFHSHAN90y/7REP
1wPRdDUglI6WJKvEailZXdNgch+HTNXDlbpAKytqRe2m/pdzqTDWpiPu1UFQ0AtQ
rRhk+rCQe467cW7ekY/t7pEXqEwxUqKjHWvCXUAFUy6rOYe6/VZJWQF7Wo4zyidy
SYCF2t7RSpMXiwt5oEnuMT+L6g9RG+5DOpHJmg5LsqCYaQ+UWB2sthIlUni7D5E4
DFlKi+1AzV3sn6qrzAE0wlMCAwEAAaNTMFEwHQYDVR0OBBYEFL6bnl/tCNaISSbE
IZEkxBZr0kZEMB8GA1UdIwQYMBaAFL6bnl/tCNaISSbEIZEkxBZr0kZEMA8GA1Ud
EwEB/wQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAIIeZjAJ1opJQnNPbarbYFTG
I1yx3IbBjwr0/TX6Ku+BFU2McLSQFYdE8mtzcKGUryz15fBnirr+Xtjp7oy+1sZp
fiJToAw0fob/hjOWrLd5Oa8ZbwCCIbqauQy75SD4T/zBGAnyUSvTvhlITKPDrvMg
q/78o+3hitOCzytPgy9njee45DyhzW3/kczTXiBObyUrgI2YnFsbBBunYu5r5atb
jflL/BPXbo2I6AUSIZBYP+sjlDugttxtm7dao61fiMREkd5sgFhFi1b7HAETESKs
YuUTLN7fP7MUIOy+1cf+uX8STUTUz5tmu4eH6NiG4+HVdQHWQ0fI/3RoZmvghOg=
-----END CERTIFICATE-----
`
	RootKey = `-----BEGIN RSA PRIVATE KEY-----
MIIEpAIBAAKCAQEAwj4JNBKIWV7DSLkivQ5zMOe5ycdsKgIRvmbfHdXIf4oUA91z
wOW2QROVKW8ptxwLcbhObwhDSU30akV6mpt3/7Tq+GJmD41TXSGhcU/umTcvCesF
cUdIcA33TL/tEQ/XA9F0NSCUjpYkq8RqKVld02ByH4dM1cOVukArK2pF7ab+l3Op
MNamI+7VQVDQC1CtGGT6sJB7jrtxbt6Rj+3ukReoTDFSoqMda8JdQAVTLqs5h7r9
VklZAXtajjPKJ3JJgIXa3tFKkxeLC3mgSe4xP4vqD1Eb7kM6kcmaDkuyoJhpD5RY
Hay2EiVSeLsPkTgMWUqL7UDNXeyfqqvMATTCUwIDAQABAoIBADAr7GJimjf3vVyC
tW/Hbp/ZSAUXlOaSHs5merzOcOvYVYBj4jobfeiDr8FX1TOZG+l2+NSmavF6CLx2
QKKpHchnmMJCvObseJknJv+QAC81NVAzXeUq9Xb8r7D0BBnwILXMsxId41m9OJj0
nBNnG1K5n3PcPRziZXaMRWh98ZuvGE2efXHO+Z+bo1O3wyBb7aH7dwMEXLRwUxMO
lRrcczLdySejcuc+z0p9jJUhCnXAuuunOhjVrv/jVsuqUaFfiuIvp0A2dLXu/Bea
mWywSr+WqTZdszErghXuEjmBMK7rFz84/fvqxUMYM+rI2PWhjIOw0K0sSkIK0SwR
wrVdFWkCgYEA9311dONQfJiwxNGpSqJaI+XdNkuzyCFollxxbJVLBrnBd5+rt3bX
4wJwttQrIDY9mlGtitijf43C5yitO9Y9z4asON8hgjfalBp2/g98Aym0oLr+GHaJ
OQhVbpHawYkrKQQUXrT2UNrUI88LJM4Ezxs1+pvB01cMVc27DxqunF0CgYEAyOvc
m0cbWS5rBLY7oTFYebMqreDY/PCXbWBeDXCuTvEa/24HRmuK3IPsv5ircOgHSxBH
imZXBMITev0MPseiMYajqcgnSUWNzEtczrBMi00ezIC2OExifWExIaYAWeF7vQoY
JAxaVAy4IVZ2gkdr2Ib4ckoH1GyUKS5/8uybbm8CgYEA08IiHOhetq1DGrS2IGj3
rZ2BgHKXmlaTkYv5dMnszw1jb0JMgAcMw20UGitB1ybx4LegQJwKkRovuPACAZ/X
dViqxWKN3kiCGpTmWY3QMzidF6XHwhCyav0pdBkSTuRZ7JdUApDd7OK//v+pbk1k
qfyDXDGnT3g80rHcKxlOa/UCgYAy8mvMC+nJYVXNqg/Qvdx7b40A7iTXboJXP7pZ
mhr49XYtEs9Rce+SHvmnU6UVSiCfTg917qFeGYArDYNPX/ump0dUw+YCVFqyVOHB
nz6pi/KlVHXgLK5EsKJur9Mi92QS+T5J1cAJ0/fUrEH8ovObwg25nUADA01Ga/4R
sSFwjQKBgQDcGD7f7dMvt5azi7/OkAc18Z7NxWwyZ52i/JwtejOoO1ZhY1R0zT1U
hu3xdcZQ98EHSzY9i/cnj8hbpRc158NRTIJ9+16XFtw4mKXwnEetw4cnotF8rUAs
EkvK5BlNCpvFCO8TKImcB/g4v8R7FNxmM4tUE1HJzSym4jbiaWtf8w==
-----END RSA PRIVATE KEY-----
`
)

const (
	StatusContinue           = 100 // RFC 7231, 6.2.1
	StatusSwitchingProtocols = 101 // RFC 7231, 6.2.2
	StatusProcessing         = 102 // RFC 2518, 10.1
	StatusEarlyHints         = 103 // RFC 8297

	StatusOK                   = 200 // RFC 7231, 6.3.1
	StatusCreated              = 201 // RFC 7231, 6.3.2
	StatusAccepted             = 202 // RFC 7231, 6.3.3
	StatusNonAuthoritativeInfo = 203 // RFC 7231, 6.3.4
	StatusNoContent            = 204 // RFC 7231, 6.3.5
	StatusResetContent         = 205 // RFC 7231, 6.3.6
	StatusPartialContent       = 206 // RFC 7233, 4.1
	StatusMultiStatus          = 207 // RFC 4918, 11.1
	StatusAlreadyReported      = 208 // RFC 5842, 7.1
	StatusIMUsed               = 226 // RFC 3229, 10.4.1

	StatusMultipleChoices   = 300 // RFC 7231, 6.4.1
	StatusMovedPermanently  = 301 // RFC 7231, 6.4.2
	StatusFound             = 302 // RFC 7231, 6.4.3
	StatusSeeOther          = 303 // RFC 7231, 6.4.4
	StatusNotModified       = 304 // RFC 7232, 4.1
	StatusUseProxy          = 305 // RFC 7231, 6.4.5
	_                       = 306 // RFC 7231, 6.4.6 (Unused)
	StatusTemporaryRedirect = 307 // RFC 7231, 6.4.7
	StatusPermanentRedirect = 308 // RFC 7538, 3

	StatusBadRequest                   = 400 // RFC 7231, 6.5.1
	StatusUnauthorized                 = 401 // RFC 7235, 3.1
	StatusPaymentRequired              = 402 // RFC 7231, 6.5.2
	StatusForbidden                    = 403 // RFC 7231, 6.5.3
	StatusNotFound                     = 404 // RFC 7231, 6.5.4
	StatusMethodNotAllowed             = 405 // RFC 7231, 6.5.5
	StatusNotAcceptable                = 406 // RFC 7231, 6.5.6
	StatusProxyAuthRequired            = 407 // RFC 7235, 3.2
	StatusRequestTimeout               = 408 // RFC 7231, 6.5.7
	StatusConflict                     = 409 // RFC 7231, 6.5.8
	StatusGone                         = 410 // RFC 7231, 6.5.9
	StatusLengthRequired               = 411 // RFC 7231, 6.5.10
	StatusPreconditionFailed           = 412 // RFC 7232, 4.2
	StatusRequestEntityTooLarge        = 413 // RFC 7231, 6.5.11
	StatusRequestURITooLong            = 414 // RFC 7231, 6.5.12
	StatusUnsupportedMediaType         = 415 // RFC 7231, 6.5.13
	StatusRequestedRangeNotSatisfiable = 416 // RFC 7233, 4.4
	StatusExpectationFailed            = 417 // RFC 7231, 6.5.14
	StatusTeapot                       = 418 // RFC 7168, 2.3.3
	StatusMisdirectedRequest           = 421 // RFC 7540, 9.1.2
	StatusUnprocessableEntity          = 422 // RFC 4918, 11.2
	StatusLocked                       = 423 // RFC 4918, 11.3
	StatusFailedDependency             = 424 // RFC 4918, 11.4
	StatusTooEarly                     = 425 // RFC 8470, 5.2.
	StatusUpgradeRequired              = 426 // RFC 7231, 6.5.15
	StatusPreconditionRequired         = 428 // RFC 6585, 3
	StatusTooManyRequests              = 429 // RFC 6585, 4
	StatusRequestHeaderFieldsTooLarge  = 431 // RFC 6585, 5
	StatusUnavailableForLegalReasons   = 451 // RFC 7725, 3

	StatusInternalServerError           = 500 // RFC 7231, 6.6.1
	StatusNotImplemented                = 501 // RFC 7231, 6.6.2
	StatusBadGateway                    = 502 // RFC 7231, 6.6.3
	StatusServiceUnavailable            = 503 // RFC 7231, 6.6.4
	StatusGatewayTimeout                = 504 // RFC 7231, 6.6.5
	StatusHTTPVersionNotSupported       = 505 // RFC 7231, 6.6.6
	StatusVariantAlsoNegotiates         = 506 // RFC 2295, 8.1
	StatusInsufficientStorage           = 507 // RFC 4918, 11.5
	StatusLoopDetected                  = 508 // RFC 5842, 7.2
	StatusNotExtended                   = 510 // RFC 2774, 7
	StatusNetworkAuthenticationRequired = 511 // RFC 6585, 6
)

var StatusText = map[int]string{
	StatusContinue:           "Continue",
	StatusSwitchingProtocols: "Switching Protocols",
	StatusProcessing:         "Processing",
	StatusEarlyHints:         "Early Hints",

	StatusOK:                   "OK",
	StatusCreated:              "Created",
	StatusAccepted:             "Accepted",
	StatusNonAuthoritativeInfo: "Non-Authoritative Information",
	StatusNoContent:            "No Content",
	StatusResetContent:         "Reset Content",
	StatusPartialContent:       "Partial Content",
	StatusMultiStatus:          "Multi-Status",
	StatusAlreadyReported:      "Already Reported",
	StatusIMUsed:               "IM Used",

	StatusMultipleChoices:   "Multiple Choices",
	StatusMovedPermanently:  "Moved Permanently",
	StatusFound:             "Found",
	StatusSeeOther:          "See Other",
	StatusNotModified:       "Not Modified",
	StatusUseProxy:          "Use Proxy",
	StatusTemporaryRedirect: "Temporary Redirect",
	StatusPermanentRedirect: "Permanent Redirect",

	StatusBadRequest:                   "Bad Request",
	StatusUnauthorized:                 "Unauthorized",
	StatusPaymentRequired:              "Payment Required",
	StatusForbidden:                    "Forbidden",
	StatusNotFound:                     "Not Found",
	StatusMethodNotAllowed:             "Method Not Allowed",
	StatusNotAcceptable:                "Not Acceptable",
	StatusProxyAuthRequired:            "Proxy Authentication Required",
	StatusRequestTimeout:               "Request Timeout",
	StatusConflict:                     "Conflict",
	StatusGone:                         "Gone",
	StatusLengthRequired:               "Length Required",
	StatusPreconditionFailed:           "Precondition Failed",
	StatusRequestEntityTooLarge:        "Request Entity Too Large",
	StatusRequestURITooLong:            "Request URI Too Long",
	StatusUnsupportedMediaType:         "Unsupported Media Type",
	StatusRequestedRangeNotSatisfiable: "Requested Range Not Satisfiable",
	StatusExpectationFailed:            "Expectation Failed",
	StatusTeapot:                       "I'm a teapot",
	StatusMisdirectedRequest:           "Misdirected Request",
	StatusUnprocessableEntity:          "Unprocessable Entity",
	StatusLocked:                       "Locked",
	StatusFailedDependency:             "Failed Dependency",
	StatusTooEarly:                     "Too Early",
	StatusUpgradeRequired:              "Upgrade Required",
	StatusPreconditionRequired:         "Precondition Required",
	StatusTooManyRequests:              "Too Many Requests",
	StatusRequestHeaderFieldsTooLarge:  "Request Header Fields Too Large",
	StatusUnavailableForLegalReasons:   "Unavailable For Legal Reasons",

	StatusInternalServerError:           "Internal Server Error",
	StatusNotImplemented:                "Not Implemented",
	StatusBadGateway:                    "Bad Gateway",
	StatusServiceUnavailable:            "Service Unavailable",
	StatusGatewayTimeout:                "Gateway Timeout",
	StatusHTTPVersionNotSupported:       "HTTP Version Not Supported",
	StatusVariantAlsoNegotiates:         "Variant Also Negotiates",
	StatusInsufficientStorage:           "Insufficient Storage",
	StatusLoopDetected:                  "Loop Detected",
	StatusNotExtended:                   "Not Extended",
	StatusNetworkAuthenticationRequired: "Network Authentication Required",
}
