package SunnyProxy

type Delegate interface {
	BeforeRequest(entity *Entity, TheonlyId int64) int
	BeforeResponse(entity *Entity, TheonlyId int64, i int) int
	ErrorLog(entity *Entity, err error, TheonlyId int64)
	WssRequest(entity *Entity, flag int, msg *WebsocketMsg, TheonlyId int64, pid int)
	TCPRequest(sname, hostname string, tcpcallType int, msgid int64, msg *WebsocketMsg, pid string)
}

// 编辑阶段检查 DefaultDelegate 是否实现了 Delegate 接口
var _ Delegate = &DefaultDelegate{}

type DefaultDelegate struct {
	Delegate
}

func (delegate *DefaultDelegate) TCPRequest(sname, hostname string, tcpcallType int, msgid int64, msg *WebsocketMsg, pid string) {
}
func (delegate *DefaultDelegate) BeforeRequest(entity *Entity, TheonlyId int64) int { return 0 }
func (delegate *DefaultDelegate) BeforeResponse(entity *Entity, TheonlyId int64, i int) int {
	return 0
}
func (delegate *DefaultDelegate) ErrorLog(entity *Entity, err error, TheonlyId int64) {}
func (delegate *DefaultDelegate) WssRequest(entity *Entity, flag int, msg *WebsocketMsg, TheonlyId int64, pid int) {
}
