package SunnyProxy

import "sync"

var ContextIDL sync.Mutex
var ContextMap = make(map[int]int)
var ContextID int
var timeout = "timeout"

func GetContextID(Context int) int {
	ContextIDL.Lock()
	defer ContextIDL.Unlock()
	if ContextMap[Context] > 0 {
		return ContextMap[Context]
	}
	ContextID++
	X := ContextID
	if X < 0 || X > 2147483647 {
		X = 1
		ContextID = 1
	}
	ContextMap[Context] = X
	return X
}

func DelContextID(id int) {
	ContextIDL.Lock()
	delete(ContextMap, id)
	ContextIDL.Unlock()
}
