# CHANGELOG FOR `1.8.X`

## v1.8.11 (2021-03-22)

#### Details

- [#12468](https://github.com/Sylius/Sylius/issues/12468) Fix the build by conflicting with doctrine/doctrine-bundle 2.3.0 ([@pamil](https://github.com/pamil))

## v1.8.10 (2021-03-18)

#### Details

- [#12126](https://github.com/Sylius/Sylius/issues/12126) Fix incorrect money format being used ([@kayue](https://github.com/kayue))
- [#12289](https://github.com/Sylius/Sylius/issues/12289) [Docs] Add docs for LoyaltyRule[Api] ([@Tomanhez](https://github.com/Tomanhez))
- [#12312](https://github.com/Sylius/Sylius/issues/12312) [CI] Ignore changes in "adr" directory ([@pamil](https://github.com/pamil))
- [#12313](https://github.com/Sylius/Sylius/issues/12313) Change package type from "project" to "library" ([@vvasiloi](https://github.com/vvasiloi))
- [#12324](https://github.com/Sylius/Sylius/issues/12324) Removing hard timeout on edit while load selected values ([@christopherhero](https://github.com/christopherhero))
- [#12352](https://github.com/Sylius/Sylius/issues/12352) [Frontend] add box with info about api identifiers ([@SirDomin](https://github.com/SirDomin))
- [#12363](https://github.com/Sylius/Sylius/issues/12363) [Maintenance] Run test suite for MySQL 8.0 ([@lchrusciel](https://github.com/lchrusciel), [@GSadee](https://github.com/GSadee))
- [#12367](https://github.com/Sylius/Sylius/issues/12367) change swagger API info color to blue ([@SirDomin](https://github.com/SirDomin))
- [#12376](https://github.com/Sylius/Sylius/issues/12376) Pass path delimiter up to parent taxon ([@Jeroen-G](https://github.com/Jeroen-G), [@Jeroen](https://github.com/Jeroen), [@pamil](https://github.com/pamil))
- [#12384](https://github.com/Sylius/Sylius/issues/12384) Doc: Fix Doctrine project url ([@n3wborn](https://github.com/n3wborn))
- [#12397](https://github.com/Sylius/Sylius/issues/12397) Do not fail when mb_detect_encoding returns false ([@stefandoorn](https://github.com/stefandoorn))
- [#12404](https://github.com/Sylius/Sylius/issues/12404) Fix nested accordion initialisation ([@DjLeChuck](https://github.com/DjLeChuck))
- [#12407](https://github.com/Sylius/Sylius/issues/12407) [AttributeBundle] custom locale_code fixed ([@Mateuszry](https://github.com/Mateuszry))

## v1.8.9 (2021-02-01)

#### TL;DR

- Fixes the application errors due to external dependencies changes

#### Details

- [#12234](https://github.com/Sylius/Sylius/issues/12234) Backport symfony/polyfill-mbstring:1.22.0 conflict to make the build passing on 1.8 ([@pamil](https://github.com/pamil))
- [#12255](https://github.com/Sylius/Sylius/issues/12255) Auto-merge passing dependabot PRs ([@Zales0123](https://github.com/Zales0123))
- [#12272](https://github.com/Sylius/Sylius/issues/12272) [Docs] fix for admin RBAC channels ([@AdamKasp](https://github.com/AdamKasp))
- [#12274](https://github.com/Sylius/Sylius/issues/12274) Fix no identifier defined error in ApiPlatform 2.6 ([@kayue](https://github.com/kayue))
- [#12281](https://github.com/Sylius/Sylius/issues/12281) Add conflict with api-platform/core:^2.6 ([@pamil](https://github.com/pamil))
- [#12295](https://github.com/Sylius/Sylius/issues/12295) [Api] Fix CommandAwareInputDataTransformer ([@Tomanhez](https://github.com/Tomanhez))

## v1.8.8 (2021-01-11)

#### Details

- [#11794](https://github.com/Sylius/Sylius/issues/11794) Fixed deprecated `Intl` component usage ([@stloyd](https://github.com/stloyd))
- [#12196](https://github.com/Sylius/Sylius/issues/12196) [CI] Ignore depenabot pushes & allow for triggering manual workflows ([@pamil](https://github.com/pamil))
- [#12201](https://github.com/Sylius/Sylius/issues/12201) [BUG-FIX] display customer email if user is not logged in ([@SirDomin](https://github.com/SirDomin))
- [#12209](https://github.com/Sylius/Sylius/issues/12209) Add friendsofphp/proxy-manager-lts for ocramius/proxy-manager ([@Tomanhez](https://github.com/Tomanhez))
- [#12210](https://github.com/Sylius/Sylius/issues/12210) [BUG-FIX] [Checkout] Change email addressing step ([@SirDomin](https://github.com/SirDomin))
- [#12211](https://github.com/Sylius/Sylius/issues/12211) [Behat][Minor] Step rephrasing to decouple from UI ([@lchrusciel](https://github.com/lchrusciel))
- [#12216](https://github.com/Sylius/Sylius/issues/12216) Update release cycle with Sylius 1.9 information ([@pamil](https://github.com/pamil))

## v1.8.7 (2020-12-23)

#### Details

- [#12067](https://github.com/Sylius/Sylius/issues/12067) [UI] change image dimensions ([@SirDomin](https://github.com/SirDomin))
- [#12110](https://github.com/Sylius/Sylius/issues/12110) Add behat scenario with free order ([@clem21](https://github.com/clem21))
- [#12155](https://github.com/Sylius/Sylius/issues/12155) [CI] Add timeouts to GitHub Actions ([@pamil](https://github.com/pamil))
- [#12156](https://github.com/Sylius/Sylius/issues/12156) Update resource_layer.rst ([@abdounikarim](https://github.com/abdounikarim))
- [#12163](https://github.com/Sylius/Sylius/issues/12163) [CI] Switch from ubuntu-latest to ubuntu-18.04 ([@pamil](https://github.com/pamil))
- [#12169](https://github.com/Sylius/Sylius/issues/12169) [CI] Ignore dependabot/* branch pushes, build PRs only ([@pamil](https://github.com/pamil))
- [#12185](https://github.com/Sylius/Sylius/issues/12185) [Bugfix][1.8] `Kernel::configureContainer()` should match it's parent signature ([@stloyd](https://github.com/stloyd))
- [#12187](https://github.com/Sylius/Sylius/issues/12187) [BugFix] Add missing argument in metchod ([@Tomanhez](https://github.com/Tomanhez))
- [#12189](https://github.com/Sylius/Sylius/issues/12189) Notify about failed jobs ([@pamil](https://github.com/pamil))

## v1.8.6 (2020-12-09)

#### Details

- [#12004](https://github.com/Sylius/Sylius/issues/12004) Menu taxon can be null, even by default ([@jacquesbh](https://github.com/jacquesbh))
- [#12010](https://github.com/Sylius/Sylius/issues/12010) [Hot-fix] Allow to use svg images without filtration ([@Zales0123](https://github.com/Zales0123), [@AdamKasp](https://github.com/AdamKasp), [@SirDomin](https://github.com/SirDomin))
- [#12018](https://github.com/Sylius/Sylius/issues/12018) [BC BREAK] [Order] Order cancelation fix ([@lchrusciel](https://github.com/lchrusciel))
- [#12046](https://github.com/Sylius/Sylius/issues/12046) Bugfix | Don't suggest old format for template locations ([@stloyd](https://github.com/stloyd))
- [#12052](https://github.com/Sylius/Sylius/issues/12052) #12051 fix attribute registry initialized twice ([@Fantus](https://github.com/Fantus))
- [#12055](https://github.com/Sylius/Sylius/issues/12055) Change route prefixes in security.yaml ([@jacquesbh](https://github.com/jacquesbh))
- [#12060](https://github.com/Sylius/Sylius/issues/12060) [PoC] Add parameter to be able to disable prepending doctrine migrations ([@GSadee](https://github.com/GSadee), [@Tomanhez](https://github.com/Tomanhez))
- [#12066](https://github.com/Sylius/Sylius/issues/12066) Fix typo in UPGRADE-1.6.md ([@stefandoorn](https://github.com/stefandoorn))
- [#12069](https://github.com/Sylius/Sylius/issues/12069) Adjust link to migration file ([@stefandoorn](https://github.com/stefandoorn))
- [#12071](https://github.com/Sylius/Sylius/issues/12071) Update supported versions info ([@Zales0123](https://github.com/Zales0123))
- [#12086](https://github.com/Sylius/Sylius/issues/12086) Add conflict with lcobucci/jwt to prevent Behat build failures ([@pamil](https://github.com/pamil))
- [#12087](https://github.com/Sylius/Sylius/issues/12087) [CI] Switch documentation build from Travis to GitHub Actions ([@pamil](https://github.com/pamil))
- [#12089](https://github.com/Sylius/Sylius/issues/12089) [CI] Switch packages build from Travis to GitHub Actions ([@pamil](https://github.com/pamil))
- [#12090](https://github.com/Sylius/Sylius/issues/12090) [CI] Switch application build from Travis to GitHub Actions ([@pamil](https://github.com/pamil))
- [#12093](https://github.com/Sylius/Sylius/issues/12093) Use sha512 to encode passwords in test environments ([@pamil](https://github.com/pamil))
- [#12101](https://github.com/Sylius/Sylius/issues/12101) Remove lcobucci/jwt v3.4 conflict ([@Tomanhez](https://github.com/Tomanhez))
- [#12103](https://github.com/Sylius/Sylius/issues/12103) Fix the uploaded image path generator spec ([@pamil](https://github.com/pamil))
- [#12105](https://github.com/Sylius/Sylius/issues/12105) [CI] Uploade Behat logs as artifacts if failed ([@pamil](https://github.com/pamil))
- [#12108](https://github.com/Sylius/Sylius/issues/12108) [CI] GitHub Actions setup improvements ([@pamil](https://github.com/pamil))
- [#12114](https://github.com/Sylius/Sylius/issues/12114) [Behat]Javascript tests helper ([@arti0090](https://github.com/arti0090))
- [#12115](https://github.com/Sylius/Sylius/issues/12115) [CI] Improve DX while debugging failed Behat scenarios ([@pamil](https://github.com/pamil))
- [#12117](https://github.com/Sylius/Sylius/issues/12117) Remove pamil/prophecy-common from require-dev dependencies ([@pamil](https://github.com/pamil))
- [#12118](https://github.com/Sylius/Sylius/issues/12118) Original price is not required in UI ([@jacquesbh](https://github.com/jacquesbh))
- [#12120](https://github.com/Sylius/Sylius/issues/12120) Fix doctrine migrations config in UPGRADE-1.8.md ([@mmenozzi](https://github.com/mmenozzi))
- [#12123](https://github.com/Sylius/Sylius/issues/12123) [Behat] Introduce test helper for more JS tests and increase timeout ([@arti0090](https://github.com/arti0090))
- [#12125](https://github.com/Sylius/Sylius/issues/12125) [Maintenance] Add retry to github action ([@lchrusciel](https://github.com/lchrusciel))
- [#12127](https://github.com/Sylius/Sylius/issues/12127) [Maintenance] Move dependency from require-dev to require in CoreBundle and AdminApiBundle composers ([@GSadee](https://github.com/GSadee))
- [#12140](https://github.com/Sylius/Sylius/issues/12140) Temporarily lock on Resource 1.6.* ([@Zales0123](https://github.com/Zales0123))
- [#12149](https://github.com/Sylius/Sylius/issues/12149) Improve retrying Behat and reduce failure rate ([@pamil](https://github.com/pamil))

## v1.8.5 (2020-11-12)

#### Details

- [#12005](https://github.com/Sylius/Sylius/issues/12005) Use the correct variable ([@jacquesbh](https://github.com/jacquesbh))
- [#12009](https://github.com/Sylius/Sylius/issues/12009) Updated translation.rst ([@Romain](https://github.com/Romain))
- [#12011](https://github.com/Sylius/Sylius/issues/12011) Customize a controller fix typo in services config ([@Oipnet](https://github.com/Oipnet))
- [#11974](https://github.com/Sylius/Sylius/issues/11974) [UI] Fix broken checkboxes that dont change state ([@misaon](https://github.com/misaon))
- [#11908](https://github.com/Sylius/Sylius/issues/11908) Use proper parameters in access control patterns ([@loevgaard](https://github.com/loevgaard), [@lchrusciel](https://github.com/lchrusciel))
- [#11899](https://github.com/Sylius/Sylius/issues/11899) Update Github PR template ([@Zales0123](https://github.com/Zales0123))
- [#12019](https://github.com/Sylius/Sylius/issues/12019) [AUTO] Updated translations from Crowdin (1.7) ()
- [#12022](https://github.com/Sylius/Sylius/issues/12022) Suggest PayPalPlugin as the default PayPal integration ([@Zales0123](https://github.com/Zales0123))
- [#11993](https://github.com/Sylius/Sylius/issues/11993) [API] Explicitly define bus to all handlers ([@lchrusciel](https://github.com/lchrusciel))
- [#12014](https://github.com/Sylius/Sylius/issues/12014) Add some explanations about the stocks issue ([@jacquesbh](https://github.com/jacquesbh))
- [#11895](https://github.com/Sylius/Sylius/issues/11895) [API][Order] Fixed wrong where condition when looking for order ([@stloyd](https://github.com/stloyd), [@AdamKasp](https://github.com/AdamKasp))

## v1.8.4 (2020-11-05)

#### Details

- [#11932](https://github.com/Sylius/Sylius/issues/11932) [Minor][API] Add missing messenger handler interfaces ([@lchrusciel](https://github.com/lchrusciel))
- [#11940](https://github.com/Sylius/Sylius/issues/11940) [Maintenance] Adjusting symfony.lock to lowest supported PHP version ([@lchrusciel](https://github.com/lchrusciel))
- [#11946](https://github.com/Sylius/Sylius/issues/11946) Changed behavior of string inflector ([@arti0090](https://github.com/arti0090))
- [#11957](https://github.com/Sylius/Sylius/issues/11957) Minor CS fixes detected by ECS ([@Zales0123](https://github.com/Zales0123))
- [#11958](https://github.com/Sylius/Sylius/issues/11958) [Core] Decouple cart collector from shop ([@lchrusciel](https://github.com/lchrusciel))
- [#11972](https://github.com/Sylius/Sylius/issues/11972) [Maintenance] Conflict symfony doctrine bridge ([@lchrusciel](https://github.com/lchrusciel))
- [#11871](https://github.com/Sylius/Sylius/issues/11871) Patch for Unable to extends ShopBillingData [#11625] ([@jbcr](https://github.com/jbcr))
- [#11982](https://github.com/Sylius/Sylius/issues/11982) [Minor] Update service definition to not using depracated service ([@lchrusciel](https://github.com/lchrusciel))
- [#11988](https://github.com/Sylius/Sylius/issues/11988) [Behat] Fix argument name after upgrade Behat to v3.8.0 ([@GSadee](https://github.com/GSadee))
- [#11981](https://github.com/Sylius/Sylius/issues/11981) Adjust services to symfony/serializer:^4.4 ([@Zales0123](https://github.com/Zales0123))
- [#11991](https://github.com/Sylius/Sylius/issues/11991) Remove nikic/php-parser as a conflict ([@loevgaard](https://github.com/loevgaard))
- [#11999](https://github.com/Sylius/Sylius/issues/11999) [Maintenance] Bump psalm, fix naming issues and build ([@lchrusciel](https://github.com/lchrusciel))
- [#11894](https://github.com/Sylius/Sylius/issues/11894) [Order] Do not stop cancelling unpaid orders on exception during canc… ([@twojtylak](https://github.com/twojtylak))

## v1.8.3 (2020-10-20)

#### Details

- [#11452](https://github.com/Sylius/Sylius/issues/11452) [Docs] Fix redirection for backwards compatibility promise ([@pamil](https://github.com/pamil))
- [#11919](https://github.com/Sylius/Sylius/issues/11919) [AUTO] Updated translations from Crowdin (1.7) ([@Sylius](https://github.com/Sylius) [@Bot](https://github.com/Bot))
- [#11929](https://github.com/Sylius/Sylius/issues/11929) [API] Add missing experimental annotations ([@lchrusciel](https://github.com/lchrusciel))
- [#11944](https://github.com/Sylius/Sylius/issues/11944) [Shop] Disabling customer when email has been changed ([@lchrusciel](https://github.com/lchrusciel))

## v1.8.2 (2020-10-12)

#### Details

- [#11882](https://github.com/Sylius/Sylius/issues/11882) Use DQL instead of repository to fetch product attributes ([@loevgaard](https://github.com/loevgaard))
- [#11911](https://github.com/Sylius/Sylius/issues/11911) Removing typehint for Symfony 4.4 compatibility ([@mamazu](https://github.com/mamazu), [@lchrusciel](https://github.com/lchrusciel))

## v1.8.1 (2020-10-02)

#### Details

- [#11835](https://github.com/Sylius/Sylius/issues/11835) [ChannelPricing] Remove channel pricing 1.7 ([@AdamKasp](https://github.com/AdamKasp), [@Tomanhez](https://github.com/Tomanhez), [@lchrusciel](https://github.com/lchrusciel))
- [#11839](https://github.com/Sylius/Sylius/issues/11839) [Behat] Remove duplicated method from ProductContext ([@GSadee](https://github.com/GSadee))
- [#11778](https://github.com/Sylius/Sylius/issues/11778) Fixed compatibility with newer version of data collectors ([@stloyd](https://github.com/stloyd))
- [#11845](https://github.com/Sylius/Sylius/issues/11845) It's been only a few days guys! ([@jacquesbh](https://github.com/jacquesbh))
- [#11844](https://github.com/Sylius/Sylius/issues/11844) [Minor] Dead code removal ([@lchrusciel](https://github.com/lchrusciel))
- [#11855](https://github.com/Sylius/Sylius/issues/11855) Typo in UPGRADE-1.8.md ([@jacquesbh](https://github.com/jacquesbh))
- [#11848](https://github.com/Sylius/Sylius/issues/11848) [Product] Add possibility to create product/variant without price in disabled channels ([@AdamKasp](https://github.com/AdamKasp))
- [#11865](https://github.com/Sylius/Sylius/issues/11865) Fix build and add missing migration ([@Tomanhez](https://github.com/Tomanhez), [@AdamKasp](https://github.com/AdamKasp))
- [#11852](https://github.com/Sylius/Sylius/issues/11852) [Docs] Add changes in UPGRADE-1.8.md ([@Tomanhez](https://github.com/Tomanhez))
- [#11830](https://github.com/Sylius/Sylius/issues/11830) [Api][Cart] Fix for Cart access tests ([@Tomanhez](https://github.com/Tomanhez))
- [#11898](https://github.com/Sylius/Sylius/issues/11898) Improve 1.8 migrations upgrade instructions ([@Zales0123](https://github.com/Zales0123))
- [#11901](https://github.com/Sylius/Sylius/issues/11901) [1.8] Fix migration generation ([@Jibbarth](https://github.com/Jibbarth))
- [#11904](https://github.com/Sylius/Sylius/issues/11904) [API] Separate providers for shop and admin users ([@GSadee](https://github.com/GSadee))

## v1.8.0 (2020-09-14)

#### Details

- [#11418](https://github.com/Sylius/Sylius/issues/11418) set default value for Channel taxCalculationStrategy ([@oallain](https://github.com/oallain))
- [#11745](https://github.com/Sylius/Sylius/issues/11745) [Api][Checkout] Modify ShippingMethod and PaymentMethod paths on Checkout ([@Tomanhez](https://github.com/Tomanhez))
- [#11781](https://github.com/Sylius/Sylius/issues/11781) Add missing new method into form extensions ([@stloyd](https://github.com/stloyd))
- [#11786](https://github.com/Sylius/Sylius/issues/11786) Fixed deprecated option usage on Email validator ([@stloyd](https://github.com/stloyd))
- [#11790](https://github.com/Sylius/Sylius/issues/11790) [Api] Add experimental warning to swagger ([@lchrusciel](https://github.com/lchrusciel))
- [#11792](https://github.com/Sylius/Sylius/issues/11792) Fixed: Parent taxon selection on taxon creation ([@igormukhingmailcom](https://github.com/igormukhingmailcom))
- [#11795](https://github.com/Sylius/Sylius/issues/11795) Api refactor product and order related endpoints ([@AdamKasp](https://github.com/AdamKasp))
- [#11797](https://github.com/Sylius/Sylius/issues/11797) Fixed Twig translate extension not working with `null` values ([@stloyd](https://github.com/stloyd))
- [#11799](https://github.com/Sylius/Sylius/issues/11799) [API]Fixed endpoints related to order-items that returns 500 error ([@arti0090](https://github.com/arti0090))
- [#11806](https://github.com/Sylius/Sylius/issues/11806) [Api][Checkout] Allowing access only for correctly logged in ([@Tomanhez](https://github.com/Tomanhez))
- [#11807](https://github.com/Sylius/Sylius/issues/11807) [API] Disable province code change in PUT endpoint ([@arti0090](https://github.com/arti0090))
- [#11808](https://github.com/Sylius/Sylius/issues/11808) allow sonata block bundle v3 ([@esserj](https://github.com/esserj))
- [#11813](https://github.com/Sylius/Sylius/issues/11813) [ADR] Minor text adjustments ([@lchrusciel](https://github.com/lchrusciel))
- [#11814](https://github.com/Sylius/Sylius/issues/11814) [Channel] Fix bc-breaking changes in ChannelFactory and minor improvements ([@lchrusciel](https://github.com/lchrusciel))
- [#11818](https://github.com/Sylius/Sylius/issues/11818) [Api] Hide token value in create cart endpoint's body ([@AdamKasp](https://github.com/AdamKasp))
- [#11819](https://github.com/Sylius/Sylius/issues/11819) [API] Refactored data transformers ([@lchrusciel](https://github.com/lchrusciel))
- [#11820](https://github.com/Sylius/Sylius/issues/11820) [ChannelPricing] Ability to remove price on channel pricing when channel is disabled ([@AdamKasp](https://github.com/AdamKasp), [@Tomanhez](https://github.com/Tomanhez))
- [#11821](https://github.com/Sylius/Sylius/issues/11821) [API] Hide product review in product create endpoint ([@AdamKasp](https://github.com/AdamKasp))
- [#11822](https://github.com/Sylius/Sylius/issues/11822) Bugfix | Fixed wrong Symfony controller class usage ([@stloyd](https://github.com/stloyd))
- [#11823](https://github.com/Sylius/Sylius/issues/11823) [API] Unify interface parameters ([@lchrusciel](https://github.com/lchrusciel))
- [#11824](https://github.com/Sylius/Sylius/issues/11824) [API]add to swagger documentation missing locale code in translations ([@arti0090](https://github.com/arti0090))
- [#11825](https://github.com/Sylius/Sylius/issues/11825) [Api][Cart] Fix for OrderGetMethodItemExtension ([@Tomanhez](https://github.com/Tomanhez))
- [#11831](https://github.com/Sylius/Sylius/issues/11831) [API] fix route for pickup cart ([@AdamKasp](https://github.com/AdamKasp))
- [#11832](https://github.com/Sylius/Sylius/issues/11832) [Api][Checkout] Allowing access only for correctly logged in - minor fixes(1.8) ([@Tomanhez](https://github.com/Tomanhez))
- [#11833](https://github.com/Sylius/Sylius/issues/11833) [Admin] Channel pricing removal for channels where the product is not available ([@lchrusciel](https://github.com/lchrusciel))
- [#11837](https://github.com/Sylius/Sylius/issues/11837) Update README.md ([@CoderMaggie](https://github.com/CoderMaggie))

## v1.8.0-RC.1 (2020-09-07)

#### Details

- [#9661](https://github.com/Sylius/Sylius/issues/9661) typo maybe! ([@xeptore](https://github.com/xeptore), [@pamil](https://github.com/pamil))
- [#10434](https://github.com/Sylius/Sylius/issues/10434) [Shipping] Shipping method rules ([@loevgaard](https://github.com/loevgaard))
- [#10565](https://github.com/Sylius/Sylius/issues/10565) Remove deprecations on Symfony Intl component ([@loic425](https://github.com/loic425))
- [#10688](https://github.com/Sylius/Sylius/issues/10688) MVP of the debug cart panel (, [@pamil](https://github.com/pamil))
- [#10749](https://github.com/Sylius/Sylius/issues/10749) Promotion fixture coupons ([@JakobTolkemit](https://github.com/JakobTolkemit), [@lchrusciel](https://github.com/lchrusciel), [@Zales0123](https://github.com/Zales0123))
- [#11029](https://github.com/Sylius/Sylius/issues/11029) Try out Behat packages supporting Symfony 5 ([@pamil](https://github.com/pamil))
- [#11116](https://github.com/Sylius/Sylius/issues/11116) Fixed: Hardcoded locale at Behat product transformer ([@igormukhingmailcom](https://github.com/igormukhingmailcom))
- [#11124](https://github.com/Sylius/Sylius/issues/11124) Template events for shop's cart ([@Tomanhez](https://github.com/Tomanhez))
- [#11126](https://github.com/Sylius/Sylius/issues/11126) Template events for layout, footer, header ([@Tomanhez](https://github.com/Tomanhez))
- [#11131](https://github.com/Sylius/Sylius/issues/11131) Template events minor fix for Shop/Cart ([@Tomanhez](https://github.com/Tomanhez))
- [#11134](https://github.com/Sylius/Sylius/issues/11134) Adding documentation of the order processor ([@mamazu](https://github.com/mamazu), [@lchrusciel](https://github.com/lchrusciel))
- [#11139](https://github.com/Sylius/Sylius/issues/11139) Disable clicked button ([@kulczy](https://github.com/kulczy))
- [#11156](https://github.com/Sylius/Sylius/issues/11156) Add link to product detail page ([@floplus](https://github.com/floplus))
- [#11164](https://github.com/Sylius/Sylius/issues/11164) [typography] return function ([@DurandSacha](https://github.com/DurandSacha))
- [#11165](https://github.com/Sylius/Sylius/issues/11165) Update basic-usage.rst with return Typography ([@DurandSacha](https://github.com/DurandSacha))
- [#11188](https://github.com/Sylius/Sylius/issues/11188) [Admin] [Shipment] Add back button on shipment show page ([@GSadee](https://github.com/GSadee))
- [#11190](https://github.com/Sylius/Sylius/issues/11190) [Maintenance] Update github PR template ([@lchrusciel](https://github.com/lchrusciel))
- [#11194](https://github.com/Sylius/Sylius/issues/11194) Opening show in the store in new tab from admin ([@antonioperic](https://github.com/antonioperic))
- [#11201](https://github.com/Sylius/Sylius/issues/11201) [Docs] [Installation] Update latest stable version ([@Jibbarth](https://github.com/Jibbarth))
- [#11207](https://github.com/Sylius/Sylius/issues/11207) Add translations issue template ([@CoderMaggie](https://github.com/CoderMaggie))
- [#11212](https://github.com/Sylius/Sylius/issues/11212) Use events fully for layout css and js ([@Prometee](https://github.com/Prometee))
- [#11214](https://github.com/Sylius/Sylius/issues/11214) Use https instead of http for Channel's hostname in form ([@jacquesbh](https://github.com/jacquesbh))
- [#11226](https://github.com/Sylius/Sylius/issues/11226) Initializing adjustments before the order item is processed ([@mamazu](https://github.com/mamazu))
- [#11227](https://github.com/Sylius/Sylius/issues/11227) Update Bootstrap-theme.rst ([@Yohann76](https://github.com/Yohann76))
- [#11239](https://github.com/Sylius/Sylius/issues/11239) [API] [Order] Orders browsing, cancelling and cancelling with promotion ([@AdamKasp](https://github.com/AdamKasp))
- [#11240](https://github.com/Sylius/Sylius/issues/11240) [API] [Product] Crud product browsing deleting editing ([@Tomanhez](https://github.com/Tomanhez))
- [#11241](https://github.com/Sylius/Sylius/issues/11241) Toggleable product variant ([@LucaGallinari](https://github.com/LucaGallinari), [@mmenozzi](https://github.com/mmenozzi))
- [#11245](https://github.com/Sylius/Sylius/issues/11245) [API] [Administrator] Implement deleting and editing administrators features ([@GSadee](https://github.com/GSadee))
- [#11246](https://github.com/Sylius/Sylius/issues/11246) [API] Browsing and deleting shipping methods ([@lchrusciel](https://github.com/lchrusciel))
- [#11248](https://github.com/Sylius/Sylius/issues/11248) [API] [Order] Fulfilling orders ([@AdamKasp](https://github.com/AdamKasp), [@Zales0123](https://github.com/Zales0123))
- [#11249](https://github.com/Sylius/Sylius/issues/11249) [API] [Shipment] Send email after shipment ship ([@AdamKasp](https://github.com/AdamKasp))
- [#11251](https://github.com/Sylius/Sylius/issues/11251) [API] [Product] Crud product validation sorting ([@Tomanhez](https://github.com/Tomanhez))
- [#11252](https://github.com/Sylius/Sylius/issues/11252) [API] Change operation path resolver from underscore to dash resolver ([@GSadee](https://github.com/GSadee))
- [#11253](https://github.com/Sylius/Sylius/issues/11253) [API] Adding shipping methods ([@lchrusciel](https://github.com/lchrusciel))
- [#11254](https://github.com/Sylius/Sylius/issues/11254) [API] Adding shipping methods ([@lchrusciel](https://github.com/lchrusciel))
- [#11255](https://github.com/Sylius/Sylius/issues/11255) [API] [Administrator] Implement managing avatar features ([@GSadee](https://github.com/GSadee))
- [#11256](https://github.com/Sylius/Sylius/issues/11256) [API] [Product] Add fixes for addTheOptions ([@Tomanhez](https://github.com/Tomanhez))
- [#11257](https://github.com/Sylius/Sylius/issues/11257) [API] Editing and validation of shipping methods ([@lchrusciel](https://github.com/lchrusciel))
- [#11258](https://github.com/Sylius/Sylius/issues/11258) [Minor] Improve ShippingCategory test ([@lchrusciel](https://github.com/lchrusciel))
- [#11260](https://github.com/Sylius/Sylius/issues/11260) [Api] [Product] Fix default product sorting ([@Tomanhez](https://github.com/Tomanhez))
- [#11262](https://github.com/Sylius/Sylius/issues/11262) [API] Protect shipping method from removal when in use ([@lchrusciel](https://github.com/lchrusciel))
- [#11264](https://github.com/Sylius/Sylius/issues/11264) [Minor] Move doctrine filters to doctrine folder in api bundle ([@lchrusciel](https://github.com/lchrusciel))
- [#11266](https://github.com/Sylius/Sylius/issues/11266) [API] Hide archived shipping methods ([@lchrusciel](https://github.com/lchrusciel))
- [#11267](https://github.com/Sylius/Sylius/issues/11267) [API] Sorting shipping method by code and position ([@Zales0123](https://github.com/Zales0123))
- [#11268](https://github.com/Sylius/Sylius/issues/11268) [API] Sorting shipping methods by name ([@Zales0123](https://github.com/Zales0123))
- [#11269](https://github.com/Sylius/Sylius/issues/11269) [API] Archivization toggling and filtration ([@lchrusciel](https://github.com/lchrusciel))
- [#11270](https://github.com/Sylius/Sylius/issues/11270) Fix build with API Behat ([@Zales0123](https://github.com/Zales0123))
- [#11273](https://github.com/Sylius/Sylius/issues/11273) [API] add locale to Api Platform ([@oallain](https://github.com/oallain))
- [#11274](https://github.com/Sylius/Sylius/issues/11274) [API] [Administrator] Refactor upload action in api client + minor fixes ([@GSadee](https://github.com/GSadee))
- [#11275](https://github.com/Sylius/Sylius/issues/11275) [API] Move API Platform configuration to ApiBundle ([@GSadee](https://github.com/GSadee))
- [#11276](https://github.com/Sylius/Sylius/issues/11276) [ShopBundle] Fix the checkout page ([@nayluge](https://github.com/nayluge), [@lchrusciel](https://github.com/lchrusciel))
- [#11278](https://github.com/Sylius/Sylius/issues/11278) [API] add country ([@oallain](https://github.com/oallain))
- [#11280](https://github.com/Sylius/Sylius/issues/11280) Order feature folder reorganization ([@lchrusciel](https://github.com/lchrusciel))
- [#11281](https://github.com/Sylius/Sylius/issues/11281) [Maintenance] Bump ApiTestCase to v5.0 ([@lchrusciel](https://github.com/lchrusciel))
- [#11282](https://github.com/Sylius/Sylius/issues/11282) [API] [Shipping Method] Improvement after PR preview ([@AdamKasp](https://github.com/AdamKasp))
- [#11283](https://github.com/Sylius/Sylius/issues/11283) [API] Add endpoint to Swagger to retrieve a JWT token ([@GSadee](https://github.com/GSadee))
- [#11286](https://github.com/Sylius/Sylius/issues/11286) [Docs] [API] Reorganize Sylius API docs + add authorization in Swagger UI ([@GSadee](https://github.com/GSadee))
- [#11287](https://github.com/Sylius/Sylius/issues/11287) [Feature] Toggleable taxon ([@mmenozzi](https://github.com/mmenozzi), [@LucaGallinari](https://github.com/LucaGallinari))
- [#11288](https://github.com/Sylius/Sylius/issues/11288) [API] Update UPGRADE-1.8 file after adding ApiBundle ([@GSadee](https://github.com/GSadee))
- [#11289](https://github.com/Sylius/Sylius/issues/11289) [API] Move serializer configuration to ApiBundle ([@GSadee](https://github.com/GSadee))
- [#11290](https://github.com/Sylius/Sylius/issues/11290) [API] Fix serializer config ([@lchrusciel](https://github.com/lchrusciel))
- [#11291](https://github.com/Sylius/Sylius/issues/11291) [API] [Homepage] Latest products ([@AdamKasp](https://github.com/AdamKasp))
- [#11293](https://github.com/Sylius/Sylius/issues/11293) Fixed hardcoded route &prefix in UPGRADE-1.8 document ([@stloyd](https://github.com/stloyd))
- [#11295](https://github.com/Sylius/Sylius/issues/11295) [API] [Product] Add sorting for products by name ([@Tomanhez](https://github.com/Tomanhez))
- [#11297](https://github.com/Sylius/Sylius/issues/11297) [API] Add prefix to all admin routes ([@GSadee](https://github.com/GSadee))
- [#11298](https://github.com/Sylius/Sylius/issues/11298) [Psalm] Add symfony/polyfill-php80 to fix build ([@GSadee](https://github.com/GSadee))
- [#11300](https://github.com/Sylius/Sylius/issues/11300) Updated OrderShipmentProcessor documentation ([@mamazu](https://github.com/mamazu))
- [#11303](https://github.com/Sylius/Sylius/issues/11303) [API] [Shop] Add customer login ([@GSadee](https://github.com/GSadee))
- [#11307](https://github.com/Sylius/Sylius/issues/11307) [API] [Product] Product sorting by name ([@Tomanhez](https://github.com/Tomanhez))
- [#11314](https://github.com/Sylius/Sylius/issues/11314) Add translation key ([@loevgaard](https://github.com/loevgaard))
- [#11316](https://github.com/Sylius/Sylius/issues/11316) [Api] [Homepage] menu taxons ([@AdamKasp](https://github.com/AdamKasp))
- [#11318](https://github.com/Sylius/Sylius/issues/11318) [API] [Product] Add subscriber for generating slug automatically ([@GSadee](https://github.com/GSadee))
- [#11319](https://github.com/Sylius/Sylius/issues/11319) [API] product association type ([@oallain](https://github.com/oallain))
- [#11321](https://github.com/Sylius/Sylius/issues/11321) [API] Extract services configs + fixes to product slug event subscriber ([@GSadee](https://github.com/GSadee))
- [#11323](https://github.com/Sylius/Sylius/issues/11323) [Symfony 5] Upgrade to PHPUnit 8 and DependencyInjectionTest 4 ([@pamil](https://github.com/pamil))
- [#11325](https://github.com/Sylius/Sylius/issues/11325) [Minor] [API] Add interfaces to applicators ([@lchrusciel](https://github.com/lchrusciel))
- [#11328](https://github.com/Sylius/Sylius/issues/11328) [API] Add description to custom path ([@AdamKasp](https://github.com/AdamKasp))
- [#11332](https://github.com/Sylius/Sylius/issues/11332) [API] disable input on stateMachine transition endpoints ([@AdamKasp](https://github.com/AdamKasp))
- [#11333](https://github.com/Sylius/Sylius/issues/11333) [API] fix typo in services ([@AdamKasp](https://github.com/AdamKasp))
- [#11337](https://github.com/Sylius/Sylius/issues/11337) [API] Association types improvements ([@lchrusciel](https://github.com/lchrusciel))
- [#11339](https://github.com/Sylius/Sylius/issues/11339) [Fixtures] Add possibility to specify menu taxon ([@lchrusciel](https://github.com/lchrusciel))
- [#11347](https://github.com/Sylius/Sylius/issues/11347) [RFC] [DX] Open consts holder classes ([@lchrusciel](https://github.com/lchrusciel))
- [#11352](https://github.com/Sylius/Sylius/issues/11352) [Maintenance] [Travis] Upgrade php memory to 6G ([@lchrusciel](https://github.com/lchrusciel))
- [#11356](https://github.com/Sylius/Sylius/issues/11356) [API] Registering shop users ([@pamil](https://github.com/pamil))
- [#11359](https://github.com/Sylius/Sylius/issues/11359) [Docs] [Plus] Resolving inventory stocks after shipment ([@AdamKasp](https://github.com/AdamKasp))
- [#11360](https://github.com/Sylius/Sylius/issues/11360) Admin filtering promotions by coupon code ([@vvasiloi](https://github.com/vvasiloi))
- [#11361](https://github.com/Sylius/Sylius/issues/11361) [API] Move messenger config to bundles + extract providing customer to a separate service ([@GSadee](https://github.com/GSadee))
- [#11367](https://github.com/Sylius/Sylius/issues/11367) Check different shipping address field and display shipping address form ([@vvasiloi](https://github.com/vvasiloi))
- [#11372](https://github.com/Sylius/Sylius/issues/11372) [API] Zones ([@oallain](https://github.com/oallain), [@GSadee](https://github.com/GSadee))
- [#11377](https://github.com/Sylius/Sylius/issues/11377) Filter the orders grid on shipping method ([@jacquesbh](https://github.com/jacquesbh))
- [#11379](https://github.com/Sylius/Sylius/issues/11379) Use hwi/oauth-bundle:^1.0 in packages ([@pamil](https://github.com/pamil))
- [#11381](https://github.com/Sylius/Sylius/issues/11381) [API] [ShippingMethod] [Product] Improve sort filter and tests  ([@Tomanhez](https://github.com/Tomanhez), [@pamil](https://github.com/pamil))
- [#11383](https://github.com/Sylius/Sylius/issues/11383) [DX] update Psalm version ([@oallain](https://github.com/oallain))
- [#11388](https://github.com/Sylius/Sylius/issues/11388) [Shipment] Remove shipment index and add show shipment from order button ([@Tomanhez](https://github.com/Tomanhez))
- [#11389](https://github.com/Sylius/Sylius/issues/11389) Switch to Doctrine/Migrations 3.0 ([@pamil](https://github.com/pamil))
- [#11392](https://github.com/Sylius/Sylius/issues/11392) Add title on most pages ([@dunglas](https://github.com/dunglas))
- [#11393](https://github.com/Sylius/Sylius/issues/11393) Ignore Symfony CLI PHP settings files ([@vvasiloi](https://github.com/vvasiloi))
- [#11394](https://github.com/Sylius/Sylius/issues/11394) [ChannelBundle] Fix channel context interface alias ([@vvasiloi](https://github.com/vvasiloi))
- [#11396](https://github.com/Sylius/Sylius/issues/11396) [Hot-fix] Conflict API Platform 2.5.5 to fix the build ([@Zales0123](https://github.com/Zales0123))
- [#11397](https://github.com/Sylius/Sylius/issues/11397) [API] Unified admin and shop paths ([@lchrusciel](https://github.com/lchrusciel), [@GSadee](https://github.com/GSadee))
- [#11401](https://github.com/Sylius/Sylius/issues/11401) [Backend] Feeding sales statistics graph with date from chosen period ([@AdamKasp](https://github.com/AdamKasp))
- [#11402](https://github.com/Sylius/Sylius/issues/11402) [API] Remove custom menu taxon endpoint ([@Zales0123](https://github.com/Zales0123))
- [#11404](https://github.com/Sylius/Sylius/issues/11404) [API] Channel switching ([@Zales0123](https://github.com/Zales0123))
- [#11406](https://github.com/Sylius/Sylius/issues/11406) Automatically add API label ([@Zales0123](https://github.com/Zales0123))
- [#11407](https://github.com/Sylius/Sylius/issues/11407) [API] [Shipment] Add implementation and test for shipment show ([@Tomanhez](https://github.com/Tomanhez), [@Zales0123](https://github.com/Zales0123))
- [#11410](https://github.com/Sylius/Sylius/issues/11410) Bump jquery from 3.4.1 to 3.5.0 ([@dependabot](https://github.com/dependabot)[[@bot](https://github.com/bot)])
- [#11411](https://github.com/Sylius/Sylius/issues/11411) [API] Add missing access control ([@lchrusciel](https://github.com/lchrusciel))
- [#11413](https://github.com/Sylius/Sylius/issues/11413) Add a filter icon for filters in admin grids ([@jacquesbh](https://github.com/jacquesbh))
- [#11417](https://github.com/Sylius/Sylius/issues/11417) [API] adding and browsing Channel ([@oallain](https://github.com/oallain), [@GSadee](https://github.com/GSadee))
- [#11419](https://github.com/Sylius/Sylius/issues/11419) [Maintenance] Update release cycle ([@lchrusciel](https://github.com/lchrusciel))
- [#11420](https://github.com/Sylius/Sylius/issues/11420) Fix UI in Product's inventory tab ([@jacquesbh](https://github.com/jacquesbh))
- [#11423](https://github.com/Sylius/Sylius/issues/11423) [Shop] [Product] Display product original price on product page (no bc break) ([@JulienLoison](https://github.com/JulienLoison), )
- [#11424](https://github.com/Sylius/Sylius/issues/11424) [Admin] [Product] Ajax product search fails ([@Prometee](https://github.com/Prometee))
- [#11431](https://github.com/Sylius/Sylius/issues/11431) [Countries] [API] cover non-empty province name validation ([@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee))
- [#11434](https://github.com/Sylius/Sylius/issues/11434) Revert "[Backend] Feeding sales statistics graph with date from chosen period" ([@lchrusciel](https://github.com/lchrusciel))
- [#11435](https://github.com/Sylius/Sylius/issues/11435) [Api]Add new-api regexp to shop firewall ([@Tomanhez](https://github.com/Tomanhez), [@pamil](https://github.com/pamil))
- [#11436](https://github.com/Sylius/Sylius/issues/11436) [Behat] Consistent channel setup context ([@vvasiloi](https://github.com/vvasiloi))
- [#11442](https://github.com/Sylius/Sylius/issues/11442) [Feature] Products filtering by channel ()
- [#11444](https://github.com/Sylius/Sylius/issues/11444) [Docs] Replace book concepts images with up-to-date list of topics ([@pamil](https://github.com/pamil))
- [#11445](https://github.com/Sylius/Sylius/issues/11445) [Docs] Update installation requirements & add upgrade instructions for Plus ([@pamil](https://github.com/pamil))
- [#11447](https://github.com/Sylius/Sylius/issues/11447) [Docs] Fix dates specified in the release cycle ([@pamil](https://github.com/pamil))
- [#11448](https://github.com/Sylius/Sylius/issues/11448) [Docs] Remove experimental badges mentioning "master" branch from theming guide ([@pamil](https://github.com/pamil))
- [#11451](https://github.com/Sylius/Sylius/issues/11451) synchronise dependencies ([@arti0090](https://github.com/arti0090))
- [#11455](https://github.com/Sylius/Sylius/issues/11455) Update webpack.rst ([@pocky](https://github.com/pocky))
- [#11457](https://github.com/Sylius/Sylius/issues/11457) [API] Remove unnecessary shop billing data client + minor fixes ([@GSadee](https://github.com/GSadee))
- [#11460](https://github.com/Sylius/Sylius/issues/11460) [Behat] Add missing zone step to fix the build ([@Zales0123](https://github.com/Zales0123))
- [#11465](https://github.com/Sylius/Sylius/issues/11465) Refactor and upgrade dashboard statistics ([@AdamKasp](https://github.com/AdamKasp), [@pamil](https://github.com/pamil))
- [#11466](https://github.com/Sylius/Sylius/issues/11466) [API] [Product] Remove custom latest products endpoint ([@GSadee](https://github.com/GSadee))
- [#11469](https://github.com/Sylius/Sylius/issues/11469) [Docs] Move contributing and support sections to the Book ([@pamil](https://github.com/pamil))
- [#11470](https://github.com/Sylius/Sylius/issues/11470) [Docs] Partition theming guide and move to other docs sections ([@pamil](https://github.com/pamil))
- [#11471](https://github.com/Sylius/Sylius/issues/11471) [Docs] Create an unified section about all Sylius APIs ([@pamil](https://github.com/pamil))
- [#11472](https://github.com/Sylius/Sylius/issues/11472) [Docs] Move plugins development guide to "The Book -> Plugins" ([@pamil](https://github.com/pamil))
- [#11474](https://github.com/Sylius/Sylius/issues/11474) [HOTFIX] [API] Resolve subresource class parameters ([@lchrusciel](https://github.com/lchrusciel))
- [#11479](https://github.com/Sylius/Sylius/issues/11479) [Api] Fix hardcoded class constraints ([@lchrusciel](https://github.com/lchrusciel), [@GSadee](https://github.com/GSadee))
- [#11481](https://github.com/Sylius/Sylius/issues/11481) Use https instead of http for all (almost) links ([@jacquesbh](https://github.com/jacquesbh))
- [#11490](https://github.com/Sylius/Sylius/issues/11490) [Countries]Add fixes for broken edit channel page and add product to cart ([@Tomanhez](https://github.com/Tomanhez))
- [#11494](https://github.com/Sylius/Sylius/issues/11494) [Minor] Sort api suites ([@lchrusciel](https://github.com/lchrusciel))
- [#11496](https://github.com/Sylius/Sylius/issues/11496) [Minor] Dead code removal ([@lchrusciel](https://github.com/lchrusciel))
- [#11499](https://github.com/Sylius/Sylius/issues/11499) [UI] added display of product variant original price on product page ([@JulienLoison](https://github.com/JulienLoison))
- [#11500](https://github.com/Sylius/Sylius/issues/11500) [Maintenance] Bump up minor versions of requirements ([@pamil](https://github.com/pamil))
- [#11503](https://github.com/Sylius/Sylius/issues/11503) [Hot-fix] Conflict SyliusFixturesBundle 1.6.0 to fix the build ([@Zales0123](https://github.com/Zales0123))
- [#11504](https://github.com/Sylius/Sylius/issues/11504) [UI] As an Administrator, I want to select period of graphs and counts on the dashboard (-Day/2 Weeks/Month/Year) ([@kulczy](https://github.com/kulczy), , [@GSadee](https://github.com/GSadee))
- [#11505](https://github.com/Sylius/Sylius/issues/11505) Travis Bionic + Chrome Headless + PHP 7.4 support ([@pamil](https://github.com/pamil))
- [#11506](https://github.com/Sylius/Sylius/issues/11506) Make compiler passes use all tags rather than the first tag ([@pamil](https://github.com/pamil))
- [#11507](https://github.com/Sylius/Sylius/issues/11507) Synchronise packages composer.json files with the main one + normalize them ([@pamil](https://github.com/pamil))
- [#11508](https://github.com/Sylius/Sylius/issues/11508) [Minor] [DX] Using parent definition for api clients ([@lchrusciel](https://github.com/lchrusciel))
- [#11514](https://github.com/Sylius/Sylius/issues/11514) [Minor] Move command to separate folder ([@lchrusciel](https://github.com/lchrusciel))
- [#11517](https://github.com/Sylius/Sylius/issues/11517) [Api] Add test for checking access ([@Tomanhez](https://github.com/Tomanhez))
- [#11520](https://github.com/Sylius/Sylius/issues/11520) Fix Psalm errors ([@pamil](https://github.com/pamil))
- [#11524](https://github.com/Sylius/Sylius/issues/11524) [API] Pick up cart implementation ([@lchrusciel](https://github.com/lchrusciel))
- [#11529](https://github.com/Sylius/Sylius/issues/11529) [RFC] Using tabs for channel pricing ([@mamazu](https://github.com/mamazu))
- [#11531](https://github.com/Sylius/Sylius/issues/11531) [Maintenance] Temporarily extend conflict to the ^2.5.5 versions of api-platform/core ([@GSadee](https://github.com/GSadee))
- [#11532](https://github.com/Sylius/Sylius/issues/11532) [API] Add simple item to cart ([@lchrusciel](https://github.com/lchrusciel))
- [#11535](https://github.com/Sylius/Sylius/issues/11535) Resolve awaiting_payment state in resolver ([@kayue](https://github.com/kayue))
- [#11536](https://github.com/Sylius/Sylius/issues/11536) [UI] add form helper ([@oallain](https://github.com/oallain))
- [#11541](https://github.com/Sylius/Sylius/issues/11541) fixed url to send valid key for channel ()
- [#11543](https://github.com/Sylius/Sylius/issues/11543) [Travis] Fix deprecations in the config ([@pamil](https://github.com/pamil))
- [#11544](https://github.com/Sylius/Sylius/issues/11544) ensure swagger docs route matches the configured new api route ([@esserj](https://github.com/esserj))
- [#11545](https://github.com/Sylius/Sylius/issues/11545) Add priority to payment gateways ([@Zales0123](https://github.com/Zales0123))
- [#11548](https://github.com/Sylius/Sylius/issues/11548) [Api] [Cart] Clear cart ([@Tomanhez](https://github.com/Tomanhez))
- [#11558](https://github.com/Sylius/Sylius/issues/11558) switch timeframe on admin dashboard ([@arti0090](https://github.com/arti0090))
- [#11560](https://github.com/Sylius/Sylius/issues/11560) [HOTFIX] Fix build ([@Tomanhez](https://github.com/Tomanhez))
- [#11561](https://github.com/Sylius/Sylius/issues/11561) [Travis] Update config on 1.7 with master ([@Tomanhez](https://github.com/Tomanhez))
- [#11563](https://github.com/Sylius/Sylius/issues/11563) [AdminApi] Add ShippingMethod authorization test ([@Tomanhez](https://github.com/Tomanhez))
- [#11564](https://github.com/Sylius/Sylius/issues/11564) [Minor] [Behat] Typo fix ([@lchrusciel](https://github.com/lchrusciel))
- [#11566](https://github.com/Sylius/Sylius/issues/11566) Limit dashboard move on future dates ([@arti0090](https://github.com/arti0090))
- [#11567](https://github.com/Sylius/Sylius/issues/11567) [Doc] change sylius.security.shop_regex in doc for new api ([@oallain](https://github.com/oallain))
- [#11571](https://github.com/Sylius/Sylius/issues/11571) [Admin] Make sidebar menu searchable ([@Florian-Merle](https://github.com/Florian-Merle))
- [#11586](https://github.com/Sylius/Sylius/issues/11586) fix left navigation arrow double click on admin statistics ([@arti0090](https://github.com/arti0090))
- [#11593](https://github.com/Sylius/Sylius/issues/11593) Upgrade static analysis tools and improve their usage ([@pamil](https://github.com/pamil))
- [#11600](https://github.com/Sylius/Sylius/issues/11600) Fix: link in github folder ([@toofff](https://github.com/toofff))
- [#11601](https://github.com/Sylius/Sylius/issues/11601) [Api] [Cart] Fix minor bug ([@Tomanhez](https://github.com/Tomanhez))
- [#11609](https://github.com/Sylius/Sylius/issues/11609) Use a placeholder in tracking code sentence in shipment email ([@jacquesbh](https://github.com/jacquesbh))
- [#11613](https://github.com/Sylius/Sylius/issues/11613) [Api] [Cart] Cart remove items ([@Tomanhez](https://github.com/Tomanhez))
- [#11615](https://github.com/Sylius/Sylius/issues/11615) [Composer] Remove conflict to api-platform/core ([@GSadee](https://github.com/GSadee))
- [#11616](https://github.com/Sylius/Sylius/issues/11616) [API] Secure subresources' endpoints ([@GSadee](https://github.com/GSadee))
- [#11619](https://github.com/Sylius/Sylius/issues/11619) [Docs] Fixing php-errors in the documentation ([@mamazu](https://github.com/mamazu))
- [#11620](https://github.com/Sylius/Sylius/issues/11620) Adding help to the tracking ([@mamazu](https://github.com/mamazu))
- [#11627](https://github.com/Sylius/Sylius/issues/11627) Add link to verify BC breaks in Pull request's template ([@jacquesbh](https://github.com/jacquesbh))
- [#11632](https://github.com/Sylius/Sylius/issues/11632) Use env:SYLIUS_FIXTURES_THEME_NAME to set the theme in fixtures ([@jacquesbh](https://github.com/jacquesbh))
- [#11636](https://github.com/Sylius/Sylius/issues/11636) Update .symfony.insight.yaml to latest PHP version ([@jacquesbh](https://github.com/jacquesbh))
- [#11642](https://github.com/Sylius/Sylius/issues/11642) Add field where You can verify shop user ([@arti0090](https://github.com/arti0090))
- [#11645](https://github.com/Sylius/Sylius/issues/11645) Add mention about translation in CONTRIBUTING.md ([@jacquesbh](https://github.com/jacquesbh))
- [#11646](https://github.com/Sylius/Sylius/issues/11646) [API] [Behat] Usage of proper tense in background ([@lchrusciel](https://github.com/lchrusciel))
- [#11651](https://github.com/Sylius/Sylius/issues/11651) Revert "Add field where You can verify shop user" ([@lchrusciel](https://github.com/lchrusciel))
- [#11655](https://github.com/Sylius/Sylius/issues/11655) [Minor] Remove final keyword ([@lchrusciel](https://github.com/lchrusciel))
- [#11656](https://github.com/Sylius/Sylius/issues/11656) [Minor] Move pickup cart command to proper namespace ([@lchrusciel](https://github.com/lchrusciel))
- [#11657](https://github.com/Sylius/Sylius/issues/11657) Make console commands lazy ([@ERuban](https://github.com/ERuban))
- [#11658](https://github.com/Sylius/Sylius/issues/11658) [Minor] Move cart commands serialization to separate folder ([@lchrusciel](https://github.com/lchrusciel))
- [#11660](https://github.com/Sylius/Sylius/issues/11660) Add documentation for checkout initialize events ([@antiseptikk](https://github.com/antiseptikk))
- [#11661](https://github.com/Sylius/Sylius/issues/11661) Loop.first is easier to 0 == loop.index0 ([@jacquesbh](https://github.com/jacquesbh))
- [#11664](https://github.com/Sylius/Sylius/issues/11664) Use env(SYLIUS_ADMIN_ROUTING_PATH_NAME) as admin's route name ([@jacquesbh](https://github.com/jacquesbh))
- [#11665](https://github.com/Sylius/Sylius/issues/11665) [Api] [Product] Product show  ([@Tomanhez](https://github.com/Tomanhez))
- [#11668](https://github.com/Sylius/Sylius/issues/11668) [Admin] Added collapse menu ([@StefDedi](https://github.com/StefDedi))
- [#11671](https://github.com/Sylius/Sylius/issues/11671) Fix space position ([@andrew-demb](https://github.com/andrew-demb))
- [#11672](https://github.com/Sylius/Sylius/issues/11672) [Product] add flags to product attributes translations ([@AdamKasp](https://github.com/AdamKasp))
- [#11673](https://github.com/Sylius/Sylius/issues/11673) [API] Checkout addressing step added - fixes ([@lchrusciel](https://github.com/lchrusciel), [@Tomanhez](https://github.com/Tomanhez))
- [#11674](https://github.com/Sylius/Sylius/issues/11674) Revert "[Admin] Added collapse menu" ([@CoderMaggie](https://github.com/CoderMaggie))
- [#11675](https://github.com/Sylius/Sylius/issues/11675) [API] Initial checkout implementation - fixes ([@lchrusciel](https://github.com/lchrusciel), [@Tomanhez](https://github.com/Tomanhez))
- [#11676](https://github.com/Sylius/Sylius/issues/11676) changed place of attribute tag ([@arti0090](https://github.com/arti0090))
- [#11683](https://github.com/Sylius/Sylius/issues/11683) [Product] [Admin] Unify product breadcrumb in both show and update page ([@hatem20](https://github.com/hatem20))
- [#11693](https://github.com/Sylius/Sylius/issues/11693) [Api]Add AddressDenormalizer ([@Tomanhez](https://github.com/Tomanhez))
- [#11695](https://github.com/Sylius/Sylius/issues/11695) [Api] [Cart] change quantity on cart ([@AdamKasp](https://github.com/AdamKasp))
- [#11698](https://github.com/Sylius/Sylius/issues/11698) Fixing the ChannelContext deprecations ([@mamazu](https://github.com/mamazu))
- [#11700](https://github.com/Sylius/Sylius/issues/11700) [Api] [Checkout] Add notes during checkout ([@Tomanhez](https://github.com/Tomanhez))
- [#11705](https://github.com/Sylius/Sylius/issues/11705) [Api] [Checkout] cover skipping payment steps in behat ([@AdamKasp](https://github.com/AdamKasp))
- [#11706](https://github.com/Sylius/Sylius/issues/11706) [API] [Cart] Maintaining cart after authorization ([@GSadee](https://github.com/GSadee))
- [#11711](https://github.com/Sylius/Sylius/issues/11711) [Api] [Checkout] skipping shipment step ([@AdamKasp](https://github.com/AdamKasp))
- [#11714](https://github.com/Sylius/Sylius/issues/11714) [API] Filling also shipping address during checkout ([@GSadee](https://github.com/GSadee))
- [#11715](https://github.com/Sylius/Sylius/issues/11715) [Api] [Checkout] [Order] Add tests for accessing order right after completing checkout ([@Tomanhez](https://github.com/Tomanhez))
- [#11716](https://github.com/Sylius/Sylius/issues/11716) [API] Minor fixes for filling shipping address during checkout ([@GSadee](https://github.com/GSadee))
- [#11717](https://github.com/Sylius/Sylius/issues/11717) [API] [Checkout]checkout without logged in account ([@arti0090](https://github.com/arti0090))
- [#11718](https://github.com/Sylius/Sylius/issues/11718) [Api] [Checkout] Add checkout:read for order api serialization configuration ([@Tomanhez](https://github.com/Tomanhez))
- [#11719](https://github.com/Sylius/Sylius/issues/11719) [API] Implement scenarios for selecting payment and shipping methods during checkout ([@GSadee](https://github.com/GSadee))
- [#11721](https://github.com/Sylius/Sylius/issues/11721) [Documentation] Add example to the grid documentation ([@s4iya](https://github.com/s4iya))
- [#11728](https://github.com/Sylius/Sylius/issues/11728) [API]seeing total tax on order summary  ([@arti0090](https://github.com/arti0090))
- [#11729](https://github.com/Sylius/Sylius/issues/11729) [API] Add products by variant code ([@lchrusciel](https://github.com/lchrusciel))
- [#11734](https://github.com/Sylius/Sylius/issues/11734) [API] [Shop] Add possibility to show variants from product ([@lchrusciel](https://github.com/lchrusciel))
- [#11735](https://github.com/Sylius/Sylius/issues/11735) [Api] [Checkout] ShippingMethod on Checkout ([@Tomanhez](https://github.com/Tomanhez))
- [#11740](https://github.com/Sylius/Sylius/issues/11740) [API]getting available payment methods ([@arti0090](https://github.com/arti0090))
- [#11741](https://github.com/Sylius/Sylius/issues/11741) [API] Remove CartShippingMethod API resource configuration ([@lchrusciel](https://github.com/lchrusciel))
- [#11742](https://github.com/Sylius/Sylius/issues/11742) [Api] [Checkout] ShippingMethod on Checkout - complete scenarios ([@lchrusciel](https://github.com/lchrusciel), [@Tomanhez](https://github.com/Tomanhez))
- [#11743](https://github.com/Sylius/Sylius/issues/11743) [Api] [Checkout] Order, shipping, promotion totals and order items on checkout summary ([@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee))
- [#11746](https://github.com/Sylius/Sylius/issues/11746) [API]Add validation to addressing fields ([@arti0090](https://github.com/arti0090))
- [#11747](https://github.com/Sylius/Sylius/issues/11747) [Api] [Checkout] Placing order with difference scopes ([@Tomanhez](https://github.com/Tomanhez))
- [#11748](https://github.com/Sylius/Sylius/issues/11748) [Api] [Checkout] Placing order with difference scopes - minor fixes ([@Tomanhez](https://github.com/Tomanhez))
- [#11749](https://github.com/Sylius/Sylius/issues/11749) [API] [Checkout] Cover scenarios for checking promotions ([@GSadee](https://github.com/GSadee))
- [#11750](https://github.com/Sylius/Sylius/issues/11750) [Api] [checkout] product integrity validation ([@AdamKasp](https://github.com/AdamKasp))
- [#11753](https://github.com/Sylius/Sylius/issues/11753) [API] Minor fixes for adjustments ([@GSadee](https://github.com/GSadee))
- [#11756](https://github.com/Sylius/Sylius/issues/11756) Replace outdated "symfony/security" package ([@stloyd](https://github.com/stloyd))
- [#11761](https://github.com/Sylius/Sylius/issues/11761) Fix bug in order total shipping rules ([@pamil](https://github.com/pamil), [@loevgaard](https://github.com/loevgaard))
- [#11769](https://github.com/Sylius/Sylius/issues/11769) [API] Mark ApiBundle as @experimental ([@GSadee](https://github.com/GSadee))
- [#11776](https://github.com/Sylius/Sylius/issues/11776) [Api] [Administrator] refactor endpoints for admin and admin avatar ([@AdamKasp](https://github.com/AdamKasp))
- [#11779](https://github.com/Sylius/Sylius/issues/11779) Api refactor simple entities part 1 ([@AdamKasp](https://github.com/AdamKasp))
- [#11782](https://github.com/Sylius/Sylius/issues/11782) [Maintenance] [HotFix] Conflict with Symofny/Form 4.4.12 ([@lchrusciel](https://github.com/lchrusciel))
- [#11789](https://github.com/Sylius/Sylius/issues/11789) [ADR] Path prefixes in new Sylius API ([@lchrusciel](https://github.com/lchrusciel))
- [#11791](https://github.com/Sylius/Sylius/issues/11791) [API] refactor endpoint for api resources ([@AdamKasp](https://github.com/AdamKasp))
- [#11796](https://github.com/Sylius/Sylius/issues/11796) Add symfony form 4.4.13 conflict ([@AdamKasp](https://github.com/AdamKasp))
- [#11810](https://github.com/Sylius/Sylius/issues/11810) [Maintenance] Update composer, bundles and symfony lock ([@lchrusciel](https://github.com/lchrusciel))
- [#11812](https://github.com/Sylius/Sylius/issues/11812) [Maintenance] Update dev-master config for bundles and components ([@lchrusciel](https://github.com/lchrusciel))
