/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class AxisImage {
    private static int MARGIN = 10;
    private static int AXIS_TEXT_INTERVAL = 3;
    private static Font FONT_TITLE = new Font("Dialog", 1, 20);
    private static Font FONT_DEFAULT = new Font("Dialog", 0, 12);
    private static Color COLOR_TITLE = Color.BLACK;
    private static Color COLOR_AXIS = Color.LIGHT_GRAY;
    private static Color COLOR_LINE = Color.BLACK;
    private static Color COLOR_POINT = Color.BLUE;
    private static int AXIS_HEIGHT = 8;
    private static DecimalFormat format = new DecimalFormat("0.##");
    private int width = 831;
    private int height = 544;
    private int leftBorderWidth;
    private int rightBorderWidth;
    private int topBorderHeight;
    private int bottomBorderHeight;
    private int yAxisLength;
    private int xAxisLength;
    private double xMin;
    private double xMax;
    private double xInterval;
    private double yMin;
    private double yMax;
    private double yInterval;
    private int xSecant = 8;
    private int ySecant = 8;
    private String imageTitle = "Dynamic Curve";
    private String xTitle = "Production Year";
    private String yTitle = "Production Rate";
    private String filePath;
    private ArrayList<Double> dataX;
    private ArrayList<Double> dataY;

    public AxisImage(String filePath, ArrayList<Double> dataX, ArrayList<Double> dataY) {
        this.filePath = filePath;
        this.initData();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.equals("");
    }

    private void initData2() {
        this.dataX = new ArrayList();
        this.dataX.add(2009.0);
        this.dataX.add(2010.0);
        this.dataX.add(2011.0);
        this.dataX.add(2012.0);
        this.dataX.add(2013.0);
        this.dataX.add(2014.0);
        this.dataX.add(2015.0);
        this.dataX.add(2016.0);
        this.dataY = new ArrayList();
        this.dataY.add(2009.0);
        this.dataY.add(2010.0);
        this.dataY.add(2011.0);
        this.dataY.add(2012.0);
        this.dataY.add(2013.0);
        this.dataY.add(2014.0);
        this.dataY.add(2015.0);
        this.dataY.add(2016.0);
    }

    private void initData() {
        this.dataX = new ArrayList();
        this.dataX.add(1970.0);
        this.dataX.add(1971.0);
        this.dataX.add(1972.0);
        this.dataX.add(1973.0);
        this.dataX.add(1974.0);
        this.dataX.add(1975.0);
        this.dataX.add(1976.0);
        this.dataX.add(1977.0);
        this.dataX.add(1978.0);
        this.dataX.add(1979.0);
        this.dataX.add(1980.0);
        this.dataX.add(1981.0);
        this.dataX.add(1982.0);
        this.dataX.add(1983.0);
        this.dataX.add(1984.0);
        this.dataX.add(1985.0);
        this.dataX.add(1986.0);
        this.dataX.add(1987.0);
        this.dataX.add(1988.0);
        this.dataX.add(1989.0);
        this.dataX.add(1990.0);
        this.dataX.add(1991.0);
        this.dataX.add(1992.0);
        this.dataX.add(1993.0);
        this.dataX.add(1994.0);
        this.dataX.add(1995.0);
        this.dataX.add(1996.0);
        this.dataX.add(1997.0);
        this.dataX.add(1998.0);
        this.dataX.add(1999.0);
        this.dataX.add(2000.0);
        this.dataX.add(2001.0);
        this.dataX.add(2002.0);
        this.dataX.add(2003.0);
        this.dataY = new ArrayList();
        this.dataY.add(2792.15);
        this.dataY.add(5278.07);
        this.dataY.add(5865.31);
        this.dataY.add(6646.68);
        this.dataY.add(5616.4);
        this.dataY.add(4714.56);
        this.dataY.add(4053.61);
        this.dataY.add(3981.79);
        this.dataY.add(3984.92);
        this.dataY.add(3815.58);
        this.dataY.add(3819.5);
        this.dataY.add(3423.39);
        this.dataY.add(3174.36);
        this.dataY.add(3417.84);
        this.dataY.add(3067.86);
        this.dataY.add(2743.75);
        this.dataY.add(2383.52);
        this.dataY.add(2456.8);
        this.dataY.add(2295.45);
        this.dataY.add(2284.7);
        this.dataY.add(3069.38);
        this.dataY.add(2596.44);
        this.dataY.add(2293.16);
        this.dataY.add(2145.34);
        this.dataY.add(2177.07);
        this.dataY.add(2094.92);
        this.dataY.add(1746.51);
        this.dataY.add(2126.63);
        this.dataY.add(2796.62);
        this.dataY.add(2954.27);
        this.dataY.add(3026.86);
        this.dataY.add(3667.41);
        this.dataY.add(4937.66);
        this.dataY.add(6000.18);
    }

    public String generate() {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = (Graphics2D)image.getGraphics();
        this.paintImage(g);
        return this.saveFile(this.filePath, image);
    }

    private void paintImage(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.BLACK);
        this.calculateMaxMin();
        this.adjustMaxMin();
        this.calculateAxisLength();
        this.drawImageTitle(g);
        this.drawXTitle(g);
        this.drawYTitle(g);
        this.drawXAxis(g);
        this.drawYAxis(g);
        this.drawPoints(g);
    }

    private void drawImageTitle(Graphics2D g0) {
        if (AxisImage.isEmpty(this.imageTitle)) {
            return;
        }
        Graphics2D g = (Graphics2D)g0.create();
        g.setColor(COLOR_TITLE);
        g.setFont(FONT_TITLE);
        TextLayout layout = new TextLayout(this.imageTitle, g.getFont(), g.getFontRenderContext());
        int x = (int)(((double)this.width - layout.getBounds().getWidth()) / 2.0);
        int y = MARGIN + (int)layout.getAscent();
        g.drawString(this.imageTitle, x, y);
        g.dispose();
    }

    private void drawXTitle(Graphics2D g0) {
        if (AxisImage.isEmpty(this.xTitle)) {
            return;
        }
        Graphics2D gx = (Graphics2D)g0.create();
        gx.setColor(COLOR_TITLE);
        gx.setFont(FONT_TITLE);
        TextLayout layout = new TextLayout(this.xTitle, gx.getFont(), gx.getFontRenderContext());
        int x = (int)((double)this.leftBorderWidth + ((double)this.xAxisLength - layout.getBounds().getWidth()) / 2.0);
        int y = this.topBorderHeight + this.yAxisLength + this.bottomBorderHeight - MARGIN - (int)layout.getDescent();
        gx.drawString(this.xTitle, x, y);
        gx.dispose();
    }

    private void drawYTitle(Graphics2D g0) {
        if (this.yTitle == null || this.yTitle.trim().equals("")) {
            return;
        }
        Graphics2D gy = (Graphics2D)g0.create();
        gy.setFont(FONT_TITLE);
        gy.setColor(COLOR_TITLE);
        AffineTransform at = new AffineTransform();
        at.setToRotation(4.71238898038469);
        gy.transform(at);
        TextLayout layout = new TextLayout(this.yTitle, gy.getFont(), gy.getFontRenderContext());
        int x = (int)(-((double)this.topBorderHeight + ((double)this.yAxisLength + layout.getBounds().getWidth()) / 2.0));
        int y = MARGIN + (int)layout.getAscent();
        gy.drawString(this.yTitle, x, y);
        gy.dispose();
    }

    private void drawXAxis(Graphics2D g0) {
        Graphics2D gx = (Graphics2D)g0.create();
        int xInterLen = this.xAxisLength / this.xSecant;
        int i = 0;
        while (i < this.xSecant + 1) {
            gx.setColor(COLOR_AXIS);
            gx.drawLine(this.leftBorderWidth + i * xInterLen, this.topBorderHeight + this.yAxisLength, this.leftBorderWidth + i * xInterLen, this.topBorderHeight + this.yAxisLength + AXIS_HEIGHT);
            gx.setColor(COLOR_TITLE);
            String axisText = format.format(this.xMin + (double)i * this.xInterval);
            TextLayout layout = new TextLayout(axisText, gx.getFont(), new FontRenderContext(null, false, false));
            gx.drawString(axisText, (float)(this.leftBorderWidth + i * xInterLen - (int)layout.getBounds().getWidth() / 2), (float)(this.topBorderHeight + this.yAxisLength + AXIS_HEIGHT) + layout.getAscent() + (float)AXIS_TEXT_INTERVAL);
            ++i;
        }
        gx.setColor(COLOR_LINE);
        gx.drawLine(this.leftBorderWidth, this.topBorderHeight, this.leftBorderWidth + this.xAxisLength, this.topBorderHeight);
        gx.drawLine(this.leftBorderWidth, this.topBorderHeight + this.yAxisLength, this.leftBorderWidth + this.xAxisLength, this.topBorderHeight + this.yAxisLength);
        gx.dispose();
    }

    private void drawYAxis(Graphics2D g0) {
        Graphics2D gy = (Graphics2D)g0.create();
        int yInterLen = this.yAxisLength / this.ySecant;
        int i = 0;
        while (i < this.ySecant + 1) {
            gy.setColor(COLOR_AXIS);
            gy.drawLine(this.leftBorderWidth - AXIS_HEIGHT, this.topBorderHeight + this.yAxisLength - i * yInterLen, this.leftBorderWidth, this.topBorderHeight + this.yAxisLength - i * yInterLen);
            if (i != 0 && i != this.ySecant) {
                gy.drawLine(this.leftBorderWidth, this.topBorderHeight + this.yAxisLength - i * yInterLen, this.leftBorderWidth + this.xAxisLength, this.topBorderHeight + this.yAxisLength - i * yInterLen);
            }
            gy.setColor(COLOR_TITLE);
            gy.setFont(FONT_DEFAULT);
            String axisText = format.format(this.yMax - (double)i * this.yInterval);
            TextLayout layout = new TextLayout(axisText, gy.getFont(), new FontRenderContext(null, false, false));
            gy.drawString(axisText, this.leftBorderWidth - AXIS_HEIGHT - AXIS_TEXT_INTERVAL - (int)layout.getBounds().getWidth(), this.topBorderHeight + i * yInterLen + (int)layout.getDescent());
            ++i;
        }
        gy.setColor(COLOR_LINE);
        gy.drawLine(this.leftBorderWidth, this.topBorderHeight, this.leftBorderWidth, this.topBorderHeight + this.yAxisLength);
        gy.drawLine(this.leftBorderWidth + this.xAxisLength, this.topBorderHeight, this.leftBorderWidth + this.xAxisLength, this.topBorderHeight + this.yAxisLength);
        gy.dispose();
    }

    private void drawPoints(Graphics2D g0) {
        Graphics2D g = (Graphics2D)g0.create();
        double xScope = this.xMax - this.xMin;
        double yScope = this.yMax - this.yMin;
        int prevX = -1;
        int prevY = -1;
        g.setColor(COLOR_POINT);
        int i = 0;
        while (i < this.dataX.size()) {
            Double xValue = this.dataX.get(i);
            Double yValue = this.dataY.get(i);
            if (!(xValue > this.xMax || xValue < this.xMin || yValue > this.yMax || yValue < this.yMin)) {
                int x = this.leftBorderWidth + (int)((xValue - this.xMin) / xScope * (double)this.xAxisLength);
                int y = this.topBorderHeight + this.yAxisLength - (int)((yValue - this.yMin) / yScope * (double)this.yAxisLength);
                g.fillOval(x - 5, y - 5, 10, 10);
                if (i != 0) {
                    g.drawLine(x, y, prevX, prevY);
                }
                prevX = x;
                prevY = y;
            }
            ++i;
        }
    }

    private String saveFile(String filePath, BufferedImage image) {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(new File(filePath));
                ImageIO.write((RenderedImage)image, "jpg", fos);
                fos.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    fos.close();
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
                return "";
            }
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return filePath;
    }

    private void calculateMaxMin() {
        int length = this.dataX.size();
        if (length != 0) {
            this.xMin = this.dataX.get(0);
            this.xMax = this.dataX.get(0);
            this.yMin = this.dataY.get(0);
            this.yMax = this.dataY.get(0);
            int i = 0;
            while (i < length) {
                double xValue = this.dataX.get(i);
                this.xMin = Math.min(this.xMin, xValue);
                this.xMax = Math.max(this.xMax, xValue);
                double yValue = this.dataY.get(i);
                this.yMin = Math.min(this.yMin, yValue);
                this.yMax = Math.max(this.yMax, yValue);
                ++i;
            }
        }
    }

    private void adjustMaxMin() {
        AxisAdjust adjustX = new AxisAdjust(this.xMax, this.xMin, this.xSecant);
        this.xMax = adjustX.getMax();
        this.xMin = adjustX.getMin();
        this.xInterval = adjustX.getInterval();
        this.xSecant = adjustX.getSecant();
        AxisAdjust adjustY = new AxisAdjust(this.yMax, this.yMin, this.ySecant);
        this.yMax = adjustY.getMax();
        this.yMin = adjustY.getMin();
        this.yInterval = adjustY.getInterval();
        this.ySecant = adjustY.getSecant();
    }

    private void calculateAxisLength() {
        int borderWidth1;
        TextLayout layout1 = new TextLayout(this.xTitle, FONT_TITLE, new FontRenderContext(null, false, false));
        this.leftBorderWidth = borderWidth1 = (int)Math.ceil(layout1.getAscent() + layout1.getDescent()) + MARGIN * 2;
        this.rightBorderWidth = borderWidth1;
        this.topBorderHeight = borderWidth1;
        this.bottomBorderHeight = borderWidth1;
        TextLayout layout2 = new TextLayout("1980", FONT_DEFAULT, new FontRenderContext(null, false, false));
        int borderWidth2 = (int)Math.ceil(layout2.getAscent() + layout2.getDescent()) + AXIS_TEXT_INTERVAL * 2;
        this.bottomBorderHeight += borderWidth2;
        String maxStr = format.format(this.yMin);
        int i = 1;
        while (i < this.ySecant + 1) {
            String str = format.format(this.yMin + (double)i * this.yInterval);
            if (str.length() > maxStr.length()) {
                maxStr = str;
            }
            ++i;
        }
        TextLayout layout3 = new TextLayout(maxStr, FONT_DEFAULT, new FontRenderContext(null, false, false));
        int borderWidth3 = (int)Math.ceil(layout3.getBounds().getWidth()) + AXIS_TEXT_INTERVAL * 2;
        this.leftBorderWidth += borderWidth3;
        this.yAxisLength = this.height - this.topBorderHeight - this.bottomBorderHeight;
        this.xAxisLength = this.width - this.leftBorderWidth - this.rightBorderWidth;
        int lessX = this.xAxisLength % this.xSecant;
        this.xAxisLength -= lessX;
        this.bottomBorderHeight += lessX;
        int lessY = this.yAxisLength % this.ySecant;
        this.yAxisLength -= lessY;
        this.rightBorderWidth += lessY;
    }

    public static void main(String[] args) {
        AxisImage axisImage = new AxisImage("imageA\\03D.jpg", new ArrayList<Double>(), new ArrayList<Double>());
        System.out.println(axisImage.generate());
    }

    private class AxisAdjust {
        private double max;
        private double min;
        private int secant;
        private double interval;

        public AxisAdjust(double max, double min, int groupNo) {
            this.max = max;
            this.min = min;
            this.secant = groupNo;
            this.adjust();
        }

        public double getInterval() {
            return this.interval;
        }

        public double getMax() {
            return this.max;
        }

        public double getMin() {
            return this.min;
        }

        public int getSecant() {
            return this.secant;
        }

        private void adjust2() {
            this.interval = (this.max - this.min) / (double)this.secant;
            double m10 = Math.floor(Math.log10(this.interval));
            double standardValue = 5.0 * Math.pow(10.0, m10 - 1.0);
            double yInterval1 = this.interval % Math.pow(10.0, Math.floor(m10));
            if (yInterval1 > standardValue) {
                double d = Math.round((yInterval1 - standardValue) * 2.0 / Math.pow(10.0, m10));
                if (d == 0.0) {
                    ++this.secant;
                    this.interval = (Math.floor(this.interval / Math.pow(10.0, Math.floor(m10))) + 0.5) * Math.pow(10.0, m10);
                } else {
                    this.interval = (Math.floor(this.interval / Math.pow(10.0, Math.floor(m10))) + 1.0) * Math.pow(10.0, m10);
                }
            } else {
                double d = Math.round(yInterval1 * 2.0 / Math.pow(10.0, m10));
                if (d == 0.0) {
                    ++this.secant;
                    this.interval = Math.floor(this.interval / Math.pow(10.0, m10)) * Math.pow(10.0, m10);
                } else {
                    this.interval = (Math.floor(this.interval / Math.pow(10.0, m10)) + 0.5) * Math.pow(10.0, m10);
                }
            }
            System.out.println("interval = " + this.interval);
            this.max = this.min + this.interval * (double)this.secant;
            System.out.println("max = " + this.max + ", min = " + this.min);
        }

        private void adjust() {
            double scope = this.max - this.min;
            this.secant = (int)(scope / (5.0 * Math.pow(10.0, Math.floor(Math.log10(scope)) - 1.0)));
            if (this.secant > 10) {
                this.secant = (this.secant + 1) / 2;
            }
            this.interval = (this.max - this.min) / (double)this.secant;
            double m10 = Math.floor(Math.log10(this.interval));
            double standardValue = 5.0 * Math.pow(10.0, m10 - 1.0);
            double yInterval1 = 0.0;
            if (m10 > 0.0) {
                yInterval1 = this.interval % Math.pow(10.0, Math.floor(m10));
            } else {
                double temp = Math.pow(10.0, -m10);
                yInterval1 = this.interval * temp % (Math.pow(10.0, Math.floor(m10)) * temp) / temp;
            }
            double d = 0.0;
            if (yInterval1 != 0.0 && yInterval1 != standardValue) {
                if (yInterval1 > standardValue) {
                    d = Math.round((yInterval1 - standardValue) * 2.0 / Math.pow(10.0, m10));
                    if (d == 0.0) {
                        ++this.secant;
                        this.interval = (Math.floor(this.interval / Math.pow(10.0, Math.floor(m10))) + 0.5) * Math.pow(10.0, m10);
                    } else {
                        this.interval = (Math.floor(this.interval / Math.pow(10.0, Math.floor(m10))) + 1.0) * Math.pow(10.0, m10);
                    }
                } else {
                    d = Math.round(yInterval1 * 2.0 / Math.pow(10.0, m10));
                    if (d == 0.0) {
                        ++this.secant;
                        this.interval = Math.floor(this.interval / Math.pow(10.0, m10)) * Math.pow(10.0, m10);
                    } else {
                        this.interval = (Math.floor(this.interval / Math.pow(10.0, m10)) + 0.5) * Math.pow(10.0, m10);
                    }
                }
            }
            this.min = Math.floor(this.min / this.interval) * this.interval;
            this.max = Math.ceil(this.max / this.interval) * this.interval;
            if (this.interval * (double)this.secant < scope) {
                ++this.secant;
            }
        }
    }
}

