/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class DragSourceTree
extends JTree
implements DragGestureListener,
DragSourceListener {
    private DragSource dragSource = DragSource.getDefaultDragSource();

    public DragSourceTree() {
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    public DragSourceTree(DefaultMutableTreeNode treeNode) {
        super(treeNode);
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        int y;
        Cursor cursor = null;
        cursor = DragSource.DefaultCopyDrop;
        Point jap = dge.getDragOrigin();
        int x = (int)jap.getX();
        TreePath tp = this.getPathForLocation(x, y = (int)jap.getY());
        if (tp != null) {
            DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)tp.getLastPathComponent();
            this.serializableNode(node1);
        }
        dge.startDrag(cursor, new StringSelection("drag"), this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    private void serializableNode(DefaultMutableTreeNode node) {
        try {
            FileOutputStream objfile = new FileOutputStream("DragNode.OBJ");
            ObjectOutputStream p = new ObjectOutputStream(objfile);
            p.writeObject(node);
            p.flush();
            objfile.close();
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }
}

