/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;

public class ImageCanvas
extends Canvas {
    Image image;

    public ImageCanvas(String name) {
        MediaTracker media = new MediaTracker(this);
        this.image = Toolkit.getDefaultToolkit().getImage(name);
        media.addImage(this.image, 0);
        try {
            media.waitForID(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ImageCanvas(ImageProducer imageProducer) {
        this.image = this.createImage(imageProducer);
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
    }

    public static void main(String[] argv) {
        if (argv.length < 1) {
            System.out.println("usage: ImageCanvas.class [image file name]");
            System.exit(0);
        }
        Frame frame = new Frame(argv[0]);
        frame.setLayout(new BorderLayout());
        frame.add("Center", new ImageCanvas(argv[0]));
        frame.resize(400, 400);
        frame.show();
    }
}

