/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;

class ImagePanel
extends JPanel {
    private DragStatus status = DragStatus.Ready;
    private Image image;
    private Point imagePosition = new Point(0, 0);
    private Point imageStartposition = new Point(0, 0);
    private Point mouseStartposition;

    ImagePanel() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ImagePanel.this.openImage();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (ImagePanel.this.status == DragStatus.Ready) {
                    ImagePanel.this.status = DragStatus.Dragging;
                    ImagePanel.this.mouseStartposition = e.getPoint();
                    ImagePanel.this.imageStartposition.setLocation(ImagePanel.this.imagePosition.getLocation());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ImagePanel.this.status == DragStatus.Dragging) {
                    ImagePanel.this.status = DragStatus.Ready;
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ImagePanel.this.status == DragStatus.Dragging) {
                    ImagePanel.this.moveImage(e.getPoint());
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void moveImage(Point point) {
        this.imagePosition.setLocation(this.imageStartposition.getX() + (point.getX() - this.mouseStartposition.getX()), this.imageStartposition.getY() + (point.getY() - this.mouseStartposition.getY()));
        this.repaint();
    }

    private void openImage() {
        System.out.println("Opening image...");
        File file = this.createFileChooser().getSelectedFile();
        if (file != null) {
            this.image = Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
            if (this.image != null) {
                this.repaint();
            }
        }
    }

    private JFileChooser createFileChooser() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("\u8bf7\u9009\u62e9\u56fe\u7247\u6587\u4ef6...");
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("\u5e38\u7528\u56fe\u7247\u683c\u5f0f", "jpg", "jpeg", "gif", "png"));
        chooser.showOpenDialog(this);
        return chooser;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            g.drawImage(this.image, (int)this.imagePosition.getX(), (int)this.imagePosition.getY(), this);
        }
    }

    private static enum DragStatus {
        Ready,
        Dragging;

    }
}

