/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

class MyMouseAdapter
extends MouseAdapter {
    private JLabel selectedCard = null;
    private JLayeredPane cardGameTable = null;
    private JPanel basePane = null;
    private int deltaX = 0;
    private int deltaY = 0;

    public MyMouseAdapter(JLayeredPane gameTable, JPanel basePane) {
        this.cardGameTable = gameTable;
        this.basePane = basePane;
    }

    @Override
    public void mousePressed(MouseEvent mEvt) {
        Component comp = this.basePane.getComponentAt(mEvt.getPoint());
        if (comp != null && comp instanceof JLabel) {
            this.selectedCard = (JLabel)comp;
            this.basePane.remove(this.selectedCard);
            this.basePane.revalidate();
            this.basePane.repaint();
            this.cardGameTable.add((Component)this.selectedCard, JLayeredPane.DRAG_LAYER);
            this.cardGameTable.revalidate();
            this.cardGameTable.repaint();
            this.deltaX = mEvt.getX() - this.selectedCard.getX();
            this.deltaY = mEvt.getY() - this.selectedCard.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mEvt) {
        if (this.selectedCard != null) {
            this.cardGameTable.remove(this.selectedCard);
            this.cardGameTable.revalidate();
            this.cardGameTable.repaint();
            this.basePane.add((Component)this.selectedCard, 0);
            this.basePane.revalidate();
            this.basePane.repaint();
            this.selectedCard = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mEvt) {
        if (this.selectedCard != null) {
            int x = mEvt.getX() - this.deltaX;
            int y = mEvt.getY() - this.deltaY;
            this.selectedCard.setLocation(x, y);
            this.cardGameTable.revalidate();
            this.cardGameTable.repaint();
        }
    }
}

