/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;

class Node {
    public String id;
    public String text;
    public String parentId;
    public int weight;
    public boolean visible = true;
    public Node parentNode;
    private Children children = new Children();

    Node() {
    }

    public void addChild(Node node) {
        this.children.addChild(node);
    }

    public String toString() {
        if (this.visible) {
            String result = "{id : '" + this.id + "'" + ", text : '" + this.text + "'";
            result = this.children != null && this.children.getSize() != 0 ? String.valueOf(result) + ", children : " + this.children.toString() : String.valueOf(result) + ", leaf : true";
            return String.valueOf(result) + "}";
        }
        return "";
    }

    public void sortChildren() {
        if (this.children != null && this.children.getSize() != 0) {
            this.children.sortChildren();
        }
    }

    public void initializeLeafList(List leafList) {
        if (this.children == null || this.children.getSize() == 0) {
            leafList.add(this);
        } else {
            this.children.initializeLeafList(leafList);
        }
    }

    public void setTreeNotVisible() {
        this.visible = false;
        if (this.children != null && this.children.getSize() != 0) {
            this.children.setTreeNotVisible();
        }
    }

    public void setTreeVisible() {
        this.visible = true;
        if (this.children != null && this.children.getSize() != 0) {
            this.children.setTreeVisible();
        }
    }

    public void setRouteVisible() {
        this.visible = true;
        Node parentNode = this.parentNode;
        while (parentNode != null) {
            parentNode.visible = true;
            parentNode = parentNode.parentNode;
        }
    }

    public void increaseRouteWeight() {
        ++this.weight;
        this.updateNodeWeightToDB(this);
        Node parentNode = this.parentNode;
        while (parentNode != null) {
            ++parentNode.weight;
            this.updateNodeWeightToDB(parentNode);
            parentNode = parentNode.parentNode;
        }
    }

    public void updateNodeWeightToDB(Node node) {
    }

    public void searchTreeNode(String keyWord) {
        if (this.text.indexOf(keyWord) > -1) {
            this.setTreeVisible();
            this.setRouteVisible();
        } else if (this.children != null && this.children.getSize() != 0) {
            this.children.searchTreeNode(keyWord);
        }
    }
}

