/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SimpleTree
extends JFrame {
    JPanel contentPane;
    JScrollPane scrollPane = new JScrollPane();
    MyTree tree = new MyTree();
    DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
    NodeRenderer renderer = new NodeRenderer();
    private TreeMouseHandler treeMouseListener = new TreeMouseHandler();

    public SimpleTree() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.tree.setEditable(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.addMouseListener(this.treeMouseListener);
        this.tree.setCellRenderer(this.renderer);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent evt) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent evt) {
            }
        });
        this.contentPane = (JPanel)this.getContentPane();
        this.setTitle("MyFrame");
        this.scrollPane.getViewport().add((Component)this.tree, null);
        this.contentPane.add((Component)this.scrollPane, "Center");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        SimpleTree simpleTree = new SimpleTree();
        simpleTree.setSize(800, 600);
        simpleTree.show();
    }

    class MyTree
    extends JTree {
        public MyTree() {
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
            DefaultMutableTreeNode sub1Node = new DefaultMutableTreeNode("sub1");
            rootNode.add(sub1Node);
            DefaultMutableTreeNode n = new DefaultMutableTreeNode("011");
            sub1Node.add(n);
            n.add(new DefaultMutableTreeNode("111"));
            n.add(new DefaultMutableTreeNode("112"));
            n.add(new DefaultMutableTreeNode("113"));
            n = new DefaultMutableTreeNode("012");
            sub1Node.add(n);
            n.add(new DefaultMutableTreeNode("121"));
            n.add(new DefaultMutableTreeNode("122"));
            n.add(new DefaultMutableTreeNode("123"));
            this.setModel(new DefaultTreeModel(rootNode));
        }
    }

    class NodeRenderer
    extends DefaultTreeCellRenderer {
        NodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (node.getUserObject().toString().trim().equals("011")) {
                this.setForeground(Color.RED);
                this.setTextSelectionColor(Color.BLUE);
                this.setBackgroundSelectionColor(Color.GREEN);
                this.setBackgroundNonSelectionColor(Color.WHITE);
            }
            return this;
        }
    }

    private class TreeMouseHandler
    extends MouseAdapter {
        private TreeMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            System.out.println("mousePressed");
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            TreePath[] selectedPaths = SimpleTree.this.tree.getSelectionPaths();
            if (selectedPaths == null || selectedPaths.length == 0) {
                return;
            }
            if (selectedPaths.length == 1) {
                if (e.getClickCount() == 1) {
                    System.out.println("mouseClicked:   left   button   *   1   :   " + selectedPaths[0]);
                } else if (e.getClickCount() == 2) {
                    System.out.println("mouseClicked:   left   button   *   2   :   " + selectedPaths[0]);
                }
            }
        }
    }
}

