/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class StyleTable
extends JTable {
    private String[] color = null;

    public StyleTable() {
    }

    public StyleTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.paintRow();
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.getModel());
        this.setRowSorter(sorter);
        this.setIntercellSpacing(new Dimension(5, 5));
        this.fitTableColumns(this);
    }

    public StyleTable(Object[][] rowData, Object[] columnNames, String[] color) {
        super(rowData, columnNames);
        this.color = color;
        this.paintColorRow();
        this.setFixColumnWidth(this);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.getModel());
        this.setRowSorter(sorter);
        this.setIntercellSpacing(new Dimension(5, 5));
        this.fitTableColumns(this);
    }

    public void paintRow() {
        TableColumnModel tcm = this.getColumnModel();
        int i = 0;
        int n = tcm.getColumnCount();
        while (i < n) {
            TableColumn tc = tcm.getColumn(i);
            tc.setCellRenderer(new RowRenderer());
            ++i;
        }
    }

    public void paintColorRow() {
        TableColumnModel tcm = this.getColumnModel();
        int i = 0;
        int n = tcm.getColumnCount();
        while (i < n) {
            TableColumn tc = tcm.getColumn(i);
            tc.setCellRenderer(new RowColorRenderer());
            ++i;
        }
    }

    public void setFixColumnWidth(JTable table) {
        this.setAutoResizeMode(0);
        TableColumnModel tcm = table.getTableHeader().getColumnModel();
        int i = 0;
        while (i < tcm.getColumnCount()) {
            TableColumn tc = tcm.getColumn(i);
            tc.setPreferredWidth(50);
            tc.setMaxWidth(50);
            ++i;
        }
    }

    public void fitTableColumns(JTable myTable) {
        myTable.setAutoResizeMode(0);
        JTableHeader header = myTable.getTableHeader();
        int rowCount = myTable.getRowCount();
        Enumeration<TableColumn> columns = myTable.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            int col = header.getColumnModel().getColumnIndex(column.getIdentifier());
            int width = (int)header.getDefaultRenderer().getTableCellRendererComponent(myTable, column.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
            int row = 0;
            while (row < rowCount) {
                int preferedWidth = (int)myTable.getCellRenderer(row, col).getTableCellRendererComponent(myTable, myTable.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
                width = Math.max(width, preferedWidth);
                ++row;
            }
            header.setResizingColumn(column);
            column.setWidth(width + myTable.getIntercellSpacing().width);
        }
    }

    private class RowColorRenderer
    extends DefaultTableCellRenderer {
        private RowColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (StyleTable.this.color[row].trim().equals("E")) {
                this.setBackground(Color.RED);
            } else if (StyleTable.this.color[row].trim().equals("H")) {
                this.setBackground(Color.CYAN);
            } else if (StyleTable.this.color[row].trim().equals("A")) {
                this.setBackground(Color.BLUE);
            } else if (StyleTable.this.color[row].trim().equals("F")) {
                this.setBackground(Color.ORANGE);
            } else {
                this.setBackground(Color.WHITE);
            }
            return super.getTableCellRendererComponent(t, value, isSelected, hasFocus, row, column);
        }
    }

    private class RowRenderer
    extends DefaultTableCellRenderer {
        private RowRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (row % 2 == 0) {
                this.setBackground(Color.BLUE);
            } else {
                this.setBackground(Color.GREEN);
            }
            return super.getTableCellRendererComponent(t, value, isSelected, hasFocus, row, column);
        }
    }
}

