/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.TextField;
import java.util.GregorianCalendar;

public class \u4e07\u5e74\u5386
extends Applet {
    static final int TOP = 70;
    static final int CELLWIDTH = 50;
    static final int CELLHEIGHT = 30;
    static final int MARGIN = 3;
    static final int FEBRUARY = 1;
    TextField tfYear = new TextField("2004", 5);
    Choice monthChoice = new Choice();
    Button btUpdate = new Button("\u66f4\u65b0");
    GregorianCalendar calendar = new GregorianCalendar();
    Font smallFont = new Font("TimesRoman", 0, 15);
    Font bigFont = new Font("TimesRoman", 1, 50);
    String[] days = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
    String[] months = new String[]{"\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
    int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    int searchMonth;
    int searchYear;

    @Override
    public void init() {
        this.setBackground(Color.white);
        this.searchMonth = this.calendar.get(2);
        this.searchYear = this.calendar.get(1);
        this.add(new Label(" \u5e74:"));
        this.tfYear.setText(String.valueOf(this.searchYear));
        this.add(this.tfYear);
        this.add(new Label(" \u6708:"));
        this.monthChoice.setFont(this.smallFont);
        int i = 0;
        while (i < 12) {
            this.monthChoice.addItem(this.months[i]);
            ++i;
        }
        this.monthChoice.select(this.searchMonth);
        this.add(this.monthChoice);
        this.add(this.btUpdate);
        int componentCount = this.getComponentCount();
        int i2 = 0;
        while (i2 < componentCount) {
            this.getComponent(i2).setFont(this.smallFont);
            ++i2;
        }
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.lightGray);
        g.setFont(this.bigFont);
        g.drawString(String.valueOf(this.searchYear) + "\u5e74", 60, 140);
        g.drawString(String.valueOf(this.searchMonth + 1) + "\u6708", 200, 200);
        g.setColor(Color.black);
        g.setFont(this.smallFont);
        FontMetrics fontMetric = g.getFontMetrics();
        int fontAscent = fontMetric.getAscent();
        int dayPos = 70 + fontAscent / 2;
        int totalWidth = 350;
        int i = 0;
        while (i < 7) {
            g.drawString(this.days[i], (50 - fontMetric.stringWidth(this.days[i])) / 2 + i * 50, dayPos - 20);
            ++i;
        }
        int numRows = this.getNumberRows(this.searchYear, this.searchMonth);
        int totalHeight = numRows * 30;
        i = 0;
        while (i <= totalWidth) {
            g.drawLine(i, 70, i, 70 + totalHeight);
            i += 50;
        }
        i = 0;
        int j = 70;
        while (i <= numRows) {
            g.drawLine(0, j, totalWidth, j);
            ++i;
            j += 30;
        }
        int xNum = (this.getFirstDayOfMonth(this.searchYear, this.searchMonth) + 1) * 50 - 3;
        int yNum = 73 + fontAscent;
        int numDays = this.daysInMonth[this.searchMonth] + (this.calendar.isLeapYear(this.searchYear) && this.searchMonth == 1 ? 1 : 0);
        int day = 1;
        while (day <= numDays) {
            String dayStr = Integer.toString(day);
            g.drawString(dayStr, xNum - fontMetric.stringWidth(dayStr), yNum);
            if ((xNum += 50) > totalWidth) {
                xNum = 47;
                yNum += 30;
            }
            ++day;
        }
    }

    @Override
    public boolean action(Event e, Object o) {
        if (e.target == this.btUpdate) {
            this.searchMonth = this.monthChoice.getSelectedIndex();
            int searchYearInt = Integer.parseInt(this.tfYear.getText(), 10);
            if (searchYearInt > 1581) {
                this.searchYear = searchYearInt;
            }
            this.repaint();
            return true;
        }
        return false;
    }

    private int getNumberRows(int year, int month) {
        if (year < 1582) {
            return -1;
        }
        if (month < 0 || month > 11) {
            return -1;
        }
        int firstDay = this.getFirstDayOfMonth(year, month);
        if (month == 1 && firstDay == 0 && !this.calendar.isLeapYear(year)) {
            return 4;
        }
        int numCells = firstDay + this.daysInMonth[month];
        if (month == 1 && this.calendar.isLeapYear(year)) {
            ++numCells;
        }
        return numCells <= 35 ? 5 : 6;
    }

    private int getFirstDayOfMonth(int year, int month) {
        if (year < 1582) {
            return -1;
        }
        if (month < 0 || month > 11) {
            return -1;
        }
        int firstDay = this.getFirstDayOfYear(year);
        int i = 0;
        while (i < month) {
            firstDay += this.daysInMonth[i];
            ++i;
        }
        if (month > 1 && this.calendar.isLeapYear(year)) {
            ++firstDay;
        }
        return firstDay % 7;
    }

    private int getFirstDayOfYear(int year) {
        if (year < 1582) {
            return -1;
        }
        int leapYears = (year - 1581) / 4;
        int hundreds = (year - 1501) / 100;
        leapYears -= hundreds;
        int fourHundreds = (year - 1201) / 400;
        int first = 5 + (year - 1582) + (leapYears += fourHundreds) % 7;
        return first;
    }
}

