/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class \u83dc\u5355\u6811\u7c7b {
    public static void main(String[] args) {
        List dataList = VirtualDataGenerator.getVirtualResult();
        Node root = \u83dc\u5355\u6811\u7c7b.buildWeightedMultiTree(dataList);
        List functionLeafList = \u83dc\u5355\u6811\u7c7b.buildFunctionLeafList(root);
        root.sortChildren();
        System.out.println("\u9996\u6b21\u767b\u5f55\u65f6\u7684\u6811\u5f62\u83dc\u5355\uff1a\n" + root.toString());
        \u83dc\u5355\u6811\u7c7b.searchTreeNode(root, "321");
        System.out.println("\u641c\u7d22\u540e\u7684\u6811\u5f62\u83dc\u5355\uff1a\n" + root.toString());
        \u83dc\u5355\u6811\u7c7b.increaseRouteWeight(root, functionLeafList, "122");
        \u83dc\u5355\u6811\u7c7b.increaseRouteWeight(root, functionLeafList, "323");
        root.sortChildren();
        System.out.println("\u8def\u5f84\u6743\u503c\u53d8\u5316\u540e\u518d\u6b21\u767b\u5f55\u65f6\u7684\u6811\u5f62\u83dc\u5355\uff1a\n" + root.toString());
        List hotFunctionLeaf = \u83dc\u5355\u6811\u7c7b.getHotFunctionLeaf(functionLeafList);
        \u83dc\u5355\u6811\u7c7b.printHotFunctionLeaf(hotFunctionLeaf);
    }

    public static Node buildWeightedMultiTree(List dataList) {
        Node node;
        HashMap<String, Node> nodeList = new HashMap<String, Node>();
        Node root = null;
        for (Map dataRecord : dataList) {
            node = new Node();
            node.id = (String)dataRecord.get("id");
            node.text = (String)dataRecord.get("text");
            node.parentId = (String)dataRecord.get("parentId");
            node.weight = Integer.parseInt((String)dataRecord.get("weight"));
            nodeList.put(node.id, node);
        }
        Set entrySet = nodeList.entrySet();
        Iterator it = entrySet.iterator();
        while (it.hasNext()) {
            node = (Node)it.next().getValue();
            if (node.parentId == null || node.parentId.equals("")) {
                root = node;
                continue;
            }
            ((Node)nodeList.get(node.parentId)).addChild(node);
            node.parentNode = (Node)nodeList.get(node.parentId);
        }
        return root;
    }

    public static List buildFunctionLeafList(Node root) {
        ArrayList functionLeafList = new ArrayList();
        root.initializeLeafList(functionLeafList);
        return functionLeafList;
    }

    public static void searchTreeNode(Node root, String keyWord) {
        root.setTreeNotVisible();
        root.searchTreeNode(keyWord);
    }

    public static void increaseRouteWeight(Node root, List functionLeafList, String nodeId) {
        root.setTreeVisible();
        for (Node leafNode : functionLeafList) {
            if (!leafNode.id.equals(nodeId)) continue;
            leafNode.increaseRouteWeight();
        }
    }

    public static List getHotFunctionLeaf(List functionLeafList) {
        int count = 0;
        int totalWeight = 0;
        for (Node node : functionLeafList) {
            totalWeight += node.weight;
            ++count;
        }
        BigDecimal avgWeight = new BigDecimal(totalWeight).divide(new BigDecimal(count), 2, 4);
        ArrayList<Node> retList = new ArrayList<Node>();
        for (Node node : functionLeafList) {
            if (!((double)node.weight > avgWeight.doubleValue())) continue;
            retList.add(node);
        }
        return retList;
    }

    public static void printHotFunctionLeaf(List hotFunctionLeaf) {
        System.out.println("\u70ed\u70b9\u529f\u80fd\u53f6\u5b50\uff1a\n" + hotFunctionLeaf);
    }
}

