﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Room.aspx.cs" Inherits="RM.Web.Live.Room" %>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <title><%=liveName %>-<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("live_Room")%></title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="Chrome=1,IE=edge" />
<meta name="renderer" content="webkit">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.1/css/bootstrap.min.css">
<!--[if lte IE 7]>
    <script type='text/javascript' src='js/lib/json2.js'></script>
    <![endif]-->
    <script src="https://code.jquery.com/jquery-1.11.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.1/js/bootstrap.min.js"></script>
    <script src="js/lib/socket.io-1.3.5.min.js"></script>
    <script src="js/lib/yunba-js-sdk.js"></script>
    <style type="text/css">
        .chat-message { margin-bottom: 10px; }
        .chat-log { color: #ccc; font-size: 12px; }
        .chat-message .chat-username { color: Blue; display: block; font-size: 12px; }
        .chat-message .chat-message-body { display: block; }
    </style>
</head>
<body>
<section>
    <div id="view-chatroom" class="container" style="padding-top: 50px;">
        <div class="row">
            <div class="col-sm-10 col-xs-7">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <div class="h3 panel-title"><%=liveName %>-讨论</div>
                    </div>
                    <div style="height: 500px;" class="panel-body">
                        <ul id="chat-messages" class="chat-messages">
                            <!--  span.chat-username 游客#1000 -->
                            <!--  span.chat-message-body 游客#1000: message -->
                        </ul>
                    </div>
                    <div class="panel-footer">
                        <div class="input-group">
                            <input type="text" id="chatroom-input" class="form-control">
                            <span class="input-group-btn">
                                <button type="button" id="btn-send-msg" class="btn btn-success">
                                    发送
                                </button>
                            </span>
                        </div>
                        
                    </div>
                </div>
            </div>
            <div class="col-sm-2 col-xs-5">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <div class="h3 panel-title">在线列表 <span id="mancount"></span></div>
                    </div>
                    <div style="height: 500px;" class="panel-body">
                        <ul id="chat-online-list" class="list-group chat-online-list">
                            <!--li.list-group-item 游客#1000-->
                        </ul>
                    </div>
                     <div class="input-group" style=" margin:10px;">
                    <button type="button" id="Button0" class="btn btn-info" onclick="jinyan(0)">
                        全员禁言</button>
                    <button type="button" id="Button1" class="btn btn-danger" onclick="jinyan(1)" style=" display:none;">
                        解除禁言</button>
                </div>
                </div>
            </div>
        </div>
    </div>
</section>
 <script type="text/javascript">
     var flashvars = {
            rid: '<%=roomId %>',
            rtmpVideo: '<%=RM.Common.DotNetConfig.ConfigHelper.GetAppSettings("RmtpURLvLive")%>',
            name: '<%=item.LiveTelecast_CreateUserName %>',
           	id:'<%=item.LiveTelecast_CreateUserId%>',
            type:<%=item.LiveTelecast_InType=="3"?0:item.LiveTelecast_InType=="1"?1:item.LiveTelecast_InType=="2"?1:item.LiveTelecast_InType=="4"?1:0 %>,
            record: '<%=IsVideo%>',
            bookname: "<%=LiveTelecast_Name%>",
            data: "<%=LiveTelecast_StartDate%>",
            createuserName: "<%=LiveTelecast_Teacher%>",
            teacherid: "<%=LiveTelecast_TeacherId %>"
        };
     var CHATROOM_TOPIC = flashvars.rid;
     var roleId = flashvars.type; // 1、学生 0、老师

     function livelog(text) {
         console.log(text);
     }
    function livestart() {
            var url = "/LiveTelecast/LiveInteractConfig.ashx?key=" + flashvars.rid + "&action=2&data=1&userid=" + flashvars.id + "&livetype=1&date=" + new Date().toLocaleString();
            $("body").append("<iframe src="+url+" style=\" display:none;\" />");
           
    }
    function jinyan(str) {
             var messageStr ="cmd:";
            if(str == 0){
                messageStr+="start";
                $("#Button0").hide();
                $("#Button1").show();
            }
            else{
                messageStr+="stop";
                 $("#Button0").show();
                  $("#Button1").hide();
            }
             var data = JSON.stringify({
                dataType: 'MESSAGE',
                dataContent: messageStr,
                username: flashvars.name
            });
            publish(CHATROOM_TOPIC, data);
        }
</script>
   
    <script type="text/javascript" src="js/main.js"></script>
</body>
</html>
