﻿(function (window, undefined) {
    //入驻so命名空间
    window.so = window.so || {};
    window.so.getElementByClassName = function (name, element, tag) {
        /// <summary>
        ///     1: 模拟class(类)选择器，返回一个含查找结果的DOM数组
        ///     &#10;    1.1 - so.getElementByClassName(name) - 查找含有指定class的element节点
        ///     &#10;    1.2 - so.getElementByClassName(name, element) - 查找指定class的节点。并提供一个查找的范围，因为采用从左往右的查找，所以该参数可以加快查找的速度
        ///     &#10;    1.3 - so.getElementByClassName(name, element, tag) - 查找指定class的节点，提供一个查找的范围，并提供一个查找的标签范围，可以加快查找速度
        /// </summary>
        /// <param name="name" type="String">
        ///     需要查找的class名，多class用空格分隔，在多class匹配下，包含其中某一class但不完全匹配指定的所有的class
        /// </param>
        /// <param name="element" type="StringOrElement">
        ///     提供该class的遍历范围的节点，为String类型的id或者DOM元素，因为采用从左往右的查找，所以可以加快查找速度
        /// </param>
        /// <param name="tag" type="String">
        ///     提供该class遍历的标签范围，指定某一标签，格式为该标签名（不含尖括号），例：p。将在该标签内进行查找，可以加快查找速度
        /// </param>
        /// <returns type="HTMLCollection" />
        if (!name || name.length < 1 || typeof (name) !== 'string') {
            //不合法
            return [document.body];
        }
        var elem = []; //结果集
        //element参数转换
        if (element) {
            element = typeof (element) === 'string' ? document.getElementById(element) : element;
        } else {
            element = document.body;
        }
        //tag参数转换
        tag = tag ? tag.toString() : "*";
        if (element.nodeType) {
            //匹配结果后的过滤集合和相关项
            var filters = element.getElementsByTagName(tag), i = 0, item;
            //在查找的class上建立正则表达式
            var reg = new RegExp(name.replace(/./g, '').replace(/\s/g, '|'), 'g');
            //遍历过滤集
            while ((item = filters[i++])) {
                if (!item.className || item.className.length < 1) {
                    continue;
                };
                //利用正则快速匹配，求出交集
                if (item.className.match(reg)) {
                    elem.push(item);
                }
            };
        }
        return elem;
    };
})(window);
//page
var livePage = {
    //{ key:直播ID ,lastTime : 最后一次请求时间, inetrval:全局读秒的函数 , state:直播是否已经开始 , scroll: 用户交互滚动条对象, userScroll: 在线用户列表滚动条对象, userId: 当前用户ID, userName: 当前用户名,isLogin: 是否已登录(0：是、1：否) }
    data: { key: undefined, lastTime: undefined, inetrval: undefined, state: false, scroll: undefined, userScroll: undefined, userId: undefined, userName: undefined, isLogin: undefined, usertype: undefined },
    init: function () {
        /// <summary>
        ///     1: 页面初始化函数
        ///     &#10;    1.1 - init() - 页面初始化函数，在页面中调用本函数初始化本类库
        /// </summary>
        /// <returns type="void" />
        livePage.StringBuffer.prototype.append = function (str) {
            this._strings.push(str);
        }
        livePage.StringBuffer.prototype.toString = function () {
            return this._strings.join('');
        }
        livePage.data.key = livePage.getUrlPara('key');
        var keyObj = $("#title_Data"); //该对象含后台很多数据
        var isError = parseInt(keyObj.attr('data'));
        livePage.data.state = (isError === 1 ? true : false);
        if (!livePage.data.state) {
            var errorTxt = undefined;
            switch (isError) {
                case 0:
                    errorTxt = lggaizhiboshangweikaishi;
                    break;
                case 2:
                    break;
                case 3:
                    errorTxt = lggaizhiboyaoqiudengluninshangweiden;
                    break;
                case 4:
                    errorTxt = lggaizhiboyunxuderenshu;
                    break;
                case 5:
                    errorTxt = lgnimeiquanxiancanyuzhe;
                    break;
                default:
                    errorTxt = lgyemianshujubuzheng;
                    break;
            }
            livePage.showWarning(errorTxt);
            return;
        }
        if (livePage.data.key.length < 1) {
            livePage.showWarning(lgyemianshujubuzheng);
            return;
        }
        //初始化数据获取时间
        livePage.data.lastTime = (new Date()).getTime();
        //输入框提示文字
        var promptTxt = lgqingshurufayandeneirongfayan;
        //获取用户信息
        livePage.data.userId = keyObj.attr('ui'); //用户ID
        livePage.data.userName = keyObj.attr('un'); //用户名
        livePage.data.isLogin = keyObj.attr('il'); //是否登录
        //如果当前正在直播状态
        if (livePage.data.state) {
            livePage.loadUserList();
            //3s读取交互信息
            livePage.data.inetrval = setInterval(function () {
                livePage.getList(livePage.data.lastTime);
                livePage.loadUserList();
            }, 6000);
            //            livePage.getList(livePage.data.lastTime);
        }
        //右侧发言区域的插件
        livePage.data.scroll = so.scroll(document.getElementById('dc_IfList'));
        so.scroll(document.getElementById('liveDis'));
        //右侧用户列表插件
        livePage.data.dc_UserList = so.scroll(document.getElementById('curUserList'));
        //绑定发言的相关事件
        $("#dc_submit").click(function () {
            var context = jQuery.trim($("#dc_txt").val());
            if (context.length < 1 || context == promptTxt) {
                $("#dc_txt").focus();
                return;
            }
            livePage.submit(context);
        });
        //文本框事件
        $("#dc_txt").blur(function () {
            var context = jQuery.trim($(this).val());
            if (context.length < 1) {
                $(this).val(promptTxt);
            }
        }).focus(function () {
            var context = jQuery.trim($("#dc_txt").val());
            if (context == promptTxt) {
                $(this).val('');
            }
        }).keydown(function (e) {
            var e = e || window.event;
            var key = e.keyCode || e.which || e.charCode;
            if (key == 13 && e.ctrlKey) {
                $("#dc_submit").click();
            }
        });
        //        //播放
        //        var flashvars = {
        //            f: rmtp + livePage.data.key,
        //            c: 0,
        //            b: 1,
        //            p:1
        //        };
        //        var params = { bgcolor: '#FFF', allowFullScreen: true, allowScriptAccess: 'always', wmode: 'opaque' };
        //        CKobject.embedSWF('/LiveTelecast/JavaScript/liveCkplayer/ckplayer.swf', 'altContent', 'ckplayer_a1', '480', '400', flashvars, params);
    },
    submit: function (context) {
        /// <summary>
        ///     1: 发表交互函数
        ///     &#10;    1.1 - submit(context) - 发表交互函数
        /// </summary>
        /// <param name="context" type="context">
        ///     交互内容
        /// </param>
        /// <returns type="void" />
        if (!livePage.data.state) {
            livePage.alertMsg(lggaizhiboshangweikaishi, 2);
            return;
        };
        livePage.ajaxLoad("/LiveTelecast/LiveInterflow.ashx", { key: livePage.data.key, context: context, ui: livePage.data.userId, un: livePage.data.userName, il: livePage.data.isLogin, action: 0 }, function (data) {
            if (data && data.code === 0) {//发言成功
                //                livePage.data.userId = data.id;
                //                livePage.data.userName = data.name;
                //                livePage.data.isLogin = data.isLogin;
                //                //写入到cookie？？？
                //                var html = new livePage.StringBuffer();
                //                html.append('<li class="di_admin"><div class="di_UserName">');
                //                html.append('[&nbsp;');
                //                html.append(livePage.data.userName);
                //                html.append('&nbsp;]');
                //                html.append('我(');
                //                html.append(livePage.dateFormat((new Date()).getTime()));
                //                html.append(')</div><div class="di_UserContext">');
                //                html.append(context);
                //                html.append('</div></li>');
                //                $("#dc_IfList").append(html.toString());
                livePage.alertMsg(lgfayanchengong, 1, 1000);
                //更新滚动条
                //                livePage.data.scroll.change();
                $("#dc_txt").val('');
                return;
            }
            switch (data.code) {
                case 1:
                    livePage.alertMsg(lgfayanshibaishujubuzhengque, 3);
                    break;
                case 3:
                    livePage.alertMsg(lgfayanshibaiqingshaohou, 3);
                    break;
                default:
                    break;
            }
        }, function () {
            livePage.alertMsg(lgtagyichang1, 3);
        });
    },
    getList: function (date) {
        /// <summary>
        ///     1: 获取指定的时间后交互信息函数
        ///     &#10;    1.1 - getList(date) - 获取指定的时间后交互信息函数
        /// </summary>
        /// <param name="date" type="TimeStamp">
        ///     要查询的[时间戳]（ms）
        /// </param>
        /// <returns type="void" />

        livePage.ajaxLoad('/LiveTelecast/LiveInterflow.ashx', { key: livePage.data.key, date: date }, function (data) {
            if (!data) {
                //                livePage.alertMsg('网络连接异常，请检查您的网络信息', 3);
                return;
            }
            switch (data.code) {
                case 0:
                    {
                        if (data.data) {//也许没有数据
                            livePage.data.lastTime = (new Date()).getTime(); //及时更新数据获取时间
                            var item;
                            var html = new livePage.StringBuffer();
                            //优化遍历速度
                            for (var i = 0; (item = data.data[i]); i++) {
                                if (item.LiveInteract_IsManager === 1) {
                                    html.append('<li class="interactAdmin">');
                                } else {
                                    html.append('<li>');
                                }
                                html.append('<div class="intUserName">');
                                html.append(livePage.htmlEncode(item.LiveInteract_UserName));
                                html.append("<span class='intDate'>");
                                html.append(livePage.dateFormat(item.LiveInteract_Date));
                                html.append("</span>");
                                html.append('</div><div class="di_UserContext">');
                                html.append(livePage.htmlEncode(item.LiveInteract_Context));
                                html.append('</div></li>');
                            }
                            $("#dc_IfList").append(html.toString());
                            //更新滚动条
                            //                            livePage.data.scroll.change();
                        }
                        break;
                    }
                case 1:
                    livePage.alertMsg(lgshujuyichangqingshuayemiancanshuyi, 3);
                    break;
                default:
                    livePage.alertMsg(lgfashengweizhiyichang, 3);
                    break;
            }
        });
    },
    loadUserList: function () {
        /// <summary>
        ///     1: 加载当前正在观看直播的用户列表
        ///     &#10;    1.1 - loadUserList() - 加载当前正在观看直播的用户列表
        /// </summary>
        /// <returns type="void" />
        livePage.ajaxLoad('/LiveTelecast/LiveTransferData.ashx', { key: livePage.data.key, id: livePage.data.userId, name: livePage.data.userName, login: livePage.data.isLogin === "1" ? 2 : 0 }, function (data) {
            if (data && data.code === 0) {
                var userCount = 0;
                if (data.list) {
                    var html = new livePage.StringBuffer(), i = 0, item;
                    var html2 = new livePage.StringBuffer(), i = 0, item;
                    while ((item = data.list[i++])) {
                        html.append('<li class="ouItem ');
                        switch (item.IsManager) {
                            case 1: //管理员
                                html.append('userItemAdmin"');
                                break;
                            case 2: //匿名
                                html.append('userItemAnony"');
                                break;
                            default: //用户
                                html.append('userItemUser"');
                                break;
                        }
                        html.append(' title="');
                        html.append(item.Name);
                        html.append('">');
                        html.append(item.Name);
                        html.append('</li>');
                    }
                    userCount = data.list.length;
                    $("#curUserList").html(html.toString());


                    //livePage.data.dc_UserList.change();
                }
                $('#ul_Count').text(userCount);
            }
        });
    },
    changeLive: function (state) {
        /// <summary>
        ///     1: 开启或关闭直播
        ///     &#10;    1.1 - changeLive(state) - 开启或关闭直播
        /// </summary>
        /// <param name="state" type="Int">
        ///     &#10;    0:关闭直播
        ///     &#10;    1:开启直播
        /// </param>
        /// <returns type="void" />
        if (state !== 1) {
            state = 0;
        }        
        livePage.ajaxLoad('/LiveTelecast/LiveInteractConfig1.ashx', { key: livePage.data.key, action: 2, data: state, userid: livePage.data.userId, usertype: livePage.data.usertype }, function (data) {
            if (data) {
                switch (data.code) {
                    case 0:
                        livePage.alertMsg(lgchenggong, 1, 1500);
                        //如果当前正在直播
                        if (!livePage.data.state) {
                            livePage.data.state = true; //开启直播状态
                            //开始干活...3s读取交互信息
                            livePage.data.inetrval = setInterval(function () {
                                livePage.getList((new Date()).getTime());
                                livePage.loadUserList();
                            }, 6000);
                        }
                        break;
                    case 1: //插入数据失败
                        livePage.alertMsg(lgcaozuoyichangqingshaohou, 3, 4000);
                        break;
                    case 2: //创建xml文件异常
                        livePage.alertMsg(lgcaozuoyichangchuangjianzhi, 3, 4000);
                        break;
                    case 3: //参数不正确
                        livePage.alertMsg(lgcaozuoyichangchongxincaoshi, 3, 4000);
                        break;
                    case 4: //session丢失
                        livePage.alertMsg(lgcaozuoyichangyonghuxinxin, 3, 4000);
                        break;
                    case 5: //关闭直播修改xml文件异常
                        livePage.alertMsg(lgcaozuoyichangguanbizhibo, 3, 4000);
                        break;
                    default: //未知
                        livePage.alertMsg(lgcaozuoyichangweizhiyichang, 3, 4000);
                        break;
                }
                if (state === 0) {
                    //关闭直播
                    livePage.showWarning();
                }
            }
        }, function () {
            livePage.alertMsg(lgwangluoyichang, 3, 3000);
        });
    },
    ajaxLoad: function (url, data, fn, error) {
        /// <summary>
        ///     1: ajax异步加载函数
        ///     &#10;    1.1 - ajaxLoad(url, data, fn, error) - ajax异步加载函数
        /// </summary>
        /// <param name="url" type="String">
        ///     url
        /// </param>
        /// <param name="data" type="Json">
        ///     ajax参数
        /// </param>
        /// <param name="fn" type="Function">
        ///     成功后执行的函数
        /// </param>
        /// <param name="error" type="Function">
        ///     [可选]发生异常后执行的函数
        /// </param>
        /// <returns type="void" />
        $.ajax({
            url: url,
            type: "post",
            contentType: 'application/x-www-form-urlencoded',
            //  contentType: 'application/json',
            //  ajax ContentType请求为application/json，有时候一般处理程序并不能解析到参数，在监控了jQuery.post()方法后将请求头修改的和post一样，测试通过，可以接收到参数，目前原因未知。
            data: data,
            dataType: "json",
            success: function (data) {
                fn(data);
            },
            error: function () {
                //异常操作
                if (error)
                    error();
            }
        });
    },
    alertMsg: function (msg, type, time) {
        /// <summary>
        ///     1: 显示错误信息方法
        ///     &#10;    1.1 - alertMsg(content,type) - 显示错误信息方法
        /// </summary>
        /// <param name="msg" type="String">
        ///     要显示的html字符串
        /// </param>
        /// <param name="type" type="String">
        ///     [可选]要显示的类型，包含以下类型：
        ///     &#10; 1:正确
        ///     &#10; 2:警告
        ///     &#10; 3:错误
        /// </param>
        /// <param name="time" type="Int">
        ///     [可选]要显示的消息的时间，默认如下
        ///     &#10; 1:正确 - 显示1500ms
        ///     &#10; 2:警告 - 显示2000ms
        ///     &#10; 3:错误 - 显示4000ms
        /// </param>
        /// <returns type="void" />
        if (!type) {
            type = 3;
        }
        var defaultTime = 1500;
        switch (type) {
            case 1:
                type = 4;
                defaultTime = 1500;
                break;
            case 3:
                type = 5;
                defaultTime = 4000;
                break;
            case 2:
                type = 3;
                defaultTime = 2000;
            default:
                break;
        }
        if (time) {
            defaultTime = time;
        }
        ZENG.msgbox.show(msg, type, defaultTime);
    },
    showWarning: function (text) {
        /// <summary>
        ///     1: 页面呈现指定的警告内容【注：此页面数据将被移除，不可再用】
        ///     &#10;    1.1 - showWarning() - 在页面中呈现默认的警告内容，同时将该页面数据清空，注：所有被清空的内容不再恢复，之后页面将无法进行任何操作
        ///     &#10;    1.2 - showWarning(text) - 在页面中呈现指定的警告内容，同时将该页面数据清空，注：所有被清空的内容不再恢复，之后页面将无法进行任何操作
        /// </summary>
        /// <param name="text" type="String">
        ///     要显示的警告内容
        /// </param>
        /// <returns type="String" />
        var obj = document.getElementById('page');
        if (obj) {
            obj.parentNode.removeChild(obj);
        }
        document.getElementById('warningText').innerHTML = text ? text : lgbencizhibojieshu;
        document.getElementById('closeWarning').style.display = 'block';
    },
    getUrlPara: function (fieldName) {
        /// <summary>
        ///     1: 获取地址栏参数方法
        ///     &#10;    1.1 - getUrlParameter(fieldName) - 在当前Url中查询指定的参数，返回查询得到的值
        /// </summary>
        /// <param name="fieldName" type="String">
        ///     要查询的字符串
        /// </param>
        /// <returns type="String" />
        var urlString = document.location.search;
        if (urlString != null) {
            var typeQu = fieldName + "=";
            var urlEnd = urlString.indexOf(typeQu);
            if (urlEnd != -1) {
                var paramsUrl = urlString.substring(urlEnd + typeQu.length);
                var isEnd = paramsUrl.indexOf('&');
                if (isEnd != -1) {
                    return paramsUrl.substring(0, isEnd);
                }
                else {
                    return paramsUrl;
                }
            }
            else {
                return "";
            }
        }
        else {
            return "";
        }
    },
    StringBuffer: function (initStr) {
        /// <summary>
        ///     1: StringBuffer对象，需要在page.initial()方法中初始化本对象数据
        ///     &#10;    1.1 - StringBuffer() - 初始化字符串拼接对象
        ///     &#10;    1.2 - StringBuffer(initStr) - 根据指定的字符串初始化字符串拼接对象
        /// </summary>
        /// <param name="initStr" type="String">
        ///     初始化字符串
        /// </param>
        /// <returns type="void" />
        this._strings = new Array();
        if (initStr) {
            this._strings[0] = initStr;
        }
        return this._strings.join('');
    },
    htmlEncode: function (html, templent) {
        /// <summary>
        ///     1: 将传入的html字符串中出现的尖括号（&lt;&gt;）替换成web符
        ///     &#10;    1.1 - htmlEncode(html) - 将html中的&gt;号替换为&amp;gt;，&lt;号替换为&amp;lt;
        ///     &#10;    1.2 - htmlEncode(initStr,templent) - 将html中的尖括号替换成指定的字符，当html为空的时候返回指定的字符（templent）
        /// </summary>
        /// <param name="html" type="String">
        ///     初始化字符串
        /// </param>
        /// <param name="templent" type="String">
        ///     初始化字符串
        /// </param>
        /// <returns type="String" />
        if (jQuery.trim(html).length < 1 && arguments.length == 2) {
            return templent;
        } else if (jQuery.trim(html).length < 1) {
            return '';
        } else {
            return html.replace(/</g, '&lt').replace(/>/g, '&gt');
        }
    },
    dateFormat: function (timestamp) {
        /// <summary>
        ///     1: 将json格式的时间戳转换为(格式为：/Date(xxxxxxxxxxx)/)标准时间
        ///     &#10;    1.1 - dateFormat(timestamp) - 将json格式的时间戳转换为(格式为：/Date(xxxxxxxxxxx)/)标准时间
        /// </summary>
        /// <param name="timestamp" type="String">
        ///     Json时间戳
        /// </param>
        /// <returns type="String" />
        if (timestamp) {
            var date;
            if (typeof timestamp === 'string') {
                date = new Date(parseInt(timestamp.replace("/Date(", "").replace(")/", ""), 10));
            } else if (typeof timestamp === 'number') {
                date = new Date(parseInt(timestamp, 10));
            }
            //            var month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
            //            var currentDate = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
            var hours = date.getHours() < 10 ? "0" + date.getHours() : date.getHours();
            var minutes = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes();
            var seconds = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();
            //            return date.getFullYear() + "-" + month + "-" + currentDate + " " + hours + ":" + minutes + ":" + seconds;
            return hours + ":" + minutes + ":" + seconds;
        }
        return lgweizhiyichang;
    }
}
var selectState = {
    _selectElement: undefined,
    _valueElement: undefined,
    selectValue: 1,
    init: function (fn) {
        /// <summary>
        ///     1: selectState对象初始化函数
        ///     &#10;    1.1 - selectState.init(fn) - 在selectState对象工作之前请先调用本函数初始化
        /// </summary>
        /// <param name="fn" type="Function">
        ///     fn(value) - 在每一次选择项改变的时候触发的函数，但不会在重复选择选项的时候触发，该函数this指向selectState对象,参数value表示当前值
        /// </param>
        /// <returns type="void" />
        this._selectElement = this._selectElement || document.getElementById('liveSelect');
        this._valueElement = this._valueElement || document.getElementById('ls_Value');
        this.addEvent(document.getElementById('live_StateLink'), 'click', function () {
            selectState._selectElement.style.display = 'block';
        });
        var lists = so.getElementByClassName('vss_Link', this._selectElement, 'a'), item, i = 0;
        while (item = lists[i++]) {
            this.addEvent(item, 'click', function () {
                selectState._valueElement.innerHTML = this.textContent || this.innerText || '';
                selectState._selectElement.style.display = 'none';
                var selValue = this.getAttribute('value');
                if (selValue != selectState.selectValue) {
                    selectState._valueElement.setAttribute('value', (selectState.selectValue = selValue ? selValue : ''));
                    fn.call(selectState, selectState.selectValue);
                }
            });
        }
    },
    val: function (value, fn) {
        /// <summary>
        ///     1: 获取或设置下拉框的值
        ///     &#10;    1.1 - selectState.val() - 获取【直播状态】下拉框的值
        ///     &#10;    1.2 - selectState.val(value) - 设置【直播状态】下拉框的值
        ///     &#10;    1.2 - selectState.val(value,fn) - 设置【直播状态】下拉框的值，并触发事件
        /// </summary>
        /// <param name="value" type="String">
        ///     要设置的值，值必须对应存在于直播可选项的列表中。允许用索引项(Int>0)进行设置，但如果刻意避免使用索引项的话，请将需要设置的值设为String类型
        /// </param>
        /// <param name="fn" type="Function">
        ///     fn(value) - 在成功修改值的情况下，同步触发的函数。该函数this指向selectState对象,参数value表示当前值
        /// </param>
        /// <returns type="String" />
        //没有参数，取值
        if (!value) {
            return this.selectValue;
        }
        //赋值
        var lists = so.getElementByClassName('vss_Link', this._selectElement, 'a'), item, i = 0;
        //索引
        if (typeof (value) === 'number' && value > 0) {
            if (item = lists[i]) {
                //注意可能两项都为空
                this._valueElement.innerHTML = item.textContent || item.innerText || '';
                var selValue = item.getAttribute('value');
                this._valueElement.setAttribute('value', (this.selectValue = selValue ? selValue : ''));
                if (fn) {
                    fn.call(this, this.selectValue);
                }
                return this;
            }
        } else {//默认为字符串
            //修正为字符串
            value = value.toString();
            //加快遍历速度
            while ((item = lists[i++])) {
                //w3c:textContent , ie:innerText or OutText
                if (item.getAttribute('id') === value || item.textContent === value || item.innerText === value) {
                    this._valueElement.innerHTML = item.textContent || item.innerText || '';
                    var selValue = item.getAttribute('value');
                    this._valueElement.setAttribute('value', (this.selectValue = selValue ? selValue : ''));
                    if (fn) {
                        fn.call(this, this.selectValue);
                    }
                    return this;
                }
            }
            return null;
        }
    },
    addEvent: function (element, type, fn) {
        /// <summary>
        ///     1: 为元素追加事件
        ///     &#10;    1.1 - css(element, type, fn) - 为元素追加事件，函数中this指向事件源
        /// </summary>
        /// <param name="element" type="ElementOrString">
        ///     节点对象
        /// </param>
        /// <param name="type" type="String">
        ///     追加的事件名，不含字符on
        /// </param>
        /// <param name="fn" type="Function">
        ///     事件对象
        /// </param>
        /// <returns type="void" />
        if (element.attachEvent) {
            element['e' + type + fn] = fn;
            element[type + fn] = function () { element['e' + type + fn](window.event); }
            element.attachEvent('on' + type, element[type + fn]);
        } else if (element.addEventListener) {
            element.addEventListener(type, fn, false);
        } else {
            return false;
        }
    }
};


