﻿/*
* Live_TelecastList.aspx页面js
*
* Comment version: 1.0.0
* Author：linkFly
* Email:linkFly6@live.com
* date：2014-01-17 18:31:26
* @copyright:newstart新启科技
*
*/
var page = {
    //页面数据对象：{ currPage: 当前页码, sumPage: 总页码, isload: 当前是否正在加载数据, pageState: 查询的状态(0：全部直播，1：正在直播, 2 :未开始的直播 ), type: 分类, date:时间 ,keywords:关键字,canPush：是否可以push地址栏,$loadNextData:下一页按钮,$loadError:加载异常按钮,$notMore:没有更多项按钮,$loadingData:正在加载DOM }
    pageData: { currPage: 1, sumPage: 1, isload: false, pageState: '', type: '', date: '', keywords: '', canPush: false, $loadNextData: $("#loadNextData"), $loadError: $("#loadError"), $notMore: $("#footerTxt"), $loadingData: $("#loadingData") },
    init: function () {
        /// <summary>
        ///     1: init() - 页面初始化方法，请在调用提供的一系列接口之前初始化调用本对象
        ///     &#10;  本对象进行了如下操作
        /// </summary>
        /// <returns type="void" />
        //初始化StringBuffer对象需要使用的方法（对原型链进行扩展）
        page.StringBuffer.prototype.append = function (str) {
            this._strings.push(str);
        }
        page.StringBuffer.prototype.toString = function () {
            return this._strings.join('');
        }
        //获取popState（获取ajax历史会话）
        page.pageData.currPage = 1;
        page.getState();
        //初始化全局变量
        page.pageData.$loadError = $("#loadError");
        page.pageData.$loadNextData = $("#loadNextData");
        page.pageData.$notMore = $("#footerTxt");
        page.pageData.$loadingData = $("#loadingData");
        //绑定下一页事件
        page.pageData.$loadNextData.click(function () {
            page.loadNextData();
        });
        //加载异常，重新加载点击事件
        page.pageData.$loadError.click(function () {
            page.ajaxLoad();
        });
        //类别选择事件
        $('.typeItem').click(function () {
            $('.typeActive').removeClass('typeActive');
            page.pageData.type = $(this).addClass('typeActive').attr('data');
            if (page.pageData.type === '0') {
                page.pageData.type = '';
            }
            page.typeChange();
        });
        //状态选择事件
        $('.stateItem').click(function () {
            $('.stateActive').removeClass('stateActive');
            page.pageData.pageState = $(this).addClass('stateActive').attr('data');
            if (!page.pageData.pageState) {
                page.pageData.pageState = '';
            }
            page.typeChange();
            return false;
        });
        //日期选择事件
        $('.dateItem').click(function () {
            $('.dateActive').removeClass('dateActive');
            page.pageData.date = $(this).addClass('dateActive').attr('data');
            page.typeChange();
            return false;
        });
        page.pageData.date = $('.dateActive').attr('data');
        //回到顶部
        $("#backTop").click(function () {
            $('html,body').animate({ scrollTop: 0 }, 120);
            return false;
        });
        $(document).bind("scroll", function () {
            var top = $(document).scrollTop();
            (top > 600) ? $("#backTop").css('display', 'block') : $("#backTop").css('display', 'none');
        });
        //页面初始化加载数据
        page.ajaxLoad();

        //以下为时间栏操作、效果
        //时间栏悬浮效果
        $('.dateItem').hover(function () {
            $(this).addClass('datehover');
        }, function () {
            $(this).removeClass('datehover');
        });
        //页面时间列表偏移位置的计算，每个时间导航的宽度是180，同时因为display:inline-block的偏移和边框等偏移，追加15px
        var menuWidth = $('.dateItem ').length * 180 + 15;
        //获取当前激活日期的距离父容器的偏移量
        var posLeft = $('.dateActive').position().left;
        //设置父容器宽度，因为时间可能不满15个
        $('#dateCon').width(menuWidth);
        //如果宽度到达父容器的极限，则偏移到最后一个元素中
        if (posLeft + 570 >= menuWidth) {
            $('#dateCon').animate({ left: $('.dateItem').last().position().left * -1 + 720 }, 600);
        } else {
            //否则偏移到激活的位置
            $('#dateCon').animate({ left: posLeft * -1 + 360 }, 600);
        }
        var dataConObj = $('#dateCon');
        //向右偏移操作
        $('#dateArrLeft').click(function () {
            var left = parseInt(dataConObj.css('left'));
            if (left >= 0) {
                return false;
            }
            if (left > -542) {
                $('#dateCon').animate({ left: 0 }, 450);
                return;
            }
            $('#dateCon').animate({ left: '+=542' }, 450);
            return false;
        });
        //将父容器宽度的变量再次使用，作为时间菜单向左偏移的极限偏移量，906是时间栏的容器最大宽度，最大宽度-(最后一栏)容器宽度=极限偏移量
        menuWidth = (menuWidth - 906) * -1;
        //向左偏移操作
        $('#dateArrRight').click(function () {
            var left = parseInt(dataConObj.css('left'));
            //                alert('left:' + left + '，宽度:' + menuWidth);
            if (left <= menuWidth) {
                return false;
            }
            if (menuWidth - left > -542) {//到达极限偏移
                $('#dateCon').animate({ left: '+=' + (menuWidth - left) }, 450);
                return false;
            }
            $('#dateCon').animate({ left: '-=542' }, 450);
            return false;
        });
    },
    ajaxLoad: function (type) {
        /// <summary>
        ///     Ajax加载数据方法
        ///     &#10;  1.1 - ajaxLoad() - ajax加载数据
        ///     &#10;  1.2 - ajaxLoad(type) - ajax加载数据，并非在现有的基础上追加数据，而是重置整个页面的数据项
        /// </summary>
        /// <param name="type" type="Boolean">
        ///     为true表示清空页面再追加
        /// </param>
        /// <returns type="void" />
        if (page.pageData.isload) return;
        if (type) {
            //清空html数据
            $("#live_ListContainer").html('');
        }

        //初始化ajax参数
        var ajaxData = {};
        if (page.pageData.keywords.length > 0)
            ajaxData.keywords = jQuery.trim(page.pageData.keywords);
        if (page.pageData.type.length > 0)
            ajaxData.lt = jQuery.trim(page.pageData.type);
        ajaxData.state = page.pageData.pageState;
        ajaxData.curIndex = page.pageData.currPage;
        ajaxData.ld = page.pageData.date;
        page.pageData.$notMore.css('display', 'none').text(lgyijingmeiyougengduo);
        page.pageData.$loadError.css('display', 'none');
        page.pageData.$loadNextData.css('display', 'none');
        page.pageData.$loadingData.css('display', 'block');
        $.ajax({
            url: "/LiveTelecast/LoadTelecastData.ashx",
            type: "post",
            contentType: 'application/x-www-form-urlencoded',
            //  contentType: 'application/json',
            //  ajax ContentType请求为application/json，有时候一般处理程序并不能解析到参数，在监控了jQuery.post()方法后将请求头修改的和post一样，测试通过，可以接收到参数，目前原因未知。
            data: ajaxData,
            dataType: "json",
            success: function (data) {
                page.pageData.$loadingData.css('display', 'none');
                page.showData(data);
            },
            error: function () {
                page.pageData.$loadingData.css('display', 'none');
                page.showError();
            }
        });
    },
    correctData: function (currPage) {
        /// <summary>
        ///     1: correctData(currPage) - 检测页面页码数据方法
        ///     &#10;  其存在如下返回值：
        ///     &#10;  0：没有异常
        ///     &#10;  1：非严重级异常，表示页码小于0，会自动修正
        ///     &#10;  2：非严重级异常，表示总页码为负数，会自动修正
        ///     &#10;  3：重要异常，表示当前页码已经超过了总页码的有效范围，不自动修正
        /// </summary>
        /// <param name="currPage" type="int">
        ///     当前页码
        /// </param>
        /// <returns type="boolean" />
        if (currPage < 1) {
            page.pageData.currPage = 1;
            return 1;
        }
        if (page.pageData.sumPage < 1) {
            page.pageData.sumPage = 1;
            return 2;
        }
        if (currPage > page.pageData.sumPage) {
            return 3;
        }
        return 0;
    },
    showData: function (data) {
        /// <summary>
        ///     当异步加载完毕之后本方法提供解析异步后的数据并呈现在页面上
        ///     &#10;  1.1 - showData(data) - 呈现数据方法
        /// </summary>
        /// <param name="data" type="Json">
        ///     Ajax返回的对象，该对象应当包含以下属性，该对象为空时显示默认的异常信息：
        ///     &#10;  errorCode：错误信息，0表示正确
        ///     &#10;  currPage：经过服务器验证后的当前页码
        ///     &#10;  sumPage：经过服务器验证后的总页码
        ///     &#10;  dataList（允许为空）：数据对象
        /// </param>
        /// <returns type="void" />
        if (!data) {
            alert(data);
            page.showError('<div>' + lgjiazaishujuyichang + '<span class="reloadData">' + lgaddchongxinjiazai + '</span><div>');
            return;
        }
        if (data.errorCode == 0) {//数据加载正确
            //设置最新数据
            page.pageData.currPage = data.currPage;
            page.pageData.sumPage = data.sumPage;
            //push浏览器会话，代码块放在这里表示只有在查询成功的情况下才会push，任何有异常的结果都不会
            page.pushState();
            if (data.dataList) {
                //输出结果到页面
                var html = new page.StringBuffer();
                for (var i = 0; i < data.dataList.length; i++) {
                    html.append('<li class="live_Item">');
                    html.append('<div class="li_dataImg"><div class="li_ImgContainer">');
                    //根据当前直播的状态显示不同的样式（直播状态、直播标题）
                    switch (data.dataList[i].LiveTelecast_State) {
                        case 0:
                            html.append('<img alt="" height="170px" width="240px" onerror="" src="/LiveTelecast/UserImg/');
                            html.append(data.dataList[i].LiveTelecast_CoverName); //图片
                            html.append('" class="li_Img" /></div>');
                            html.append('<p class="li_State li_End">' + lggaizhiboshangweikaishi + '</p></div><div class="li_Data"><h2 class="li_Title">');
                            html.append(page.htmlEncode(data.dataList[i].LiveTelecast_Name)); //将<和>剔除
                            html.append('</h2><div class="li_Date"><span class="annotate">' + lgdatetime + '：</span><span class="li_TelDate">');
                            html.append(page.dateFormat(data.dataList[i].LiveTelecast_StartDate)); //直播开始时间
                            html.append('</span></div>');
                            break;
                        case 2:
                            html.append('<a onclick=" IsLogin(this);return false;" href="/Live/LiveVideoPlay.aspx?key=');
                            html.append(data.dataList[i].LiveTelecast_Id);
                            html.append('" target="_blank" class="li_TitleLink">');
                            html.append('<img alt="" height="170px" width="240px" onerror="" src="/LiveTelecast/UserImg/');
                            html.append(data.dataList[i].LiveTelecast_CoverName); //图片
                            html.append('" class="li_Img" /></a></div>');
                            html.append('<p class="li_State li_End">' + lgbencizhibojieshu + '</p></div><div class="li_Data"><h2 class="li_Title">');
                            html.append(page.htmlEncode(data.dataList[i].LiveTelecast_Name));
                            html.append('</h2><div class="li_Date"><span class="annotate">' + lgdatetime + '：</span><span class="li_TelDate">');
                            html.append(page.dateFormat(data.dataList[i].LiveTelecast_StartDate));
                            html.append('</span></div>');
                            break;
                        case 1:
                            if (data.dataList[i].LiveTelecast_Modle == null || data.dataList[i].LiveTelecast_Modle == "" || data.dataList[i].LiveTelecast_Modle == lgshipinzhibo) {
                                html.append('<a onclick=" IsLogin(this);return false;" href="/LiveTelecast/Live.aspx?key=');
                            } else if (data.dataList[i].LiveTelecast_Modle = lgfuhezhibo) {
                                html.append('<a onclick=" IsLogin(this);return false;" href="/Live/H5Room.aspx?key=');
                            }
                            html.append(data.dataList[i].LiveTelecast_Id);
                            html.append('" target="_blank" class="li_TitleLink">');
                            html.append('<img alt=""" title="' + lgdianjijinruzhibo + '" height="170px" width="240px" onerror="" src="/LiveTelecast/UserImg/');
                            html.append(data.dataList[i].LiveTelecast_CoverName); //图片
                            html.append('" class="li_Img" /></a></div>');
                            html.append('<p class="li_State li_Now">' + lgzhengzaizhibo + '</p></div><div class="li_Data"><h2 class="li_Title">');
                            if (data.dataList[i].LiveTelecast_Modle == null || data.dataList[i].LiveTelecast_Modle == "" || data.dataList[i].LiveTelecast_Modle == lgshipinzhibo) {
                                html.append('<a onclick=" IsLogin(this);return false;" href="/LiveTelecast/Live.aspx?key=');
                            } else if (data.dataList[i].LiveTelecast_Modle = lgfuhezhibo) {
                                html.append('<a onclick=" IsLogin(this);return false;" href="/Live/H5Room.aspx?key=');
                            }
                            html.append(data.dataList[i].LiveTelecast_Id);
                            html.append('" target="_blank" class="li_TitleLink">');
                            html.append(page.htmlEncode(data.dataList[i].LiveTelecast_Name));
                            html.append('</a></h2><div class="li_Date"><span class="annotate">' + lgdatetime + '：</span><span class="li_TelDate li_TelDateActive">');
                            html.append(page.dateFormat(data.dataList[i].LiveTelecast_StartDate));
                            html.append('</span></div>');
                            break;
                    }

                    html.append('<div class="li_Teacher"><span class="annotate">' + lgzhujiang + '：</span>');
                    html.append(data.dataList[i].LiveTelecast_Teacher); //主讲
                    html.append('</div><div class="li_Users"><span class="annotate">' + lgcanyu + '：</span>');
                    html.append(data.dataList[i].LiveTelecast_UserGroupName); //【参与人：数据库暂时没有本字段】
                    html.append('</div><div class="li_Dis"><span class="annotate">' + lgmiaosu + '：</span><div class="li_Discription">');
                    html.append(page.htmlEncode(data.dataList[i].LiveTelecast_Discription, lgmeiyouxiangguandexinx)); //描述，没有针对<和>进行剔除
                    html.append('</div></div></div></li>');
                }
                //追加显示到页面
                $("#live_ListContainer").append(html.toString());
            }
            if (data.currPage >= data.sumPage) {//没有数据可以加载
                page.pageData.isload = true; //不再加载
                page.pageData.$loadError.css('display', 'none'); //隐藏页面相关可操作的按钮
                page.pageData.$loadNextData.css('display', 'none');
                page.pageData.$notMore.css('display', 'block');

            } else {
                page.pageData.isload = false;
                page.pageData.$notMore.css('display', 'none');
                page.pageData.$loadNextData.css('display', 'block');
            }

        } else//数据加载异常
            page.showError(data.errorCode);
    },
    showError: function (errorInfo) {
        /// <summary>
        ///     显示错误方法
        ///     &#10;    1.1 - errorInfo() - 显示默认的异常信息
        ///     &#10;    1.2 - errorInfo(errorInfo) - int类型：根据指定的错误码显示异常信息 String：显示传入的字符串
        /// </summary>
        /// <param name="errorInfo" type="Int or String">
        ///     &#10;   int：根据指定的错误码显示系统设定的异常信息
        ///     &#10;   String：显示传入的字符串
        /// </param>
        /// <returns type="void" />
        if (!errorInfo) errorInfo = 1;
        if (typeof (errorInfo) === 'number') {
            switch (errorInfo) {
                case 1: //查询数据异常
                    page.pageData.$loadError.text(lgjiazaishujuyichang).css('display', 'block');
                    break;
                case 2: //没有查询到数据
                    page.pageData.$notMore.text(lgmeiyouchaxundaoxiangguan).css('display', 'block');
                    break;
                default:
                    page.pageData.$loadError.text(lgfashengyichangcuowubianma + '：' + errorInfo).css('display', 'block');
                    break;
            }
        } else {
            page.pageData.$loadError.text(errorInfo).css('display', 'block');
        }
    },
    typeChange: function (keywords, currType, currState) {
        /// <summary>
        ///     - 页面状态改变方法，当页面的一些查询状态改变可以调用本方法进行数据更新操作。（本函数也可以用于重置页面对象信息）
        ///     &#10;  1.1 - typeChange() - 根据当前既定的状态进行数据查询，同时完成更新到页面的一系列操作，当页面任何需要重载数据的时候都可以通过调用本函数实现数据更新
        ///     &#10;  1.2 - typeChange(keywords) - 根据指定的关键字查询
        ///     &#10;  1.3 - typeChange(keywords,currType) - 根据指定的关键字和指定的页面类型查询
        ///     &#10;  1.4 - typeChange(keywords, currType, currState) - 页面状态改变方法，本函数主要用于重置页面对象信息
        /// </summary>
        /// <param name="keywords" type="String">
        ///     搜索关键字
        /// </param>
        /// <param name="currType" type="Int">
        ///     当前选择的直播类型
        /// </param>
        /// <param name="currState" type="Int">
        ///     当前选择的直播状态（正在直播 or 全部直播）
        /// </param>
        /// <returns type="void" />
        if (keywords) {
            page.pageData.keywords = jQuery.trim(keywords);
            if (currType) {
                page.pageData.type = currType;
                if (currState)
                    page.pageData.pageState = currState;
            }
        }
        page.pageData.currPage = 1;
        page.pageData.sumPage = 1;
        page.pageData.isload = false;
        page.ajaxLoad(true);
    },
    loadNextData: function (currPage) {
        /// <summary>
        ///     1: 加载下一页或指定页信息
        ///     &#10;  1.1 - loadNextData() - 加载下一页数据
        ///     &#10;  1.2 - loadNextData(currPage) - 本方法只是为了保证在特殊情况下的使用，为了保证页面数据的连贯性，请尽可能避免使用本方法
        /// </summary>
        /// <param name="currPage" type="int">
        ///     加载指定页的数据，尽可能避免使用本参数，[注：即使使用本参数也不会重置总页码信息！]
        /// </param>
        /// <returns type="void" />
        if (currPage) {
            page.pageData.currPage = currPage < 1 ? 1 : currPage;
        } else {
            switch (page.correctData(page.pageData.currPage + 1)) {
                case 0: //验证通过，加载数据
                    page.pageData.currPage++;
                    page.ajaxLoad();
                    break;
                case 1: //非严重级异常，已修正
                case 2:
                    break;
                case 3: //页码超过有效范围
                    $("#footerTxt").css('display', 'block');
                    //                    page.pageData.$loadNextData.remove();
                    page.pageData.$loadNextData.css('display', 'none');
                    return;

            }
        }

    },
    showAlert: function (data, time, type) {
        /// <summary>
        ///     1: showAlert(data) - 弹窗方法
        /// </summary>
        /// </param>
        /// <returns type="void" />


    },

    pushState: function (url) {
        /// <summary>
        ///     状态保持方法（需要高版本浏览器支持），当canPush为true的时候表示浏览器可以进行push状态，则进行状态push并返回是否成功
        ///     &#10;   1.1 - pushState() 通过push浏览器会话历史进行状态保持，将当前pageData保存如会话历史中，自动根据当前业务生成需要push的url
        ///     &#10;   1.1 - pushState(url) 将指定的url push到浏览器会话历史进行状态保持，将当前pageData保存如会话历史中【注意不允许跨域】
        /// </summary>
        /// <param name="url" type="String">
        ///     需要写入浏览器会话历史的url
        /// </param>
        /// <returns type="Boolean" />
        if (page.pageData.canPush) {
            if (typeof (url) == 'undefined') {
                url = window.location.pathname + "?lt=" + page.pageData.type + "&state=" + page.pageData.pageState + "&curIndex=" + page.pageData.currPage + "&keywords=" + (page.pageData.keywords ? encodeURIComponent(page.pageData.keywords) : '' + '&ld=' + (page.pageData.date ? encodeURIComponent(page.pageData.date) : ''));
            }
            //注意state虽然可以保存数据，但是不能保存DOM或仍然引用着当前页面元素的对象，例如$("DOM")这样一个对象，就会出现ObjectCloneError
            var state = { currPage: page.pageData.currPage, sumPage: page.pageData.currPage, pageState: page.pageData.pageState, type: page.pageData.type, keywords: page.pageData.keywords };
            //push两次
            window.history.pushState(state, document.title, url);
            return true;
        }
        return false;
    },
    getState: function () {
        /// <summary>
        ///     1: getState() - 获取状态方法（需要高版本浏览器支持），返回ture表示获取成功，false表示获取失败
        ///     &#10; - 通过push浏览器会话历史进行状态保持，将当前pageData保存如会话历史中
        /// </summary>
        /// <param name="hisctoryState" type="String">
        ///     需要写入浏览器会话历史的url
        /// </param>
        /// <returns type="Boolean" />

        //检测浏览器是否支持保存状态
        //关于浏览器状态保持：请参阅：http://yansong.me/2013/01/11/learning-history.pushState-and-history.replaceState.html
        //关于效果的描述：http://bbs.csdn.net/topics/390169689
        if (window.history.pushState) {
            page.pageData.canPush = true;
            //无法通过onpopstate事件来截取到历史信息，因为Firefox不会在onload中执行onpopstate事件，所以只能通过解析url参数来获取历史信息
            if (page.getUrlParameter('lt').length > 0) {//获取类型
                page.pageData.type = page.getUrlParameter('lt');
                //还原类型的页面表现
                $('.typeActive').removeClass('typeActive');
                $('.typeItem[data=' + page.pageData.type + ']').addClass('typeActive');
            }
            if (page.getUrlParameter('state').length > 0) {//获取状态
                page.pageData.pageState = parseInt(page.getUrlParameter('state'));
                //还原直播状态的页面表现
                $('.stateActive').removeClass('stateActive');
                $('.stateItem[data=' + page.pageData.pageState + ']').addClass('stateActive');
            }
            //            if (page.getUrlParameter('curIndex').length > 0) {//获取当前页码
            //                page.pageData.currPage = page.getUrlParameter('curIndex');
            //                //页码是否需要还原？还原之后会出现页码断码的表现
            //            }
            //            if (page.getUrlParameter('ld').length > 0) {//获取时间
            //                page.pageData.date = decodeURIComponent(page.getUrlParameter('ld'));
            //                //还原时间
            //                $('.dateActive').removeClass('dateActive');
            //                $('.dateItem[data=' + page.pageData.date + ']').addClass('dateActive');
            //            }
            if (page.getUrlParameter('keywords').length > 0) {//获取关键字
                //注意中文编码
                page.pageData.keywords = decodeURIComponent(page.getUrlParameter('keywords'));
            }
        }
    },
    StringBuffer: function (initStr) {
        /// <summary>
        ///     1: StringBuffer对象，需要在page.initial()方法中初始化本对象数据
        ///     &#10;    1.1 - StringBuffer() - 初始化字符串拼接对象
        ///     &#10;    1.2 - StringBuffer(initStr) - 根据指定的字符串初始化字符串拼接对象
        /// </summary>
        /// <param name="initStr" type="String">
        ///     初始化字符串
        /// </param>
        /// <returns type="void" />
        this._strings = new Array();
        if (initStr) {
            this._strings[0] = initStr;
        }
        return this._strings.join('');
    },
    htmlEncode: function (html, templent) {
        /// <summary>
        ///     1: 将传入的html字符串中出现的尖括号（&lt;&gt;）替换成web符
        ///     &#10;    1.1 - htmlEncode(html) - 将html中的&gt;号替换为&amp;gt;，&lt;号替换为&amp;lt;
        ///     &#10;    1.2 - htmlEncode(initStr,templent) - 将html中的尖括号替换成指定的字符，当html为空的时候返回指定的字符（templent）
        /// </summary>
        /// <param name="html" type="String">
        ///     初始化字符串
        /// </param>
        /// <param name="templent" type="String">
        ///     初始化字符串
        /// </param>
        /// <returns type="String" />
        if (jQuery.trim(html).length < 1 && arguments.length == 2) {
            return templent;
        } else if (jQuery.trim(html).length < 1) {
            return '';
        } else {
            return html.replace(/</g, '&lt').replace(/>/g, '&gt');
        }
    },
    dateFormat: function (timestamp) {
        /// <summary>
        ///     1: 将json格式的时间戳转换为(格式为：/Date(xxxxxxxxxxx)/)标准时间
        ///     &#10;    1.1 - dateFormat(timestamp) - 将json格式的时间戳转换为(格式为：/Date(xxxxxxxxxxx)/)标准时间
        /// </summary>
        /// <param name="timestamp" type="String">
        ///     Json时间戳
        /// </param>
        /// <returns type="String" />
        if (timestamp) {
            var date = new Date(parseInt(timestamp.replace("/Date(", "").replace(")/", ""), 10));
            var month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
            var currentDate = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
            var hours = date.getHours() < 10 ? "0" + date.getHours() : date.getHours();
            var minutes = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes();
            var seconds = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();
            return date.getFullYear() + "-" + month + "-" + currentDate + " " + hours + ":" + minutes + ":" + seconds;
        }
        return "未知";
    },
    getUrlParameter: function (fieldName) {
        /// <summary>
        ///     1: 获取地址栏参数方法
        ///     &#10;    1.1 - getUrlParameter(fieldName) - 在当前Url中查询指定的参数，返回查询得到的值
        /// </summary>
        /// <param name="fieldName" type="String">
        ///     要查询的字符串
        /// </param>
        /// <returns type="String" />
        var urlString = document.location.search;
        if (urlString != null) {
            var typeQu = fieldName + "=";
            var urlEnd = urlString.indexOf(typeQu);
            if (urlEnd != -1) {
                var paramsUrl = urlString.substring(urlEnd + typeQu.length);
                var isEnd = paramsUrl.indexOf('&');
                if (isEnd != -1) {
                    return paramsUrl.substring(0, isEnd);
                }
                else {
                    return paramsUrl;
                }
            }
            else {
                return "";
            }
        }
        else {
            return "";
        }
    }
};