﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ExamSchoolAssignment.aspx.cs"
    Inherits="RM.Web.Training.Exam.ExamSchoolAssignment" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("ExamSchoolAssignment_Title")%></title>
    <link href="Themes/Css/ExamGlobal.css" rel="stylesheet" type="text/css" />
    <link href="../../Themes/Styles/Site.css" rel="stylesheet" type="text/css" />
    <script src="../../Themes/Scripts/jquery-1.8.2.min.js" type="text/javascript"></script>
    <script src="../../Themes/Scripts/artDialog/artDialog.js" type="text/javascript"></script>
    <script src="../../Themes/Scripts/artDialog/iframeTools.js" type="text/javascript"></script>
    <script src="../../Themes/Scripts/FunctionJS.js" type="text/javascript"></script>
    <link href="Themes/Css/ExaminationCss.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript">
        var resultKey = $("#submitExam").attr("resultKey"); //xml文件路径
        var pageError = true; //表示页面是否有错误，默认true表示有
        $(function () {
            function resizeimg(objImg, maxWidth, maxHeight) {
                ///	<summary>
                ///     根据图片对象和指定的参数按比例缩放图片
                ///     &#10;1: resizeimg(obj, maxW, maxH) - 根据图片对象和指定的参数按比例缩放图片
                ///	</summary>
                ///	<param name="obj" type="ImageObject">图片对象</param>
                ///	<param name="maxW" type="int">最大宽度</param>
                ///	<param name="maxH" type="int">最大高度</param>
                ///	<returns type="string" />
                var img = new Image();
                img.src = objImg.src;
                var hRatio;
                var wRatio;
                var Ratio = 1;
                var w = img.width;
                var h = img.height;
                wRatio = maxWidth / w;
                hRatio = maxHeight / h;
                if (maxWidth == 0 && maxHeight == 0) {
                    Ratio = 1;
                } else if (maxWidth == 0) {//
                    if (hRatio < 1) Ratio = hRatio;
                } else if (maxHeight == 0) {
                    if (wRatio < 1) Ratio = wRatio;
                } else if (wRatio < 1 || hRatio < 1) {
                    Ratio = (wRatio <= hRatio ? wRatio : hRatio);
                }
                if (Ratio < 1) {
                    w = w * Ratio;
                    h = h * Ratio;
                }
                objImg.height = h;
                objImg.width = w;
            }
            if ($.browser.msie) {
                var imgList = $("#examItem img");
                for (var i = 0; i < imgList.length; i++) {
                    resizeimg(imgList.get(i), 600, 500);
                }
            } else {
                $("#examItem img").load(function () {
                    resizeimg(this, 600, 500);
                });
            }
            //把经常变换的对象预留出来
            resultKey = $("#submitExam").attr("resultKey"); //xml文件路径
            var $currQueCount = $("#currQueCount"); //答题情况
            var $exam_Num = $("#exam_Num"); //题目编号
            var $exam_Type = $("#exam_Type"); //题目类型
            var $exam_Score = $("#exam_Score"); //题目分值
            var $list = $(".ques_Context"); //题目对象
            var $linkList = $(".curr_State>li>a"); //右侧题目编号列表
            var $pageBody = $("body"); //body对象
            var $examItem = $("#examItem"); //左侧题目对象
            if (!$list || $list.length < 1 || !$linkList || $linkList.length < 1) {//页面有错误
                return;
            }
            pageError = false;
            $list.first().addClass("activeQuetion");
            $linkList.first().addClass("currLinkNum");
            //自适应宽高
            function changePageWindow() {
                if ($pageBody.height() < $("#toolBar").height()) //右侧工具栏自适应高度
                    $("#toolBar").css("overflow", "scroll");
                else
                    $("#toolBar").css("overflow", "auto");
                $("#toolBar").height($pageBody.height());
                $examItem.width($pageBody.width() - 290); //左侧题目自适应高度
                changePageHeight();
            }
            //每次题目改变根据题目的高度自适应高度
            function changePageHeight() {
                if ($examItem.height() > $pageBody.height()) {
                    $examItem.css("overflow", "scroll");
                } else {
                    $examItem.css("overflow", "auto");
                }
                $examItem.height($pageBody.height());
            }
            changePageWindow();
            $(window).resize(changePageWindow); //绑定系统宽高改变事件
            function triggerText() {//触发textarea的blur事件
                var $currText = $(".activeQuetion").find("textarea");
                if ($(".activeQuetion").find("textarea").length > 0) $currText.blur();
            }
            $("#upQuestion").click(function () {//上一题
                triggerText();
                var $tempObj = $(".activeQuetion");
                var $tempNumObj = $(".currLinkNum");
                if ($tempObj.prev().length < 1) {
                    showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("ChapterList_mysyt")%>", 2000, 3);
                } else {
                    $tempObj.removeClass("activeQuetion").prev().addClass("activeQuetion");
                    $tempNumObj.removeClass("currLinkNum").prev().addClass("currLinkNum");
                }
            });
            $("#nextQuesion").click(function () {//下一题
                triggerText();
                var $tempObj = $(".activeQuetion");
                var $tempNumObj = $(".currLinkNum");
                if ($tempObj.next().length < 1) {
                    showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("ChapterList_myxyt")%>", 2000, 3);
                } else {
                    $tempObj.removeClass("activeQuetion").next().addClass("activeQuetion");
                    $tempNumObj.removeClass("currLinkNum").next().addClass("currLinkNum");
                }
            });
            $linkList.click(function () { //右侧题目列表
                triggerText();
                $(".activeQuetion").removeClass("activeQuetion");
                $(".currLinkNum").removeClass("currLinkNum");
                $(this).addClass("currLinkNum");
                $list.eq(parseInt($(this).text()) - 1).addClass("activeQuetion");
            });
            $(".exam_result>li").hover(function () {//选项的悬浮
                if ($(this).has("textarea").length > 0) return;
                $(this).addClass("hoverLi");
            }, function () {
                if ($(this).has("textarea").length > 0) return;
                $(this).removeClass("hoverLi");
            });

            //阻止事件冒泡的通用函数  
            function stopBubble(e) {
                // 如果传入了事件对象，那么就是非ie浏览器  
                if (e && e.stopPropagation) {
                    //因此它支持W3C的stopPropagation()方法  
                    e.stopPropagation();
                } else {
                    //否则我们使用ie的方法来取消事件冒泡  
                    window.event.cancelBubble = true;
                }
            }
            $(".exam_result>li>input:radio").change(function () {//radio选项的选中样式改变
                $(this).parent().parent().children("li").removeClass("checkedInput");
                $(this).parent().addClass("checkedInput");
                postback($(this).parent().parent().children("li"), $(this).attr("name"), $(this).attr("data"), 0, resultKey, $(".activeQuetion").index());

            });
            $(".exam_result>li>input[type=checkbox]").change(function () {//checkbox选项的选中样式改变
                if ($(this).is(":checked")) {
                    $(this).parent().addClass("checkedInput");
                } else {
                    $(this).parent().removeClass("checkedInput");
                }
                var data = "";
                $(this).parent().parent().children("li").children("input:checked").each(function () {
                    data += $(this).attr("data");
                });
                postback($(this).parent().parent().children("li"), $(this).attr("name"), data, 0, resultKey, $(".activeQuetion").index());
            });
            $(".exam_result>li>textarea").blur(function () {
                postback($(this), $(this).attr("name"), $(this).val(), 0, resultKey, $(".activeQuetion").index());
            });

            $("label").click(function (e) {//阻止事件冒泡，如果不阻止则单击li触发label的click()，然后label又触发li的click，冒泡无限循环了
                stopBubble(e);
            });
            $(".exam_result>li").click(function (e) {//li单击事件
                $(this).children("label").click();
            });
            function postback(objList, questionKey, itemKey, overplus, resultKey, currIndex) {
                ///	<summary>
                ///     答题方法
                ///     &#10;postback(objList,questionKey, itemKey, overplus,resultKey) - 答题方法
                ///	</summary>
                ///	<param name="objList" type="list">要锁定的一组（或一个）对象</param>
                ///	<param name="questionKey" type="string">题目ID</param>
                ///	<param name="itemKey" type="string">答案</param>
                ///	<param name="overplus" type="double">当前剩余时间</param>
                ///	<param name="resultKey" type="string">xml文件路径名</param>
                ///	<returns type="void" />
                $(objList).attr("disabled", "disabled"); //锁住选项
                $.ajax({
                    url: "ReplyQuesion.ashx",
                    type: "post",
                    data: { "replay": itemKey, "queKey": questionKey, "resultKey": resultKey, "overplus": overplus },
                    dataType: "text",
                    success: function (data) {
                        if (data) {
                            if (parseInt(data) < 0) {
                                showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("ChapterList_sjtjyc")%>", 2000, 5);
                            } else {//答题成功
                                if (parseInt(data) == 0) {//取消回答
                                    $linkList.eq(currIndex).removeAttr("style");
                                    $currQueCount.text(parseInt($currQueCount.text()) - 1);
                                } else {//回答成功
                                    $linkList.eq(currIndex).css({ "background-color": "#a0ff76", "color": "black" });
                                    $currQueCount.text(data);
                                }
                            }
                        } else {
                            showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("ChapterList_wlljyc")%>", 2000, 5);
                        }
                        $(objList).removeAttr("disabled"); //释放选项
                    },
                    error: function () {
                        showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("ChapterList_wlljyc")%>", 2000, 5);
                        $(objList).removeAttr("disabled");
                    }
                });
            }
            $("#submitExam").click(function () {//提交试卷按钮
                showConfirmMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Examination_tijiao")%>", function () {
                    var url = "/Training/Exam/Report.aspx?key=" + resultKey + "&EPKey" + QueryString("EPKey");
                    window.parent.parent.openDialog("/Training/Exam/Report.aspx?Not=exam&key=" + resultKey, 'ReportInfo', '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("CorrectExam_sjtj")%> - <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("CorrectExam_dtbg")%>', 550, 220, 50, 50);
                    window.location = "/Training/Exam/ExamHistory_List.aspx";
                });
            });
        });
        var mathcontent = "";
        function mathshow(mathname) {
            mathcontent = mathname;
            //alert(mathcontent);
            $("#mathquill").show();
        }
        //光标处插入图片
        function funInsertTopic(textObj, textStr) {
            textObj.focus();
            var topic = textStr, value = textObj.value, index = value.indexOf(topic);
            if (index === -1) {
                //匹配
                funTextAsTopic(textObj, topic);
            }
            value = textObj.value;
            index = value.indexOf(topic);
            if (textObj.createTextRange) {
                var range = textObj.createTextRange();
                range.moveEnd("character", (index + textStr.length) - value.length);
                range.moveStart("character", index);
                range.select();
            } else {
                textObj.setSelectionRange(index, index + textStr.length);
                textObj.focus();
            }
        };
        function funTextAsTopic(textObj, textFeildValue) {
            if (textObj.createTextRange) {
                var caretPos = document.selection.createRange().duplicate();
                document.selection.empty();
                caretPos.text = textFeildValue;
            } else if (textObj.setSelectionRange) {
                var rangeStart = textObj.selectionStart;
                var rangeEnd = textObj.selectionEnd;
                var tempStr1 = textObj.value.substring(0, rangeStart);
                var tempStr2 = textObj.value.substring(rangeEnd);
                textObj.value = tempStr1 + textFeildValue + tempStr2;
                textObj.blur();
            }
        };
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="btnbartitle">
        <div runat="server" id="ExaminationPaperTitle">
        </div>
    </div>
    <div id="container">
        <div id="examItem">
            <div id="ei_Container">
                <div class="examContext">
                    <%=QuestionHtml.ToString() %>
                </div>
            </div>
            <div id="btnContainer">
                <input type="button" value="<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("ChapterList_syt")%>" id="upQuestion" />
                <input type="button" value="<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("ChapterList_xyt")%>" id="nextQuesion" />
            </div>
            <div class="promptContext">
                <label class="asterisk">
                    *
                </label>
               <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Examination_tsdjxxjkdtxzdah")%> <br />
                &nbsp;&nbsp;<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Examination_djsytxytan")%>
            </div>
        </div>
        <div id="toolBar">
            <div id="submitContainer">
                <a href="javascript:void(0)" id="submitExam" resultkey="<%=hashKey %>"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Exam_qdjj")%></a>
            </div>
            <div id="currStateInfo">
                <div class="ans_State">
                    <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Examination_dtqk")%></div>
                <div id="ans_State">
                    <label id="currQueCount" runat="server">
                        0</label>/<label id="sumQueCount"><%=SumCount %></label></div>
                <ul class="curr_State">
                    <li>
                        <%=LinkStateHtml.ToString() %>
                    </li>
                </ul>
                <div class="promptContext">
                    <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Examination_dgdtmxshs")%><br />
                     <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Examination_wdgdxsbs")%></div>
            </div>
        </div>
        <div class="clear">
        </div>
    </div>
    </form>
 <div id="mathquill" style=" width:600px; position:absolute; height:300px; left:0; bottom:0; background-color:White; display:none; z-index:9999;">
         <iframe src="/Training/TrainingTest/gs/mathdialog.html" width="600" height="300" scrolling="no"  frameborder="0" style=" padding:0;"></iframe>
    </div>
</body>
</html>
