﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ImportNowData.aspx.cs"
    Inherits="RM.Web.Training.Tool.ImportNowData" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>上传Excel文件</title>
    <link href="/Themes/Styles/Site.css" rel="stylesheet" type="text/css" />
    <script src="/Themes/Scripts/jquery-1.8.2.min.js" type="text/javascript"></script>
    <script src="/Themes/Scripts/Validator/JValidator.js" type="text/javascript"></script>
    <script src="/Themes/Scripts/artDialog/artDialog.js" type="text/javascript"></script>
    <script src="/Themes/Scripts/artDialog/iframeTools.js" type="text/javascript"></script>
    <script src="/Themes/Scripts/FunctionJS.js" type="text/javascript"></script>
    <style type="text/css">
        .lbl_Title { padding: 0 6px 0 8px; }
        li { list-style: none; }
        ul, li, fieldset, legend, p, div { margin: 0; padding: 5px; }
        #statisticsName { border: 1px solid #CCC; line-height: 18px; height: 18px; width: 200px; font-family: "microsoft yahei" ,simhei; }
        .configDetail { display: inline-block; }
        .configDetail input { width: 60px; padding-left: 5px; border: 1px solid #CCC; height: 18px; line-height: 18px; font-size: 10pt; font-family: "microsoft yahei" ,simhei; }
        .discript p { color: Red; }
        #handleIcon { display: none; background: url("/Themes/Images/loading.gif") no-repeat scroll 7px 2px #FFFFFF; left: 25%; padding: 6px 5px 6px 40px; position: absolute; top: 45%; z-index: 3000; }
    </style>
    <script type="text/javascript">
        $(function () {
            $("#config input").blur(function () {
                if (jQuery.trim($(this).val()) == "") {
                    showTipsMsg($(this).prev().text() + "不允许为空！", 1500, 3);
                    return false;
                }
            });
        });
        //验证数字 num
        function isInteger(obj) {
            reg = /^[-+]?\d+$/;
            if (!reg.test(obj)) {
                return false;
            } else {
                return true;
            }
        }
        function checkExcel() {
            var isCheck = false;
            $("#config input").each(function () {
                if (jQuery.trim($(this).val()) == "") {
                    showTipsMsg($(this).prev().text() + "不允许为空！", 1500, 3);
                    isCheck = true;
                    return false;
                } else if ($(this).hasClass("isNums")) {
                    if (!isInteger($(this).val())) {
                        showTipsMsg($(this).prev().text() + "请输入合法的数字！", 1500, 3);
                        isCheck = true;
                        return false;
                    }
                }
            });
            if (isCheck) return false;
            var imgSrc = "";
            //上传图片
            var fileName = $("#excelFile").val();
            if (fileName.length < 1) {//不合法
                showTipsMsg("请选择要上传的Excel文件", 2000, 3);
                return false;
            } else {
                var extension = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length).toLowerCase(); //获取扩展名
                if (extension == "xlsx" || extension == "xls") {//合法

                } else {
                    showTipsMsg("文件格式不正确，只允许xls、xlsx的Excel文件", 2000, 3);
                    return false;
                }
            }
            $("#handleIcon").show(0);
        }
    </script>
</head>
<body>
    <form id="form1" runat="server" method="post" enctype="multipart/form-data">
    <div>
        <fieldset id="config">
            <legend>配置参数 </legend>
            <div>
                <label class="lbl_Title">
                    考试名称：</label><input id="statisticsName" name="" runat="server" /><label class="lbl_Title">Excel文件：</label><input
                        type="file" id="excelFile" name="imgFile" />
            </div>
            <ul class="configContainer">
                <li>
                    <%--<div class="configDetail">
                        <span>语文老师：</span>
                        <input id="input_ChineseTeacher" runat="server" />
                    </div>--%>
                    <div class="configDetail">
                        <span>语文及格分：</span>
                        <input id="input_ChinesePass" runat="server" value="72" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>语文良好分：</span>
                        <input id="input_ChineseGood" runat="server" value="84" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>语文优秀分：</span>
                        <input id="input_ChineseFine" runat="server" value="96" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>语文特优分：</span>
                        <input id="input_ChineseBestFine" runat="server" value="108" class="isNums" />
                    </div>
                </li>
                <li>
                    <%--   <div class="configDetail">
                        <span>数学老师：</span>
                        <input id="input_MathTeacher" runat="server" />
                    </div>--%>
                    <div class="configDetail">
                        <span>数学及格分：</span>
                        <input id="input_MathPass" runat="server" value="72" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>数学良好分：</span>
                        <input id="input_MathGood" runat="server" value="84" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>数学优秀分：</span>
                        <input id="input_MathFine" runat="server" value="96" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>数学特优分：</span>
                        <input id="input_MathBestFine" runat="server" value="108" class="isNums" />
                    </div>
                </li>
                <li>
                    <%-- <div class="configDetail">
                        <span>英语老师：</span>
                        <input id="input_EnglishTeacher" runat="server" />
                    </div>--%>
                    <div class="configDetail">
                        <span>英语及格分：</span>
                        <input id="input_EnglishPass" runat="server" value="72" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>英语良好分：</span>
                        <input id="input_EnglishGood" runat="server" value="84" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>英语优秀分：</span>
                        <input id="input_EnglishFine" runat="server" value="96" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>英语特优分：</span>
                        <input id="input_EnglishBestFine" runat="server" value="108" class="isNums" />
                    </div>
                </li>
                <li>
                    <%--  <div class="configDetail">
                        <span>物理老师：</span>
                        <input id="input_PhysicsTeacher" runat="server" />
                    </div>--%>
                    <div class="configDetail">
                        <span>物理及格分：</span>
                        <input id="input_PhysicsPass" runat="server" value="48" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>物理良好分：</span>
                        <input id="input_PhysicsGood" runat="server" value="56" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>物理优秀分：</span>
                        <input id="input_PhysicsFine" runat="server" value="64" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>物理特优分：</span>
                        <input id="input_PhysicsBestFine" runat="server" value="72" class="isNums" />
                    </div>
                </li>
                <li>
                    <%--<div class="configDetail">
                        <span>化学老师：</span>
                        <input id="input_ChemTeacher" runat="server" />
                    </div>--%>
                    <div class="configDetail">
                        <span>化学及格分：</span>
                        <input id="input_ChemPass" runat="server" value="42" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>化学良好分：</span>
                        <input id="input_ChemGood" runat="server" value="49" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>化学优秀分：</span>
                        <input id="input_ChemFine" runat="server" value="56" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>化学特优分：</span>
                        <input id="input_ChemBestFine" runat="server" value="63" class="isNums" />
                    </div>
                </li>
                <li>
                    <%-- <div class="configDetail">
                        <span>政治老师：</span>
                        <input id="input_PoliticsTeacher" runat="server" />
                    </div>--%>
                    <div class="configDetail">
                        <span>政治及格分：</span>
                        <input id="input_PoliticsPass" runat="server" value="45" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>政治良好分：</span>
                        <input id="input_PoliticsGood" runat="server" value="53" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>政治优秀分：</span>
                        <input id="input_PoliticsFine" runat="server" value="60" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>政治特优分：</span>
                        <input id="input_PoliticsBestFine" runat="server" value="68" class="isNums" />
                    </div>
                </li>
                <li>
                    <%-- <div class="configDetail">
                        <span>历史老师：</span>
                        <input id="input_HistoryTeacher" runat="server" />
                    </div>--%>
                    <div class="configDetail">
                        <span>历史及格分：</span>
                        <input id="input_HistoryPass" runat="server" value="45" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>历史良好分：</span>
                        <input id="input_HistoryGood" runat="server" value="53" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>历史优秀分：</span>
                        <input id="input_HistoryFine" runat="server" value="60" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>历史特优分：</span>
                        <input id="input_HistoryBestFine" runat="server" value="68" class="isNums" />
                    </div>
                </li>
                <li>
                    <%-- <div class="configDetail">
                        <span>历史老师：</span>
                        <input id="input_HistoryTeacher" runat="server" />
                    </div>--%>
                    <div class="configDetail">
                        <span>生物及格分：</span>
                        <input id="input_OrganismPass" runat="server" value="45" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>生物良好分：</span>
                        <input id="input_OrganismGood" runat="server" value="53" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>生物优秀分：</span>
                        <input id="input_OrganismFine" runat="server" value="60" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>生物特优分：</span>
                        <input id="input_OrganismBestFine" runat="server" value="68" class="isNums" />
                    </div>
                </li>
                <li>
                    <%-- <div class="configDetail">
                        <span>历史老师：</span>
                        <input id="input_HistoryTeacher" runat="server" />
                    </div>--%>
                    <div class="configDetail">
                        <span>地理及格分：</span>
                        <input id="input_GeographyPass" runat="server" value="45" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>地理良好分：</span>
                        <input id="input_GeographyGood" runat="server" value="53" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>地理优秀分：</span>
                        <input id="input_GeographyFine" runat="server" value="60" class="isNums" />
                    </div>
                    <div class="configDetail">
                        <span>地理特优分：</span>
                        <input id="input_GeographyBestFine" runat="server" value="68" class="isNums" />
                    </div>
                </li>
            </ul>
        </fieldset>
        <div class="discript">
            <p>
                上传学员成绩的excel文件表中，注意将表中和统计相关的数据清空。
            </p>
            <p>
                页面数据不允许存在空项！上传之后因为需要进行多次计算生成数据，所以请耐心等待。
            </p>
        </div>
        <asp:Button ID="submitBtn" runat="server" Text="保存" OnClientClick="javascript:return checkExcel();"
            OnClick="submitBtn_Click" Style="float: right;" />
    </div>
    <div id="handleIcon">
        正在处理数据，因为需要进行多次计算生成数据，所以请耐心等待。</div>
    </form>
</body>
</html>
