﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="NowDataManager.aspx.cs"
    Inherits="RM.Web.Training.Tool.NowDataManager" %>

<%@ Register Src="~/UserControl/LoadButton.ascx" TagName="LoadButton" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>成绩管理</title>
    <link href="/Themes/Styles/Site.css" rel="stylesheet" type="text/css" />
    <script src="/Themes/Scripts/jquery-1.8.2.min.js" type="text/javascript"></script>
    <link href="/Themes/Scripts/artDialog/skins/opera.css" rel="stylesheet" type="text/css" />
    <script src="/Themes/Scripts/artDialog/artDialog.js" type="text/javascript"></script>
    <script src="/Themes/Scripts/artDialog/iframeTools.js" type="text/javascript"></script>
    <script src="/Themes/Scripts/FunctionJS.js" type="text/javascript"></script>
    <style type="text/css">
        #ddl_QueryType, #ddl_Subject { border: 1px solid #CCC; }
    </style>
</head>
<body>
    <form id="form1" runat="server">
    <div class="btnbartitle">
        <div>
            成绩管理
        </div>
    </div>
    <div class="btnbarcontetn">
        <div style="float: left; padding: 5px 0 0 5px;">
            <asp:DropDownList ID="ddl_QueryType" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddl_QueryType_SelectedIndexChanged">
            </asp:DropDownList>
            <asp:DropDownList ID="ddl_Subject" runat="server" AutoPostBack="true">
                <asp:ListItem Text="全部" Value=""></asp:ListItem>
                <asp:ListItem Text="语文" Value="语文"></asp:ListItem>
                <asp:ListItem Text="数学" Value="数学"></asp:ListItem>
                <asp:ListItem Text="英语" Value="英语"></asp:ListItem>
                <asp:ListItem Text="物理" Value="物理"></asp:ListItem>
                <asp:ListItem Text="化学" Value="化学"></asp:ListItem>
                <asp:ListItem Text="政治" Value="政治"></asp:ListItem>
                <asp:ListItem Text="历史" Value="历史"></asp:ListItem>
            </asp:DropDownList>
        </div>
        <div style="text-align: right">
            <a class="button green" id="exportExcelData" href="javascript:;" onclick="javascript:TableExport('table1')"
                title="导出Excel"><span class="icon-botton" style="background: url('/Themes/images/16/2012080412486.png') no-repeat scroll 0px 4px;">
                </span>导出Excel</a>
            <uc2:LoadButton ID="LoadButton1" runat="server" />
        </div>
    </div>
    <div class="div-body">
        <%=PageHtml.ToString()%>
    </div>
    </form>
</body>
<script type="text/javascript">
    $(function () {
        //把分页定位到屏幕下面
        divresize(70);
        FixedTableHeader("#table1", $(window).height() - 121);
    })
    var Mywindows = 'TKS_ToolStaResu';
    //导入
    function inport() {
        var url = "/Training/Tool/ImportNowData.aspx";
        top.openDialog(url, 'ImportNowData', '成绩管理 - 导入成绩', 700, 600, 50, 50);
    }
    function Delete() {
        var value = jQuery.trim($("#ddl_QueryType").val());
        if (value == "") {
            showTipsMsg("当前没有数据，无法进行删除操作", 2000, 3);
            return false;
        }
        showConfirmMsg("将会删除<span style='color:red;font-weight:bold;font-size:11pt;padding:0 5px;'>" + $("#ddl_QueryType").find("option:selected").text() + "</span>的相关数据（学员成绩，成绩统计，班级成绩）,确认删除么？", function () {
            $.post("/Training/Tool/DelToolResultData.ashx", { key: value }, function (data) {
                var result = parseInt(data);
                if (result < 1) {
                    showTipsMsg("删除数据异常，请检查您的网络连接或稍后重新尝试", 2500, 5);
                    window.location.href = "/Training/Tool/NowDataManager.aspx";
                } else {
                    showTipsMsg("删除数据成功！", 2500, 4);
                    window.location.href = "/Training/Tool/NowDataManager.aspx";
                }
            });
        });
    }
</script>
<script src="/Themes/Scripts/CreateContextJs.js" type="text/javascript"></script>
</html>
