﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="EditQuestionByExam.aspx.cs"
    Inherits="RM.Web.Training.TrainingTest.EditQuestionByExam" %>

<%@ Register Src="/UserControl/LoadButton.ascx" TagName="LoadButton" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_edit")%></title>
    <link href="/Themes/Styles/Site.css" rel="stylesheet" type="text/css" />
    <link href="/Training/Exam/Themes/Css/AddQuesionsCss.css" rel="stylesheet" type="text/css" />
    <script src="/Themes/Scripts/jquery-1.8.2.min.js" type="text/javascript"></script>
    <script src="/Themes/Scripts/jquery.json-2.3.min.js" type="text/javascript"></script>
    <script src="/Themes/Scripts/jquery.form.js" type="text/javascript"></script>
    <link href="/Themes/Scripts/artDialog/skins/opera.css" rel="stylesheet" type="text/css" />
    <script src="/Themes/Scripts/artDialog/artDialog.js" type="text/javascript"></script>
    <script src="/Themes/Scripts/FunctionJS.js" type="text/javascript"></script>
    <script type="text/javascript">
        var btnClickEvent; //添加题目按钮单击事件
        var savaAndToExamEvent; //保存并生成事件按钮单击事件
        var ques = new Array(); //全局题目的数组对象
        var pageType = false;   //页面类型：表示是添加问卷还是添加试卷。true：添加问卷、false：添加试卷
        var exKey; //被编辑的试卷ID
        var btnClickChoiseQuestion;
        String.prototype.getQueryString = function (name) {//获取地址栏参数，使用方法：location.search.getQueryString("要查询的参数")
            var reg = new RegExp("(^|&|\\?)" + name + "=([^&]*)(&|$)"), r;
            if (r = this.match(reg)) return unescape(r[2]);
            return null;
        }

        //光标处插入图片
        function funInsertTopic(textObj, textStr) {
            textObj.focus();
            var topic = textStr, value = textObj.value, index = value.indexOf(topic);
            if (index === -1) {
                //匹配
                funTextAsTopic(textObj, topic);
            }
            value = textObj.value;
            index = value.indexOf(topic);
            if (textObj.createTextRange) {
                var range = textObj.createTextRange();
                range.moveEnd("character", (index + textStr.length) - value.length);
                range.moveStart("character", index);
                range.select();
            } else {
                textObj.setSelectionRange(index, index + textStr.length);
                textObj.focus();
            }
        };
        function funTextAsTopic(textObj, textFeildValue) {
            if (textObj.createTextRange) {
                var caretPos = document.selection.createRange().duplicate();
                document.selection.empty();
                caretPos.text = textFeildValue;
            } else if (textObj.setSelectionRange) {
                var rangeStart = textObj.selectionStart;
                var rangeEnd = textObj.selectionEnd;
                var tempStr1 = textObj.value.substring(0, rangeStart);
                var tempStr2 = textObj.value.substring(rangeEnd);
                textObj.value = tempStr1 + textFeildValue + tempStr2;
                textObj.blur();
            }
        };

        $(function () {
                    var isError=$('#errorCode').attr('data');
            if(isError==='1')
            {
                showTipsMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_showExcep")%>',1500,3);
                return;
            }else if(isError==='2')
            {
                showTipsMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_showNotExam")%>',3500,3);
                return;    
            }

            var $pageOpType = $("#page_OpType"); //全局状态变量
            //获取地址栏参数
            pageType = Boolean($("#priviewContainer").attr("pagetype")); //true为问卷，否则为试卷
            exKey = location.search.getQueryString("exKey"); //获取试卷ID
            //回到顶部
            var $backToTopEle = $('<div class="backToTop" style="cursor: pointer;_right: auto; width: 50px; color:#4Db6E8; height: 50px; background: url(\'/Themes/Images/BackTop_default.png\') no-repeat 0px 0px; position: fixed; _position: absolute; bottom: 88px; right: 8.6%; z-index: 1280;"></div>').appendTo($("body")).click(function () {
                $("#priviewContent").animate({ scrollTop: 0 }, 120);
            }).hover(function () {
                $(this).css({ "background-position": "-50px 0px" });
            }, function () {
                $(this).css({ "background-position": "0px 0px" });
            }), $backToTopFun = function () {
                var st = $("#priviewContent").scrollTop(), winh = $("#priviewContent").height();
                (st > 600) ? $backToTopEle.show() : $backToTopEle.hide(); //显示backToTop
            };
            $("#priviewContent").bind("scroll", $backToTopFun);
            $backToTopFun();
            //上传图片
            $("#uploadImg").change(function () {
                var imgSrc = "";
                //上传图片
                var fileName = $(this).val(); //文件名
                if (fileName.length < 1) {//不合法
                    showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("upload_pictures")%>", 2000, 3);
                } else {
                    var extension = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length).toLowerCase(); //获取扩展名
                    if (extension == "bmp" || extension == "jpg" || extension == "jpge" || extension == "gif") {//合法
                        $("#uploadForm").ajaxSubmit({
                            type: "post",
                            url: "UploadImg.ashx",
                            success: function (data) {
                                if (data) {
                                    switch (data) {
                                        case "1":
                                            showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("File_not")%>", 2000, 3);
                                            return;
                                        case "2":
                                            showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("File_size")%>", 2000, 3);
                                            return;
                                        case "3":
                                            showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("File_format")%>", 2000, 3);
                                            return;
                                        case "4":
                                            showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("File_Exam")%>", 2000, 5);
                                            return;
                                        default:
                                            //插入附件
                                            var textObj = $("#questionText").get(0);
                                            funInsertTopic(textObj, '〔' + data + '〕');
                                            break;
                                    }
                                } else {
                                    showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("File_Exam")%>", 3000, 5);
                                }
                            }
                        });
                    } else {
                        showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("File_format")%>", 2000, 3);
                    }
                }

            });
            //题目对象
            function queObj(Questions_QtId, Questions_Title, Questions_OptionOne, Questions_OptionTwo, Questions_OptionThree, Questions_OptionFour, questions_OptionFive, Questions_OptionSix, Questions_OptionSeven, Questions_OptionEight, Questions_OptionNine, Questions_OptionTen, Questions_Answer, Questions_Discription, Questions_Id,ExamDetail_Fen) {
                ///	<summary>
                ///     题目对象
                ///     date:2013年10月17日 17:02:32
                ///     author:jl
                ///     version:1.0
                ///     &#10;1: queObj(Questions_QtId, Questions_Title, Questions_OptionOne, Questions_OptionTwo, Questions_OptionThree, Questions_OptionFour, questions_OptionFive, Questions_OptionSix,Questions_Answer,Questions_Discription,Questions_Id) - 题目对象
                ///	</summary>
                ///	<param name="Questions_QtId" type="int">题目类型：默认：单选题、2：多选题、3：问答题、4：判断题</param>
                /// <param name="Questions_Title" type="string">题目标题</param>
                /// <param name="Questions_OptionOne" type="string">选项1，本参数及以后参数都可省略</param>
                /// <param name="Questions_Answer" type="string">答案</param>
                /// <param name="Questions_Discription" type="string">注释</param>
                /// <param name="Questions_Id" type="string">ID（当从题库中选择题目后默认存在ID，数据库直接插入即可，但是如果该题目经过编辑，则清空该项）</param>
                ///	<returns type="string" />
                this.Questions_QtId = Questions_QtId;
                this.Questions_Title = Questions_Title;
                if (Questions_OptionOne) this.Questions_OptionOne = Questions_OptionOne;
                if (Questions_OptionTwo) this.Questions_OptionTwo = Questions_OptionTwo;
                if (Questions_OptionThree) this.Questions_OptionThree = Questions_OptionThree;
                if (Questions_OptionFour) this.Questions_OptionFour = Questions_OptionFour;
                if (questions_OptionFive) this.questions_OptionFive = questions_OptionFive;
                if (Questions_OptionSix) this.Questions_OptionSix = Questions_OptionSix;
                if (Questions_OptionSeven) this.Questions_OptionSeven = Questions_OptionSeven;
                if (Questions_OptionEight) this.Questions_OptionEight = Questions_OptionEight;
                if (Questions_OptionNine) this.Questions_OptionNine = Questions_OptionNine;
                if (Questions_OptionTen) this.Questions_OptionTen = Questions_OptionTen;
                if (Questions_Answer) this.Questions_Answer = Questions_Answer; //答案
                if (Questions_Discription) this.Questions_Discription = Questions_Discription; //注释，注解
                if (Questions_Id) this.Questions_Id = Questions_Id; //ID
               if (ExamDetail_Fen) this.ExamDetail_Fen=ExamDetail_Fen;//分数
            }; //注意有;

            //Start
            function readObj(questions) {
                ///	<summary>
                ///     根据每个题目的文本数组生成题目，返回每个题目的对象（queObj）
                ///     date:2013年10月18日 18:25:52
                ///     author:jl
                ///     version:1.0
                ///     &#10;1: readObj(questions) - 根据每个题目的文本数组生成题目，返回每个题目的对象（queObj）
                ///	</summary>
                ///	<param name="questions" type="Array[]">题目的文本数组</param>
                ///	<returns type="queObj" />
                var questionObj = new queObj();
                var index = -1; //索引
                for (var temp in questions) {//循环题目的明细 
                    if (!questions[temp] || questions[temp].length < 1 || jQuery.trim(questions[temp]).length < 1) continue;
                    //ABCD剔除
                    if (questions[temp].indexOf("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("answer")%>：") >= 0 || questions[temp].indexOf("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("answer")%>:") >= 0) {
                        questionObj.Questions_Answer = questions[temp].replace("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("answer")%>：", "").replace("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("answer")%>:", ""); //保存答案
                        continue;
                    }
                    if (questions[temp].indexOf("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_zssm")%>：") >= 0 || questions[temp].indexOf("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_zjsm")%>:") >= 0) {
                        questionObj.Questions_Discription = questions[temp].replace("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_zssm")%>：", "").replace("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_zjsm")%>:", ""); //注释
                        continue;
                    }
                      if (questions[temp].indexOf("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Courseware_Fraction")%>：") >= 0 || questions[temp].indexOf("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Courseware_Fraction")%>:") >= 0) {
                        questionObj.ExamDetail_Fen = questions[temp].replace("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Courseware_Fraction")%>：", "").replace("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Courseware_Fraction")%>:", ""); //注释
                        continue;
                    }
                    //开始生成题目
                    index++;
                    switch (index) {   //录入题型
                        case 0:
                            questionObj.Questions_Title = questions[temp];
                            break;
                        case 1:
                            questionObj.Questions_OptionOne = questions[temp];
                            break;
                        case 2:
                            questionObj.Questions_OptionTwo = questions[temp];
                            break;
                        case 3:
                            questionObj.Questions_OptionThree = questions[temp];
                            break;
                        case 4:
                            questionObj.Questions_OptionFour = questions[temp];
                            break;
                        case 5:
                            questionObj.questions_OptionFive = questions[temp];
                            break;
                        case 6:
                            questionObj.Questions_OptionSix = questions[temp];
                            break;
                        case 7:
                            questionObj.Questions_OptionSeven = questions[temp];
                            break;
                        case 8:
                            questionObj.Questions_OptionEight = questions[temp];
                            break;
                        case 9:
                            questionObj.Questions_OptionNine = questions[temp];
                            break;
                        case 10:
                            questionObj.Questions_OptionTen = questions[temp];
                            break;
                       
                        default:
                            break;
                    }
                }
                return questionObj;
            }
            //End

            //Start
            function getQuestion(opType, textObj) {
                ///	<summary>
                ///     根据要求的题目类型和textarea对象生成题目数组对象和html文本
                ///     date:2013年10月17日 14:32:33
                ///     author:jl
                ///     version:1.0
                ///     &#10;1: getQuestion(opType,textObj) - 根据要求的题目类型和textarea对象生成题目数组对象和html文本
                ///	</summary>
                ///	<param name="opType" type="int">题目类型：默认：单选题、2：多选题、3：问答题、4：判断题</param>
                /// <param name="textObj" type="textarea object">textarea对象</param>
                ///	<returns type="object" />
                var html = ""; //返回的文本
                var textStr = $(textObj).val(); //文本

                if (textStr.length < 1 || jQuery.trim(textStr).length < 1) {
                    showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_qsrnr")%>", 2000, 3);
                    return;
                }

                var arr; //分割后的每一道题的数组
                if (textStr.indexOf("\n\n") >= 0) {//多题
                    arr = textStr.split(/\n\n/g);
                } else {//一题
                    arr = new Array();
                    arr.push(textStr);
                }

                var questions; //把每道题分割为数组生成题目
                for (var item in arr) {
                    if (!arr[item] || arr[item].length < 1 || !jQuery.trim(arr[item])) continue; //题目为空
                    if (arr[item].indexOf("\n") >= 0) {
                        questions = arr[item].split(/\n/g);
                    } else {
                        questions = new Array();
                        questions.push(arr[item]);
                    }
                    var questionObj = readObj(questions); //生成题目
                    if (questionObj) {//添加到数组
                        if (opType == 3 || opType == 4) {//不必要的数据清空，但是处理方案仍然不妥当
                            if (opType == 3) {//问答题
                                questionObj.Questions_OptionOne = "";
                                questionObj.Questions_OptionTwo = "";
                            }
                            questionObj.Questions_OptionThree = "";
                            questionObj.Questions_OptionFour = "";
                            questionObj.questions_OptionFive = "";
                            questionObj.Questions_OptionSix = "";
                            questionObj.Questions_OptionSeven = "";
                            questionObj.Questions_OptionEight = "";
                            questionObj.Questions_OptionNine = "";
                            questionObj.Questions_OptionTen = "";
                            questionObj.ExamDetail_Fen = "";
                        }
                        questionObj.Questions_QtId = opType;
                        ques.push(questionObj);
                    } else {
                        showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_formate")%>", 2000, 3);
                    }
                }
                html = getHtmlByQuestionsList(ques); //获取html
                return { QuestionsList: ques, html: html };
            }
            //End

            //Start
             function getHtmlByQuestionsList(queObj) {
                ///	<summary>
                ///     根据Question对象数组生成对应的HTML源代码
                ///     date:2013年10月17日 17:43:59
                ///     author:jl
                ///     version:1.0
                ///     &#10;1: getHtmlByQuestionsList(queObj) - 根据Question对象数组生成对应的HTML源代码
                ///	</summary>
                ///	<param name="queObj" type="ArrayObject">题目对象数组</param>
                ///	<returns type="string" />
                try{
                if (!queObj) return ""; //为空
                var errorNums = "";
                var html = "";
                for (var i = 0; i < queObj.length; i++) {//循环题目
//                    alert(queObj[i].Questions_QtId);
               
                    var qtid = queObj[i].Questions_QtId.toString();
                    
                    switch (qtid) {
                        case "2": //多选题
                            html += '<ul><li class="question_Ttitle" id="que_' + i + '">' + (i + 1) + '、' + queObj[i].Questions_Title + '<span class="op_Title">[<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("SmartQuestion_duoxuan")%>]</span><a href="javascript:void(0)" class="editQp" op_Id="' + i + '"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Edit")%></a><a href="javascript:void(0)" class="deleteQp" op_Id="' + i + '"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Delete")%></a></li>';
                            if (queObj[i].Questions_OptionOne) html += '<li><span class="question_Ttitle">A：</span><input id="list_cbo_' + i + '1" type="checkbox" name="que_cbo_' + i + '" /><label for="list_cbo_' + i + '1">' + (queObj[i].Questions_OptionOne = queObj[i].Questions_OptionOne.toUpperCase().replace("A.", "").replace("A：", "").replace("A:", "").replace("A、", "").replace("1:", "").replace("1：", "").replace("1.", "").replace("1、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionTwo) html += '<li><span class="question_Ttitle">B：</span><input id="list_cbo_' + i + '2" type="checkbox" name="que_cbo_' + i + '" /><label for="list_cbo_' + i + '2">' + (queObj[i].Questions_OptionTwo = queObj[i].Questions_OptionTwo.toUpperCase().replace("B.", "").replace("B:", "").replace("B：", "").replace("2:", "").replace("2：", "").replace("B、", "").replace("2.", "").replace("2、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionThree) html += '<li><span class="question_Ttitle">C：</span><input id="list_cbo_' + i + '3" type="checkbox" name="que_cbo_' + i + '" /><label for="list_cbo_' + i + '3">' + (queObj[i].Questions_OptionThree = queObj[i].Questions_OptionThree.toUpperCase().replace("C.", "").replace("C:", "").replace("C：", "").replace("3:", "").replace("3：", "").replace("C、", "").replace("3.", "").replace("3、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionFour) html += '<li><span class="question_Ttitle">D：</span><input id="list_cbo_' + i + '4" type="checkbox" name="que_cbo_' + i + '" /><label for="list_cbo_' + i + '4">' + (queObj[i].Questions_OptionFour = queObj[i].Questions_OptionFour.toUpperCase().replace("D.", "").replace("D:", "").replace("D：", "").replace("4:", "").replace("4：", "").replace("D、", "").replace("4.", "").replace("4、", "")) + '</label></li>';
                            if (queObj[i].questions_OptionFive) html += '<li><span class="question_Ttitle">E：</span><input id="list_cbo_' + i + '5" type="checkbox" name="que_cbo_' + i + '" /><label for="list_cbo_' + i + '5">' + (queObj[i].questions_OptionFive = queObj[i].questions_OptionFive.toUpperCase().replace("E.", "").replace("E:", "").replace("E：", "").replace("5:", "").replace("5：", "").replace("E、", "").replace("5.", "").replace("5、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionSix) html += '<li><span class="question_Ttitle">F：</span><input id="list_cbo_' + i + '6" type="checkbox" name="que_cbo_' + i + '" /><label for="list_cbo_' + i + '6">' + (queObj[i].Questions_OptionSix = queObj[i].Questions_OptionSix.toUpperCase().replace("F.", "").replace("F:", "").replace("F：", "").replace("6:", "").replace("6：", "").replace("F、", "").replace("6.", "").replace("6、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionSeven) html += '<li><span class="question_Ttitle">G：</span><input id="list_cbo_' + i + '7" type="checkbox" name="que_cbo_' + i + '" /><label for="list_cbo_' + i + '7">' + (queObj[i].Questions_OptionSeven = queObj[i].Questions_OptionSeven.toUpperCase().replace("G.", "").replace("G:", "").replace("G：", "").replace("7:", "").replace("7：", "").replace("G、", "").replace("7.", "").replace("7、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionEight) html += '<li><span class="question_Ttitle">H：</span><input id="list_cbo_' + i + '8" type="checkbox" name="que_cbo_' + i + '" /><label for="list_cbo_' + i + '8">' + (queObj[i].Questions_OptionEight = queObj[i].Questions_OptionEight.toUpperCase().replace("H.", "").replace("H:", "").replace("H：", "").replace("8:", "").replace("8：", "").replace("H、", "").replace("8.", "").replace("8、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionNine) html += '<li><span class="question_Ttitle">I：</span><input id="list_cbo_' + i + '9" type="checkbox" name="que_cbo_' + i + '" /><label for="list_cbo_' + i + '9">' + (queObj[i].Questions_OptionNine = queObj[i].Questions_OptionNine.toUpperCase().replace("I.", "").replace("I:", "").replace("I：", "").replace("9:", "").replace("9：", "").replace("I、", "").replace("9.", "").replace("9、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionTen) html += '<li><span class="question_Ttitle">J：</span><input id="list_cbo_' + i + '10" type="checkbox" name="que_cbo_' + i + '" /><label for="list_cbo_' + i + '10">' + (queObj[i].Questions_OptionTen = queObj[i].Questions_OptionTen.toUpperCase().replace("J.", "").replace("J:", "").replace("J：", "").replace("10:", "").replace("10：", "").replace("J、", "").replace("10.", "").replace("10、", "")) + '</label></li>';

                            break;
                        case "3": //简答题
                            html += '<ul><li class="question_Ttitle" id="que_' + i + '">' + (i + 1) + '、' + queObj[i].Questions_Title + '<span class="op_Title">[<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("SmartQuestion_wenda")%>]</span><a href="javascript:void(0)" class="editQp" op_Id="' + i + '"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Edit")%></a><a href="javascript:void(0)" class="deleteQp" op_Id="' + i + '"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Delete")%></a></li>';
                            html += '<li><textarea class="as_Text" spellcheck="false" id="quAs_' + i + '"></textarea></li>';
                            break;
                        case "4": //判断题
                            html += '<ul><li class="question_Ttitle" id="que_' + i + '">' + (i + 1) + '、' + queObj[i].Questions_Title + '<span class="op_Title">[<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("SmartQuestion_panduan")%>]</span><a href="javascript:void(0)" class="editQp" op_Id="' + i + '"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Edit")%></a><a href="javascript:void(0)" class="deleteQp" op_Id="' + i + '"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Delete")%></a></li>';
                            if (queObj[i].Questions_OptionOne) html += '<li><input id="list_jue_' + i + '1" type="radio" name="que_jue_' + i + '" /><label for="list_jue_' + i + '1">' + (queObj[i].Questions_OptionOne = queObj[i].Questions_OptionOne.replace("A、", "").replace("1.", "").replace("1、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionTwo) html += '<li><input id="list_jue_' + i + '2" type="radio" name="que_jue_' + i + '" /><label for="list_jue_' + i + '2">' + (queObj[i].Questions_OptionTwo = queObj[i].Questions_OptionTwo.replace("B、", "").replace("2.", "").replace("2、", "")) + '</label></li>';
                            break;
                        case "5": //排序题
                            html += '<ul><li class="question_Ttitle" id="que_' + i + '">' + (i + 1) + '、' + queObj[i].Questions_Title + '<span class="op_Title">[<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("SmartQuestion_paixun")%>]</span><a href="javascript:void(0)" class="editQp" op_Id="' + i + '"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Edit")%></a><a href="javascript:void(0)" class="deleteQp" op_Id="' + i + '"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Delete")%></a></li>';
                            if (queObj[i].Questions_OptionOne) html += '<li><span class="question_Ttitle">1：</span><label for="list_cbo_' + i + '1">' + (queObj[i].Questions_OptionOne = queObj[i].Questions_OptionOne.toUpperCase().replace("A.", "").replace("A：", "").replace("A:", "").replace("A、", "").replace("1:", "").replace("1：", "").replace("1.", "").replace("1、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionTwo) html += '<li><span class="question_Ttitle">2：</span><label for="list_cbo_' + i + '2">' + (queObj[i].Questions_OptionTwo = queObj[i].Questions_OptionTwo.toUpperCase().replace("B.", "").replace("B:", "").replace("B：", "").replace("2:", "").replace("2：", "").replace("B、", "").replace("2.", "").replace("2、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionThree) html += '<li><span class="question_Ttitle">3：</span><label for="list_cbo_' + i + '3">' + (queObj[i].Questions_OptionThree = queObj[i].Questions_OptionThree.toUpperCase().replace("C.", "").replace("C:", "").replace("C：", "").replace("3:", "").replace("3：", "").replace("C、", "").replace("3.", "").replace("3、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionFour) html += '<li><span class="question_Ttitle">4：</span><label for="list_cbo_' + i + '4">' + (queObj[i].Questions_OptionFour = queObj[i].Questions_OptionFour.toUpperCase().replace("D.", "").replace("D:", "").replace("D：", "").replace("4:", "").replace("4：", "").replace("D、", "").replace("4.", "").replace("4、", "")) + '</label></li>';
                            if (queObj[i].questions_OptionFive) html += '<li><span class="question_Ttitle">5：</span><label for="list_cbo_' + i + '5">' + (queObj[i].questions_OptionFive = queObj[i].questions_OptionFive.toUpperCase().replace("E.", "").replace("E:", "").replace("E：", "").replace("5:", "").replace("5：", "").replace("E、", "").replace("5.", "").replace("5、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionSix) html += '<li><span class="question_Ttitle">6：</span><label for="list_cbo_' + i + '6">' + (queObj[i].Questions_OptionSix = queObj[i].Questions_OptionSix.toUpperCase().replace("F.", "").replace("F:", "").replace("F：", "").replace("6:", "").replace("6：", "").replace("F、", "").replace("6.", "").replace("6、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionSeven) html += '<li><span class="question_Ttitle">7：</span><label for="list_cbo_' + i + '7">' + (queObj[i].Questions_OptionSeven = queObj[i].Questions_OptionSeven.toUpperCase().replace("G.", "").replace("G:", "").replace("G：", "").replace("7:", "").replace("7：", "").replace("G、", "").replace("7.", "").replace("7、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionEight) html += '<li><span class="question_Ttitle">8：</span><label for="list_cbo_' + i + '8">' + (queObj[i].Questions_OptionEight = queObj[i].Questions_OptionEight.toUpperCase().replace("H.", "").replace("H:", "").replace("H：", "").replace("8:", "").replace("8：", "").replace("H、", "").replace("8.", "").replace("8、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionNine) html += '<li><span class="question_Ttitle">9：</span><label for="list_cbo_' + i + '9">' + (queObj[i].Questions_OptionNine = queObj[i].Questions_OptionNine.toUpperCase().replace("I.", "").replace("I:", "").replace("I：", "").replace("9:", "").replace("9：", "").replace("I、", "").replace("9.", "").replace("9、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionTen) html += '<li><span class="question_Ttitle">10：</span><label for="list_cbo_' + i + '10">' + (queObj[i].Questions_OptionTen = queObj[i].Questions_OptionTen.toUpperCase().replace("J.", "").replace("J:", "").replace("J：", "").replace("10:", "").replace("10：", "").replace("J、", "").replace("10.", "").replace("10、", "")) + '</label></li>';
                           
                            break;
                        default: //单选题
                            html += '<ul><li class="question_Ttitle" id="que_' + i + '">' + (i + 1) + '、' + queObj[i].Questions_Title + '<span class="op_Title">[<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("SmartQuestion_danxuan")%>]</span><a href="javascript:void(0)" class="editQp" op_Id="' + i + '"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Edit")%></a><a href="javascript:void(0)" class="deleteQp" op_Id="' + i + '"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Delete")%></a></li>';
                            if (queObj[i].Questions_OptionOne) html += '<li><span class="question_Ttitle">A:</span><input id="list_rdo_' + i + '1" type="radio" name="que_rdo_' + i + '" /><label for="list_rdo_' + i + '1">' + (queObj[i].Questions_OptionOne = queObj[i].Questions_OptionOne.replace("A.", "").replace("A、", "").replace("1.", "").replace("1、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionTwo) html += '<li><span class="question_Ttitle">B:</span><input id="list_rdo_' + i + '2" type="radio" name="que_rdo_' + i + '" /><label for="list_rdo_' + i + '2">' + (queObj[i].Questions_OptionTwo = queObj[i].Questions_OptionTwo.replace("B.", "").replace("B、", "").replace("2.", "").replace("2、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionThree) html += '<li><span class="question_Ttitle">C:</span><input id="list_rdo_' + i + '3" type="radio" name="que_rdo_' + i + '" /><label for="list_rdo_' + i + '3">' + (queObj[i].Questions_OptionThree = queObj[i].Questions_OptionThree.replace("C.", "").replace("C、", "").replace("3.", "").replace("3、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionFour) html += '<li><span class="question_Ttitle">D:</span><input id="list_rdo_' + i + '4" type="radio" name="que_rdo_' + i + '" /><label for="list_rdo_' + i + '4">' + (queObj[i].Questions_OptionFour = queObj[i].Questions_OptionFour.replace("D.", "").replace("D、", "").replace("4.", "").replace("4、", "")) + '</label></li>';
                            if (queObj[i].questions_OptionFive) html += '<li><span class="question_Ttitle">E:</span><input id="list_rdo_' + i + '5" type="radio" name="que_rdo_' + i + '" /><label for="list_rdo_' + i + '5">' + (queObj[i].questions_OptionFive = queObj[i].questions_OptionFive.replace("E.", "").replace("E、", "").replace("5.", "").replace("5、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionSix) html += '<li><span class="question_Ttitle">F:</span><input id="list_rdo_' + i + '6" type="radio" name="que_rdo_' + i + '" /><label for="list_rdo_' + i + '6">' + (queObj[i].Questions_OptionSix = queObj[i].Questions_OptionSix.replace("F.", "").replace("F、", "").replace("6.", "").replace("6、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionSeven) html += '<li><span class="question_Ttitle">G:</span><input id="list_rdo_' + i + '7" type="radio" name="que_rdo_' + i + '" /><label for="list_rdo_' + i + '7">' + (queObj[i].Questions_OptionSeven = queObj[i].Questions_OptionSeven.replace("G.", "").replace("G、", "").replace("7.", "").replace("7、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionEight) html += '<li><span class="question_Ttitle">H:</span><input id="list_rdo_' + i + '8" type="radio" name="que_rdo_' + i + '" /><label for="list_rdo_' + i + '8">' + (queObj[i].Questions_OptionEight = queObj[i].Questions_OptionEight.replace("H.", "").replace("H、", "").replace("8.", "").replace("8、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionNine) html += '<li><span class="question_Ttitle">I:</span><input id="list_rdo_' + i + '9" type="radio" name="que_rdo_' + i + '" /><label for="list_rdo_' + i + '9">' + (queObj[i].Questions_OptionNine = queObj[i].Questions_OptionNine.replace("I.", "").replace("I、", "").replace("9.", "").replace("9、", "")) + '</label></li>';
                            if (queObj[i].Questions_OptionTen) html += '<li><span class="question_Ttitle">J:</span><input id="list_rdo_' + i + '10" type="radio" name="que_rdo_' + i + '" /><label for="list_rdo_' + i + '10">' + (queObj[i].Questions_OptionTen = queObj[i].Questions_OptionTen.replace("J.", "").replace("J、", "").replace("10.", "").replace("10、", "")) + '</label></li>';
                            break;
                    }
                    reg = /([A-J]|[a-j])((.|、|,)*)/; //匹配答案是否正确
                    if (!pageType && (!queObj[i].Questions_Answer && (!queObj[i].Questions_Answer || (!reg.test(queObj[i].Questions_Answer) && queObj[i].Questions_QtId != 3) || (!reg.test(queObj[i].Questions_Answer) && queObj[i].Questions_QtId != 5)))) {
                        errorNums += (i + 1) + '、'; //累加错误编号
                    } else {
                        if (!pageType)
                            html += '<li class="op_Result"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("answer")%>：<label class="question_Ttitle">' + queObj[i].Questions_Answer + '</label></li>';
                        if (queObj[i].ExamDetail_Fen > 0) {
                            html += '<li class="op_Result"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Courseware_Fraction")%>：<label class="question_Ttitle">' + queObj[i].ExamDetail_Fen + '</label></li>';
                        }

                    }

                    if (queObj[i].Questions_Discription) html += '<li class="op_Discription"><fieldset><legend><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_zssm")%></legend><div>' + queObj[i].Questions_Discription + '</div></fieldset></li>';
                    html += '</ul>';
                }
                if (errorNums.length > 0) {
                    showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_NoIs")%>：" + errorNums + "<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_NotAnswer")%>", 5000, 3);
                }
                return html;
                }
                catch(e)
                {
                   alert(e.message); 
                   return "";
                }
            }

            function editQuestionInfo() {
                ///	<summary>
                ///     【确定】按钮事件
                ///     date:2013年10月17日 14:32:33
                ///     author:jl
                ///     version:1.0
                ///     &#10;1: editQuestionInfo() - 【确定】按钮事件（含：添加的完成、编辑的完成）
                ///	</summary>
                ///	<returns type="Boolean" />
                var opType = $pageOpType.attr("opType"); //获取全局变量得到状态，是编辑信息还是添加信息，-1为添加，>0（题目数组索引）则为编辑
                var htmlContext = "";
                if (opType) {
                    if (parseInt(opType) < 0) {//-1表示为添加，0和正数表示为修改
                        var questionObj = getQuestion(parseInt($pageOpType.attr("opratertype")), $("#questionText"));
                        htmlContext = questionObj.html;                        
                    } else {    //修改
                        var $textObj = $("#questionText");
                        var textStr = $textObj.val(); //文本
                        if (textStr.length < 1 && jQuery.trim(textStr).length < 1) {
                            showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_textValNull")%>", 2000, 3);
                            return false;
                        }
                        var questions = textStr.split(/\n/g); //分割题目
                        var resultObj = readObj(questions);
                        if (resultObj) {
                            if (ques[opType].Questions_QtId == 3 || ques[opType].Questions_QtId == 4) {//不必要的数据清空，但是处理方案仍然不妥当
                                if (ques[opType].Questions_QtId == 3) {//问答题
                                    resultObj.Questions_OptionOne = "";
                                    resultObj.Questions_OptionTwo = "";
                                }
                                resultObj.Questions_OptionThree = "";
                                resultObj.Questions_OptionFour = "";
                                resultObj.questions_OptionFive = "";
                                resultObj.Questions_OptionSix = "";
                                resultObj.Questions_OptionSeven = "";
                                resultObj.Questions_OptionEight = "";
                                resultObj.Questions_OptionNine = "";
                                resultObj.Questions_OptionTen = "";

                            }
                            resultObj.Questions_QtId = ques[opType].Questions_QtId;
                            resultObj.Questions_Id = null;
                            ques[opType] = resultObj;

                        }
                        else showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_formate")%>", 2000, 3);
                        htmlContext = getHtmlByQuestionsList(ques); //生成html
                    }
                    $("#pc_View").html(htmlContext); //添加题目
                    imgLoad(); //图片比例缩小
                    $pageOpType.attr("opType", "-1"); //全局状态：表示添加
                    //bindEditAndDeleteEvent(); //绑定编辑和删除事件
                    return true;
                } else {
                    showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_webExcep")%>", 2000, 5);
                }
                return false;
            }

            function createDialog(key, context) {
                ///	<summary>
                ///     创建对话框方法
                ///     date:2013年10月19日 10:26:56
                ///     author:jl
                ///     version:1.0
                ///     &#10;1: createDialog(key, context) - 创建对话框方法
                ///	</summary>
                ///	<param name="key" type="String">决定添加的类型</param>
                /// <param name="context" type="string">编辑状态下，要赋值给textarea对象的值</param>
                ///	<returns type="object" />
                var opTitle = "";
                if (!context) {//添加题目事件
                    opTitle = "<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_insert")%>";

                } else {//编辑题目事件
                    opTitle = "<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Edit")%>";
                    $("#questionText").val(context);
                }
                var $discriptionObjs = $(".questionDiscription");
                $discriptionObjs.removeClass("activeDiscription");
                if (key) {
                    switch (key) {
                        case "addsingle":
                            $pageOpType.attr("opratertype", 1);
                            $discriptionObjs.eq(0).addClass("activeDiscription");
                            opTitle += "<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("SmartQuestion_danxuan")%>";
                            break;
                        case "addmultiple":
                            $pageOpType.attr("opratertype", 2);
                            $discriptionObjs.eq(1).addClass("activeDiscription");
                            opTitle += "<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("SmartQuestion_duoxuan")%>";
                            break;
                        case "addanswer":
                            $pageOpType.attr("opratertype", 3);
                            $discriptionObjs.eq(2).addClass("activeDiscription");
                            opTitle += "<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("SmartQuestion_wenda")%>";
                            break;
                        case "addjudge":
                            $pageOpType.attr("opratertype", 4);
                            $discriptionObjs.eq(3).addClass("activeDiscription");
                            opTitle += "<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("SmartQuestion_panduan")%>";
                            break;
                        case "addsort":
                            $pageOpType.attr("opratertype", 5);
                            $discriptionObjs.eq(4).addClass("activeDiscription");
                            opTitle += "<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("SmartQuestion_paixun")%>";
                            break;
                    }
                }
                if ($.browser.msie) {//ie上传图片不允许用按钮模拟
                   
                    if (!context) {
                        $("#uploadImgContainer").css({ "width": "auto", "height": "auto" });
                    } else {
                        $("#uploadImgContainer").css({ "width": "1px", "height": "1px" });
                    }
                    //artDialog提示框
                    art.dialog({
                        content: document.getElementById("addQuesionContainer"),
                        padding: 0,
                        button: [
                            {
                                name: '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_dete")%>',
                                callback: editQuestionInfo,
                                focus: true
                            },
                            {
                                name: '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_gsbjq")%>',
                                callback: function () {
                                    $("#mathquill").show();
                                    return false;
                                }
                            },
                            {
                                name: '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_Cancel")%>',
                                callback: function () {
                                    $pageOpType.attr("opType", "-1"); //全局状态：表示添加
                                }
                            }
                        ],
                        lock: true,
                        opacity: 0.1,
                        title: opTitle
                    });
                    return false;
                }
                //artDialog提示框
                art.dialog({
                    content: document.getElementById("addQuesionContainer"),
                    padding: 0,
                    button: [
                    {
                        name: '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_uploadImg")%>',
                        callback: function () {
                            $("#uploadImg").click();
                            return false;
                        }
                    },
                    {
                        name: '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_gsbjq")%>',
                        callback: function () {
                            $("#mathquill").show();
                            return false;
                        }
                    },
                    {
                        name: '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_dete")%>',
                        callback: editQuestionInfo,
                        focus: true
                    },
                    {
                        name:'<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_Cancel")%>',
                        callback: function () {
                            $pageOpType.attr("opType", "-1"); //全局状态：表示添加
                        }
                    }
                    ],
                    lock: true,
                    opacity: 0.1,
                    title: opTitle
                });
                return false;

            }
            btnClickEvent = function (key) {//绑定单击按钮的单击事件
                createDialog(key);
            }
            //function bindEditAndDeleteEvent() {
            ///	<summary>
            ///     绑定编辑、删除按钮事件
            ///	</summary>
            ///	<returns type="void" />
            $(".editQp").live("click", function () { //编辑按钮
                //事件委托绑定
                var op_Id = $(this).attr("op_Id");
                if (op_Id && !isNaN(parseInt(op_Id))) {
                    var op_Index = parseInt(op_Id);
                    var context = ques[op_Index].Questions_Title + '\n';
                    if (ques[op_Index].Questions_OptionOne) context += ques[op_Index].Questions_OptionOne + '\n';
                    if (ques[op_Index].Questions_OptionTwo && ques[op_Index].Questions_QtId != 3) context += ques[op_Index].Questions_OptionTwo + '\n';
                    if (ques[op_Index].Questions_OptionThree && ques[op_Index].Questions_QtId != 3) context += ques[op_Index].Questions_OptionThree + '\n';
                    if (ques[op_Index].Questions_QtId != 3 && ques[op_Index].Questions_QtId != 4) {
                        if (ques[op_Index].Questions_OptionFour) context += ques[op_Index].Questions_OptionFour + '\n';
                        if (ques[op_Index].questions_OptionFive) context += ques[op_Index].questions_OptionFive + '\n';
                        if (ques[op_Index].Questions_OptionSix) context += ques[op_Index].Questions_OptionSix + '\n';
                        if (ques[op_Index].Questions_OptionSeven) context += ques[op_Index].Questions_OptionSeven + '\n';
                        if (ques[op_Index].Questions_OptionEight) context += ques[op_Index].Questions_OptionEight + '\n';
                        if (ques[op_Index].Questions_OptionNine) context += ques[op_Index].Questions_OptionNine + '\n';
                        if (ques[op_Index].Questions_OptionTen) context += ques[op_Index].Questions_OptionTen + '\n';

                    }
                    if (ques[op_Index].Questions_Answer) context += '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("answer")%>：' + ques[op_Index].Questions_Answer + '\n';
                    
                    if (ques[op_Index].Questions_Discription) context += '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_zssm")%>：' + ques[op_Index].Questions_Discription + '\n';
                    $pageOpType.attr("opType", parseInt(op_Index)); //表示修改模式
                    createDialog(null, context); //编辑
                }
                return false;
            });
            $(".deleteQp").live("click", function () { //删除按钮
                var op_Id = $(this).attr("op_Id");
                if (op_Id && !isNaN(parseInt(op_Id))) {
                    showConfirmMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_delwant")%>", function () {
                        ques.splice(parseInt(op_Id), 1);
                        if (ques.length > 0) {
                            $("#pc_View").html(getHtmlByQuestionsList(ques));
                            //bindEditAndDeleteEvent(); //绑定编辑和删除事件
                            return false;
                        }
                        $("#pc_View").html("");
                    });
                }
                return false;
            });
            //}
            savaAndToExamEvent = function () { //保存并生成试卷
                if (!ques || ques.length < 1) {
                    showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_notinfo")%>", 2000, 3);
                    return false;
                }
                $("#handleIcon").show(0);

                var errorNums = "";
                //检测数据是否都存在答案并且是否都合法
                for (var i = 0; i < ques.length; i++) {
                    reg = /([A-J]|[a-j])((.|、|,)*)/; //匹配答案是否正确
                    //错误
                     if ((!pageType && (!ques[i].Questions_Answer || ques[i].Questions_Answer.length < 1) || (!reg.test(ques[i].Questions_Answer) && ques[i].Questions_QtId != 3 && ques[i].Questions_QtId != 5)) || (ques[i].Questions_QtId != 3 && (!ques[i].Questions_OptionOne || ques[i].Questions_OptionOne.length < 1 || !ques[i].Questions_OptionTwo || ques[i].Questions_OptionTwo.length < 1))) {
                        errorNums += (i + 1) + '、';
                    } else {//正确
                        if (ques[i].Questions_Answer) {
                            ques[i].Questions_Answer = ques[i].Questions_Answer.toUpperCase(); //转换成大写
                            ques[i].Questions_Answer = ques[i].Questions_Answer.replace(/ /g, "").replace(/,/g, "").replace(/\./g, "").replace(/、/g, "");
                            if (ques[i].Questions_QtId != 3) ques[i].Questions_Answer = ques[i].Questions_Answer.split('').sort().toString().replace(/,/g, ''); //split分割ABCD这种无符号的字符串需要用''空引号来分割，否则分割不了，只会返回完整的字符串，血的教训
                        }
                    }
                }
                if (errorNums.length > 0) {
                    showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_jcNoIs")%>：" + errorNums + "<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_NotAnswer")%>", 5000, 3);
                    $("#handleIcon").fadeOut(200);
                    return;
                }
                $.ajax({
                    url: "SaveQuestionByEdit.ashx",
                    type: "post",
                    data: { "array": $.toJSON(ques), "pageType": pageType, "exKey": exKey },
                    dataType: "json",
                    success: function (data) {
                        $("#handleIcon").hide(0);
                        var resultStr = "";
                        if (data) {//不为空
                            if (data.error || data.error.length > 0) {//有异常
                                resultStr = data.error;
                            } else {
                                if (data.errorNums || data.errorNums.length > 0) { //存在题目未能录取成功
                                    resultStr = '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_NoIs")%>：' + data.errorNums + '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_lrsb")%>';
                                } else {
                                    if (data.examId || data.length > 0) {//试卷ID
                                        if (pageType) {
                                            var url = "/Training/QuesNaire/Questionnaire_Form.aspx?ExamKey=" + data.examId;
                                            top.openDialog(url, "ExaminationPaper_Form", "<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_wjinfo")%> - <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Edit")%> ", 750, 380, 50, 50); //录入试卷信息
                                            window.location="/Training/TrainingTest/ExaminationPaper_Manager.aspx";
                                        } else {
                                            var url = "/Training/TrainingTest/ExaminationPaper_Form.aspx?ExamKey=" + data.examId;
                                            top.openDialog(url, "ExaminationPaper_Form", "<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_info")%> - <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Edit")%> ", 750, 380, 50, 50); //录入试卷信息
                                            window.location="/Training/TrainingTest/ExaminationPaper_Manager.aspx";
                                        }
                                        return;
                                    } else {
                                        resultStr = <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_showExcep")%>;
                                    }
                                }
                            }
                            showTipsMsg(resultStr, 3000, 5);
                        }
                    },
                    error: function () {
                        showTipsMsg(" <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("File_Exam")%>", 3000, 5);
                        $("#handleIcon").fadeOut(200);
                    }
                });
                return false;
            }

            //阻止事件冒泡的通用函数  
            function stopBubble(e) {
                // 如果传入了事件对象，那么就是非ie浏览器  
                if (e && e.stopPropagation) {
                    //因此它支持W3C的stopPropagation()方法  
                    e.stopPropagation();
                } else {
                    //否则我们使用ie的方法来取消事件冒泡  
                    window.event.cancelBubble = true;
                }
            }
            //无参数获取Event对象方法 
            function GetEvent() {
                if (document.all) // IE
                {
                    return window.event;
                }
                func = GetEvent.caller; // 返回调用本函数的函数
                while (func != null) {
                    // Firefox 中一个隐含的对象 arguments，第一个参数为 event 对象
                    var arg0 = func.arguments[0];
                    // alert('参数长度：' + func.arguments.length);
                    if (arg0) {
                        if ((arg0.constructor == Event || arg0.constructor == MouseEvent) || (typeof (arg0) == "object" && arg0.preventDefault && arg0.stopPropagation)) {
                            return arg0;
                        }
                    }
                    func = func.caller;
                }
                return null;
            }

            //从题库中选择题目插入 update：2013年12月5日 16:24:23 author:jl
            btnClickChoiseQuestion = function (clickObj) {
                $("#choiseBody").html('<tr><td colspan="6" style="color:#32b775;"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_loading")%></td></tr>');
                $("#choiseQuestion").css({ left: clickObj.offsetLeft, top: clickObj.offsetTop + clickObj.offsetHeight }).show(300).click(function (e) {
                    stopBubble(e);
                });
                stopBubble(GetEvent());
                //加载结束
                if ($("#choiseQuesionTypeList>option").length <= 1) {//异步加载，然后不再加载
                    queryQuestionData({ "aT": 1 }, function (data) {
                        if (data) {
                            for (var i = 0; i < data.length; i++) {
                                $("#choiseQuesionTypeList").append("<option value='" + data[i].Value + "'>" + data[i].Name + "</option>");
                            }
                            bindChoiseEvent(1, "", "");
                        }
                    }, function () {
                        showTipsMsg(<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_webExcep")%>, 3000, 5);
                    });
                } else { //不进行异步加载则加载别的数据
                    $("#choiseQuestion").css({ left: clickObj.offsetLeft, top: clickObj.offsetTop + clickObj.offsetHeight }).show(300).click(function (e) {
                        stopBubble(e);
                    });
                    bindChoiseEvent(1, "", "");
                }
                $(document).click(function () {
                    $("#choiseQuestion").hide(300);
                });
            }
            $(".choiseTable tr").live("mouseenter", function () {//鼠标悬浮样式
                $(this).children("td").addClass("ciTdHover");
            }).live("mouseleave", function () {//鼠标移除样式
                $(this).children("td").removeClass("ciTdHover");
            });
            $(".choiseAllKey").click(function () {
                if (!$(this).attr("checked")) {
                    $(".choiseTable input[type=checkbox]").attr("checked", "checked");
                    $(this).attr("checked", "checked");
                } else {
                    $(".choiseTable input[type=checkbox]").removeAttr("checked");
                    $(this).removeAttr("checked", "checked");
                }
            });
            $("#choiseUpPage").click(function () {//上一页
                var upPage = parseInt($(this).attr('data'));
                bindChoiseEvent(upPage <= 1 ? 1 : upPage, $("#choiseQuesionTypeList").val(), jQuery.trim($("#choiseSearch").val()));
            });
            $("#choiseDownPage").click(function () {//下一页
                var downPage = parseInt($(this).attr('data'));
                var sumPage = parseInt($("#choiseSumCount").text());
                bindChoiseEvent(downPage >= sumPage ? sumPage : downPage, $("#choiseQuesionTypeList").val(), jQuery.trim($("#choiseSearch").val()));
            });
            $("#choiseFirstPage").click(function () {//首页
                bindChoiseEvent(1, $("#choiseQuesionTypeList").val(), jQuery.trim($("#choiseSearch").val()));
            });
            $("#choiseLastPage").click(function () {//尾页
                var sumData = parseInt($(this).attr('data'));
                bindChoiseEvent(sumData < 1 ? 1 : sumData, $("#choiseQuesionTypeList").val(), jQuery.trim($("#choiseSearch").val()));
            });
            $("#choiseSearch").keydown(function (e) {
                var event = e || event; //兼容性处理
                if (e.keyCode == 13) $("#searchChoiseInfo").click();
            });
            $("#searchChoiseInfo").click(function () { //搜索
                bindChoiseEvent(1, $("#choiseQuesionTypeList").val(), jQuery.trim($("#choiseSearch").val()));
            });
            $("#addChoiseQues").click(function () {
                var keyList = $("#choiseBody").find("input[checked=checked]"); //获取选种项
                if (keyList.length == 0) {
                    showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_selectitme")%>", 1500, 3);
                    return;
                }
                var keyStr = ""; //累加成'主键','主键'格式的字符串
                keyList.each(function () {
                    keyStr += "'" + $(this).val() + "',";
                });
                keyStr = keyStr.substring(0, keyStr.length - 1);
                queryQuestionData({ aT: 3, kL: keyStr }, function (data) {
                    $("#handleIcon").show(0);
                    //异步查询
                    if (data && parseInt(data) != -1) {
                        for (var i = 0; i < data.length; i++) {
                            //alert(item);
                            var item = new queObj(data[i].Questions_QtId, data[i].Questions_Title, data[i].Questions_OptionOne, data[i].Questions_OptionTwo, data[i].Questions_OptionThree, data[i].Questions_OptionFour, data[i].questions_OptionFive, data[i].Questions_OptionSix, data[i].Questions_OptionSeven, data[i].Questions_OptionEight, data[i].Questions_OptionNine, data[i].Questions_OptionTen, data[i].Questions_Answer, data[i].Questions_Discription, data[i].Questions_Id);
                            ques.push(item);
                        }
                        $("#pc_View").html(getHtmlByQuestionsList(ques));
                        $(document).click();
                        $("#handleIcon").hide(0);
                        showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_insertScu")%>", 3000, 4);
                    } else {
                        $("#handleIcon").hide(0);
                        showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_webExcep")%>", 3000, 5);                        
                    }
                });
            });
            function bindChoiseEvent(currIndex, quesTypekey, quesKeywords) {//绑定事件，这些事件每次加载完毕都得重新绑定，因为阻止了事件冒泡，所以无法用live绑定
                $("#choiseBody").html('<tr><td colspan="6" style="color:#32b775;"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_loading")%></td></tr>');
                if (quesTypekey == 'notChoise')
                    quesTypekey = '';
                //加载列表
                queryQuestionData({ "iD": currIndex, "tY": quesTypekey, "kW": quesKeywords }, function (data) {
                    if (data) {
                        var choiseBody = $("#choiseBody");
                        if (data.sumCount == 0) {
                            $("#choiseBody").html('<tr><td colspan="6" style="color:red;"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Nodata")%></td></tr>');                            
                            return;
                        }
                        //设置页码
                        $("#choiseCurrIndex").text(currIndex);
                        $("#choiseUpPage").attr('data', currIndex == 1 ? 1 : currIndex - 1);
                        $("#choiseDownPage").attr('data', currIndex >= data.sumCount ? data.sumCount : currIndex + 1);
                        $("#choiseSumCount").text(data.sumCount);
                        $("#choiseLastPage").attr('data', data.sumCount);
                        //循环数据
                        choiseBody.html('');
                        for (var i = 0; i < data.list.length; i++) {
                            choiseBody.append('<tr><td class="cohoiseKey"><input type="checkbox" value="' + data.list[i].Questions_Id + '" /></td><td class="choiseQuesTitle" title="'+data.list[i].Questions_Title.replace(/</g, '&lt').replace(/>/g, '&gt').replace(/'/g,'\'')+'">' + data.list[i].Questions_Title.replace(/</g, '&lt').replace(/>/g, '&gt').replace(/'/g,'\'') + '</td><td>' + data.list[i].Questions_DefaultScore + '</td><td>' + data.list[i].Questions_Discription.replace(/</g, '&lt').replace(/>/g, '&gt').replace(/'/g,'\'') + '</td><td>' + data.list[i].Questions_Answer.replace(/</g, '&lt').replace(/>/g, '&gt').replace(/'/g,'\'') + '</td><td data="' + data.list[i].Questions_Id + '">无</td></tr>');
                        }
                        //绑定一系列事件
                        $(".choiseTable tr:odd").children("td").addClass("ciTd");
                        $(".choiseTable tr:even").children("td").addClass("ciTds");
                        $("#choiseBody tr").unbind("click");
                        $("#choiseBody tr").bind("click", function () {
                            var inputObj = $(this).find("input");
                            if (inputObj.attr("checked")) {
                                inputObj.removeAttr("checked");
                                $(this).children("td").removeClass("ciTdCheck");
                            } else {
                                $(this).children("td").addClass("ciTdCheck");
                                inputObj.attr("checked", "checked");
                            }
                        });

                    } else {
                        showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_webExcep2")%>", 3000, 5);
                    }
                }, function () {
                    showTipsMsg("<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_webExcep2")%>", 3000, 5);
                });
            }
            function queryQuestionData(parm, callBack, errCallBack) {

                //可以从这里开始异步加载
                $.ajax({
                    url: "GetQuestionList.ashx",
                    type: "post",
                    data: parm,
                    dataType: "json",
                    success: function (data) {
                        callBack(data);
                    },
                    error: function () {
                        if (errCallBack) errCallBack();
                        else {
                            showTipsMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_webExcep")%>', 1500, 5);
                        }
                    }
                });
            }
            $('#btnSkipRandom').click(function () {
                showConfirmMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_prompt1")%><span style="color:red"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_prompt2")%></span>，<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_prompt3")%>', function () {
                    window.location = "/Training/TrainingTest/RandomMakeQues.aspx";
                });
                return false;
            });
            //还原数据
            <%=restore.ToString() %>
            imgLoad();
        });
    </script>
</head>
<body>
    <div class="btnbartitle" runat="server" data="" id="errorCode">
        <div>
            <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_entry")%>
        </div>
    </div>
    <div class="btnbarcontetn">
        <div style="float: left;">
            <a class="button green" onclick="btnClickChoiseQuestion(this)" title="<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_Choisetishi")%>"
                style="float: left;"><span class="icon-botton" style="background: url('/Themes/images/16/layout_add.png') no-repeat scroll 0px 4px;">
                </span><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_Choise")%> </a><a class="button green" id="btnSkipRandom" title="<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_Choisetz")%>"
                    style="float: left;"><span class="icon-botton" style="background: url('/Themes/images/16/arrow_switch_bluegreen.png') no-repeat scroll 0px 4px;">
                    </span><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_radom")%></a>
        </div>
        <div style="text-align: right">
            <uc1:LoadButton ID="LoadButton1" runat="server" />
        </div>
    </div>
    <div id="priviewContainer" pagetype="<%=pageType %>">
        <fieldset id="priviewContext">
            <legend><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Preview")%></legend>            
            <div id="priviewContent">
                <!--priviewStart--->
                <div id="pc_View">
                </div>
                <div id="choiseQuestion">
                    <div id="choiseWhere">
                        <span><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_fenlei")%></span>
                        <select id="choiseQuesionTypeList">
                            <option value="notChoise">不选择</option>
                        </select>
                        <input id="choiseSearch" /><a href="javascript:;" id="searchChoiseInfo">搜索题目</a>
                    </div>
                    <table class="choiseTable">
                        <thead class="choiseTitle">
                            <tr>
                                <th class="choiseAllKey">
                                </th>
                                <th class="choiseQuesTitle">
                                    <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Courseware_Script_Form_title")%>                                    
                                </th>
                                <th>
                                    <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_fenzhi")%>
                                </th>
                                <th>
                                    <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_tixing")%>
                                </th>
                                <th>
                                    <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("answer")%>
                                </th>
                                <th>
                                    <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Cz")%>                                    
                                </th>
                            </tr>
                        </thead>
                        <tbody id="choiseBody">
                        </tbody>
                    </table>
                    <div id="choisePage">
                        <a href="javascript:;" id="addChoiseQues"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_insert")%> </a>
                        <a href="javascript:;" id="choiseFirstPage"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Page_firstPage")%></a>
                        <a href="javascript:;" id="choiseUpPage" data="1"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Page_UpPage")%></a>
                        <span id="choiseCurrIndex">1</span>/<span id="choiseSumCount">1</span>
                        <a href="javascript:;" id="choiseDownPage" data="1"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Page_DownPage")%></a>
                        <a href="javascript:;" id="choiseLastPage" data="1"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Page_LastPage")%></a>
                    </div>
                </div>
                <!--PriviewEnd--->
            </div>
        </fieldset>
    </div>
    <div id="addQuesionContainer">
        <div id="questionForm">
            <textarea id="questionText" spellcheck="false"></textarea>
        </div>
        <%=rightPromptHtml %>
        <div class="clear">
            <form method="post" action="" id="uploadForm" enctype="multipart/form-data">
            <div id="uploadImgContainer">
                <span><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Ques_uploadImg")%>：</span><input type="file" name="imgFile" id="uploadImg" />
            </div>
            </form>
            <input type="hidden" id="page_OpType" optype="-1" opratertype="1" /><!--保存状态信息-->
        </div>
    </div>
    <div id="handleIcon"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("UserRight_chuli")%></div>
    <div id="mathquill" style="width: 600px; position: absolute; height: 300px; left: 0;
        bottom: 0; background-color: White; display: none; z-index: 9999;">
        <iframe src="/Training/TrainingTest/gs/mathdialog.html" width="600" height="300"
            scrolling="no" frameborder="0" style="padding: 0;"></iframe>
    </div>
</body>
</html>
