--[[

	文件名:
		scripts/config/editor/menus.lua
	说明:
		编辑器右键菜单注册文件
		此文件为测试功能，接口可能在将来的版本做较大修整
		
--]]

require("scripts.config.editor.things")

function make_functionInfo(name_, args_, func_)
	return {
		title = name_,
		args = {
			title = name_,
			caption = {"含义", "值"},
			args = args_,
		},
		target = func_,
	}
end

return 
{
	{
		-------------------------------------
	},
	{
		title	= "折叠/展开(&E)",
		target	= (function()
			codeFoldToggle()
		end),
	},
	{
		-------------------------------------
	},
	{
		title	= "插入触动函数(&I)",
		target	= {
			make_functionInfo(
				"弹窗(dialog)",
				{
					{"提示文本", "这是一条文本提示"},
					{"停留时间", "0"},
				},
				function(args_)
					return defaultInsertFunctionMethod(
						args_,
						'dialog',
						{
							'string',
							"number",
						}
					)
				end
			),
			make_functionInfo(
				"选项弹窗(dialogRet) 返回值:(文本)",
				{
					{"提示文本",		"这是一条文本提示"},
					{"默认按钮标题",	"默认按钮"},
					{"可选按钮1标题",	""},
					{"可选按钮2标题",	""},
					{"停留时间",		"0"},
				},
				function(args_)
					return defaultInsertFunctionMethod(
						args_,
						'dialogRet',
						{
							'string',
							'string',
							'string',
							'string',
							"number",
						}
					)
				end
			),
			make_functionInfo(
				"输入弹窗(dialogInput) 返回值:(文本, 文本)",
				{
					{"提示文本",				"这是一条文本提示"},
					{"编辑框1浅色提示",			"编辑框中提示"},
					{"编辑框2浅色提示(可选)",	""},
					{"确认按钮标题",			"确认"},
				},
				function(args_)
					local sel = getSelectedText()
					if #sel>0 then
						args_.args[1][2] = sel
					end
					ret = dialogPickArgs(args_)
					if ret then
						local str_tar = 'dialogInput('
						str_tar = str_tar..'"'..tostring(ret[1]):gsub('"', '\\"')..'", '
						str_tar = str_tar..'"'..tostring(ret[2]):gsub('"', '\\"')
						if #ret[3]>0 then
							str_tar = str_tar..'#'..tostring(ret[3]):gsub('"', '\\"')
						end
						str_tar = str_tar..'", '
						str_tar = str_tar..'"'..tostring(ret[4]):gsub('"', '\\"')..'")'
						if #sel>0 then
							replaceSelText(str_tar)
						else
							addText(str_tar)
						end
					end
					return 1
				end
			),
			make_functionInfo(
				"初始化(init)",
				{
					{"程序包名(BID)",		"0"},
					{"旋转方向",			"0"},
				},
				function(args_)
					defaultInsertFunctionMethod(
						args_,
						'init',
						{
							"string",
							"number",
						}
					)
				end
			),
			make_functionInfo(
				"触摸按下(touchDown)",
				{
					{"手指序号",			"0"},
					{"横(X轴)坐标位置",		"0"},
					{"纵(Y轴)坐标位置",		"0"},
				},
				function(args_)
					defaultInsertFunctionMethod(
						args_,
						'touchDown',
						{
							"number",
							"number",
							"number",
						}
					)
				end
			),
			make_functionInfo(
				"触摸移动(touchMove)",
				{
					{"手指序号",			"0"},
					{"横(X轴)坐标位置",		"0"},
					{"纵(Y轴)坐标位置",		"0"},
				},
				function(args_)
					defaultInsertFunctionMethod(
						args_,
						'touchDown',
						{
							"number",
							"number",
							"number",
						}
					)
				end
			),
			make_functionInfo(
				"触摸抬起(touchUp)",
				{
					{"手指序号",			"0"},
					{"横(X轴)坐标位置",		"0"},
					{"纵(Y轴)坐标位置",		"0"},
				},
				function(args_)
					defaultInsertFunctionMethod(
						args_,
						'touchUp',
						{
							"number",
							"number",
							"number",
						}
					)
				end
			),
			make_functionInfo(
				"输入文本(inputText)",
				{
					{"文本内容",			"需要输入的内容"},
				},
				function(args_)
					defaultInsertFunctionMethod(
						args_,
						'inputText',
						{
							"string",
						}
					)
				end
			),
			make_functionInfo(
				"获取颜色(getColor) 返回值:(数值)",
				{
					{"横(X轴)坐标位置",		"0"},
					{"纵(Y轴)坐标位置",		"0"},
				},
				function(args_)
					defaultInsertFunctionMethod(
						args_,
						'getColor',
						{
							"number",
							"number",
						}
					)
				end
			),
			make_functionInfo(
				"获取颜色(getColorRGB) 返回值:(数值, 数值, 数值)",
				{
					{"横(X轴)坐标位置",		"0"},
					{"纵(Y轴)坐标位置",		"0"},
				},
				function(args_)
					defaultInsertFunctionMethod(
						args_,
						'getColorRGB',
						{
							"number",
							"number",
						}
					)
				end
			),
			make_functionInfo(
				"等待延迟(mSleep)",
				{
					{"延迟毫秒数",			"1000"},
				},
				function(args_)
					defaultInsertFunctionMethod(
						args_,
						'mSleep',
						{
							"number",
						}
					)
				end
			),
			make_functionInfo(
				"区域模糊找色(findColorInRegionFuzzy) 返回值:(数值, 数值)",
				{
					{"需要找的颜色值",		"0xffffff"},
					{"寻找精度(1~100)",		"90"},
					{"左上X坐标",			"0"},
					{"左上Y坐标",			"0"},
					{"右下X坐标",			"0"},
					{"右下Y坐标",			"0"},
				},
				function(args_)
					defaultInsertFunctionMethod(
						args_,
						'findColorInRegionFuzzy',
						{
							"normal",
							"number",
							"number",
							"number",
							"number",
							"number",
						}
					)
				end
			),
			make_functionInfo(
				"区域模糊找图(findImageInRegionFuzzy) 返回值:(数值, 数值)",
				{
					{"找寻图片文件名",		"image.png"},
					{"寻找精度(1~100)",		"90"},
					{"左上X坐标",			"0"},
					{"左上Y坐标",			"0"},
					{"右下X坐标",			"0"},
					{"右下Y坐标",			"0"},
					{"忽略颜色(透明色)",	"0x000000"},
				},
				function(args_)
					defaultInsertFunctionMethod(
						args_,
						'findImageInRegionFuzzy',
						{
							"string",
							"number",
							"number",
							"number",
							"number",
							"normal",
						}
					)
				end
			),
			make_functionInfo(
				"区域多点找色(findMultiColorInRegionFuzzy) 返回值:(数值, 数值)",
				{
					{"需要找的颜色值",		"0xffffff"},
					{"周边点颜色参数",		""},
					{"寻找精度(1~100)",		"90"},
					{"左上X坐标",			"0"},
					{"左上Y坐标",			"0"},
					{"右下X坐标",			"0"},
					{"右下Y坐标",			"0"},
				},
				function(args_)
					defaultInsertFunctionMethod(
						args_,
						'findMultiColorInRegionFuzzy',
						{
							"normal",
							"string",
							"number",
							"number",
							"number",
							"number",
						}
					)
				end
			),
			make_functionInfo(
				"截图(snapshot)",
				{

					{"图片文件名",					"image.png.bmp.jpg"},
					{"左上X坐标",					"0"},
					{"左上Y坐标",					"0"},
					{"右下X坐标",					"0"},
					{"右下Y坐标",					"0"},
					{"JPG图片质量(0.01~1.00)",		"1.00"},
				},
				function(args_)
					defaultInsertFunctionMethod(
						args_,
						'snapshot',
						{
							"string",
							"number",
							"number",
							"number",
							"number",
							"number",
						}
					)
				end
			),
			make_functionInfo(
				"退出脚本(lua_exit)",{},
				function(args_)
					defaultInsertFunctionMethod(args_, 'lua_exit')
				end
			),
			make_functionInfo(
				"模拟主屏幕按键(pressHomeKey)",{},
				function(args_)
					defaultInsertFunctionMethod(args_, 'pressHomeKey')
				end
			),
			make_functionInfo(
				"双击主屏幕键(doublePressHomeKey)",{},
				function(args_)
					defaultInsertFunctionMethod(args_, 'doublePressHomeKey')
				end
			),
			make_functionInfo(
				"重置锁屏计时(resetIDLETimer)",{},
				function(args_)
					defaultInsertFunctionMethod(args_, 'resetIDLETimer')
				end
			),
			make_functionInfo(
				"手机震动(vibrator)",{},
				function(args_)
					defaultInsertFunctionMethod(args_, 'vibrator')
				end
			),
			make_functionInfo(
				"锁定设备(lockDevice)",{},
				function(args_)
					defaultInsertFunctionMethod(args_, 'lockDevice')
				end
			),
			make_functionInfo(
				"锁定状态(deviceIsLock) 返回值:(布尔) [该函数可以唤醒设备]",{},
				function(args_)
					defaultInsertFunctionMethod(args_, 'deviceIsLock')
				end
			),
			make_functionInfo(
				"解锁设备(unlockDevice)",{},
				function(args_)
					defaultInsertFunctionMethod(args_, 'unlockDevice')
				end
			),
		},
	},
	{
		-------------------------------------
	},
	{
		title = "函数列表(&F)",
		target = funcListPopup,
	},
	-- {
	-- 	-------------------------------------
	-- },
	-- {
	-- 	title = "扩展功能",
	-- 	target = {
	-- 		{
	-- 			title = "扩展功能1",
	-- 			target = function() msgbox("哪来的这么多功能？") end,
	-- 		},
	-- 		{
	-- 			title = "扩展功能2",
	-- 			target = function()msgbox("爱过")end,
	-- 		},
	-- 	},
	-- },
}

--[[
----------------------------------------------------------
	编辑器右键菜单接口格式说明
----------------------------------------------------------


{
	{
		title = "函数项",
		target = (function() msgbox("这里是一个函数项") end),
	},
	{
		title = "子菜单项",
		target = {
			{
				title = "子菜单中的项目1",
				target = {
					{
						title = "子菜单中的项目1中的1",
						target = (function() msgbox("这里 是子菜单中的项目1中的1 函数项") end),
					},
					{
						title = "子菜单中的项目1中的2",
						target = (function() msgbox("这里 是子菜单中的项目1中的2 函数项") end),
					},
				},
				title = "子菜单中的项目2",
				target = {
					{
						title = "子菜单中的项目2中的1",
						target = (function() msgbox("这里 是子菜单中的项目2中的1 函数项") end),
					},
					{
						title = "子菜单中的项目2中的2",
						target = (function() msgbox("这里 是子菜单中的项目2中的2 函数项") end),
					},
				},
				title = "子菜单中的项目3",
				target = (function() msgbox("这里 是子菜单中的项目3 函数项") end),
				},
			},
		},
	},
}

如果 @target 为一个函数，则菜单项被点击的时候会执行那个函数
如果 @target 为一个表，则菜单项可以建立一个子菜单，理论上可以建立无穷层菜单，然并卵


----------------------------------------------------------
--]]

--[[
----------------------------------------------------------
	接口函数列表
----------------------------------------------------------


	函数 msgbox(text)
		弹出一个显示有 (@参数 text - 文本型) 提示窗
		
	函数 writePasteboard(text)
		将 (@参数 text - 文本型) 写入系统剪贴板
		
	函数 readPasteboard()
		读取系统剪贴板内容
		@返回值: 文本型|nil - 当系统剪贴板中有文本之时，返回文本，否则返回 nil
		
	函数 inputBox([default, title])
		弹出一个输入提示窗，阻塞并返回
		@参数 default : 文本型 - 为文本框中默认存在的文本
		@参数 title : 文本型 - 为弹出窗口的标题
		@返回值: 文本型 - 最终的文本框中的文本内容
		
	函数 actionSheet([list])
		弹出一个选择表，阻塞并返回
		@参数 list : 表型 - 为一个顺序表，表中值类型为文本
		@返回值: 数值型 - 返回被用户选择的那个项的顺序编号

	函数 setSelectionStart(pos)
		设置框选开始的位置
		@参数 pos : 数值型 - 位置
	
	
	函数 setSelectionEnd(pos)
		设置框选结束的位置
		@参数 pos : 数值型 - 位置
	
	
	函数 setEmptySelection()
		清空框选
	
	
	函数 selectAll()
		文档全选
	
	
	函数 clearAll()
		文档内容清空
	
	
	函数 lineFromPosition(pos)
		获取位置所在行
		@参数 pos : 数值型 - 位置
		@返回值: 数值型 - 位置所在行（文档第一行为 0）
	
	
	函数 positionFromLine(line)
	函数 getLineStartPosition(line)
		获取某行开始的位置
		@参数 line : 数值型 - 行号
		@返回值: 数值型 - 行开始的位置
	
	
	函数 getLineEndPosition(line)
		获取某行末尾的位置
		@参数 line : 数值型 - 行号
		@返回值: 数值型 - 行开始的位置
	
	
	函数 getLineLength(line)
		获取某行的长度
		@参数 line : 数值型 - 行号
		@返回值: 数值型 - 行的字节数
	
	
	函数 getSelectionStart()
		获取框选开始的位置
		@返回值: 数值型 - 框选开始的位置
	
	
	函数 getSelectionStart()
		获取框选结束的位置
		@返回值: 数值型 - 框选结束的位置
	
	
	函数 getCurrentPos()
		获取当前光标所在位置
		@返回值: 数值型 - 当前光标所在位置
	
	
	函数 getTextInRange(sel_start, sel_end)
		获取范围中的文本
		@参数 sel_start : 数值型 - 开始的位置
		@参数 sel_end : 数值型 - 终止的位置
		@返回值: 文本型 - 位置 sel_start 到 sel_end 之间所有的文本
	
	
	函数 getSelectedText()
		获取框选的所有文本
		@返回值: 文本型 - 框选的开始和结束之间所有的文本
	
	
	函数 replaceSelText(str_rpl)
		替换框选的所有的文本
		@参数 str_rpl : 文本型 - 替换的文本
	
	
	函数 gotoPosition(pos)
		跳转到位置，会清除当前的框选以及影响滚动条
		@参数 pos : 数值型 - 需要跳转到的位置
	
	
	函数 codeFoldToggle()
		代码折叠开关
	
	
	函数 codeFoldContract()
		代码折叠
	
	
	函数 codeFoldExpand()
		代码折叠
	
	
	函数 getFuncList()
		获取词法分析出的当前文件的函数列表
		@返回值: 表型 | nil - 格式如下：
			{
				{位置1, 位置2, 位置3, ...},
				{函数名1, 函数名2, 函数名3, ...},
			}
			 | 假如词法分析尚未完成则返回 nil
	
	
	函数 dialogPickArgs(tab)
		弹出一个参数定义框
		@参数 tab : 表型 - 格式如下:
			{
				title = 窗口标题,
				caption = {表头键名, 表头值名},
				args = {
					{参数1名, 参数1默认值},
					{参数2名, 参数2默认值},
					{参数3名, 参数3默认值},
					{参数4名, 参数4默认值},
					...
				},
			}
		@返回值: 表型 - 格式如下:
			{
				参数1值,
				参数2值,
				参数3值,
				参数4值,
				...
			}
	
	
	函数 actionSheet(sheet[, align, title])
		弹出一个选择表
		@参数 sheet : 表型 - 格式如下:
			{
				第 1 项,
				第 2 项,
				第 3 项,
				第 4 项,
				...
			}
		@参数 align : 数值型 - 文本对齐方式 0为左对齐 1为右对齐 2为文本居中
		@参数 title : 文本型 - 窗口标题
		@返回值: 数值型 - 选择的项编号，从 1 开始，0 为未选择



----------------------------------------------------------
--]]