
function defaultInsertFunctionMethod(args_, func_name_, atype_)
	local sel = getSelectedText()
	if #args_.args>0 then
		if #sel>0 then
			args_.args[1][2] = sel
		end
		ret = dialogPickArgs(args_)
		if ret then
			local str_tar = func_name_..'('
			for i,v in ipairs(ret) do
				if atype_[i]=="string" then
					str_tar = str_tar..'"'..tostring(v):gsub('"', '\\"')..'", '
				elseif atype_[i]=="number" then
					str_tar = str_tar..(tonumber(v) or 0)..', '
				else
					str_tar = str_tar..v..', '
				end
				if i==#ret then
					str_tar = str_tar:sub(1, -3)
				end
			end
			str_tar = str_tar..')'
			if #sel>0 then
				replaceSelText(str_tar)
			else
				addText(str_tar)
			end
		end
	else
		if #sel>0 then
			replaceSelText(func_name_..'()')
		else
			addText(func_name_..'()')
		end
	end
	return 1
end

function funcListPopup()
	-- getFuncList 函数返回一张表
	-- 表中含有两张顺序表，分别记录 函数位置 和 函数名加参数列表
	-- 列表中的位置 不一定 是顺序排序的
	-- 假如词法分析尚未完成则返回 nil
	local fl = getFuncList()
	if fl then
		local pos_list = fl[1]
		local func_list = fl[2]
		local pos_map = {}
		local sorted_func_list = {}

		for i,v in ipairs(func_list) do
			-- 去除参数列表可能存在的空格并加上行标注
			func_list[i] = '第 '..string.format("%6d", lineFromPosition(pos_list[i]) + 1)..' 行:'..
			string.rep(' ', 16)..v:gsub(' ',''):gsub('\r',''):gsub('\n','')
			-- 创建一个位置列表映射
			pos_map[ pos_list[i] ] = i
		end

		-- 排序位置列表
		table.sort(pos_list, function(a, b)
			return a<b
		end)

		-- 通过位置列表的映射创建一个排序好的函数名列表
		for _,v in ipairs(pos_list) do
			table.insert(
				sorted_func_list,
				func_list[ pos_map[v] ]
			)
		end

		local sel = actionSheet(sorted_func_list, 0, "函数列表")
		if 0~=sel then
			-- 如果没有取消选择则跳转到所选位置
			gotoPosition(pos_list[sel])
		end
	end
end