/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.adminObj.client;

import java.util.Enumeration;
import java.util.EventListener;
import oracle.ewt.event.ListenerManager;
import oracle.sysman.emSDK.adminObj.client.ObjectEvent;
import oracle.sysman.emSDK.adminObj.client.ObjectListener;
import oracle.sysman.emSDK.adminObj.server.DataSourceUpdateException;
import oracle.sysman.emSDK.adminObj.server.Factory;
import oracle.sysman.emSDK.adminObj.server.InitFailureException;
import oracle.sysman.emSDK.adminObj.server.InsufficientInitException;
import oracle.sysman.emSDK.adminObj.server.ServerObject;
import oracle.sysman.emSDK.adminObj.server.ValidateException;
import oracle.sysman.vxx.VxxAuxFinalizeable;
import oracle.sysman.vxx.VxxAuxFinalizer;
import org.omg.CORBA.NO_IMPLEMENT;

public abstract class ClientObject
implements VxxAuxFinalizeable {
    private ServerObject m_srvObj;
    private Factory m_factory;
    private ListenerManager m_listenerManager;
    private VxxAuxFinalizeable m_f;

    public void doCleanUp() {
        if (this.m_factory != null && this.m_srvObj != null) {
            try {
                this.m_factory.releaseObject(this.m_srvObj);
            }
            catch (NO_IMPLEMENT nO_IMPLEMENT) {}
        }
        this.m_srvObj = null;
    }

    public void doFinalization() {
        this.doCleanUp();
    }

    public void setNextFinalizeable(VxxAuxFinalizeable finalizable) {
        this.m_f = finalizable;
    }

    public VxxAuxFinalizeable getNextFinalizeable() {
        return this.m_f;
    }

    protected void finalize() throws Throwable {
        if (this.m_factory != null && this.m_srvObj != null) {
            VxxAuxFinalizer.addFinalizeable(this);
        }
    }

    public String getType() {
        return "";
    }

    public void commit(boolean bReinitToReuse) throws ValidateException, InsufficientInitException, DataSourceUpdateException {
        if (this.m_srvObj == null) {
            return;
        }
        boolean create = this.isCreating();
        this.m_srvObj.commit(bReinitToReuse);
        if (create) {
            this.objectCreated();
        } else {
            this.objectModified();
        }
    }

    public void remove() throws DataSourceUpdateException {
        if (this.m_srvObj == null) {
            return;
        }
        this.m_srvObj.remove();
        this.objectRemoved();
    }

    public void revert() {
        if (this.m_srvObj == null) {
            return;
        }
        this.m_srvObj.revert();
    }

    public boolean isCreating() {
        if (this.m_srvObj == null) {
            return false;
        }
        return this.m_srvObj.isCreating();
    }

    public boolean sameDataSourceObject(ClientObject obj) {
        if (this.m_srvObj == null) {
            return false;
        }
        return this.m_srvObj.sameDataSourceObject(obj.m_srvObj);
    }

    public void addObjectListener(ObjectListener listener) {
        if (this.m_listenerManager == null) {
            this.m_listenerManager = new ListenerManager();
        }
        this.m_listenerManager.addListener((EventListener)listener);
    }

    public void removeObjectListener(ObjectListener listener) {
        if (this.m_listenerManager != null) {
            this.m_listenerManager.removeListener((EventListener)listener);
        }
    }

    protected ClientObject() {
    }

    protected ClientObject(Factory factory) {
        this.m_factory = factory;
    }

    protected void setFactory(Factory factory) {
        this.m_factory = factory;
    }

    protected Factory getFactory() {
        return this.m_factory;
    }

    protected void setServerObj(ServerObject srvObj) {
        this.m_srvObj = srvObj;
    }

    protected ServerObject getServerObj() {
        return this.m_srvObj;
    }

    protected boolean isModifiable() {
        return true;
    }

    String getRemoveWarning() {
        return this.m_srvObj.getRemoveWarning();
    }

    private void objectCreated() {
        if (this.m_listenerManager == null) {
            return;
        }
        Enumeration e = this.m_listenerManager.getListeners();
        if (e == null) {
            return;
        }
        ObjectEvent event = new ObjectEvent(this, 0);
        while (e.hasMoreElements()) {
            ObjectListener listener = (ObjectListener)e.nextElement();
            listener.objectCreated(event);
        }
    }

    private void objectModified() {
        if (this.m_listenerManager == null) {
            return;
        }
        Enumeration e = this.m_listenerManager.getListeners();
        if (e == null) {
            return;
        }
        ObjectEvent event = new ObjectEvent(this, 1);
        while (e.hasMoreElements()) {
            ObjectListener listener = (ObjectListener)e.nextElement();
            listener.objectModified(event);
        }
    }

    private void objectRemoved() {
        if (this.m_listenerManager == null) {
            return;
        }
        Enumeration e = this.m_listenerManager.getListeners();
        if (e == null) {
            return;
        }
        ObjectEvent event = new ObjectEvent(this, 2);
        while (e.hasMoreElements()) {
            ObjectListener listener = (ObjectListener)e.nextElement();
            listener.objectRemoved(event);
        }
    }

    public void setName(String name) {
        if (this.m_srvObj == null) {
            return;
        }
        this.m_srvObj.setName(name);
    }

    public String getName() {
        if (this.m_srvObj == null) {
            return null;
        }
        return this.m_srvObj.getName();
    }

    public void initialize(int initFlags) throws InitFailureException {
        if (this.m_srvObj == null) {
            return;
        }
        this.m_srvObj.initialize(initFlags);
    }
}

