/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.adminObj.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import oracle.ewt.EwtComponent;
import oracle.ewt.EwtContainer;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.splitter.Splitter;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.emSDK.adminObj.client.GuiException;
import oracle.sysman.emSDK.adminObj.client.GuiObject;
import oracle.sysman.emSDK.adminObj.client.PropertyPage;
import oracle.sysman.emSDK.adminObj.server.DataSourceUpdateException;
import oracle.sysman.emSDK.adminObj.server.InsufficientInitException;
import oracle.sysman.emSDK.adminObj.server.ValidateException;
import oracle.sysman.emSDK.client.appContainer.ImageLoader;
import oracle.sysman.emSDK.client.guiComponent.alert.AppAlert;
import oracle.sysman.emSDK.client.guiComponent.helpButton.HelpButton;
import oracle.sysman.emSDK.common.nls.MessageBundle;
import oracle.sysman.vtx.VtxPSButtonPanel;
import oracle.sysman.vtx.VtxWindowsUtil;
import oracle.sysman.vxx.VxxAuxFinalizeable;
import oracle.sysman.vxx.VxxAuxFinalizer;
import oracle.sysman.vxx.vxxt.VxxtTRACE;

public class PropertySheet
extends LWContainer
implements TabPanelListener,
WindowListener,
ActionListener,
VxxAuxFinalizeable {
    static short MODAL;
    static short MODELESS;
    static short EMBEDDED;
    private static MessageBundle m_msgBundle;
    private ImageLoader m_imgLoader;
    private BufferedFrame m_parentFrame;
    private Container m_parentPanel;
    private BufferedDialog m_dialog;
    private GuiObject m_object;
    private boolean m_modified = false;
    private boolean m_success = false;
    private short m_mode;
    private PushButton okButton;
    private PushButton cancelButton;
    private PushButton applyButton;
    private PushButton revertButton;
    private VxxAuxFinalizeable m_f;
    protected LWContainer clientPanel;
    private VtxPSButtonPanel buttonPanel = new VtxPSButtonPanel();
    private Component _content;
    private boolean m_okPressed;
    private ScrollBox m_scrollBox;
    private Splitter m_splitter;
    private GridBagLayout gridbag;
    private GridBagConstraints c;

    public PropertySheet(ImageLoader imgLoader) {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.clientPanel = new LWContainer();
        EwtContainer tempPanel = new EwtContainer();
        EwtContainer mainContainer = new EwtContainer();
        mainContainer.setLayout(new BorderLayout());
        this.m_imgLoader = imgLoader;
        this._content = this.createContent();
        if (this._content instanceof TabPanel) {
            ((TabPanel)this._content).addTabPanelListener((TabPanelListener)this);
        }
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        tempPanel.setLayout(this.gridbag);
        this.addComponent((Container)tempPanel, this._content, 10, 1, 1, 0, -1, -1, new Insets(0, 0, 4, 0), 0, 0, 1.0, 1.0);
        this.addComponent((Container)tempPanel, (Component)((Object)this.buttonPanel), 10, 1, 0, 0, -1, -1, new Insets(0, 0, 0, 0), 0, 0, 0.0, 0.0);
        this.m_splitter = new Splitter(true);
        this.m_splitter.add((Component)tempPanel);
        this.m_splitter.add((Component)this.clientPanel);
        this.m_splitter.setSizeRatio(0.8);
        mainContainer.add("Center", (Component)this.m_splitter);
        tempPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 0, 0, 0));
        mainContainer.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 5, 5, 5));
        ((Container)((Object)this)).add("Center", (Component)mainContainer);
        this.clientPanel.setVisible(false);
        this.setBackground(UIManager.getColor((Object)LookAndFeel.DARK_LOOK));
    }

    protected Component createContent() {
        return new TabPanel();
    }

    protected VtxPSButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public ImageLoader getLoaderForImage() {
        return this.m_imgLoader;
    }

    public TabPanel getTabPanel() {
        Component content = this.getContent();
        if (content instanceof TabPanel) {
            return (TabPanel)content;
        }
        return null;
    }

    public Component getContent() {
        return this._content;
    }

    private void internalInit(GuiObject object) {
        this.m_object = object;
        this.m_object.setPropertySheet(this);
        this.addButtons();
        this.addPages();
        this.enableButtons();
        if (this.m_object.getClientObject() != null && !this.m_object.isCreatingNew()) {
            this.m_object.setVisiblePages();
        }
    }

    public void setDialogTitle(String title) {
        if (this.m_dialog != null) {
            this.m_dialog.setTitle(title);
        }
    }

    public String getDialogTitle() {
        if (this.m_dialog != null) {
            return this.m_dialog.getTitle();
        }
        return "";
    }

    public void toFront() {
        if (this.m_dialog != null) {
            this.m_dialog.toFront();
        }
    }

    private void createDialog(boolean modal, BufferedFrame parent) {
        this.m_parentFrame = parent;
        this.m_parentPanel = null;
        Dimension size = this.m_object.getPreferredPageSize();
        this.setSize(size);
        this.m_dialog = new BufferedDialog((Frame)this.m_parentFrame, this.getDefaultDialogTitle(), modal);
        this.m_dialog.setLayout((LayoutManager)new BorderLayout());
        this.m_scrollBox = new ScrollBox((Component)((Object)this), 0, 0);
        this.m_dialog.add((Component)this.m_scrollBox, "Center");
        this.m_dialog.setResizable(this.m_object.arePagesResizable());
        this.m_dialog.setSize(size);
        this.m_dialog.addWindowListener(this);
        WindowUtils.centerWindow((Window)this.m_dialog, (Component)parent);
        if (this.m_object.getClientObject() != null && this.m_object.isCreatingNew()) {
            this.m_object.setVisiblePages();
        }
        this.m_dialog.setVisible(true);
    }

    public void createModal(GuiObject object, BufferedFrame parent) {
        VtxWindowsUtil.setCursor(3, (Component)parent);
        this.m_mode = MODAL;
        this.internalInit(object);
        this.createDialog(true, parent);
        VtxWindowsUtil.setCursor(0, (Component)parent);
    }

    public void createModeless(GuiObject object, BufferedFrame parent) {
        VtxWindowsUtil.setCursor(3, (Component)parent);
        this.m_mode = MODELESS;
        this.internalInit(object);
        this.createDialog(false, parent);
        VtxWindowsUtil.setCursor(0, (Component)parent);
    }

    public void createEmbedded(GuiObject object, Container panel) {
        VtxWindowsUtil.setCursor(3, (Component)panel);
        this.m_parentFrame = null;
        this.m_parentPanel = panel;
        this.m_mode = EMBEDDED;
        this.internalInit(object);
        if (this.m_parentPanel instanceof EwtComponent) {
            FixedBorderPainter borderPainter = new FixedBorderPainter(10, 10, 10, 10);
            ((EwtComponent)this.m_parentPanel).setBorderPainter((BorderPainter)borderPainter);
        }
        this.m_parentPanel.setLayout(new BorderLayout());
        this.m_parentPanel.add("Center", (Component)((Object)this));
        this.setSize(panel.getSize());
        VtxWindowsUtil.setCursor(0, (Component)panel);
    }

    private Dimension getAdjustedSize(int width, int height) {
        if (this.m_object != null) {
            Dimension min = this.m_object.getMinimumPageSize();
            width = Math.max(width, min.width);
            height = Math.max(height, min.height);
            Dimension max = this.m_object.getMaximumPageSize();
            if (max.width > 0) {
                width = Math.min(width, max.width);
            }
            if (max.height > 0) {
                height = Math.min(height, max.height);
            }
        }
        return new Dimension(width, height);
    }

    public void setSize(int width, int height) {
        Dimension dim = this.getAdjustedSize(width, height);
        super.setSize(dim.width, dim.height);
    }

    public void setSize(Dimension size) {
        super.setSize(this.getAdjustedSize(size.width, size.height));
    }

    public boolean reinit(GuiObject object) {
        int result;
        if (this.m_object == null || object == null) {
            return false;
        }
        boolean sameType = this.m_object.getClass() == object.getClass();
        boolean sameDB = true;
        if (this.m_modified && (result = this.interruptAlert()) == 1) {
            return false;
        }
        this.setObj(object);
        this.m_object.setPropertySheet(this);
        this.removeButtons();
        this.addButtons();
        this.replacePages();
        this.enableButtons();
        this.resetModified();
        this.m_object.setVisiblePages();
        return true;
    }

    protected boolean isModified() {
        return this.m_modified;
    }

    public boolean isObjectValid() {
        return this.m_object != null;
    }

    int getDlgMode() {
        return this.m_mode;
    }

    public boolean dismissPropertySheet() {
        if (this.m_object == null) {
            return true;
        }
        if (this.m_mode == EMBEDDED) {
            return false;
        }
        if (this.checkInterrupt()) {
            this.cleanup();
            return true;
        }
        return false;
    }

    public boolean checkInterrupt() {
        int nRet;
        return !this.m_modified || (nRet = this.interruptAlert()) != 4;
    }

    private int interruptAlert() {
        Object[] args = new Object[]{this.getDialogTitle()};
        String warningMsg = m_msgBundle.getMessage("2000", false, args);
        AppAlert alert = new AppAlert((Frame)VtxWindowsUtil.getFrame((Component)((Object)this)), 1, 7);
        alert.setMessage(warningMsg);
        int nResult = alert.runAlert();
        if (nResult == 1 && !this.commit(false)) {
            nResult = 4;
        }
        return nResult;
    }

    protected void cleanup() {
        TabPanel tabPanel;
        if (this.m_dialog != null) {
            this.m_dialog.dispose();
        }
        if ((tabPanel = this.getTabPanel()) != null) {
            int i = 0;
            while (i < tabPanel.getPageCount()) {
                ((PropertyPage)((Object)tabPanel.getPage(i).getContent())).cleanup();
                ++i;
            }
            tabPanel.removeAllPages();
        }
        this.m_object.setPropertySheet(null);
        this.m_object.doCleanUp();
        this.m_object = null;
    }

    public void selectPage(PropertyPage page) {
        if (this.getTabPanel() != null) {
            int i = 0;
            while (i < this.getTabPanel().getPageCount()) {
                TabPanelPage tpPage = this.getTabPanel().getPage(i);
                PropertyPage guiPage = (PropertyPage)((Object)tpPage.getContent());
                if (guiPage == page) {
                    tpPage.setSelected(true);
                    break;
                }
                ++i;
            }
        }
    }

    public void onOK() {
        boolean success = true;
        if (success) {
            this.updateAndClose();
        }
    }

    private void updateAndClose() {
        this.m_success = this.commit(false);
        if (this.m_success) {
            this.cleanup();
        }
    }

    public void onCancel() {
        this.cleanup();
    }

    public void onApply() {
        this.updateAndDisplay();
    }

    private void updateAndDisplay() {
        this.m_success = this.commit(true);
        if (!this.m_success) {
            return;
        }
        if (this.getTabPanel() != null) {
            PropertyPage page;
            int i = 0;
            while (i < this.getTabPanel().getPageCount()) {
                page = (PropertyPage)((Object)this.getTabPanel().getPage(i).getContent());
                if (page.getReinitOnApply()) {
                    page.setInitNeeded(true);
                }
                ++i;
            }
            page = (PropertyPage)((Object)this.getTabPanel().getSelectedPage().getContent());
            if (page.getReinitOnApply()) {
                page.reinitializePage();
            }
        }
        this.resetModified();
    }

    public void onRevert() {
        this.m_object.revertToOriginal();
        this.reinitPages();
        this.resetModified();
    }

    protected void updateObject() throws GuiException {
        if (this.getTabPanel() != null) {
            int i = 0;
            while (i < this.getTabPanel().getPageCount()) {
                PropertyPage page = (PropertyPage)((Object)this.getTabPanel().getPage(i).getContent());
                page.updateObject();
                ++i;
            }
        }
    }

    private boolean commit(boolean reinit) {
        BufferedFrame frame = VtxWindowsUtil.getFrame((Component)((Object)this));
        try {
            this.updateObject();
        }
        catch (GuiException e) {
            String msg = e.getMessage();
            if (msg != null && !msg.equals("")) {
                AppAlert alert = new AppAlert((Frame)frame, 0, 1);
                alert.setMessage(msg);
                alert.runAlert();
            }
            return false;
        }
        VtxWindowsUtil.setCursor(3, (Component)((Object)this));
        boolean error = false;
        String errorMsg = "";
        Throwable errorException = null;
        try {
            this.m_object.commit(reinit);
        }
        catch (InsufficientInitException e) {
            VxxtTRACE.out("need more initializaton!!  " + e.necessaryInit);
            e.printStackTrace();
            VtxWindowsUtil.setCursor(0, (Component)((Object)this));
            return false;
        }
        catch (ValidateException e) {
            errorMsg = e.reason;
            errorException = e;
            error = true;
        }
        catch (DataSourceUpdateException e) {
            errorMsg = e.reason;
            errorException = e;
            error = true;
        }
        if (error) {
            VtxWindowsUtil.setCursor(0, (Component)((Object)this));
            AppAlert alert = new AppAlert((Frame)VtxWindowsUtil.getFrame((Component)((Object)this)), 0, 1);
            alert.setMessage(errorMsg);
            alert.runAlert();
            return false;
        }
        VtxWindowsUtil.setCursor(0, (Component)((Object)this));
        return true;
    }

    public void tabPanelSelectionChanging(TabPanelEvent event) {
        if (this.getTabPanel() == null) {
            return;
        }
        TabPanelPage tpPage = this.getTabPanel().getSelectedPage();
        if (tpPage == null) {
            return;
        }
        PropertyPage page = (PropertyPage)((Object)tpPage.getContent());
        PropertyPage c = this.m_mode != EMBEDDED ? this.m_dialog : page;
        VtxWindowsUtil.setCursor(3, (Component)((Object)c));
    }

    public void tabPanelSelectionChanged(TabPanelEvent event) {
        if (this.getTabPanel() == null) {
            return;
        }
        TabPanelPage tpPage = this.getTabPanel().getSelectedPage();
        if (tpPage == null) {
            return;
        }
        PropertyPage page = (PropertyPage)((Object)tpPage.getContent());
        if (!page.isDisplayed()) {
            page.onCreatePage();
            page.setDisplayed(true);
        }
        page.onSetActive();
        PropertyPage c = this.m_mode != EMBEDDED ? this.m_dialog : page;
        VtxWindowsUtil.setCursor(0, (Component)((Object)c));
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okButton) {
            this.onOK();
        } else if (event.getSource() == this.cancelButton) {
            this.onCancel();
        } else if (event.getSource() == this.applyButton) {
            this.onApply();
        } else if (event.getSource() == this.revertButton) {
            this.onRevert();
        }
    }

    protected void addPage(PropertyPage page) {
        if (this.getTabPanel() != null) {
            this.getTabPanel().addPage(page.getTitle(), (Component)((Object)page));
        }
    }

    private void addPages() {
        int i = 0;
        while (i < this.m_object.getNumPages()) {
            PropertyPage page = this.m_object.createPageAt(i);
            this.addPage(page);
            ++i;
        }
    }

    private String getDefaultDialogTitle() {
        if (this.getObj() == null) {
            return "";
        }
        String title = "";
        if (this.getObj().getFullDisplayName() != null) {
            title = this.getObj().getFullDisplayName();
        } else {
            Object[] msgArgs = new Object[]{this.getObj().getDisplayName()};
            title = this.getObj().isCreatingNew() ? m_msgBundle.getMessage("3009", false, msgArgs) : m_msgBundle.getMessage("3013", false, msgArgs);
        }
        return title;
    }

    void notifyOfInitError(PropertyPage page, String errorText) {
        BufferedFrame frame;
        String msg = m_msgBundle.getMessage("2002", true);
        if (errorText != null && !errorText.equals("")) {
            msg = String.valueOf(msg) + "\n" + errorText;
        }
        if ((frame = VtxWindowsUtil.getFrame((Component)((Object)this))) == null) {
            frame = new BufferedFrame();
        }
        AppAlert alert = new AppAlert((Frame)frame, 1, 1);
        alert.setMessage(msg);
        alert.runAlert();
    }

    private void reinitPages() {
        if (this.getTabPanel() != null) {
            PropertyPage page;
            int i = 0;
            while (i < this.getTabPanel().getPageCount()) {
                page = (PropertyPage)((Object)this.getTabPanel().getPage(i).getContent());
                page.setObj(this.m_object);
                ++i;
            }
            page = (PropertyPage)((Object)this.getTabPanel().getSelectedPage().getContent());
            page.onSetActive();
        }
    }

    private void replacePages() {
        if (this.getTabPanel() != null) {
            int oldPageCount = this.getTabPanel().getPageCount();
            this.getTabPanel().freezeRepaints();
            int i = oldPageCount - 1;
            while (i >= 0) {
                this.getTabPanel().removePage(this.getTabPanel().getPage(i));
                --i;
            }
            this.getTabPanel().unfreezeRepaints();
            this.addPages();
            PropertyPage page = (PropertyPage)((Object)this.getTabPanel().getPage(0).getContent());
            page.onSetActive();
        }
    }

    protected PushButton addButton(String caption) {
        PushButton newButton = this.buttonPanel.addButton(caption);
        newButton.addActionListener((ActionListener)this);
        return newButton;
    }

    protected PushButton addOKButton() {
        this.okButton = this.addButton(m_msgBundle.getMessage("3003", false));
        return this.okButton;
    }

    protected PushButton addOKButton(String label) {
        this.okButton = this.addButton(label);
        return this.okButton;
    }

    protected PushButton addCancelButton() {
        this.cancelButton = this.addButton(m_msgBundle.getMessage("3004", false));
        return this.cancelButton;
    }

    protected PushButton addCancelButton(String label) {
        this.cancelButton = this.addButton(label);
        return this.cancelButton;
    }

    protected PushButton addApplyButton() {
        this.applyButton = this.addButton(m_msgBundle.getMessage("3005", false));
        return this.applyButton;
    }

    protected PushButton addApplyButton(String label) {
        this.applyButton = this.addButton(label);
        return this.applyButton;
    }

    protected PushButton addRevertButton() {
        this.revertButton = this.addButton(m_msgBundle.getMessage("3006", false));
        return this.revertButton;
    }

    protected PushButton addRevertButton(String label) {
        this.revertButton = this.addButton(label);
        return this.revertButton;
    }

    protected void addHelpButton() {
        HelpButton helpButton = new HelpButton();
        this.buttonPanel.addHelpButton((PushButton)helpButton);
    }

    protected void addButtons() {
        boolean creating = this.m_object.isCreatingNew();
        boolean modifiable = this.m_object.isModifiable();
        if (creating || modifiable) {
            if (creating) {
                this.okButton = this.addButton(m_msgBundle.getMessage("3008", false));
                this.addCancelButton();
            } else if (this.m_mode == EMBEDDED) {
                this.addApplyButton();
                this.addRevertButton();
            } else {
                this.addOKButton();
                this.addCancelButton();
                this.addApplyButton();
            }
        } else if (this.m_mode != EMBEDDED) {
            this.cancelButton = this.addButton(m_msgBundle.getMessage("3002", false));
        }
        this.addHelpButton();
    }

    private void removeButtons() {
        this.buttonPanel.removeAll();
    }

    void updateModifiedPage() {
        this.m_modified = false;
        if (this.getTabPanel() != null) {
            int i = 0;
            while (i < this.getTabPanel().getPageCount()) {
                PropertyPage page = (PropertyPage)((Object)this.getTabPanel().getPage(i).getContent());
                this.m_modified |= page.isModified();
                ++i;
            }
        }
        this.enableButtons();
    }

    protected void resetModified() {
        this.m_modified = false;
        if (this.getTabPanel() != null) {
            int i = 0;
            while (i < this.getTabPanel().getPageCount()) {
                PropertyPage page = (PropertyPage)((Object)this.getTabPanel().getPage(i).getContent());
                page.setModified(false);
                ++i;
            }
        }
        this.enableButtons();
    }

    protected void enableButtons() {
        if (this.applyButton != null) {
            this.applyButton.setEnabled(this.m_modified);
        }
        if (this.revertButton != null) {
            this.revertButton.setEnabled(this.m_modified);
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.cleanup();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    protected final void setObj(GuiObject object) {
        if (this.m_object != object && this.m_object != null) {
            this.m_object.doCleanUp();
        }
        this.m_object = object;
    }

    public GuiObject getObj() {
        return this.m_object;
    }

    public void doFinalization() {
        if (this.m_object != null) {
            this.m_object.doCleanUp();
        }
    }

    public void setNextFinalizeable(VxxAuxFinalizeable finalizable) {
        this.m_f = finalizable;
    }

    public VxxAuxFinalizeable getNextFinalizeable() {
        return this.m_f;
    }

    protected void finalize() {
        if (this.m_object != null) {
            VxxAuxFinalizer.addFinalizeable(this);
        }
    }

    private void addComponent(Container con, Component comp, int anchor, int fill, int gridheight, int gridwidth, int gridx, int gridy, Insets insets, int ipadx, int ipady, double weightx, double weighty) {
        this.c.anchor = anchor;
        this.c.fill = fill;
        this.c.gridheight = gridheight;
        this.c.gridwidth = gridwidth;
        this.c.gridx = gridx;
        this.c.gridy = gridy;
        this.c.insets = insets;
        this.c.ipadx = ipadx;
        this.c.ipady = ipady;
        this.c.weightx = weightx;
        this.c.weighty = weighty;
        this.gridbag.setConstraints(comp, this.c);
        con.add(comp);
    }

    protected Splitter getSplitter() {
        return this.m_splitter;
    }

    static {
        MODELESS = 1;
        EMBEDDED = (short)2;
        m_msgBundle = MessageBundle.getMessageBundle("Vto");
    }
}

