/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.appComponent;

import java.awt.Component;
import java.awt.Image;
import java.text.MessageFormat;
import oracle.ewt.EwtContainer;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.ImageStrip;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWMenuSeparator;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.sysman.emSDK.client.appComponent.BaseACCommandListener;
import oracle.sysman.emSDK.client.appContainer.Displayable;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.client.guiComponent.alert.AppAlert;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.ApplicationAdapter;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CheckboxMenuCommandItem;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandListener;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.MenuCommandItem;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.SystemCommandAdapter;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.ToolBarCommandButton;
import oracle.sysman.emSDK.client.guiComponent.selection.Selection;
import oracle.sysman.emSDK.client.guiComponent.selection.SelectionComponent;
import oracle.sysman.emSDK.client.guiComponent.selection.SelectionManager;
import oracle.sysman.emSDK.common.nls.MessageBundle;

public class BaseAppComponent
extends EwtContainer
implements Displayable,
SelectionComponent {
    private WebApplication m_container;
    private SystemCommandAdapter m_adapter;
    private SelectionManager m_selectionManager;
    private BaseACCommandListener m_listener;
    private static MessageBundle m_msgFile = MessageBundle.getMessageBundle("Vta");

    public BaseAppComponent(WebApplication w) {
        this.m_container = w;
    }

    protected void initClient() {
    }

    public final void init() {
        this.m_adapter = new SystemCommandAdapter(this.getContainer());
        this.getContainer().getCommandAdapter().addCommandListener(this.m_adapter);
        this.m_selectionManager = new SelectionManager();
        this.m_listener = new BaseACCommandListener(this);
        this.initClient();
        this.addDefaultHelpMenuItems(this.getContainer().getHelpMenu());
        this.addDefaultToolBarItems();
    }

    public Component getDisplay() {
        return this;
    }

    public boolean isExitAllowed() {
        return true;
    }

    public void destroy() {
        if (this.m_adapter != null) {
            this.getContainer().getCommandAdapter().removeCommandListener(this.m_adapter);
            this.m_adapter = null;
        }
        this.m_selectionManager = null;
    }

    public WebApplication getContainer() {
        return this.m_container;
    }

    public Image getImage(String strPartialUrl) {
        return this.getContainer().getImage(strPartialUrl);
    }

    public static BaseAppComponent getBaseAppComponent(Component child) {
        while (child != null) {
            if (child instanceof BaseAppComponent) {
                return (BaseAppComponent)((Object)child);
            }
            child = child.getParent();
        }
        return null;
    }

    public static Image getImage(String strPartialUrl, Component child) {
        BaseAppComponent BaseAppComponent2 = BaseAppComponent.getBaseAppComponent(child);
        if (BaseAppComponent2 == null) {
            return null;
        }
        return BaseAppComponent2.getImage(strPartialUrl);
    }

    public void addHelpBook(Class baseClass, String dirName, String baseName, String title) {
        this.getContainer().addHelpBook(baseClass, dirName, baseName, title);
    }

    public void showHelpContents() {
        this.getContainer().showHelpContents();
    }

    public void showHelpSearch() {
        this.getContainer().showHelpSearch();
    }

    public void showHelpTopic(String baseName, String topic) {
        this.getContainer().showHelpTopic(baseName, topic);
    }

    public ApplicationAdapter getCommandAdapter() {
        return this.m_adapter;
    }

    public void addMenu(LWMenu menu) {
        this.getContainer().addMenu(menu);
    }

    public void addToolBar(ToolBar toolBar) {
        this.getCommandAdapter().addToolBar(toolBar);
    }

    public void checkStandardMenus() {
    }

    public void addCommandListener(CommandListener l, String command) {
        this.getCommandAdapter().addCommandListener(l, command);
    }

    public void removeCommandListener(CommandListener l) {
        this.getCommandAdapter().removeCommandListener(l);
    }

    public void addCommandListener(CommandListener l, int commandId) {
        this.getCommandAdapter().addCommandListener(l, commandId);
    }

    public SelectionManager getSelectionManager() {
        return this.m_selectionManager;
    }

    public void setCurrentSelectionComponent(SelectionComponent selComp) {
        this.getSelectionManager().setCurrentSelectionComponent(selComp);
    }

    public Selection[] getSelectedItems() {
        return this.getSelectionManager().getAllSelections();
    }

    public Selection[] getAllSelections() {
        return this.getSelectionManager().getAllSelections();
    }

    public Selection[] getSelectionOfType(String type) {
        return this.getSelectionManager().getSelectionOfType(type);
    }

    protected String getAboutMenuText() {
        String strAbout = m_msgFile.getMessage("3022", false);
        return this.getAboutString(strAbout);
    }

    protected void showAboutBox() {
        String strAbout = m_msgFile.getMessage("3023", false);
        strAbout = this.getAboutString(strAbout);
        AppAlert alert = new AppAlert(this.getContainer().getFrame(), strAbout, 2, 1);
        alert.runAlert();
    }

    protected String getApplicationName() {
        return this.getContainer().getFrame().getTitle();
    }

    private String getAboutString(String strAboutFormat) {
        String strAppName = this.getApplicationName();
        return MessageFormat.format(strAboutFormat, strAppName);
    }

    public LWMenu getDefaultViewMenu() {
        String strView = m_msgFile.getMessage("3007", false);
        LWMenu viewMenu = new LWMenu(strView, new LWPopupMenu());
        this.addDefaultViewMenuItems(viewMenu);
        return viewMenu;
    }

    private void addDefaultViewMenuItems(LWMenu viewMenu) {
        String strToolBar = m_msgFile.getMessage("3024", false);
        String strStatusBar = m_msgFile.getMessage("3026", false);
        CheckboxMenuCommandItem itemToolBar = new CheckboxMenuCommandItem("3024", strToolBar);
        CheckboxMenuCommandItem itemStatusBar = new CheckboxMenuCommandItem("3026", strStatusBar);
        itemToolBar.setState(true);
        itemStatusBar.setState(true);
        if (viewMenu.getSubMenu().getContent().getComponentCount() > 0) {
            viewMenu.getSubMenu().add((Component)new LWMenuSeparator());
        }
        viewMenu.getSubMenu().add((Component)((Object)itemToolBar));
        viewMenu.getSubMenu().add((Component)((Object)itemStatusBar));
        this.addCommandListener((CommandListener)this.m_listener, "3024");
        this.addCommandListener((CommandListener)this.m_listener, "3026");
    }

    private void addDefaultHelpMenuItems(LWMenu helpMenu) {
        int nItems = helpMenu.getSubMenu().getContent().getComponentCount();
        String strContents = m_msgFile.getMessage("3016", false);
        String strSearch = m_msgFile.getMessage("3031", false);
        String strAbout = this.getAboutMenuText();
        helpMenu.getSubMenu().add((Component)((Object)new MenuCommandItem(101, strContents)), 0);
        helpMenu.getSubMenu().add((Component)((Object)new MenuCommandItem(102, strSearch)), 1);
        if (nItems > 0) {
            helpMenu.getSubMenu().add((Component)new LWMenuSeparator(), 2);
        }
        helpMenu.getSubMenu().add((Component)new LWMenuSeparator());
        helpMenu.getSubMenu().add((Component)((Object)new MenuCommandItem("3022", strAbout)));
        this.addCommandListener((CommandListener)this.m_listener, 101);
        this.addCommandListener((CommandListener)this.m_listener, 102);
        this.addCommandListener((CommandListener)this.m_listener, "3022");
    }

    protected LWMenuItem getLaunchURLMenuItem(String menuText, String strURL) {
        this.addCommandListener((CommandListener)this.m_listener, 107);
        return new MenuCommandItem(strURL, 107, menuText);
    }

    protected LWMenuItem getLaunchFileMenuItem(String menuText, String strLocalFileName) {
        this.addCommandListener((CommandListener)this.m_listener, 108);
        return new MenuCommandItem(strLocalFileName, 108, menuText);
    }

    private void addDefaultToolBarItems() {
        ToolBar t = new ToolBar();
        String strImage = "/oracle/sysman/emSDK/client/appComponent/images/help.gif";
        Image image = this.getImage(strImage);
        ImageStrip iset = new ImageStrip(image, 16);
        ToolBarCommandButton b = new ToolBarCommandButton("3016", 101, (ImageSet)iset);
        b.setHelpText(m_msgFile.getMessage("3059", false));
        t.addItem((ToolBarItem)b);
        this.getCommandAdapter().addToolBar(t);
    }
}

