/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.dataComponent.dataDrivenTree;

import java.awt.Component;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Vector;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.DataDrivenTree;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSource;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItemData;
import oracle.sysman.emSDK.common.nls.ImageBundle;
import oracle.sysman.vtx.VtxWindowsUtil;

public abstract class StaticItemSource
extends TreeDataSource {
    private Object m_monitor = new Object();
    private boolean m_monitorInUse = false;
    private static ImageBundle m_imgBundle;
    protected Vector m_items;
    protected boolean m_populated = false;

    public StaticItemSource(DataDrivenTree tree) {
        super(tree);
    }

    protected StaticItemSource() {
    }

    protected void init() {
        super.init();
        if (m_imgBundle == null) {
            m_imgBundle = new ImageBundle(this.getTree().getImageLoader(), "Vta");
        }
        Image img = this.getIcon();
        Image[] icons = new Image[]{img};
        this.setImageList(icons);
        this.setSorted(true);
    }

    protected Image getIcon() {
        if (m_imgBundle == null) {
            return null;
        }
        return m_imgBundle.getImage("2000");
    }

    protected final int internal_getItemCount() {
        this._checkForItemPopulation();
        if (this.m_items != null) {
            return this.m_items.size();
        }
        return 0;
    }

    protected Image getImage(int index) {
        Image[] icons = this.getImageList();
        return icons[0];
    }

    protected final Object internal_getData(int index) {
        String[] item = (String[])this.m_items.elementAt(index);
        return new TreeItemData(item[0], this.getImage(index));
    }

    protected final void internal_setData(int index, Object data) {
    }

    protected abstract DTreeItem internal_createStaticItem(String var1, String var2);

    protected final DTreeItem internal_createItem(DTreeDeferringParent parent, int index) {
        String[] item = (String[])this.m_items.elementAt(index);
        return this.internal_createStaticItem(item[0], item[1]);
    }

    protected abstract void populateItemList();

    protected void addItem(String label, String type) {
        String[] item = new String[]{label, type};
        if (this.isSorted()) {
            int index = this._findIndex(label);
            this.m_items.insertElementAt(item, index);
        } else {
            this.m_items.addElement(item);
        }
    }

    protected String getLabel(int index) {
        return ((String[])this.m_items.elementAt(index))[0];
    }

    protected String getType(int index) {
        return ((String[])this.m_items.elementAt(index))[1];
    }

    protected final void internal_clearData() {
        if (this.m_items != null) {
            OneDDataSourceEvent evt = new OneDDataSourceEvent((Object)this, 2002, 0, this.m_items.size());
            this.m_items = null;
            this.processEvent(evt);
        }
    }

    protected void internal_refetchData() {
        VtxWindowsUtil.setCursor(3, (Component)((Object)this.getTree()));
        this.m_items = null;
        this.m_populated = false;
        this._checkForItemPopulation();
        VtxWindowsUtil.setCursor(0, (Component)((Object)this.getTree()));
    }

    protected void internal_refreshData() {
        VtxWindowsUtil.setCursor(3, (Component)((Object)this.getTree()));
        String[] originalList = this.getOriginalList();
        this.m_items = null;
        this.m_populated = false;
        this._checkForItemPopulation();
        this.optimizeRefresh(originalList, this.getRefreshedList());
        VtxWindowsUtil.setCursor(0, (Component)((Object)this.getTree()));
    }

    private int _findIndex(String label) {
        int index = 0;
        Enumeration enumeration = this.m_items.elements();
        while (enumeration.hasMoreElements()) {
            String[] item = (String[])enumeration.nextElement();
            if (label.compareTo(item[0]) < 0) {
                return index;
            }
            ++index;
        }
        return index;
    }

    protected void _checkForItemPopulation() {
        block11: {
            Object object = this.m_monitor;
            synchronized (object) {
                if (this.m_monitorInUse) {
                    Object var2_3 = null;
                    return;
                }
                this.m_monitorInUse = true;
            }
            try {
                if (this.m_populated) break block11;
                this.m_items = new Vector();
                this.populateItemList();
                this.m_populated = true;
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                Object object2 = this.m_monitor;
                synchronized (object2) {
                    this.m_monitorInUse = false;
                }
                throw throwable;
            }
        }
        Object var2_4 = null;
        Object object = this.m_monitor;
        synchronized (object) {
            this.m_monitorInUse = false;
        }
    }

    protected boolean isPopulated() {
        return this.m_populated;
    }
}

