/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.dataComponent.dataDrivenTree;

import java.util.Vector;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.DataDrivenTree;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSource;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSourceInfo;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSourceRegistry;
import oracle.sysman.vxx.vxxt.VxxtTRACE;

public class TreeDataSourceLoader {
    private TreeDataSourceInfo[] m_dsInfoList;
    private DataDrivenTree m_tree;
    private TreeDataSourceRegistry m_registry;

    public TreeDataSourceLoader(DataDrivenTree tree, TreeDataSourceRegistry registry) {
        this.m_tree = tree;
        this.m_registry = registry;
        if (registry != null) {
            this._loadSources();
        }
    }

    private void _loadSources() {
        String appName = this.m_tree.getApplicationName();
        this.m_dsInfoList = this.m_registry.getNavigatorItems(appName);
    }

    private void _dumpRegistry() {
        System.out.println("Registered info:");
        int i = 0;
        while (i < this.m_dsInfoList.length) {
            System.out.println("\t" + this.m_dsInfoList[i].dataSource);
            System.out.println("\tContext:");
            int j = 0;
            while (j < this.m_dsInfoList[i].contextList.length) {
                System.out.println("\t\t" + this.m_dsInfoList[i].contextList[j]);
                ++j;
            }
            ++i;
        }
    }

    public Vector getRegisteredDataSourceItems(String nodeContext) {
        Vector<TreeDataSource> temp = new Vector<TreeDataSource>();
        if (this.m_dsInfoList == null) {
            return null;
        }
        int i = 0;
        while (i < this.m_dsInfoList.length) {
            if (this.m_dsInfoList[i].matchesContext(nodeContext)) {
                try {
                    TreeDataSource ds = (TreeDataSource)Class.forName(this.m_dsInfoList[i].dataSource).newInstance();
                    ds.setTree(this.m_tree);
                    temp.addElement(ds);
                }
                catch (ClassNotFoundException e) {
                    VxxtTRACE.out(e.getMessage());
                }
                catch (InstantiationException e) {
                    VxxtTRACE.out(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    VxxtTRACE.out(e.getMessage());
                }
            }
            ++i;
        }
        return temp;
    }
}

