/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.dataComponent.multiColumnWidget;

import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.button.PushButton;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.Grid;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.sysman.emSDK.client.dataComponent.multiColumnWidget.ExtractableSpreadTable;
import oracle.sysman.emSDK.client.guiComponent.alert.AppAlert;
import oracle.sysman.emSDK.client.guiComponent.helpButton.HelpButton;
import oracle.sysman.emSDK.client.guiComponent.util.BrowserLauncher;
import oracle.sysman.emSDK.common.nls.MessageBundle;
import oracle.sysman.vtx.VtxButtonPanel;
import oracle.sysman.vtx.VtxGBPanel;
import oracle.sysman.vxx.vxxt.VxxtTRACE;

public class ExtractDialog
extends BufferedDialog
implements ActionListener,
ItemListener,
TextListener,
WindowListener {
    static MessageBundle m_msgBundle = MessageBundle.getMessageBundle("EmSDK");
    static String m_extractIntoDirectory = null;
    static final int WIDTH = 375;
    static final int HEIGHT = 225;
    private final int PADDING = 6;
    static String DEFAULT_FILENAME = "extract.html";
    boolean m_cancelled = true;
    BufferedFrame m_parentFrame;
    private AppletContext m_appletContext;
    String m_HTMLTitle;
    ExtractableSpreadTable m_spreadTable;
    int[] m_selectedRows;
    private HelpButton m_helpButton;
    private PushButton m_cancelButton;
    private PushButton m_OKButton;
    EwtContainer m_whichFilePanel;
    LWTextField m_fileNameTextField;
    PushButton m_browseButton;
    VtxGBPanel m_whichRowsPanel;
    LWCheckboxGroup m_whichRowsGroup;
    LWCheckbox m_allRowsRadioButton;
    LWCheckbox m_selectedRowsRadioButton;
    EwtContainer m_whichFormatPanel;
    LWCheckboxGroup m_whichFormatGroup;
    LWCheckbox m_HTMLRadioButton;
    LWCheckbox m_textRadioButton;
    LWCheckbox m_CSVRadioButton;
    PushButton m_viewButton;
    ComboBox m_formatComboBox;
    int HTML_OPTION_INDEX;
    int TEXT_OPTION_INDEX;
    int CSV_OPTION_INDEX;
    private VtxGBPanel m_mainPanel;

    public ExtractDialog(BufferedFrame parentFrame, ExtractableSpreadTable spreadTable, AppletContext appletContext) {
        super((Frame)parentFrame, true);
        ((Dialog)((Object)this)).setTitle(this.getMsg("3050"));
        this.m_parentFrame = parentFrame;
        this.m_spreadTable = spreadTable;
        this.m_appletContext = appletContext;
        this.m_selectedRows = this.getGrid().getGridSelection().getSelectedRows();
        int selectedRowCount = 0;
        if (this.m_selectedRows != null) {
            selectedRowCount = this.m_selectedRows.length;
        }
        int fullRowCount = this.getGrid().getDataSource().getRowCount();
        String helpBook = "vtc";
        String helpTopic = "ExtractDialog";
        this.setHelpBook(helpBook);
        this.setHelpTopic(helpTopic);
        this.setLayout(new BorderLayout());
        ((Component)((Object)this)).setSize(375, 225);
        Toolkit toolKit = Toolkit.getDefaultToolkit();
        Dimension dimScreen = toolKit.getScreenSize();
        int x = dimScreen.width / 2 - ((Component)((Object)this)).getSize().width / 2;
        int y = dimScreen.height / 2 - ((Component)((Object)this)).getSize().height / 2;
        ((Component)((Object)this)).setBounds(x + 25, y + 25, ((Component)((Object)this)).getSize().width, ((Component)((Object)this)).getSize().height);
        this.m_mainPanel = new VtxGBPanel(new GridBagLayout());
        String nlsLabel = "";
        LWLabel fileNameLabel = new LWLabel(this.getMsg("3051"));
        this.m_mainPanel.add((Component)fileNameLabel, -1, -1, 1, 1, 0, 17, 0.0, 0.0, 20, 10, 0, 0);
        this.m_fileNameTextField = new LWTextField();
        if (m_extractIntoDirectory == null) {
            m_extractIntoDirectory = System.getProperty("user.dir");
        }
        this.setFileNameDefault(new File(m_extractIntoDirectory, DEFAULT_FILENAME).getAbsolutePath());
        this.m_mainPanel.add((Component)this.m_fileNameTextField, -1, -1, 1, 1, 2, 17, 1.0, 0.0, 20, 10, 0, 0);
        this.m_browseButton = new PushButton(this.getMsg("3052"));
        this.m_mainPanel.add((Component)this.m_browseButton, -1, -1, 0, 1, 0, 17, 0.0, 0.0, 20, 10, 0, 10);
        this.m_whichFormatGroup = new LWCheckboxGroup();
        LWLabel formatLabel = new LWLabel(this.getMsg("3053"));
        this.m_mainPanel.add((Component)formatLabel, -1, -1, 1, 1, 0, 17, 0.0, 0.0, 10, 10, 0, 0);
        this.m_formatComboBox = new ComboBox();
        this.m_formatComboBox.setEditable(false);
        this.m_formatComboBox.removeAll();
        this.m_formatComboBox.addItem(this.getMsg("3054"));
        this.HTML_OPTION_INDEX = 0;
        this.m_formatComboBox.addItem(this.getMsg("3055"));
        this.TEXT_OPTION_INDEX = 1;
        this.m_formatComboBox.addItem(this.getMsg("3056"));
        this.CSV_OPTION_INDEX = 2;
        this.m_mainPanel.add((Component)this.m_formatComboBox, -1, -1, 1, 1, 2, 17, 1.0, 0.0, 10, 10, 0, 0);
        this.m_viewButton = new PushButton(this.getMsg("3057"));
        this.m_mainPanel.add((Component)this.m_viewButton, -1, -1, 0, 1, 0, 17, 0.0, 0.0, 10, 10, 0, 10);
        this.m_whichRowsGroup = new LWCheckboxGroup();
        this.m_whichRowsPanel = new VtxGBPanel(new GridBagLayout());
        this.m_whichRowsPanel.setBorderPainter(UIManager.createGroupBoxPainter((String)this.getMsg("3058")));
        this.m_allRowsRadioButton = new LWCheckbox(this.getMsg("3059", String.valueOf(fullRowCount)), this.m_whichRowsGroup, true);
        String selectedRowsCaption = this.getMsg("3062");
        if (selectedRowCount > 0) {
            this.m_selectedRowsRadioButton = new LWCheckbox(this.getMsg("3063", String.valueOf(selectedRowCount)), this.m_whichRowsGroup, true);
        } else {
            this.m_selectedRowsRadioButton = new LWCheckbox(this.getMsg("3062"), this.m_whichRowsGroup, false);
            this.m_selectedRowsRadioButton.setEnabled(false);
        }
        this.m_whichRowsPanel.add((Component)this.m_allRowsRadioButton, -1, -1, 0, 1, 2, 17, 1.0, 0.0, 10, 10, 0, 0);
        this.m_whichRowsPanel.add((Component)this.m_selectedRowsRadioButton, -1, -1, 0, 1, 2, 17, 1.0, 0.0, 10, 10, 0, 0);
        this.m_mainPanel.add((Component)((Object)this.m_whichRowsPanel), -1, -1, 0, 1, 2, 18, 1.0, 0.0, 5, 10, 10, 10);
        LWLabel dummyLabel = new LWLabel("");
        this.m_mainPanel.add((Component)dummyLabel, -1, -1, 0, 0, 1, 18, 1.0, 1.0, 10, 10, 0, 0);
        ((Container)((Object)this)).add("Center", (Component)((Object)this.m_mainPanel));
        VtxButtonPanel buttonPanel = new VtxButtonPanel();
        this.m_OKButton = buttonPanel.add(this.getMsg("3060"));
        this.m_cancelButton = buttonPanel.add(this.getMsg("3061"));
        this.m_OKButton.setLeftmost(true);
        this.m_OKButton.setDefault(true);
        this.m_cancelButton.setRightmost(true);
        this.m_helpButton = new HelpButton();
        buttonPanel.add((Component)((Object)this.m_helpButton));
        ((Container)((Object)this)).add("South", (Component)((Object)buttonPanel));
        this.m_cancelButton.addActionListener((ActionListener)this);
        this.m_OKButton.addActionListener((ActionListener)this);
        this.m_browseButton.addActionListener((ActionListener)this);
        this.m_viewButton.addActionListener((ActionListener)this);
        this.m_fileNameTextField.addTextListener((TextListener)this);
        this.m_formatComboBox.addItemListener((ItemListener)this);
        this.m_allRowsRadioButton.addItemListener((ItemListener)this);
        this.m_selectedRowsRadioButton.addItemListener((ItemListener)this);
        ((Window)((Object)this)).addWindowListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_cancelButton) {
            this.m_cancelled = true;
            this.onDismiss();
        }
        if (e.getSource() == this.m_OKButton) {
            this.m_cancelled = false;
            this.onDismiss();
        }
        if (e.getSource() == this.m_browseButton) {
            this.onBrowseButton();
        }
        if (e.getSource() == this.m_fileNameTextField) {
            this.onFileNameChange();
        }
        if (e.getSource() == this.m_viewButton) {
            this.onViewButtonPressed();
        }
    }

    public void textValueChanged(TextEvent e) {
        if (e.getSource() == this.m_fileNameTextField) {
            this.onFileNameChange();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_formatComboBox) {
            this.onExtractTypeChange();
        }
    }

    public boolean wasCancelled() {
        return this.m_cancelled;
    }

    public boolean allRowsOption() {
        return this.m_allRowsRadioButton.getState();
    }

    public boolean formatHTMLOption() {
        return this.m_formatComboBox.getSelectedIndex() == this.HTML_OPTION_INDEX;
    }

    public boolean formatTextOption() {
        return this.m_formatComboBox.getSelectedIndex() == this.TEXT_OPTION_INDEX;
    }

    public boolean formatCSVOption() {
        return this.m_formatComboBox.getSelectedIndex() == this.CSV_OPTION_INDEX;
    }

    public void onFileNameChange() {
        String fileName = this.m_fileNameTextField.getText();
        if (this.hasGoodSuffix(fileName)) {
            String suffix = this.getSuffix(fileName);
            if (suffix.equals("html")) {
                this.m_formatComboBox.select(this.HTML_OPTION_INDEX);
            } else if (suffix.equals("txt")) {
                this.m_formatComboBox.select(this.TEXT_OPTION_INDEX);
            } else if (suffix.equals("csv")) {
                this.m_formatComboBox.select(this.CSV_OPTION_INDEX);
            }
            this.m_formatComboBox.repaint();
            this.m_viewButton.setEnabled(this.isViewable());
        }
    }

    public void onExtractTypeChange() {
        String fileName = this.m_fileNameTextField.getText();
        if (this.hasGoodSuffix(fileName)) {
            String prefix = this.stripGoodSuffix(fileName);
            if (this.formatHTMLOption()) {
                this.m_fileNameTextField.setText(String.valueOf(prefix) + ".html");
            } else if (this.formatTextOption()) {
                this.m_fileNameTextField.setText(String.valueOf(prefix) + ".txt");
            } else if (this.formatCSVOption()) {
                this.m_fileNameTextField.setText(String.valueOf(prefix) + ".csv");
            }
            this.m_fileNameTextField.repaint();
        }
        this.m_viewButton.setEnabled(this.isViewable());
    }

    private void onBrowseButton() {
        String strOutputFile = this.showFileSave(this.m_parentFrame, this.getMsg("3064"), this.m_fileNameTextField.getText());
        if (strOutputFile != null) {
            this.m_fileNameTextField.setText(strOutputFile);
            this.m_fileNameTextField.repaint();
            this.onFileNameChange();
        }
    }

    private void onDismiss() {
        if (this.m_cancelled) {
            ((Component)((Object)this)).setVisible(false);
        } else {
            this.extractAsRequested();
        }
        this.dispose();
    }

    private boolean isViewable() {
        return this.formatHTMLOption();
    }

    private void onViewButtonPressed() {
        if (!this.isViewable()) {
            VxxtTRACE.out("View button improperly enabled.");
            return;
        }
        String dir = System.getProperty("user.dir");
        String extractFile = String.valueOf(dir) + "/EM_temp.html";
        this.writeExtractFile(extractFile);
        BrowserLauncher.showFileInBrowser((Frame)this.m_parentFrame, this.m_appletContext, extractFile);
    }

    private String getMsg(String msgId) {
        return m_msgBundle.getMessage(msgId, false);
    }

    private String getMsg(String msgId, String parm0) {
        if (parm0 == null) {
            parm0 = "<null>";
        }
        Object[] args = new Object[]{parm0};
        return m_msgBundle.getMessage(msgId, false, args);
    }

    private String getMsg(String msgId, String parm0, String parm1) {
        if (parm0 == null) {
            parm0 = "<null>";
        }
        if (parm1 == null) {
            parm1 = "<null>";
        }
        Object[] args = new Object[]{parm0, parm1};
        return m_msgBundle.getMessage(msgId, false, args);
    }

    private String getMsg(String msgId, String parm0, String parm1, String parm2) {
        if (parm0 == null) {
            parm0 = "<null>";
        }
        if (parm1 == null) {
            parm1 = "<null>";
        }
        if (parm2 == null) {
            parm2 = "<null>";
        }
        Object[] args = new Object[]{parm0, parm1, parm2};
        return m_msgBundle.getMessage(msgId, false, args);
    }

    public void setFileNameDefault(String s) {
        this.m_fileNameTextField.setText(s);
    }

    public String getFileName() {
        return this.m_fileNameTextField.getText();
    }

    public void setHTMLTitle(String title) {
        this.m_HTMLTitle = title;
    }

    private String showFileSave(BufferedFrame parent, String strTitle, String strFile) {
        FileDialog fileDialog = new FileDialog((Frame)parent, strTitle, 0);
        fileDialog.setFile(strFile);
        if (m_extractIntoDirectory != null && m_extractIntoDirectory.length() > 0) {
            fileDialog.setDirectory(m_extractIntoDirectory);
        }
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return null;
        }
        m_extractIntoDirectory = fileDialog.getDirectory();
        return String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
    }

    private boolean hasGoodSuffix(String fileName) {
        String suffix = this.getSuffix(fileName);
        return suffix.indexOf(".") == -1;
    }

    private String stripGoodSuffix(String fileName) {
        int i = fileName.indexOf(".");
        if (i == -1) {
            return fileName;
        }
        return fileName.substring(0, i);
    }

    private String getSuffix(String fileName) {
        int i = fileName.indexOf(46);
        if (i == -1) {
            return "";
        }
        return fileName.substring(i + 1);
    }

    private void extractAsRequested() {
        String outputFileName = this.getFileName();
        if (outputFileName != null) {
            this.writeExtractFile(outputFileName);
            ((Component)((Object)this)).setVisible(false);
            AppAlert alert = new AppAlert((Frame)this.m_parentFrame, 2, 1);
            alert.setMessage("File " + outputFileName + " has been successfully written.");
            alert.runAlert();
        } else {
            ((Component)((Object)this)).setVisible(false);
        }
    }

    void writeExtractFile(String outputFileName) {
        if (this.allRowsOption()) {
            this.m_selectedRows = null;
        }
        if (this.m_HTMLTitle == null) {
            this.m_HTMLTitle = "*** Apps should set the title via setHTMLTitle method ***";
            VxxtTRACE.out("*** Apps should set the title via setHTMLTitle method ***");
        }
        BufferedWriter bufferedWriter = null;
        try {
            File outputFile = new File(outputFileName);
            bufferedWriter = new BufferedWriter(new FileWriter(outputFile));
            if (this.formatHTMLOption()) {
                this.saveAsHTML(bufferedWriter, this.m_selectedRows);
            } else if (this.formatCSVOption()) {
                this.saveAsCSV(bufferedWriter, this.m_selectedRows);
            } else {
                this.saveAsText(bufferedWriter, this.m_selectedRows);
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("IO Exception for " + outputFileName);
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException2) {}
        }
    }

    public boolean doSaveToFile(File f) {
        boolean rValue = false;
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(f));
            this.saveAsText(bw, null);
            bw.close();
            rValue = true;
        }
        catch (IOException iOException) {
            try {
                bw.close();
            }
            catch (IOException iOException2) {}
        }
        return rValue;
    }

    private void saveAsText(BufferedWriter bw, int[] rowSelection) throws IOException {
        int[] colWidths = this.getColumnWidths(rowSelection);
        this.saveHeaderToFile(bw, colWidths);
        this.saveMCWContentsToFile(rowSelection, bw, colWidths);
    }

    private int[] getColumnWidths(int[] rowSelection) {
        Grid g = this.getGrid();
        OneDDataSource headers = this.m_spreadTable.getColumnHeader().getDataSource();
        TwoDDataSource ds = g.getDataSource();
        int numCols = g.getColumnCount();
        int numRows = this.getRowCount(ds, rowSelection);
        int[] widths = new int[numCols];
        int col = 0;
        while (col < numCols) {
            if (g.isColumnVisible(col)) {
                Object headerTxt = headers.getData(col);
                widths[col] = headerTxt instanceof String ? ((String)headerTxt).length() : 1;
                int row = 0;
                while (row < numRows) {
                    int length = this.m_spreadTable.getCellValue(col, this.getCorrespRow(rowSelection, row)).length();
                    if (widths[col] < length) {
                        widths[col] = length;
                    }
                    ++row;
                }
            } else {
                widths[col] = -1;
            }
            ++col;
        }
        return widths;
    }

    private void saveHeaderToFile(BufferedWriter bw, int[] widths) throws IOException {
        OneDDataSource headers = this.m_spreadTable.getColumnHeader().getDataSource();
        StringBuffer headerLine = new StringBuffer();
        StringBuffer separator = new StringBuffer();
        int col = 0;
        while (col < widths.length) {
            if (this.getGrid().isColumnVisible(col) && widths[col] > 0) {
                int i;
                Object headerTxt = headers.getData(col);
                if (!(headerTxt instanceof String)) {
                    headerTxt = new String("?");
                }
                headerLine.append((String)headerTxt);
                int numSpc = widths[col] - ((String)headerTxt).length() + 6;
                if (numSpc > 0) {
                    i = 0;
                    while (i < numSpc) {
                        headerLine.append(" ");
                        ++i;
                    }
                }
                i = 0;
                while (i < widths[col] + 6) {
                    separator.append("-");
                    ++i;
                }
            }
            ++col;
        }
        bw.write(headerLine.toString());
        bw.newLine();
        bw.write(separator.toString());
        bw.newLine();
    }

    private void saveMCWContentsToFile(int[] rowSelection, BufferedWriter bw, int[] widths) throws IOException {
        TwoDDataSource ds = this.getGrid().getDataSource();
        int numRows = this.getRowCount(ds, rowSelection);
        int row = 0;
        while (row < numRows) {
            StringBuffer line = new StringBuffer();
            int col = 0;
            while (col < widths.length) {
                if (this.getGrid().isColumnVisible(col) && widths[col] > 0) {
                    String item = this.m_spreadTable.getCellValue(col, this.getCorrespRow(rowSelection, row));
                    if (item.length() > widths[col]) {
                        item = item.substring(0, widths[col]);
                    }
                    line.append(item);
                    int numSpc = widths[col] - item.length() + 6;
                    if (numSpc > 0) {
                        int i = 0;
                        while (i < numSpc) {
                            line.append(" ");
                            ++i;
                        }
                    }
                }
                ++col;
            }
            bw.write(line.toString());
            bw.newLine();
            ++row;
        }
    }

    private void saveAsCSV(BufferedWriter bw, int[] rowSelection) throws IOException {
        OneDDataSource columnHeaders = this.m_spreadTable.getColumnHeader().getDataSource();
        Object rowHeaders = null;
        TwoDDataSource rows = this.getGrid().getDataSource();
        Writer fw = null;
        try {
            if (rowHeaders != null) {
                bw.write("\"\",");
            }
            int i = 0;
            while (i < columnHeaders.getItemCount()) {
                if (this.getGrid().isColumnVisible(i)) {
                    bw.write("\"" + columnHeaders.getData(i) + "\"");
                    if (i != columnHeaders.getItemCount() - 1) {
                        bw.write(",");
                    }
                }
                ++i;
            }
            bw.write(System.getProperty("line.separator", "\n"));
            int rowCount = this.getRowCount(rows, rowSelection);
            int i2 = 0;
            while (i2 < rowCount) {
                if (rowHeaders != null) {
                    fw.write(String.valueOf(rowHeaders.getData(this.getCorrespRow(rowSelection, i2))) + ",");
                }
                int y = 0;
                while (y < rows.getColumnCount()) {
                    if (this.getGrid().isColumnVisible(y)) {
                        bw.write("\"" + this.m_spreadTable.getCellValue(y, this.getCorrespRow(rowSelection, i2)) + "\"");
                        if (y != rows.getColumnCount() - 1) {
                            bw.write(",");
                        }
                    }
                    ++y;
                }
                bw.write(System.getProperty("line.separator", "\n"));
                ++i2;
            }
        }
        finally {
            Object var8_11 = null;
            if (bw != null) {
                bw.close();
            }
        }
    }

    private void saveAsHTML(BufferedWriter bw, int[] rowSelection) throws IOException {
        OneDDataSource columnHeaders = this.m_spreadTable.getColumnHeader().getDataSource();
        TwoDDataSource rows = this.getGrid().getDataSource();
        Object fw = null;
        String newLine = System.getProperty("line.separator", "\n");
        try {
            bw.write("<TITLE> " + this.m_HTMLTitle + "</TITLE>");
            bw.write(newLine);
            bw.write("<H1> " + this.m_HTMLTitle + "</H1>");
            bw.write(newLine);
            bw.write("<TABLE BORDER>");
            bw.write(newLine);
            bw.write("<TR> ");
            int i = 0;
            while (i < columnHeaders.getItemCount()) {
                if (this.getGrid().isColumnVisible(i)) {
                    bw.write("<TH>" + columnHeaders.getData(i) + "</TH> ");
                }
                ++i;
            }
            bw.write("</TR>");
            bw.write(newLine);
            int rowCount = this.getRowCount(rows, rowSelection);
            bw.write("<TR> ");
            int i2 = 0;
            while (i2 < rowCount) {
                int y = 0;
                while (y < rows.getColumnCount()) {
                    if (this.getGrid().isColumnVisible(y)) {
                        bw.write("<TD>" + this.m_spreadTable.getCellValue(y, this.getCorrespRow(rowSelection, i2)) + "</TD> ");
                    }
                    ++y;
                }
                bw.write("</TR>");
                bw.write(newLine);
                ++i2;
            }
            bw.write("</TABLE>");
            bw.write(newLine);
        }
        finally {
            Object var8_11 = null;
            if (bw != null) {
                bw.close();
            }
        }
    }

    private int getRowCount(TwoDDataSource ds, int[] rowSelection) {
        if (rowSelection == null) {
            return ds.getRowCount();
        }
        return rowSelection.length;
    }

    private int getCorrespRow(int[] rowSelection, int i) {
        if (rowSelection == null) {
            return i;
        }
        return rowSelection[i];
    }

    private Grid getGrid() {
        return this.m_spreadTable.getGrid();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.onDismiss();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] argv) {
        BufferedFrame f = new BufferedFrame();
    }
}

