/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.guiComponent.alert;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Hashtable;
import oracle.ewt.alert.Alert;
import oracle.ewt.util.WindowUtils;

public class AppAlert
extends Alert {
    private static Hashtable m_titleTable = new Hashtable();
    private static int DEFAULT_TITLE = -11;

    public AppAlert(Frame parent, int alertType, int buttons) {
        super(parent, alertType, buttons);
        this.setTitle(alertType);
    }

    public AppAlert(Dialog parent, String message, int alertType, int buttons) {
        super(parent, message, alertType, buttons);
        this.setTitle(alertType);
    }

    public AppAlert(Frame parent, String message, int alertType, int buttons) {
        super(parent, message, alertType, buttons);
        this.setTitle(alertType);
    }

    private String getParentTitle() {
        Frame frame = WindowUtils.parentFrame((Component)((Object)this));
        if (frame != null) {
            return frame.getTitle();
        }
        return null;
    }

    public static void setAppAlertTitle(String defaultTitle) {
        AppAlert.putTitle(defaultTitle, DEFAULT_TITLE);
    }

    public static void setAppAlertTitle(String defaultTitle, int alertType) {
        AppAlert.putTitle(defaultTitle, alertType);
    }

    public static String getAppAlertTitle(int alertType) {
        String defaultTitle = AppAlert.getTitle(alertType);
        if (defaultTitle == null) {
            defaultTitle = AppAlert.getTitle(DEFAULT_TITLE);
        }
        return defaultTitle;
    }

    private void setTitle(int alertType) {
        String title = AppAlert.getAppAlertTitle(alertType);
        if (title == null) {
            title = this.getParentTitle();
        }
        if (title != null) {
            ((Dialog)((Object)this)).setTitle(title);
        }
    }

    private static synchronized void putTitle(String defaultTitle, int alertType) {
        if (AppAlert.getTitle(alertType) == null) {
            m_titleTable.put(new Integer(alertType), defaultTitle);
        }
    }

    private static synchronized String getTitle(int alertType) {
        Object o = m_titleTable.get(new Integer(alertType));
        return (String)o;
    }

    public int runAlert() {
        int button = super.runAlert();
        this.dispose();
        return button;
    }
}

