/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.guiComponent.commandAdapter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarActionListener;
import oracle.ewt.toolBar.ToolBarEvent;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandEvent;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandItem;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandListener;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.MnemonicUtils;

public class CommandAdapter
implements ActionListener,
ItemListener,
ToolBarActionListener,
CommandListener {
    private Vector CommandListeners = new Vector();
    private Vector toolBarActionListeners = new Vector();
    private WebApplication myContainer;
    private ToolBar toolBar;

    public CommandAdapter(WebApplication myContainer) {
        this.myContainer = myContainer;
    }

    public CommandAdapter(WebApplication myContainer, CommandListener listener) {
        this(myContainer);
        this.addCommandListener(listener);
    }

    public void addMenu(LWMenu menu) {
        this.registerEventForMenu(menu);
        this.myContainer.addMenu(menu);
    }

    private void registerEventForMenu(LWMenuItem item) {
        if (item instanceof LWMenu) {
            this.registerEventForMenu((LWMenu)item);
        } else if (item instanceof CommandItem) {
            item.addActionListener((ActionListener)this);
        }
    }

    private void registerEventForMenu(LWMenu menu) {
        if (menu instanceof CommandItem) {
            menu.addActionListener((ActionListener)this);
        }
        LWPopupMenu popupMenu = menu.getSubMenu();
        int count = 0;
        if (popupMenu != null) {
            count = popupMenu.getContent().getComponentCount();
        }
        int i = 0;
        while (i < count) {
            Component comp = popupMenu.getContent().getComponent(i);
            if (comp instanceof LWMenuItem) {
                this.registerEventForMenu((LWMenuItem)comp);
            }
            ++i;
        }
    }

    public void addMenus(LWMenu[] menu) {
        if (menu != null) {
            int i = 0;
            while (i < menu.length) {
                this.addMenu(menu[i]);
                ++i;
            }
        }
    }

    public void addToolBar(ToolBar toolBar) {
        this.toolBar = toolBar;
        this.myContainer.addToolBar(toolBar);
        this.myContainer.addToolBarActionListener(this);
    }

    public void checkStandardMenus() {
        LWMenu menu = null;
        int nMenu = 0;
        while (nMenu < 2) {
            switch (nMenu) {
                case 0: {
                    menu = this.myContainer.getFileMenu();
                    break;
                }
                case 1: {
                    menu = this.myContainer.getHelpMenu();
                    break;
                }
                default: {
                    menu = null;
                }
            }
            if (menu != null) {
                MnemonicUtils.processMnemonic(menu);
                this.registerEventForMenu(menu);
            }
            ++nMenu;
        }
    }

    public void addToolBarActionListener(ToolBarActionListener l) {
        this.toolBarActionListeners.addElement(l);
    }

    public void removeToolBarActionListener(ToolBarActionListener l) {
        this.toolBarActionListeners.removeElement(l);
    }

    public void addCommandListener(CommandListener t) {
        this.CommandListeners.addElement(t);
    }

    public void removeCommandListener(CommandListener t) {
        this.CommandListeners.removeElement(t);
    }

    public void toolBarItemActionPerformed(ToolBarEvent e) {
        if (e.getItem() instanceof CommandItem) {
            this.commandIssued(new CommandEvent(e));
        } else if (this.toolBarActionListeners.size() > 0) {
            Vector temp = (Vector)this.toolBarActionListeners.clone();
            Enumeration enumeration = this.toolBarActionListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ToolBarActionListener)enumeration.nextElement()).toolBarItemActionPerformed(e);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.commandIssued(new CommandEvent(e));
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof CommandItem) {
            this.commandIssued(new CommandEvent(e));
        }
    }

    private void deliverEvent(CommandEvent e) {
        if (this.CommandListeners.size() > 0) {
            Vector temp = (Vector)this.CommandListeners.clone();
            Enumeration enumeration = this.CommandListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((CommandListener)enumeration.nextElement()).commandIssued(e);
            }
        }
    }

    public void commandIssued(CommandEvent e) {
        this.deliverEvent(e);
    }
}

