/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.guiComponent.commandAdapter;

import java.util.Enumeration;
import java.util.StringTokenizer;
import oracle.ewt.button.PushButton;
import oracle.ewt.event.KeyStroke;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.tabBar.TabBarItem;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.ewt.util.StringUtils;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.EMMenuItemList;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.ProcessInfo;

public class MnemonicUtils {
    private static final String VK_ = "VK_";

    public static void processMnemonic(LWMenuBar bar) {
        MnemonicUtils.processMnemonic(new EMMenuItemList(bar).elements());
    }

    public static void processMnemonic(LWMenu menu) {
        MnemonicUtils.processMnemonic(new EMMenuItemList(menu).elements());
    }

    public static void processMnemonic(LWPopupMenu popup) {
        MnemonicUtils.processMnemonic(new EMMenuItemList(popup).elements());
    }

    public static void processMnemonic(LWMenuItem item) {
        MnemonicUtils.processMnemonic(new EMMenuItemList(item).elements());
    }

    private static void processMnemonic(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            MnemonicUtils.processMnemonicMenuItem((LWMenuItem)enumeration.nextElement());
        }
    }

    private static void processMnemonicMenuItem(LWMenuItem item) {
        String label = item.getLabel();
        if (MnemonicUtils.processMnemonic((LWComponent)item, label)) {
            item.setLabel(MnemonicUtils.getUnannotatedLabel(label));
        }
    }

    public static void processMnemonic(PushButton item) {
        String label = item.getLabel();
        if (MnemonicUtils.processMnemonic((LWComponent)item, label)) {
            item.setLabel(MnemonicUtils.getUnannotatedLabel(label));
        }
    }

    public static void processMnemonic(LWCheckbox item) {
        String label = item.getLabel();
        if (MnemonicUtils.processMnemonic((LWComponent)item, label)) {
            item.setLabel(MnemonicUtils.getUnannotatedLabel(label));
        }
    }

    public static void processMnemonic(LWLabel item) {
        String label = item.getText();
        if (MnemonicUtils.processMnemonic((LWComponent)item, label)) {
            item.setText(MnemonicUtils.getUnannotatedLabel(label));
        }
    }

    public static void processMnemonic(TabBarItem item) {
        String label = item.getLabel();
        ProcessInfo info = MnemonicUtils.getProcessInfo(label);
        if (item != null && info != null && info.m_index >= 0) {
            item.setMnemonicIndex(info.m_index);
            item.setLabel(MnemonicUtils.getUnannotatedLabel(label));
        }
    }

    public static void processMnemonic(TabPanelPage item) {
        String label = item.getLabel();
        ProcessInfo info = MnemonicUtils.getProcessInfo(label);
        if (item != null && info != null && info.m_index >= 0) {
            item.setMnemonicIndex(info.m_index);
            item.setLabel(MnemonicUtils.getUnannotatedLabel(label));
        }
    }

    private static boolean processMnemonic(LWComponent item, String label) {
        boolean changed = false;
        ProcessInfo info = MnemonicUtils.getProcessInfo(label);
        if (item != null && info != null) {
            if (info.m_index >= 0) {
                item.setMnemonicIndex(info.m_index);
                changed = true;
            }
            if (info.m_stroke != null && item instanceof LWMenuItem) {
                ((LWMenuItem)item).setAccelerator(info.m_stroke);
                changed = true;
            }
        }
        return changed;
    }

    private static ProcessInfo getProcessInfo(String label) {
        StringTokenizer st = new StringTokenizer(label, "\t");
        int index = -1;
        KeyStroke stroke = null;
        if (st.hasMoreElements()) {
            index = StringUtils.getMnemonicIndex((String)st.nextToken());
        }
        if (st.hasMoreElements()) {
            stroke = MnemonicUtils.getKeyStroke(st.nextToken(), false);
        }
        return new ProcessInfo(index, stroke);
    }

    public static String getUnannotatedLabel(String label) {
        StringTokenizer st;
        if (label != null && (st = new StringTokenizer(label, "\t")).hasMoreElements()) {
            label = StringUtils.stripMnemonic((String)st.nextToken());
        }
        return label;
    }

    private static KeyStroke getKeyStroke(String str, boolean maskRequired) {
        KeyStroke stroke = null;
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, "+");
            int mask = 0;
            boolean vkey = false;
            String tok = st.nextToken();
            while (st.hasMoreElements()) {
                mask |= MnemonicUtils.cvtStringToInputEventMask(tok);
                tok = st.nextToken();
            }
            if (!(tok == null || maskRequired && mask == 0)) {
                if (tok.length() == 1) {
                    stroke = new KeyStroke(tok.charAt(0), mask);
                } else {
                    int code = MnemonicUtils.cvtStringToKeyEventCode(tok);
                    if (code != 0) {
                        stroke = new KeyStroke(code, mask);
                    }
                }
            }
        }
        return stroke;
    }

    private static int cvtStringToInputEventMask(String str) {
        int code = MnemonicUtils.cvtStringToKeyEventCode(str);
        if (code == 16) {
            return 1;
        }
        if (code == 17) {
            return 2;
        }
        if (code == 18) {
            return 8;
        }
        if (code == 157) {
            return 4;
        }
        return 0;
    }

    private static int cvtStringToKeyEventCode(String str) {
        if ((str = str.toUpperCase()).startsWith(VK_)) {
            str = str.substring(VK_.length());
        }
        if (str.length() == 1) {
            char c = str.charAt(0);
            if (c >= '0' && c <= '9') {
                return c;
            }
            if (c >= 'A' && c <= 'Z') {
                return c;
            }
            switch (c) {
                case '`': {
                    return 192;
                }
                case '\\': {
                    return 92;
                }
                case ']': {
                    return 93;
                }
                case ',': {
                    return 44;
                }
                case '/': {
                    return 111;
                }
                case '=': {
                    return 61;
                }
                case '*': {
                    return 106;
                }
                case '[': {
                    return 91;
                }
                case '.': {
                    return 46;
                }
                case '\"': {
                    return 222;
                }
                case ';': {
                    return 59;
                }
                case ' ': {
                    return 32;
                }
                case '+': {
                    return 107;
                }
                case '-': {
                    return 109;
                }
            }
        }
        if (str.compareTo("ENTER") == 0) {
            return 10;
        }
        if (str.compareTo("BACK_SPACE") == 0) {
            return 8;
        }
        if (str.compareTo("TAB") == 0) {
            return 9;
        }
        if (str.compareTo("CANCEL") == 0) {
            return 3;
        }
        if (str.compareTo("CLEAR") == 0) {
            return 12;
        }
        if (str.compareTo("SHIFT") == 0) {
            return 16;
        }
        if (str.compareTo("CONTROL") == 0) {
            return 17;
        }
        if (str.compareTo("ALT") == 0) {
            return 18;
        }
        if (str.compareTo("PAUSE") == 0) {
            return 19;
        }
        if (str.compareTo("CAPS_LOCK") == 0) {
            return 20;
        }
        if (str.compareTo("ESCAPE") == 0) {
            return 27;
        }
        if (str.compareTo("SPACE") == 0) {
            return 32;
        }
        if (str.compareTo("PAGE_UP") == 0) {
            return 33;
        }
        if (str.compareTo("PAGE_DOWN") == 0) {
            return 34;
        }
        if (str.compareTo("END") == 0) {
            return 35;
        }
        if (str.compareTo("HOME") == 0) {
            return 36;
        }
        if (str.compareTo("LEFT") == 0) {
            return 37;
        }
        if (str.compareTo("UP") == 0) {
            return 38;
        }
        if (str.compareTo("RIGHT") == 0) {
            return 39;
        }
        if (str.compareTo("DOWN") == 0) {
            return 40;
        }
        if (str.compareTo("COMMA") == 0) {
            return 44;
        }
        if (str.compareTo("PERIOD") == 0) {
            return 46;
        }
        if (str.compareTo("SLASH") == 0) {
            return 47;
        }
        if (str.compareTo("SEMICOLON") == 0) {
            return 59;
        }
        if (str.compareTo("EQUALS") == 0) {
            return 61;
        }
        if (str.compareTo("OPEN_BRACKET") == 0) {
            return 91;
        }
        if (str.compareTo("BACK_SLASH") == 0) {
            return 92;
        }
        if (str.compareTo("CLOSE_BRACKET") == 0) {
            return 93;
        }
        if (str.compareTo("NUMPAD0") == 0) {
            return 96;
        }
        if (str.compareTo("NUMPAD1") == 0) {
            return 97;
        }
        if (str.compareTo("NUMPAD2") == 0) {
            return 98;
        }
        if (str.compareTo("NUMPAD3") == 0) {
            return 99;
        }
        if (str.compareTo("NUMPAD4") == 0) {
            return 100;
        }
        if (str.compareTo("NUMPAD5") == 0) {
            return 101;
        }
        if (str.compareTo("NUMPAD6") == 0) {
            return 102;
        }
        if (str.compareTo("NUMPAD7") == 0) {
            return 103;
        }
        if (str.compareTo("NUMPAD8") == 0) {
            return 104;
        }
        if (str.compareTo("NUMPAD9") == 0) {
            return 105;
        }
        if (str.compareTo("MULTIPLY") == 0) {
            return 106;
        }
        if (str.compareTo("ADD") == 0) {
            return 107;
        }
        if (str.compareTo("SEPARATER") == 0) {
            return 108;
        }
        if (str.compareTo("SUBTRACT") == 0) {
            return 109;
        }
        if (str.compareTo("DECIMAL") == 0) {
            return 110;
        }
        if (str.compareTo("DIVIDE") == 0) {
            return 111;
        }
        if (str.compareTo("F1") == 0) {
            return 112;
        }
        if (str.compareTo("F2") == 0) {
            return 113;
        }
        if (str.compareTo("F3") == 0) {
            return 114;
        }
        if (str.compareTo("F4") == 0) {
            return 115;
        }
        if (str.compareTo("F5") == 0) {
            return 116;
        }
        if (str.compareTo("F6") == 0) {
            return 117;
        }
        if (str.compareTo("F7") == 0) {
            return 118;
        }
        if (str.compareTo("F8") == 0) {
            return 119;
        }
        if (str.compareTo("F9") == 0) {
            return 120;
        }
        if (str.compareTo("F10") == 0) {
            return 121;
        }
        if (str.compareTo("F11") == 0) {
            return 122;
        }
        if (str.compareTo("F12") == 0) {
            return 123;
        }
        if (str.compareTo("DELETE") == 0) {
            return 127;
        }
        if (str.compareTo("NUM_LOCK") == 0) {
            return 144;
        }
        if (str.compareTo("SCROLL_LOCK") == 0) {
            return 145;
        }
        if (str.compareTo("PRINTSCREEN") == 0) {
            return 154;
        }
        if (str.compareTo("INSERT") == 0) {
            return 155;
        }
        if (str.compareTo("HELP") == 0) {
            return 156;
        }
        if (str.compareTo("META") == 0) {
            return 157;
        }
        if (str.compareTo("BACK_QUOTE") == 0) {
            return 192;
        }
        if (str.compareTo("QUOTE") == 0) {
            return 222;
        }
        if (str.compareTo("CTRL") == 0) {
            return 17;
        }
        if (str.compareTo("PLUS") == 0) {
            return 107;
        }
        if (str.compareTo("SEPARATER") == 0) {
            return 108;
        }
        if (str.compareTo("MINUS") == 0) {
            return 109;
        }
        if (str.compareTo("OPENBRACKET") == 0) {
            return 91;
        }
        if (str.compareTo("BACKSLASH") == 0) {
            return 92;
        }
        if (str.compareTo("CLOSEBRACKET") == 0) {
            return 93;
        }
        return 0;
    }
}

