/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.common.nls;

import java.awt.Image;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.ewt.graphics.ImageUtils;
import oracle.sysman.emSDK.client.appContainer.ImageLoader;
import oracle.sysman.vxx.vxxt.VxxtTRACE;

public class ImageBundle {
    private static int IMG_CACHE_SIZE = 100;
    private static Hashtable img_cache = new Hashtable();
    private ResourceBundle m_bundle;
    private ImageLoader m_imgCont;
    private String m_package = "oracle.sysman.resources";
    private Locale m_locale = Locale.getDefault();
    private String m_facility;

    public ImageBundle(String facility) {
        this(Locale.getDefault(), facility);
    }

    public ImageBundle(ImageLoader imgCont, String facility) {
        this(imgCont, Locale.getDefault(), facility);
    }

    public ImageBundle(Locale locale, String facility) {
        if (locale != null) {
            this.m_locale = locale;
        }
        this.m_facility = facility;
    }

    public ImageBundle(ImageLoader imgCont, Locale locale, String facility) {
        this.m_imgCont = imgCont;
        if (locale != null) {
            this.m_locale = locale;
        }
        this.m_facility = facility;
    }

    public ImageBundle(ImageLoader imgCont, Locale locale, String facility, String packageName) {
        this(imgCont, locale, facility);
        this.setPackage(packageName);
    }

    private Image checkImageCache(String key) {
        Image keyImage = null;
        Hashtable facCache = (Hashtable)img_cache.get(this.m_facility);
        if (facCache != null) {
            keyImage = (Image)facCache.get(key);
        }
        return keyImage;
    }

    private void addToImageCache(String key, Image image) {
        Hashtable<String, Image> facCache = (Hashtable<String, Image>)img_cache.get(this.m_facility);
        if (facCache == null) {
            facCache = new Hashtable<String, Image>();
            img_cache.put(this.m_facility, facCache);
        }
        facCache.put(key, image);
    }

    public Image getImage(String key) {
        Image img = this.checkImageCache(key);
        if (img != null) {
            return img;
        }
        String imgStr = null;
        try {
            this.loadBundle(false);
            imgStr = this.m_bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            VxxtTRACE.out("Could not find resource: " + key);
            return null;
        }
        img = this.getImageFromString(imgStr);
        if (img != null) {
            this.addToImageCache(key, img);
        }
        return img;
    }

    public Image getImageFromString(String imgStr) {
        if (this.m_imgCont == null) {
            return ImageUtils.getImageResource(this.getClass(), (String)imgStr);
        }
        return this.getImageFromString2(imgStr);
    }

    private Image getImageFromString2(String imgStr) {
        Class<?> baseClass;
        URL url;
        Image image = null;
        if (this.m_imgCont != null && (url = (baseClass = this.getClass()).getResource(imgStr)) != null) {
            image = this.m_imgCont.getImage(url);
        }
        if (image == null) {
            image = ImageUtils.getNotLoadedImage();
        }
        return image;
    }

    public String getImageFileName(String key) {
        String imgStr = null;
        try {
            this.loadBundle(false);
            imgStr = this.m_bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            VxxtTRACE.out("Could not find resource: " + key);
            return null;
        }
        return imgStr;
    }

    public synchronized String getPackage() {
        return this.m_package;
    }

    public synchronized void setPackage(String packageName) throws MissingResourceException {
        this.m_package = packageName;
        this.loadBundle(true);
    }

    private void loadBundle(boolean forceReload) {
        if (this.m_bundle == null || forceReload) {
            String resourceString = String.valueOf(this.m_package) + "." + this.m_facility + "Img";
            this.m_bundle = ResourceBundle.getBundle(resourceString, this.m_locale);
        }
    }
}

