/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.common.registry;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.emSDK.common.nls.MessageBundle;
import oracle.sysman.emSDK.common.registry.Entry;
import oracle.sysman.emSDK.common.registry.InvalidKeyException;
import oracle.sysman.emSDK.common.registry.NotFoundException;
import oracle.sysman.emSDK.common.registry.RegistryException;
import oracle.sysman.emSDK.common.registry.RegistryImplementationOperations;
import oracle.sysman.vxx.VxxPropertiesFile;

public abstract class PropertiesFileRegistry
implements RegistryImplementationOperations {
    private VxxPropertiesFile m_propFile;
    private String m_context = "";

    public String get(String key) throws NotFoundException, InvalidKeyException, RegistryException {
        this.validateInit();
        this.validateKey(key);
        String value = null;
        value = this.m_propFile.getProperty(key);
        if (value == null) {
            throw new NotFoundException();
        }
        return value;
    }

    public void put(String key, String val) throws InvalidKeyException, RegistryException {
        this.validateInit();
        this.validateKey(key);
        this.m_propFile.put(key, val);
    }

    public void removeKey(String key) throws NotFoundException, InvalidKeyException, RegistryException {
        this.validateInit();
        this.validateKey(key);
        Object obj = this.m_propFile.remove((Object)key, true);
        if (obj == null) {
            throw new NotFoundException();
        }
    }

    public Entry[] getSubtree(String rootKey) throws InvalidKeyException, RegistryException {
        this.validateInit();
        this.validateKey(rootKey);
        Vector<Entry> v = new Vector<Entry>();
        String subKey1 = String.valueOf(rootKey) + "/";
        String subKey2 = String.valueOf(rootKey) + "=";
        Enumeration e = this.m_propFile.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!PropertiesFileRegistry.containSubKey(key, subKey1, subKey2)) continue;
            String value = this.m_propFile.getProperty(key);
            key = key.substring(rootKey.length() + 1);
            Entry newEntry = new Entry(key, value);
            v.addElement(newEntry);
        }
        Object[] subTree = new Entry[v.size()];
        v.copyInto(subTree);
        return subTree;
    }

    public String[] getSubtreeKeys(String rootKey) throws InvalidKeyException, RegistryException {
        this.validateInit();
        this.validateKey(rootKey);
        Vector<String> v = new Vector<String>();
        String subKey1 = String.valueOf(rootKey) + "/";
        String subKey2 = String.valueOf(rootKey) + "=";
        Enumeration e = this.m_propFile.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!PropertiesFileRegistry.containSubKey(key, subKey1, subKey2)) continue;
            key = key.substring(rootKey.length() + 1);
            v.addElement(key);
        }
        Object[] subTree = new String[v.size()];
        v.copyInto(subTree);
        return subTree;
    }

    public void putSubtree(String rootKey, Entry[] entries) throws InvalidKeyException, RegistryException {
        this.validateInit();
        this.validateKey(rootKey);
        int i = 0;
        while (i < entries.length) {
            this.m_propFile.put(String.valueOf(rootKey) + "/" + entries[i].key, entries[i].val);
            ++i;
        }
    }

    public void removeSubtree(String rootKey) throws NotFoundException, InvalidKeyException, RegistryException {
        this.validateInit();
        this.validateKey(rootKey);
        String subKey1 = String.valueOf(rootKey) + "/";
        String subKey2 = String.valueOf(rootKey) + "=";
        Enumeration e = this.m_propFile.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!PropertiesFileRegistry.containSubKey(key, subKey1, subKey2)) continue;
            this.m_propFile.remove((Object)key, true);
        }
    }

    public String getRegistryNamingContext() throws RegistryException {
        return this.m_context;
    }

    public void saveRegistry() throws RegistryException {
        this.validateInit();
        try {
            this.m_propFile.save();
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageBundle m_msgBundle = MessageBundle.getMessageBundle("EmSDK");
            throw new RegistryException(m_msgBundle.getMessage("2039", false));
        }
        catch (IOException e) {
            throw new RegistryException(e.getMessage());
        }
    }

    public abstract String getRegistryName();

    public String getRegistryScope() {
        String location = null;
        try {
            location = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        return location;
    }

    void dump() {
        this.m_propFile.list(System.out);
    }

    protected PropertiesFileRegistry() {
    }

    protected PropertiesFileRegistry(String fileName) throws IOException {
        this.setPropertiesFile(fileName);
    }

    protected void setPropertiesFile(String fileName) throws IOException {
        this.m_propFile = new VxxPropertiesFile(fileName);
        this.m_propFile.setAutoCopy(true);
        this.m_propFile.load();
        this.m_propFile.setFileBanner(this.getRegistryName());
    }

    protected void setRegistryNamingContext(String nameContext) throws InvalidKeyException, RegistryException {
        this.validateKey(nameContext);
        this.m_context = nameContext;
    }

    private void validateInit() throws RegistryException {
        if (this.m_propFile == null) {
            MessageBundle m_msgBundle = MessageBundle.getMessageBundle("EmSDK");
            throw new RegistryException(m_msgBundle.getMessage("2040", false));
        }
    }

    private void validateKey(String key) throws InvalidKeyException {
    }

    private static boolean containSubKey(String key, String subKey1, String subKey2) {
        return key.startsWith(subKey1) || key.startsWith(subKey2);
    }
}

