/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.common.registry;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.emSDK.common.registry.Entry;
import oracle.sysman.emSDK.common.registry.ObjectContext;

public class RegistryObject {
    private ObjectContext m_ctxt;
    private String m_type;
    private String m_name;
    private Entry[] m_fields;

    public RegistryObject(ObjectContext ctxt, String objType, String objName, Entry[] objFields) {
        this.m_ctxt = this.overrideDefaultContext();
        this.setObjectDetails(objType, objName, objFields);
    }

    public String getObjectType() {
        return String.valueOf(this.m_ctxt.getContext()) + "/" + this.m_type;
    }

    public String getRawType() {
        return this.m_type;
    }

    public String getObjectName() {
        return String.valueOf(this.m_ctxt.getContext()) + "/" + this.m_type + "/" + this.m_name;
    }

    public String getRawName() {
        return this.m_name;
    }

    public Entry[] getObjectFields() {
        return this.m_fields;
    }

    public void setObjectContext(ObjectContext ctxt) {
        this.m_ctxt = ctxt;
    }

    protected RegistryObject() {
        this.m_ctxt = this.overrideDefaultContext();
    }

    protected ObjectContext overrideDefaultContext() {
        return ObjectContext.CONTEXT_OEM_SYSTEM;
    }

    protected void setObjectDetails(String objType, String objName, Entry[] objFields) {
        this.m_type = objType;
        this.m_name = objName;
        this.m_fields = objFields;
    }

    RegistryObject(ObjectContext ctxt, String objName, Entry[] fields) {
        this.m_fields = fields;
        this.m_ctxt = ctxt;
        objName = RegistryObject.stripContext(ctxt, objName);
        int nameIndex = objName.lastIndexOf("/");
        this.m_name = objName.substring(nameIndex + 1);
        this.m_type = objName.substring(0, nameIndex);
    }

    static RegistryObject[] parseObjectSubtree(ObjectContext ctxt, String objType, Entry[] raw) {
        Vector objects;
        String name;
        Hashtable names = new Hashtable();
        int i = 0;
        while (i < raw.length) {
            int nameIndex = raw[i].key.lastIndexOf("/");
            String field = raw[i].key.substring(nameIndex + 1);
            name = raw[i].key.substring(0, nameIndex);
            objects = (Vector)names.get(name);
            if (objects == null) {
                objects = new Vector();
            }
            Entry obj = new Entry(field, raw[i].val);
            objects.addElement(obj);
            names.put(name, objects);
            ++i;
        }
        RegistryObject[] roa = new RegistryObject[names.size()];
        Object[] fields = null;
        int i2 = 0;
        Enumeration enumeration = names.keys();
        while (enumeration.hasMoreElements()) {
            name = (String)enumeration.nextElement();
            objects = (Vector)names.get(name);
            fields = new Entry[objects.size()];
            objects.copyInto(fields);
            roa[i2] = new RegistryObject(ctxt, objType, name, (Entry[])fields);
            ++i2;
        }
        return roa;
    }

    private static String stripContext(ObjectContext ctxt, String key) {
        String context = ctxt.getContext();
        System.out.println("stripContext: key is " + key);
        System.out.println("stripContext: key.length is " + key.length());
        System.out.println("stripContext: ctxt is " + context);
        System.out.println("stripContext: context.length is " + context.length());
        return key.substring(context.length() + 1, key.length());
    }

    public void dump() {
        System.out.println("Registry Object: context = " + this.m_ctxt.getContext() + " type = " + this.m_type + " name = " + this.m_name);
        int i = 0;
        while (i < this.m_fields.length) {
            System.out.println("  " + this.m_fields[i].key + " = " + this.m_fields[i].val);
            ++i;
        }
    }
}

