/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vtx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import oracle.sysman.vtx.VtxAssert;
import oracle.sysman.vtx.VtxOrientation;

public class VtxButtonRowLayout
implements LayoutManager {
    private static int _defaultGap = 10;
    private int gap;
    private VtxOrientation verticalOrientation;
    private VtxOrientation horizontalOrientation;

    public VtxButtonRowLayout() {
        this(VtxOrientation.CENTER, VtxOrientation.CENTER, _defaultGap);
    }

    public VtxButtonRowLayout(int gap) {
        this(VtxOrientation.CENTER, VtxOrientation.CENTER, gap);
    }

    public VtxButtonRowLayout(VtxOrientation horizontalOrient, VtxOrientation verticalOrient) {
        this(horizontalOrient, verticalOrient, _defaultGap);
    }

    public VtxButtonRowLayout(VtxOrientation horizontalOrient, VtxOrientation verticalOrient, int gap) {
        boolean validArgs = !(gap < 0 || horizontalOrient != VtxOrientation.LEFT && horizontalOrient != VtxOrientation.CENTER && horizontalOrient != VtxOrientation.RIGHT || verticalOrient != VtxOrientation.TOP && verticalOrient != VtxOrientation.CENTER && verticalOrient != VtxOrientation.BOTTOM);
        VtxAssert.notFalse(validArgs);
        this.gap = gap;
        this.verticalOrientation = verticalOrient;
        this.horizontalOrientation = horizontalOrient;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = this.layoutSize(target, false);
        return dim;
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension dim = this.layoutSize(target, true);
        return dim;
    }

    public void layoutContainer(Container target) {
        Component comp;
        Insets insets = target.getInsets();
        int top = insets.top;
        int left = insets.left;
        int numComp = target.getComponentCount();
        int numVisibleComp = 0;
        Dimension targetSize = target.getSize();
        int i = 0;
        while (i < numComp) {
            comp = target.getComponent(i);
            if (comp.isVisible()) {
                ++numVisibleComp;
            }
            ++i;
        }
        Dimension dim = this.layoutSize(target, false);
        int buttonWidth = numVisibleComp == 0 ? 0 : (dim.width - insets.left - insets.right - numVisibleComp * this.gap) / numVisibleComp;
        int totButtonWidth = (buttonWidth + this.gap) * numVisibleComp;
        int buttonHeight = dim.height - insets.top - insets.bottom;
        if (this.horizontalOrientation == VtxOrientation.CENTER) {
            left += (targetSize.width - insets.left - insets.right - totButtonWidth) / 2;
        } else if (this.horizontalOrientation == VtxOrientation.RIGHT) {
            left += targetSize.width - insets.left - insets.right - totButtonWidth;
        }
        left += this.gap / 2;
        if (this.verticalOrientation == VtxOrientation.CENTER) {
            top += (targetSize.height - insets.top - insets.bottom - buttonHeight) / 2;
        } else if (this.verticalOrientation == VtxOrientation.BOTTOM) {
            top += targetSize.height - insets.top - insets.bottom - buttonHeight;
        }
        int i2 = 0;
        while (i2 < numComp) {
            comp = target.getComponent(i2);
            if (comp.isVisible()) {
                comp.setBounds(left, top, buttonWidth, buttonHeight);
                left += buttonWidth + this.gap;
            }
            ++i2;
        }
    }

    private Dimension layoutSize(Container parent, boolean minimum) {
        Insets insets = parent.getInsets();
        int n = parent.getComponentCount();
        int maxW = 0;
        int maxH = 0;
        int i = 0;
        while (i < n) {
            Component c = parent.getComponent(i);
            Dimension d = minimum ? c.getMinimumSize() : c.getPreferredSize();
            maxW = Math.max(maxW, d.width);
            maxH = Math.max(maxH, d.height);
            ++i;
        }
        int width = insets.left + insets.right + (maxW + this.gap) * n;
        int height = insets.top + insets.bottom + maxH;
        return new Dimension(width, height);
    }
}

