/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vtx;

import java.util.Vector;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.sysman.vdb.VdbCachedResultSet;
import oracle.sysman.vdb.VdbCachedResultSetClient;
import oracle.sysman.vdb.VdbCachedResultSetClientOperations;
import oracle.sysman.vdb._tie_VdbCachedResultSetClient;
import oracle.sysman.vxx.VxxSortVector;
import oracle.sysman.vxx.vxxo.VxxoEMORB;
import oracle.sysman.vxx.vxxt.VxxtTRACE;
import org.omg.CORBA.Object;

public class VtxCachedResultSet
implements VdbCachedResultSetClientOperations {
    private VdbCachedResultSet m_rs;
    private Vector headers;
    private VxxSortVector data;
    private int numColumns;
    private int numRows;
    private int m_maxFetched;
    private int m_noExtraRows;
    private int m_noDeletedRows;
    private int pageSize = 50;
    private boolean localStoreModified = false;
    private boolean m_bDataWasTruncated = false;
    private TwoDDataSource m_2DClient;
    private OneDDataSource m_1DClient;
    private VdbCachedResultSetClient m_crsClient;
    private VxxoEMORB m_orb;

    public VtxCachedResultSet(VdbCachedResultSet crs, VxxoEMORB orb) {
        this.m_rs = crs;
        this.m_orb = orb;
        this.m_crsClient = this.getTieObject();
        if (orb != null) {
            orb.register((Object)this.m_crsClient);
        }
        crs.setClient(this.m_crsClient);
        this.numColumns = crs.getNumColumns();
        this.headers = new Vector();
        this.data = new VxxSortVector();
        String[] headerStrings = crs.getColumnHeaders();
        int i = 0;
        while (i < this.numColumns) {
            this.headers.addElement(headerStrings[i]);
            this.data.setColumnType(i, crs.getColumnType(i));
            ++i;
        }
        this.initRowCount();
    }

    public VdbCachedResultSetClient getTieObject() {
        return new _tie_VdbCachedResultSetClient(this);
    }

    public VtxCachedResultSet(String[] headerStrings, String[][] dataStrings) {
        this.numColumns = headerStrings.length;
        this.numRows = dataStrings.length;
        this.headers = new Vector();
        this.data = new VxxSortVector();
        int i = 0;
        while (i < this.numColumns) {
            this.headers.addElement(headerStrings[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numRows) {
            Vector<String> nextRow = new Vector<String>();
            int j = 0;
            while (j < this.numColumns) {
                nextRow.addElement(dataStrings[i2][j]);
                ++j;
            }
            this.data.addElement(nextRow);
            ++i2;
        }
    }

    public void addData(java.lang.Object newData) {
        this.data.addElement(newData);
        ++this.numRows;
        ++this.m_noExtraRows;
        this.localStoreModified = true;
    }

    public void addDataAt(java.lang.Object newData, int index) {
        this.data.insertElementAt(newData, index);
        ++this.numRows;
        ++this.m_noExtraRows;
        this.localStoreModified = true;
    }

    public void removeDataAt(int index) {
        this.data.removeElementAt(index);
        --this.numRows;
        ++this.m_noDeletedRows;
        this.localStoreModified = true;
    }

    public void set2DClient(TwoDDataSource client) {
        this.m_2DClient = client;
    }

    public void set1DClient(OneDDataSource client) {
        this.m_1DClient = client;
    }

    public void setColumnType(int colIndex, int dataType) {
        this.data.setColumnType(colIndex, dataType);
    }

    public void setItem(int row, int col, String newValue) {
        if (this.m_rs == null) {
            Vector rowVector = (Vector)this.data.elementAt(row);
            rowVector.setElementAt(newValue, col);
            this.localStoreModified = true;
        }
    }

    public void updateItem(int row, int col, String newValue) {
        Vector rowVector = (Vector)this.data.elementAt(row);
        rowVector.setElementAt(newValue, col);
        this.localStoreModified = true;
    }

    public String getItem(int row, int col) {
        if (col > this.numColumns) {
            return null;
        }
        if (this.m_rs == null && row > this.numRows) {
            return null;
        }
        if (this.m_rs != null) {
            while (row >= this.m_maxFetched + this.m_noExtraRows - this.m_noDeletedRows) {
                String[][] newRows = this.m_rs.getRows(this.m_maxFetched, this.m_maxFetched + this.pageSize);
                this.m_maxFetched += newRows.length;
                int i = 0;
                while (i < newRows.length) {
                    Vector<String> nextRow = new Vector<String>();
                    int j = 0;
                    while (j < this.numColumns) {
                        nextRow.addElement(newRows[i][j]);
                        ++j;
                    }
                    this.data.addElement(nextRow);
                    ++i;
                }
                if (newRows.length < this.pageSize) break;
            }
            if (row >= this.m_maxFetched + this.m_noExtraRows - this.m_noDeletedRows) {
                return null;
            }
        }
        String item = null;
        try {
            Vector rowVector = (Vector)this.data.elementAt(row);
            item = (String)rowVector.elementAt(col);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return item;
    }

    public void sortData(int colIndex, boolean ascending) {
        this.sort(colIndex, ascending);
    }

    public void sort(int colIndex, boolean ascending) {
        if (this.m_rs != null) {
            this.waitFetchFinish();
            if (this.localStoreModified || this.data.size() >= this.m_rs.getNumRows() + this.m_noExtraRows) {
                String discard = this.getItem(this.m_rs.getNumRows() + this.m_noExtraRows - 1, 0);
                this.data.sort(colIndex, ascending, this.localStoreModified);
            } else {
                this.m_rs.sort(colIndex, ascending);
                this.data.removeAllElements();
                this.m_maxFetched = 0;
            }
        } else if (!this.data.isEmpty()) {
            this.data.sort(colIndex, ascending, this.localStoreModified);
        }
    }

    public String getColumnLabel(int col) {
        return (String)this.headers.elementAt(col);
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getNumRows() {
        return this.numRows;
    }

    private void initRowCount() {
        if (this.m_rs != null) {
            this.m_rs.setClientActive(true);
        }
    }

    public void setNumRows(int rowCount) {
        int n;
        this.numRows = rowCount;
        if (this.m_2DClient != null) {
            n = this.m_2DClient.getRowCount();
        }
        if (this.m_1DClient != null) {
            n = this.m_1DClient.getItemCount();
        }
    }

    public void setTruncatedRowCount(int rowCount) {
        this.m_bDataWasTruncated = true;
        this.setNumRows(rowCount);
    }

    public boolean getTruncatedStatus() {
        return this.m_bDataWasTruncated;
    }

    public void setNumColumns(int columnCount) {
        this.numColumns = columnCount;
    }

    public void release(boolean releaseServerCRS) {
        try {
            try {
                if (this.m_rs != null) {
                    if (releaseServerCRS) {
                        this.m_rs.setClientActive(false);
                        this.m_rs.setClient(null);
                        this.waitFetchFinish();
                        VxxtTRACE.out("VtxCRS:Attempting to release Server CRS", 2);
                        this.m_rs.release();
                    } else {
                        VxxtTRACE.out("VtxCRS:Bypassing the release of server CRS", 2);
                    }
                }
            }
            catch (Exception e) {
                String message = "VtxCachedResultSet:Ignoring Exception while releasing Server CRS";
                VxxtTRACE.out(message, 16);
                VxxtTRACE.out("VtxCachedResultSet:release() Exception is : " + e);
            }
            java.lang.Object var3_4 = null;
            if (this.m_crsClient != null) {
                if (this.m_orb != null) {
                    this.m_orb.deregister((Object)this.m_crsClient);
                }
                this.m_crsClient = null;
            }
            this.m_rs = null;
            this.m_2DClient = null;
            this.m_1DClient = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var3_5 = null;
            if (this.m_crsClient != null) {
                if (this.m_orb != null) {
                    this.m_orb.deregister((Object)this.m_crsClient);
                }
                this.m_crsClient = null;
            }
            this.m_rs = null;
            this.m_2DClient = null;
            this.m_1DClient = null;
            throw throwable;
        }
    }

    public void release() {
        boolean releaseServerCRS = true;
        this.release(releaseServerCRS);
    }

    public int getElementCount() {
        return this.data.size();
    }

    public void waitFetchFinish() {
        while (this.m_rs != null && this.m_rs.getThreadActive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public VdbCachedResultSet getCachedResultSet() {
        return this.m_rs;
    }
}

