/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vtx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VtxVerticalFlowLayout
implements LayoutManager {
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    int align;
    int hgap;
    int vgap;

    public VtxVerticalFlowLayout() {
        this(0, 5, 5);
    }

    public VtxVerticalFlowLayout(int align) {
        this(align, 5, 5);
    }

    public VtxVerticalFlowLayout(int align, int hgap, int vgap) {
        this.align = align;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int align) {
        this.align = align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        int i = 0;
        while (i < nmembers) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getPreferredSize();
                dim.width = Math.max(dim.width, d.width);
                if (i > 0) {
                    dim.height += this.getVgap();
                }
                dim.height += d.height;
            }
            ++i;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.getHgap() * 2;
        dim.height += insets.top + insets.bottom + this.getVgap() * 2;
        return dim;
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        int i = 0;
        while (i < nmembers) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getMinimumSize();
                dim.width = Math.max(dim.width, d.width);
                if (i > 0) {
                    dim.height += this.getVgap();
                }
                dim.height += d.height;
            }
            ++i;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.getHgap() * 2;
        dim.height += insets.top + insets.bottom + this.getVgap() * 2;
        return dim;
    }

    private void moveComponents(Container target, int x, int y, int width, int height, int colStart, int colEnd) {
        switch (this.getAlignment()) {
            case 1: {
                y += height / 2;
                break;
            }
            case 2: {
                y += height;
                break;
            }
        }
        int i = colStart;
        while (i < colEnd) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension dim = m.getSize();
                m.setLocation(x + (width - dim.width) / 2, y);
                y += this.getVgap() + dim.height;
            }
            ++i;
        }
    }

    public void layoutContainer(Container target) {
        this.layoutContainerOneColumn(target);
    }

    private void layoutContainerNColumns(Container target) {
        Insets insets = target.getInsets();
        int maxHeight = target.getSize().height - (insets.top + insets.bottom + this.getVgap() * 2);
        int nmembers = target.getComponentCount();
        int x = insets.left + this.getHgap();
        int y = 0;
        int colw = 0;
        int start = 0;
        int i = 0;
        while (i < nmembers) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (y == 0 || y + d.height <= maxHeight) {
                    if (y > 0) {
                        y += this.getVgap();
                    }
                    y += d.height;
                    colw = Math.max(colw, d.width);
                } else {
                    this.moveComponents(target, x, insets.top + this.getVgap(), colw, maxHeight - y, start, i);
                    x += this.getHgap() + colw;
                    y = d.height;
                    colw = d.width;
                    start = i;
                }
            }
            ++i;
        }
        this.moveComponents(target, x, insets.top + this.getVgap(), colw, maxHeight - y, start, nmembers);
    }

    private void layoutContainerOneColumn(Container target) {
        Insets insets = target.getInsets();
        int maxHeight = target.getSize().height - (insets.top + insets.bottom + this.getVgap() * 2);
        int nmembers = target.getComponentCount();
        int x = insets.left + this.getHgap();
        int y = 0;
        int colw = 0;
        int start = 0;
        int i = 0;
        while (i < nmembers) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (y > 0) {
                    y += this.getVgap();
                }
                y += d.height;
                colw = Math.max(colw, d.width);
            }
            ++i;
        }
        this.moveComponents(target, x, insets.top + this.getVgap(), colw, maxHeight - y, start, nmembers);
    }

    public String toString() {
        String str = "";
        switch (this.align) {
            case 0: {
                str = ",align=top";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=bottom";
                break;
            }
        }
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

