/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxn;

import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.vxn.VxnCannotProceedException;
import oracle.sysman.vxn.VxnNamingService;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming._NamingContextImplBase;

public class VxnNamingContext
extends _NamingContextImplBase {
    private int m_cursor;
    private static Vector m_liveContexts = new Vector();
    private static VxnNamingService m_ns;
    private int m_ncNum;
    private static int m_count;

    public void bind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        this.checkMe();
        this.checkName(n);
        try {
            m_ns.bind(n, obj, this.m_cursor, false);
        }
        catch (VxnCannotProceedException e) {
            throw this.newCP(e);
        }
    }

    public void rebind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName {
        this.checkMe();
        this.checkName(n);
        try {
            m_ns.bind(n, obj, this.m_cursor, true);
        }
        catch (VxnCannotProceedException e) {
            throw this.newCP(e);
        }
        catch (AlreadyBound alreadyBound) {}
    }

    public void bind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        this.checkMe();
        this.checkName(n);
    }

    public void rebind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName {
        this.checkMe();
        this.checkName(n);
    }

    public Object resolve(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        this.checkMe();
        this.checkName(n);
        Object obj = null;
        try {
            obj = m_ns.resolve(n, this.m_cursor);
        }
        catch (VxnCannotProceedException e) {
            throw this.newCP(e);
        }
        return obj;
    }

    public void unbind(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        this.checkMe();
        this.checkName(n);
        try {
            m_ns.unbind(n, this.m_cursor);
        }
        catch (VxnCannotProceedException e) {
            throw this.newCP(e);
        }
    }

    public NamingContext new_context() {
        VxnNamingContext nc = m_ns.newContext(this.m_cursor);
        return nc;
    }

    public NamingContext bind_new_context(NameComponent[] n) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        this.checkMe();
        this.checkName(n);
        VxnNamingContext nc = null;
        try {
            nc = m_ns.bindNewContext(n, this.m_cursor);
        }
        catch (VxnCannotProceedException e) {
            throw this.newCP(e);
        }
        return nc;
    }

    public void destroy() throws NotEmpty {
        m_ns.destroyContext(this.m_cursor);
        m_ns.getORB().disconnect((Object)this);
        m_liveContexts.removeElement((java.lang.Object)this);
        this.m_cursor = -1;
    }

    public void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
        m_ns.list(how_many, bl, bi, this.m_cursor);
    }

    static VxnNamingContext getNewContext(int index) {
        VxnNamingContext nc = null;
        VxnNamingContext newNC = null;
        Enumeration e = m_liveContexts.elements();
        while (e.hasMoreElements()) {
            nc = (VxnNamingContext)((java.lang.Object)e.nextElement());
            if (nc.m_cursor != index) continue;
            newNC = nc;
            break;
        }
        if (newNC == null) {
            newNC = new VxnNamingContext(index);
        }
        return newNC;
    }

    static void setNamingService(VxnNamingService ns) {
        m_ns = ns;
    }

    static void incCursorsFromIndex(int index) {
        Enumeration e = m_liveContexts.elements();
        while (e.hasMoreElements()) {
            VxnNamingContext vnc = (VxnNamingContext)((java.lang.Object)e.nextElement());
            if (vnc.m_cursor < index) continue;
            ++vnc.m_cursor;
        }
    }

    static void decCursorsFromIndex(int index) {
        Enumeration e = m_liveContexts.elements();
        while (e.hasMoreElements()) {
            VxnNamingContext vnc = (VxnNamingContext)((java.lang.Object)e.nextElement());
            if (vnc.m_cursor <= index) continue;
            --vnc.m_cursor;
        }
    }

    static void dump() {
        System.out.println("Live naming contexts: " + m_liveContexts.size());
        Enumeration e = m_liveContexts.elements();
        while (e.hasMoreElements()) {
            VxnNamingContext vnc = (VxnNamingContext)((java.lang.Object)e.nextElement());
            System.out.println("Context " + vnc.m_ncNum + " has cursor at " + vnc.m_cursor);
        }
    }

    private VxnNamingContext(int index) {
        this.m_cursor = index;
        m_liveContexts.addElement(this);
        this.m_ncNum = m_count++;
        m_ns.getORB().connect((Object)this);
    }

    private void checkMe() throws CannotProceed {
        if (this.m_cursor == -1) {
            throw new CannotProceed((NamingContext)this, new NameComponent[0]);
        }
    }

    private void checkName(NameComponent[] n) throws InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
    }

    private CannotProceed newCP(VxnCannotProceedException e) {
        return new CannotProceed((NamingContext)this, e.rest);
    }
}

