/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import oracle.sysman.vxx.VxxConst;

public class VxxProperties
extends Properties {
    private boolean m_autoCopy = true;

    public static void main(String[] args) {
        VxxProperties.getAppProperties();
        Properties sysProps = System.getProperties();
        sysProps.list(System.out);
        VxxProperties props = new VxxProperties();
        props.put("Lovelace", "Ada");
        props.put("Babbage", "Charles");
        props.put("Turing", "Alan");
        System.out.println(">>>VxxProperties contents:");
        props.list(System.out);
        System.out.println(">>>System Properties contents:");
        sysProps.list(System.out);
        props.remove((Object)"Turing", true);
        props.remove((Object)"Babbage", false);
        ((Hashtable)props).remove("Lovelace");
        System.out.println(">>>VxxProperties contents:");
        props.list(System.out);
        System.out.println(">>>System Properties contents:");
        sysProps.list(System.out);
    }

    public VxxProperties() {
    }

    public VxxProperties(Properties defaults) {
        super(defaults);
    }

    public boolean isAutoCopy() {
        return this.m_autoCopy;
    }

    public void setAutoCopy(boolean b) {
        this.m_autoCopy = b;
    }

    public synchronized void load(InputStream in) throws IOException {
        super.load(in);
        if (this.m_autoCopy) {
            this.copyAllToSystem();
        }
    }

    public synchronized Object put(Object key, Object value) {
        Object obj = super.put(key, value);
        if (this.m_autoCopy) {
            Properties sysProps = System.getProperties();
            ((Hashtable)sysProps).put(key, value);
        }
        return obj;
    }

    public synchronized Object remove(Object key, boolean removeFromSystem) {
        Object obj = super.remove(key);
        if (removeFromSystem) {
            Properties sysProps = System.getProperties();
            ((Hashtable)sysProps).remove(key);
        }
        return obj;
    }

    public static void getAppProperties(String strPropFile) {
        File propFile = new File(strPropFile);
        VxxProperties.getAppProperties(propFile);
    }

    public static void getAppProperties() {
        String ORACLE_HOME = System.getProperty("ORACLE_HOME");
        String propFilePath = ORACLE_HOME == null ? System.getProperty("user.dir") : String.valueOf(ORACLE_HOME) + VxxConst.FILE_SEPARATOR + "sysman" + VxxConst.FILE_SEPARATOR + "config";
        File propFile = new File(propFilePath, "omsconfig.properties");
        VxxProperties.getAppProperties(propFile);
    }

    public static void getClientAppProperties() {
        String ORACLE_HOME = System.getProperty("ORACLE_HOME");
        String propFilePath = ORACLE_HOME == null ? System.getProperty("user.dir") : String.valueOf(ORACLE_HOME) + VxxConst.FILE_SEPARATOR + "sysman" + VxxConst.FILE_SEPARATOR + "config";
        File propFile = new File(propFilePath, "ClientConfig.properties");
        VxxProperties.getAppProperties(propFile);
    }

    public static void getAppProperties(File propFile) {
        try {
            FileInputStream stream = new FileInputStream(propFile);
            VxxProperties.getAppProperties(stream);
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public static void getAppProperties(FileInputStream stream) {
        Properties appProps = new Properties();
        boolean success = false;
        try {
            try {
                appProps.load(stream);
                Enumeration<?> e = appProps.propertyNames();
                while (e.hasMoreElements()) {
                    String trimmedVal;
                    Object o = e.nextElement();
                    String key = (String)o;
                    String val = appProps.getProperty(key);
                    if (val.equals(trimmedVal = val.trim())) continue;
                    ((Hashtable)appProps).put(key, trimmedVal);
                }
                success = true;
            }
            catch (Exception exception) {
            }
            Object var4_8 = null;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        if (success) {
            VxxProperties.updateSystemProperties(appProps);
        }
    }

    public static void updateSystemProperties(Properties appProps) {
        Properties sysProps = System.getProperties();
        Enumeration<?> e = sysProps.propertyNames();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            ((Hashtable)appProps).put(obj, sysProps.getProperty((String)obj));
        }
        System.setProperties(appProps);
    }

    public void copyAllToSystem() {
        Properties sysProps = System.getProperties();
        Enumeration<?> e = super.propertyNames();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            ((Hashtable)sysProps).put(obj, super.getProperty((String)obj));
        }
    }
}

